//#include "burnint.h"
#include "snem.h"

unsigned char DoSnesReset = 0;

unsigned char SnesJoy1[12] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static struct BurnInputInfo SnesInputList[] =
{
	{"P1 Start",	  BIT_DIGITAL,   SnesJoy1 +  7, "p1 start"  },
	{"P1 Up",	  	  BIT_DIGITAL,   SnesJoy1 +  0, "p1 up"     },
	{"P1 Down",	  	  BIT_DIGITAL,   SnesJoy1 +  1, "p1 down"   },
	{"P1 Left",		  BIT_DIGITAL,   SnesJoy1 +  2, "p1 left"   },
	{"P1 Right",	  BIT_DIGITAL,   SnesJoy1 +  3, "p1 right"  },
	{"P1 Button A",	  BIT_DIGITAL,   SnesJoy1 +  6, "p1 fire 1" },
	{"P1 Button B",	  BIT_DIGITAL,   SnesJoy1 +  4, "p1 fire 2" },
	{"P1 Button C",	  BIT_DIGITAL,   SnesJoy1 +  5, "p1 fire 3" },
	{"P1 Button X",	  BIT_DIGITAL,   SnesJoy1 + 10, "p1 fire 4" },
	{"P1 Button Y",	  BIT_DIGITAL,   SnesJoy1 +  9, "p1 fire 5" },
	{"P1 Button Z",	  BIT_DIGITAL,   SnesJoy1 +  8, "p1 fire 6" },
	{"P1 Mode",	 	  BIT_DIGITAL,   SnesJoy1 + 11, "p1 select" },
	{"Reset"             , BIT_DIGITAL  , &DoSnesReset        , "reset"     },
};

STDINPUTINFO(Snes)

static struct BurnDIPInfo SnesDIPList[]=
{
	// Default Values
	{0x11, 0xff, 0xff, 0x02, NULL                     },
};

STDDIPINFO(Snes)



static struct BurnRomInfo r96ZenkokuKoukouSoccerSenshukenJapanRomDesc[] = {
	{ "'96 Zenkoku Koukou Soccer Senshuken (Japan).sfc",          1572864, 0x5fbb855, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r96ZenkokuKoukouSoccerSenshukenJapan)
STD_ROM_FN(r96ZenkokuKoukouSoccerSenshukenJapan)

struct BurnDriver BurnDrvr96ZenkokuKoukouSoccerSenshukenJapan = {
	"'96 Zenkoku Koukou Soccer Senshuken (Japan)", NULL, NULL, "1986",
	"'96 Zenkoku Koukou Soccer Senshuken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"'96 Zenkoku Koukou Soccer Senshuken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r96ZenkokuKoukouSoccerSenshukenJapanRomInfo, r96ZenkokuKoukouSoccerSenshukenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r2020SuperBaseballJapanRomDesc[] = {
	{ "2020 Super Baseball (Japan).sfc",          1572864, 0xe95a3dd7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r2020SuperBaseballJapan)
STD_ROM_FN(r2020SuperBaseballJapan)

struct BurnDriver BurnDrvr2020SuperBaseballJapan = {
	"2020 Super Baseball (Japan)", NULL, NULL, "1986",
	"2020 Super Baseball (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"2020 Super Baseball (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r2020SuperBaseballJapanRomInfo, r2020SuperBaseballJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r2020SuperBaseballUSARomDesc[] = {
	{ "2020 Super Baseball (USA).sfc",          1572864, 0xd77933e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r2020SuperBaseballUSA)
STD_ROM_FN(r2020SuperBaseballUSA)

struct BurnDriver BurnDrvr2020SuperBaseballUSA = {
	"2020 Super Baseball (USA)", NULL, NULL, "1986",
	"2020 Super Baseball (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"2020 Super Baseball (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r2020SuperBaseballUSARomInfo, r2020SuperBaseballUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r3NinjasKickBackUSARomDesc[] = {
	{ "3 Ninjas Kick Back (USA).sfc",          2097152, 0xf2ee11f9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r3NinjasKickBackUSA)
STD_ROM_FN(r3NinjasKickBackUSA)

struct BurnDriver BurnDrvr3NinjasKickBackUSA = {
	"3 Ninjas Kick Back (USA)", NULL, NULL, "1986",
	"3 Ninjas Kick Back (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"3 Ninjas Kick Back (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r3NinjasKickBackUSARomInfo, r3NinjasKickBackUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r3jinoWideShou5GatsugouJapanBSRomDesc[] = {
	{ "3-ji no Wide Shou - 5 Gatsugou (Japan) (BS).sfc",          524288, 0x78ce2bf6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r3jinoWideShou5GatsugouJapanBS)
STD_ROM_FN(r3jinoWideShou5GatsugouJapanBS)

struct BurnDriver BurnDrvr3jinoWideShou5GatsugouJapanBS = {
	"3-ji no Wide Shou - 5 Gatsugou (Japan) (BS)", NULL, NULL, "1986",
	"3-ji no Wide Shou - 5 Gatsugou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"3-ji no Wide Shou - 5 Gatsugou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r3jinoWideShou5GatsugouJapanBSRomInfo, r3jinoWideShou5GatsugouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r3jinoWideShou6GatsugouJapanBSRomDesc[] = {
	{ "3-ji no Wide Shou - 6 Gatsugou (Japan) (BS).sfc",          524288, 0xdbe754c6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r3jinoWideShou6GatsugouJapanBS)
STD_ROM_FN(r3jinoWideShou6GatsugouJapanBS)

struct BurnDriver BurnDrvr3jinoWideShou6GatsugouJapanBS = {
	"3-ji no Wide Shou - 6 Gatsugou (Japan) (BS)", NULL, NULL, "1986",
	"3-ji no Wide Shou - 6 Gatsugou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"3-ji no Wide Shou - 6 Gatsugou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r3jinoWideShou6GatsugouJapanBSRomInfo, r3jinoWideShou6GatsugouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r3jigenKakutouBallzJapanbRomDesc[] = {
	{ "3-jigen Kakutou Ballz (Japan) [b].sfc",          1048576, 0xf0810694, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r3jigenKakutouBallzJapanb)
STD_ROM_FN(r3jigenKakutouBallzJapanb)

struct BurnDriver BurnDrvr3jigenKakutouBallzJapanb = {
	"3-jigen Kakutou Ballz (Japan) [b]", NULL, NULL, "1986",
	"3-jigen Kakutou Ballz (Japan) [b]\0", NULL, "Nintendo", "Miscellaneous",
	L"3-jigen Kakutou Ballz (Japan) [b]", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r3jigenKakutouBallzJapanbRomInfo, r3jigenKakutouBallzJapanbRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r3x3EyesJuumaHoukanJapanRomDesc[] = {
	{ "3x3 Eyes - Juuma Houkan (Japan).sfc",          2097152, 0xad4ad163, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r3x3EyesJuumaHoukanJapan)
STD_ROM_FN(r3x3EyesJuumaHoukanJapan)

struct BurnDriver BurnDrvr3x3EyesJuumaHoukanJapan = {
	"3x3 Eyes - Juuma Houkan (Japan)", NULL, NULL, "1986",
	"3x3 Eyes - Juuma Houkan (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"3x3 Eyes - Juuma Houkan (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r3x3EyesJuumaHoukanJapanRomInfo, r3x3EyesJuumaHoukanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r3x3EyesSeimaKourindenJapanRomDesc[] = {
	{ "3x3 Eyes - Seima Kourinden (Japan).sfc",          1048576, 0xfbf3c0ff, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r3x3EyesSeimaKourindenJapan)
STD_ROM_FN(r3x3EyesSeimaKourindenJapan)

struct BurnDriver BurnDrvr3x3EyesSeimaKourindenJapan = {
	"3x3 Eyes - Seima Kourinden (Japan)", NULL, NULL, "1986",
	"3x3 Eyes - Seima Kourinden (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"3x3 Eyes - Seima Kourinden (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r3x3EyesSeimaKourindenJapanRomInfo, r3x3EyesSeimaKourindenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r4ninShougiJapanRomDesc[] = {
	{ "4-nin Shougi (Japan).sfc",          524288, 0x9008c18a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r4ninShougiJapan)
STD_ROM_FN(r4ninShougiJapan)

struct BurnDriver BurnDrvr4ninShougiJapan = {
	"4-nin Shougi (Japan)", NULL, NULL, "1986",
	"4-nin Shougi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"4-nin Shougi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r4ninShougiJapanRomInfo, r4ninShougiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r46OkunenMonogatariHarukanaruEdeneJapanRomDesc[] = {
	{ "46 Okunen Monogatari - Harukanaru Eden e (Japan).sfc",          1572864, 0xb090235a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r46OkunenMonogatariHarukanaruEdeneJapan)
STD_ROM_FN(r46OkunenMonogatariHarukanaruEdeneJapan)

struct BurnDriver BurnDrvr46OkunenMonogatariHarukanaruEdeneJapan = {
	"46 Okunen Monogatari - Harukanaru Eden e (Japan)", NULL, NULL, "1986",
	"46 Okunen Monogatari - Harukanaru Eden e (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"46 Okunen Monogatari - Harukanaru Eden e (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r46OkunenMonogatariHarukanaruEdeneJapanRomInfo, r46OkunenMonogatariHarukanaruEdeneJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r7thSagaTheUSARomDesc[] = {
	{ "7th Saga, The (USA).sfc",          1572864, 0xb3abdde6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r7thSagaTheUSA)
STD_ROM_FN(r7thSagaTheUSA)

struct BurnDriver BurnDrvr7thSagaTheUSA = {
	"7th Saga, The (USA)", NULL, NULL, "1986",
	"7th Saga, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"7th Saga, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r7thSagaTheUSARomInfo, r7thSagaTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r90MinutesEuropeanPrimeGoalEuropeBetaRomDesc[] = {
	{ "90 Minutes - European Prime Goal (Europe) (Beta).sfc",          2097152, 0x1bc71881, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r90MinutesEuropeanPrimeGoalEuropeBeta)
STD_ROM_FN(r90MinutesEuropeanPrimeGoalEuropeBeta)

struct BurnDriver BurnDrvr90MinutesEuropeanPrimeGoalEuropeBeta = {
	"90 Minutes - European Prime Goal (Europe) (Beta)", NULL, NULL, "1986",
	"90 Minutes - European Prime Goal (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"90 Minutes - European Prime Goal (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r90MinutesEuropeanPrimeGoalEuropeBetaRomInfo, r90MinutesEuropeanPrimeGoalEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo r90MinutesEuropeanPrimeGoalEuropeRomDesc[] = {
	{ "90 Minutes - European Prime Goal (Europe).sfc",          2097152, 0x1ad61bd0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(r90MinutesEuropeanPrimeGoalEurope)
STD_ROM_FN(r90MinutesEuropeanPrimeGoalEurope)

struct BurnDriver BurnDrvr90MinutesEuropeanPrimeGoalEurope = {
	"90 Minutes - European Prime Goal (Europe)", NULL, NULL, "1986",
	"90 Minutes - European Prime Goal (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"90 Minutes - European Prime Goal (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, r90MinutesEuropeanPrimeGoalEuropeRomInfo, r90MinutesEuropeanPrimeGoalEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rASPAirStrikePatrolUSARomDesc[] = {
	{ "A.S.P. - Air Strike Patrol (USA).sfc",          1048576, 0x5c0da54, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rASPAirStrikePatrolUSA)
STD_ROM_FN(rASPAirStrikePatrolUSA)

struct BurnDriver BurnDrvrASPAirStrikePatrolUSA = {
	"A.S.P. - Air Strike Patrol (USA)", NULL, NULL, "1986",
	"A.S.P. - Air Strike Patrol (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"A.S.P. - Air Strike Patrol (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rASPAirStrikePatrolUSARomInfo, rASPAirStrikePatrolUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAaahhRealMonstersEuropeRomDesc[] = {
	{ "Aaahh!!! Real Monsters (Europe).sfc",          2097152, 0x946313fb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAaahhRealMonstersEurope)
STD_ROM_FN(rAaahhRealMonstersEurope)

struct BurnDriver BurnDrvrAaahhRealMonstersEurope = {
	"Aaahh!!! Real Monsters (Europe)", NULL, NULL, "1986",
	"Aaahh!!! Real Monsters (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aaahh!!! Real Monsters (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAaahhRealMonstersEuropeRomInfo, rAaahhRealMonstersEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAaahhRealMonstersUSARomDesc[] = {
	{ "Aaahh!!! Real Monsters (USA).sfc",          2097152, 0x27ff5ba1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAaahhRealMonstersUSA)
STD_ROM_FN(rAaahhRealMonstersUSA)

struct BurnDriver BurnDrvrAaahhRealMonstersUSA = {
	"Aaahh!!! Real Monsters (USA)", NULL, NULL, "1986",
	"Aaahh!!! Real Monsters (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aaahh!!! Real Monsters (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAaahhRealMonstersUSARomInfo, rAaahhRealMonstersUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rABCMondayNightFootballJapanRomDesc[] = {
	{ "ABC Monday Night Football (Japan).sfc",          1048576, 0x24d4cfe9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rABCMondayNightFootballJapan)
STD_ROM_FN(rABCMondayNightFootballJapan)

struct BurnDriver BurnDrvrABCMondayNightFootballJapan = {
	"ABC Monday Night Football (Japan)", NULL, NULL, "1986",
	"ABC Monday Night Football (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"ABC Monday Night Football (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rABCMondayNightFootballJapanRomInfo, rABCMondayNightFootballJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rABCMondayNightFootballUSARomDesc[] = {
	{ "ABC Monday Night Football (USA).sfc",          1048576, 0xe0dc8ad7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rABCMondayNightFootballUSA)
STD_ROM_FN(rABCMondayNightFootballUSA)

struct BurnDriver BurnDrvrABCMondayNightFootballUSA = {
	"ABC Monday Night Football (USA)", NULL, NULL, "1986",
	"ABC Monday Night Football (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"ABC Monday Night Football (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rABCMondayNightFootballUSARomInfo, rABCMondayNightFootballUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAcceleBridJapanRomDesc[] = {
	{ "Accele Brid (Japan).sfc",          2097152, 0x4a736c38, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAcceleBridJapan)
STD_ROM_FN(rAcceleBridJapan)

struct BurnDriver BurnDrvrAcceleBridJapan = {
	"Accele Brid (Japan)", NULL, NULL, "1986",
	"Accele Brid (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Accele Brid (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAcceleBridJapanRomInfo, rAcceleBridJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAceoNeraeJapanRomDesc[] = {
	{ "Ace o Nerae! (Japan).sfc",          1048576, 0x6c5f1a18, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAceoNeraeJapan)
STD_ROM_FN(rAceoNeraeJapan)

struct BurnDriver BurnDrvrAceoNeraeJapan = {
	"Ace o Nerae! (Japan)", NULL, NULL, "1986",
	"Ace o Nerae! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ace o Nerae! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAceoNeraeJapanRomInfo, rAceoNeraeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rACMEAnimationFactoryEuropeRomDesc[] = {
	{ "ACME Animation Factory (Europe).sfc",          1048576, 0xaad3a72d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rACMEAnimationFactoryEurope)
STD_ROM_FN(rACMEAnimationFactoryEurope)

struct BurnDriver BurnDrvrACMEAnimationFactoryEurope = {
	"ACME Animation Factory (Europe)", NULL, NULL, "1986",
	"ACME Animation Factory (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"ACME Animation Factory (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rACMEAnimationFactoryEuropeRomInfo, rACMEAnimationFactoryEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rACMEAnimationFactoryUSARomDesc[] = {
	{ "ACME Animation Factory (USA).sfc",          1048576, 0x944a5c3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rACMEAnimationFactoryUSA)
STD_ROM_FN(rACMEAnimationFactoryUSA)

struct BurnDriver BurnDrvrACMEAnimationFactoryUSA = {
	"ACME Animation Factory (USA)", NULL, NULL, "1986",
	"ACME Animation Factory (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"ACME Animation Factory (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rACMEAnimationFactoryUSARomInfo, rACMEAnimationFactoryUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAcrobatMissionJapanRomDesc[] = {
	{ "Acrobat Mission (Japan).sfc",          1048576, 0xda18a10, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAcrobatMissionJapan)
STD_ROM_FN(rAcrobatMissionJapan)

struct BurnDriver BurnDrvrAcrobatMissionJapan = {
	"Acrobat Mission (Japan)", NULL, NULL, "1986",
	"Acrobat Mission (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Acrobat Mission (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAcrobatMissionJapanRomInfo, rAcrobatMissionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rActionPachioJapanRomDesc[] = {
	{ "Action Pachio (Japan).sfc",          1048576, 0xc752f5df, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rActionPachioJapan)
STD_ROM_FN(rActionPachioJapan)

struct BurnDriver BurnDrvrActionPachioJapan = {
	"Action Pachio (Japan)", NULL, NULL, "1986",
	"Action Pachio (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Action Pachio (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rActionPachioJapanRomInfo, rActionPachioJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rActRaiserEuropeRomDesc[] = {
	{ "ActRaiser (Europe).sfc",          1048576, 0x9097b2b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rActRaiserEurope)
STD_ROM_FN(rActRaiserEurope)

struct BurnDriver BurnDrvrActRaiserEurope = {
	"ActRaiser (Europe)", NULL, NULL, "1986",
	"ActRaiser (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"ActRaiser (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rActRaiserEuropeRomInfo, rActRaiserEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rActRaiserFranceRomDesc[] = {
	{ "ActRaiser (France).sfc",          1048576, 0xa27e2664, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rActRaiserFrance)
STD_ROM_FN(rActRaiserFrance)

struct BurnDriver BurnDrvrActRaiserFrance = {
	"ActRaiser (France)", NULL, NULL, "1986",
	"ActRaiser (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"ActRaiser (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rActRaiserFranceRomInfo, rActRaiserFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rActRaiserGermanyRomDesc[] = {
	{ "ActRaiser (Germany).sfc",          1048576, 0x29a78af9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rActRaiserGermany)
STD_ROM_FN(rActRaiserGermany)

struct BurnDriver BurnDrvrActRaiserGermany = {
	"ActRaiser (Germany)", NULL, NULL, "1986",
	"ActRaiser (Germany)\0", NULL, "Nintendo", "Miscellaneous",
	L"ActRaiser (Germany)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rActRaiserGermanyRomInfo, rActRaiserGermanyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rActraiserJapanRomDesc[] = {
	{ "Actraiser (Japan).sfc",          1048576, 0xbee9b30c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rActraiserJapan)
STD_ROM_FN(rActraiserJapan)

struct BurnDriver BurnDrvrActraiserJapan = {
	"Actraiser (Japan)", NULL, NULL, "1986",
	"Actraiser (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Actraiser (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rActraiserJapanRomInfo, rActraiserJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rActRaiserUSARomDesc[] = {
	{ "ActRaiser (USA).sfc",          1048576, 0xeac3358d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rActRaiserUSA)
STD_ROM_FN(rActRaiserUSA)

struct BurnDriver BurnDrvrActRaiserUSA = {
	"ActRaiser (USA)", NULL, NULL, "1986",
	"ActRaiser (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"ActRaiser (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rActRaiserUSARomInfo, rActRaiserUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rActRaiser2EuropeEnFrDeRomDesc[] = {
	{ "ActRaiser 2 (Europe) (En,Fr,De).sfc",          1572864, 0x630e16a1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rActRaiser2EuropeEnFrDe)
STD_ROM_FN(rActRaiser2EuropeEnFrDe)

struct BurnDriver BurnDrvrActRaiser2EuropeEnFrDe = {
	"ActRaiser 2 (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"ActRaiser 2 (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"ActRaiser 2 (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rActRaiser2EuropeEnFrDeRomInfo, rActRaiser2EuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rActRaiser2USARomDesc[] = {
	{ "ActRaiser 2 (USA).sfc",          1572864, 0x4901f718, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rActRaiser2USA)
STD_ROM_FN(rActRaiser2USA)

struct BurnDriver BurnDrvrActRaiser2USA = {
	"ActRaiser 2 (USA)", NULL, NULL, "1986",
	"ActRaiser 2 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"ActRaiser 2 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rActRaiser2USARomInfo, rActRaiser2USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rActRaiser2ChinmokuenoSeisenJapanRomDesc[] = {
	{ "ActRaiser 2 - Chinmoku e no Seisen (Japan).sfc",          1572864, 0x3cbc264f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rActRaiser2ChinmokuenoSeisenJapan)
STD_ROM_FN(rActRaiser2ChinmokuenoSeisenJapan)

struct BurnDriver BurnDrvrActRaiser2ChinmokuenoSeisenJapan = {
	"ActRaiser 2 - Chinmoku e no Seisen (Japan)", NULL, NULL, "1986",
	"ActRaiser 2 - Chinmoku e no Seisen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"ActRaiser 2 - Chinmoku e no Seisen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rActRaiser2ChinmokuenoSeisenJapanRomInfo, rActRaiser2ChinmokuenoSeisenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAddamsFamilyValuesEuropeEnFrDeRomDesc[] = {
	{ "Addams Family Values (Europe) (En,Fr,De).sfc",          2097152, 0xae38adb6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAddamsFamilyValuesEuropeEnFrDe)
STD_ROM_FN(rAddamsFamilyValuesEuropeEnFrDe)

struct BurnDriver BurnDrvrAddamsFamilyValuesEuropeEnFrDe = {
	"Addams Family Values (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Addams Family Values (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Addams Family Values (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAddamsFamilyValuesEuropeEnFrDeRomInfo, rAddamsFamilyValuesEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAddamsFamilyValuesUSAEnFrDeRomDesc[] = {
	{ "Addams Family Values (USA) (En,Fr,De).sfc",          2097152, 0x98b07db8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAddamsFamilyValuesUSAEnFrDe)
STD_ROM_FN(rAddamsFamilyValuesUSAEnFrDe)

struct BurnDriver BurnDrvrAddamsFamilyValuesUSAEnFrDe = {
	"Addams Family Values (USA) (En,Fr,De)", NULL, NULL, "1986",
	"Addams Family Values (USA) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Addams Family Values (USA) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAddamsFamilyValuesUSAEnFrDeRomInfo, rAddamsFamilyValuesUSAEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAddamsFamilyTheEuropeEnFrDeRomDesc[] = {
	{ "Addams Family, The (Europe) (En,Fr,De).sfc",          1048576, 0x82497f19, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAddamsFamilyTheEuropeEnFrDe)
STD_ROM_FN(rAddamsFamilyTheEuropeEnFrDe)

struct BurnDriver BurnDrvrAddamsFamilyTheEuropeEnFrDe = {
	"Addams Family, The (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Addams Family, The (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Addams Family, The (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAddamsFamilyTheEuropeEnFrDeRomInfo, rAddamsFamilyTheEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAddamsFamilyTheJapanRomDesc[] = {
	{ "Addams Family, The (Japan).sfc",          1048576, 0xcd80351c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAddamsFamilyTheJapan)
STD_ROM_FN(rAddamsFamilyTheJapan)

struct BurnDriver BurnDrvrAddamsFamilyTheJapan = {
	"Addams Family, The (Japan)", NULL, NULL, "1986",
	"Addams Family, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Addams Family, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAddamsFamilyTheJapanRomInfo, rAddamsFamilyTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAddamsFamilyTheUSARomDesc[] = {
	{ "Addams Family, The (USA).sfc",          1048576, 0x2e8034ab, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAddamsFamilyTheUSA)
STD_ROM_FN(rAddamsFamilyTheUSA)

struct BurnDriver BurnDrvrAddamsFamilyTheUSA = {
	"Addams Family, The (USA)", NULL, NULL, "1986",
	"Addams Family, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Addams Family, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAddamsFamilyTheUSARomInfo, rAddamsFamilyTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAddamsFamilyThePugsleysScavengerHuntEuropeRomDesc[] = {
	{ "Addams Family, The - Pugsley's Scavenger Hunt (Europe).sfc",          1048576, 0x644e7fbf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAddamsFamilyThePugsleysScavengerHuntEurope)
STD_ROM_FN(rAddamsFamilyThePugsleysScavengerHuntEurope)

struct BurnDriver BurnDrvrAddamsFamilyThePugsleysScavengerHuntEurope = {
	"Addams Family, The - Pugsley's Scavenger Hunt (Europe)", NULL, NULL, "1986",
	"Addams Family, The - Pugsley's Scavenger Hunt (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Addams Family, The - Pugsley's Scavenger Hunt (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAddamsFamilyThePugsleysScavengerHuntEuropeRomInfo, rAddamsFamilyThePugsleysScavengerHuntEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAddamsFamilyThePugsleysScavengerHuntUSABetaRomDesc[] = {
	{ "Addams Family, The - Pugsley's Scavenger Hunt (USA) (Beta).sfc",          1048576, 0x64d68066, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAddamsFamilyThePugsleysScavengerHuntUSABeta)
STD_ROM_FN(rAddamsFamilyThePugsleysScavengerHuntUSABeta)

struct BurnDriver BurnDrvrAddamsFamilyThePugsleysScavengerHuntUSABeta = {
	"Addams Family, The - Pugsley's Scavenger Hunt (USA) (Beta)", NULL, NULL, "1986",
	"Addams Family, The - Pugsley's Scavenger Hunt (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Addams Family, The - Pugsley's Scavenger Hunt (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAddamsFamilyThePugsleysScavengerHuntUSABetaRomInfo, rAddamsFamilyThePugsleysScavengerHuntUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAddamsFamilyThePugsleysScavengerHuntUSARomDesc[] = {
	{ "Addams Family, The - Pugsley's Scavenger Hunt (USA).sfc",          1048576, 0x153a00a7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAddamsFamilyThePugsleysScavengerHuntUSA)
STD_ROM_FN(rAddamsFamilyThePugsleysScavengerHuntUSA)

struct BurnDriver BurnDrvrAddamsFamilyThePugsleysScavengerHuntUSA = {
	"Addams Family, The - Pugsley's Scavenger Hunt (USA)", NULL, NULL, "1986",
	"Addams Family, The - Pugsley's Scavenger Hunt (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Addams Family, The - Pugsley's Scavenger Hunt (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAddamsFamilyThePugsleysScavengerHuntUSARomInfo, rAddamsFamilyThePugsleysScavengerHuntUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAdventuresofBatmanRobinTheEuropeRomDesc[] = {
	{ "Adventures of Batman & Robin, The (Europe).sfc",          2097152, 0x96b0c568, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAdventuresofBatmanRobinTheEurope)
STD_ROM_FN(rAdventuresofBatmanRobinTheEurope)

struct BurnDriver BurnDrvrAdventuresofBatmanRobinTheEurope = {
	"Adventures of Batman & Robin, The (Europe)", NULL, NULL, "1986",
	"Adventures of Batman & Robin, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Adventures of Batman & Robin, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAdventuresofBatmanRobinTheEuropeRomInfo, rAdventuresofBatmanRobinTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAdventuresofBatmanRobinTheUSARomDesc[] = {
	{ "Adventures of Batman & Robin, The (USA).sfc",          2097152, 0xb3ef81f5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAdventuresofBatmanRobinTheUSA)
STD_ROM_FN(rAdventuresofBatmanRobinTheUSA)

struct BurnDriver BurnDrvrAdventuresofBatmanRobinTheUSA = {
	"Adventures of Batman & Robin, The (USA)", NULL, NULL, "1986",
	"Adventures of Batman & Robin, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Adventures of Batman & Robin, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAdventuresofBatmanRobinTheUSARomInfo, rAdventuresofBatmanRobinTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAdventuresofDrFrankenTheEuropeEnFrDeEsItNlSvRomDesc[] = {
	{ "Adventures of Dr. Franken, The (Europe) (En,Fr,De,Es,It,Nl,Sv).sfc",          1048576, 0xe4925f15, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAdventuresofDrFrankenTheEuropeEnFrDeEsItNlSv)
STD_ROM_FN(rAdventuresofDrFrankenTheEuropeEnFrDeEsItNlSv)

struct BurnDriver BurnDrvrAdventuresofDrFrankenTheEuropeEnFrDeEsItNlSv = {
	"Adventures of Dr. Franken, The (Europe) (En,Fr,De,Es,It,Nl,Sv)", NULL, NULL, "1986",
	"Adventures of Dr. Franken, The (Europe) (En,Fr,De,Es,It,Nl,Sv)\0", NULL, "Nintendo", "Miscellaneous",
	L"Adventures of Dr. Franken, The (Europe) (En,Fr,De,Es,It,Nl,Sv)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAdventuresofDrFrankenTheEuropeEnFrDeEsItNlSvRomInfo, rAdventuresofDrFrankenTheEuropeEnFrDeEsItNlSvRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAdventuresofDrFrankenTheUSARomDesc[] = {
	{ "Adventures of Dr. Franken, The (USA).sfc",          1048576, 0xcfab3bba, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAdventuresofDrFrankenTheUSA)
STD_ROM_FN(rAdventuresofDrFrankenTheUSA)

struct BurnDriver BurnDrvrAdventuresofDrFrankenTheUSA = {
	"Adventures of Dr. Franken, The (USA)", NULL, NULL, "1986",
	"Adventures of Dr. Franken, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Adventures of Dr. Franken, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAdventuresofDrFrankenTheUSARomInfo, rAdventuresofDrFrankenTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAdventuresofKidKleetsTheUSAEnFrEsRomDesc[] = {
	{ "Adventures of Kid Kleets, The (USA) (En,Fr,Es).sfc",          1310720, 0x1664ae48, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAdventuresofKidKleetsTheUSAEnFrEs)
STD_ROM_FN(rAdventuresofKidKleetsTheUSAEnFrEs)

struct BurnDriver BurnDrvrAdventuresofKidKleetsTheUSAEnFrEs = {
	"Adventures of Kid Kleets, The (USA) (En,Fr,Es)", NULL, NULL, "1986",
	"Adventures of Kid Kleets, The (USA) (En,Fr,Es)\0", NULL, "Nintendo", "Miscellaneous",
	L"Adventures of Kid Kleets, The (USA) (En,Fr,Es)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAdventuresofKidKleetsTheUSAEnFrEsRomInfo, rAdventuresofKidKleetsTheUSAEnFrEsRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAdventuresofRockyandBullwinkleandFriendsTheUSARomDesc[] = {
	{ "Adventures of Rocky and Bullwinkle and Friends, The (USA).sfc",          1048576, 0xdc8f5734, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAdventuresofRockyandBullwinkleandFriendsTheUSA)
STD_ROM_FN(rAdventuresofRockyandBullwinkleandFriendsTheUSA)

struct BurnDriver BurnDrvrAdventuresofRockyandBullwinkleandFriendsTheUSA = {
	"Adventures of Rocky and Bullwinkle and Friends, The (USA)", NULL, NULL, "1986",
	"Adventures of Rocky and Bullwinkle and Friends, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Adventures of Rocky and Bullwinkle and Friends, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAdventuresofRockyandBullwinkleandFriendsTheUSARomInfo, rAdventuresofRockyandBullwinkleandFriendsTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAdventuresoftheRocketeerTheJapanRomDesc[] = {
	{ "Adventures of the Rocketeer, The (Japan).sfc",          1048576, 0xcbc4868e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAdventuresoftheRocketeerTheJapan)
STD_ROM_FN(rAdventuresoftheRocketeerTheJapan)

struct BurnDriver BurnDrvrAdventuresoftheRocketeerTheJapan = {
	"Adventures of the Rocketeer, The (Japan)", NULL, NULL, "1986",
	"Adventures of the Rocketeer, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Adventures of the Rocketeer, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAdventuresoftheRocketeerTheJapanRomInfo, rAdventuresoftheRocketeerTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAdventuresofYogiBearUSARomDesc[] = {
	{ "Adventures of Yogi Bear (USA).sfc",          1048576, 0x7448d45c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAdventuresofYogiBearUSA)
STD_ROM_FN(rAdventuresofYogiBearUSA)

struct BurnDriver BurnDrvrAdventuresofYogiBearUSA = {
	"Adventures of Yogi Bear (USA)", NULL, NULL, "1986",
	"Adventures of Yogi Bear (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Adventures of Yogi Bear (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAdventuresofYogiBearUSARomInfo, rAdventuresofYogiBearUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAeroFightersUSARomDesc[] = {
	{ "Aero Fighters (USA).sfc",          1310720, 0xf194d00a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAeroFightersUSA)
STD_ROM_FN(rAeroFightersUSA)

struct BurnDriver BurnDrvrAeroFightersUSA = {
	"Aero Fighters (USA)", NULL, NULL, "1986",
	"Aero Fighters (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aero Fighters (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAeroFightersUSARomInfo, rAeroFightersUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAerotheAcroBatEuropeRomDesc[] = {
	{ "Aero the Acro-Bat (Europe).sfc",          1048576, 0xfa0ce63a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAerotheAcroBatEurope)
STD_ROM_FN(rAerotheAcroBatEurope)

struct BurnDriver BurnDrvrAerotheAcroBatEurope = {
	"Aero the Acro-Bat (Europe)", NULL, NULL, "1986",
	"Aero the Acro-Bat (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aero the Acro-Bat (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAerotheAcroBatEuropeRomInfo, rAerotheAcroBatEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAerotheAcroBatUSARomDesc[] = {
	{ "Aero the Acro-Bat (USA).sfc",          1048576, 0x919f23cb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAerotheAcroBatUSA)
STD_ROM_FN(rAerotheAcroBatUSA)

struct BurnDriver BurnDrvrAerotheAcroBatUSA = {
	"Aero the Acro-Bat (USA)", NULL, NULL, "1986",
	"Aero the Acro-Bat (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aero the Acro-Bat (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAerotheAcroBatUSARomInfo, rAerotheAcroBatUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAerotheAcroBat2EuropeRomDesc[] = {
	{ "Aero the Acro-Bat 2 (Europe).sfc",          2097152, 0x242b8181, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAerotheAcroBat2Europe)
STD_ROM_FN(rAerotheAcroBat2Europe)

struct BurnDriver BurnDrvrAerotheAcroBat2Europe = {
	"Aero the Acro-Bat 2 (Europe)", NULL, NULL, "1986",
	"Aero the Acro-Bat 2 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aero the Acro-Bat 2 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAerotheAcroBat2EuropeRomInfo, rAerotheAcroBat2EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAerotheAcroBat2USARomDesc[] = {
	{ "Aero the Acro-Bat 2 (USA).sfc",          2097152, 0x8c05ed51, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAerotheAcroBat2USA)
STD_ROM_FN(rAerotheAcroBat2USA)

struct BurnDriver BurnDrvrAerotheAcroBat2USA = {
	"Aero the Acro-Bat 2 (USA)", NULL, NULL, "1986",
	"Aero the Acro-Bat 2 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aero the Acro-Bat 2 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAerotheAcroBat2USARomInfo, rAerotheAcroBat2USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAerobizUSARomDesc[] = {
	{ "Aerobiz (USA).sfc",          1048576, 0x54302a46, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAerobizUSA)
STD_ROM_FN(rAerobizUSA)

struct BurnDriver BurnDrvrAerobizUSA = {
	"Aerobiz (USA)", NULL, NULL, "1986",
	"Aerobiz (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aerobiz (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAerobizUSARomInfo, rAerobizUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAerobizSupersonicUSARomDesc[] = {
	{ "Aerobiz Supersonic (USA).sfc",          1048576, 0xefafab12, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAerobizSupersonicUSA)
STD_ROM_FN(rAerobizSupersonicUSA)

struct BurnDriver BurnDrvrAerobizSupersonicUSA = {
	"Aerobiz Supersonic (USA)", NULL, NULL, "1986",
	"Aerobiz Supersonic (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aerobiz Supersonic (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAerobizSupersonicUSARomInfo, rAerobizSupersonicUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAgingCassetteJapanRomDesc[] = {
	{ "Aging Cassette (Japan).sfc",          131072, 0x55938e4e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAgingCassetteJapan)
STD_ROM_FN(rAgingCassetteJapan)

struct BurnDriver BurnDrvrAgingCassetteJapan = {
	"Aging Cassette (Japan)", NULL, NULL, "1986",
	"Aging Cassette (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aging Cassette (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAgingCassetteJapanRomInfo, rAgingCassetteJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAguriSuzukiF1SuperDrivingEuropeRomDesc[] = {
	{ "Aguri Suzuki F-1 Super Driving (Europe).sfc",          1048576, 0xc8382f39, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAguriSuzukiF1SuperDrivingEurope)
STD_ROM_FN(rAguriSuzukiF1SuperDrivingEurope)

struct BurnDriver BurnDrvrAguriSuzukiF1SuperDrivingEurope = {
	"Aguri Suzuki F-1 Super Driving (Europe)", NULL, NULL, "1986",
	"Aguri Suzuki F-1 Super Driving (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aguri Suzuki F-1 Super Driving (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAguriSuzukiF1SuperDrivingEuropeRomInfo, rAguriSuzukiF1SuperDrivingEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAIIISVAResshadeIkou3SuperVersionJapanRomDesc[] = {
	{ "AIII S.V. - A Ressha de Ikou 3 - Super Version (Japan).sfc",          2097152, 0xf953b79a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAIIISVAResshadeIkou3SuperVersionJapan)
STD_ROM_FN(rAIIISVAResshadeIkou3SuperVersionJapan)

struct BurnDriver BurnDrvrAIIISVAResshadeIkou3SuperVersionJapan = {
	"AIII S.V. - A Ressha de Ikou 3 - Super Version (Japan)", NULL, NULL, "1986",
	"AIII S.V. - A Ressha de Ikou 3 - Super Version (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"AIII S.V. - A Ressha de Ikou 3 - Super Version (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAIIISVAResshadeIkou3SuperVersionJapanRomInfo, rAIIISVAResshadeIkou3SuperVersionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAirCavalryEuropeRomDesc[] = {
	{ "Air Cavalry (Europe).sfc",          1048576, 0xb3f57cc6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAirCavalryEurope)
STD_ROM_FN(rAirCavalryEurope)

struct BurnDriver BurnDrvrAirCavalryEurope = {
	"Air Cavalry (Europe)", NULL, NULL, "1986",
	"Air Cavalry (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Air Cavalry (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAirCavalryEuropeRomInfo, rAirCavalryEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAirCavalryUSARomDesc[] = {
	{ "Air Cavalry (USA).sfc",          1048576, 0x6b452801, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAirCavalryUSA)
STD_ROM_FN(rAirCavalryUSA)

struct BurnDriver BurnDrvrAirCavalryUSA = {
	"Air Cavalry (USA)", NULL, NULL, "1986",
	"Air Cavalry (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Air Cavalry (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAirCavalryUSARomInfo, rAirCavalryUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAirManagementOozoraniKakeruJapanRev1RomDesc[] = {
	{ "Air Management - Oozora ni Kakeru (Japan) (Rev 1).sfc",          1048576, 0xa533bc97, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAirManagementOozoraniKakeruJapanRev1)
STD_ROM_FN(rAirManagementOozoraniKakeruJapanRev1)

struct BurnDriver BurnDrvrAirManagementOozoraniKakeruJapanRev1 = {
	"Air Management - Oozora ni Kakeru (Japan) (Rev 1)", NULL, NULL, "1986",
	"Air Management - Oozora ni Kakeru (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Air Management - Oozora ni Kakeru (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAirManagementOozoraniKakeruJapanRev1RomInfo, rAirManagementOozoraniKakeruJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAirManagementOozoraniKakeruJapanRomDesc[] = {
	{ "Air Management - Oozora ni Kakeru (Japan).sfc",          1048576, 0xf6643226, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAirManagementOozoraniKakeruJapan)
STD_ROM_FN(rAirManagementOozoraniKakeruJapan)

struct BurnDriver BurnDrvrAirManagementOozoraniKakeruJapan = {
	"Air Management - Oozora ni Kakeru (Japan)", NULL, NULL, "1986",
	"Air Management - Oozora ni Kakeru (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Air Management - Oozora ni Kakeru (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAirManagementOozoraniKakeruJapanRomInfo, rAirManagementOozoraniKakeruJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAirManagementIIKoukuuOuoMezaseJapanRomDesc[] = {
	{ "Air Management II - Koukuu Ou o Mezase (Japan).sfc",          1048576, 0x8d0b3c85, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAirManagementIIKoukuuOuoMezaseJapan)
STD_ROM_FN(rAirManagementIIKoukuuOuoMezaseJapan)

struct BurnDriver BurnDrvrAirManagementIIKoukuuOuoMezaseJapan = {
	"Air Management II - Koukuu Ou o Mezase (Japan)", NULL, NULL, "1986",
	"Air Management II - Koukuu Ou o Mezase (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Air Management II - Koukuu Ou o Mezase (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAirManagementIIKoukuuOuoMezaseJapanRomInfo, rAirManagementIIKoukuuOuoMezaseJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAkagawaJirouMajotachinoNemuriJapanRomDesc[] = {
	{ "Akagawa Jirou Majo-tachi no Nemuri (Japan).sfc",          3145728, 0x167e4c15, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAkagawaJirouMajotachinoNemuriJapan)
STD_ROM_FN(rAkagawaJirouMajotachinoNemuriJapan)

struct BurnDriver BurnDrvrAkagawaJirouMajotachinoNemuriJapan = {
	"Akagawa Jirou Majo-tachi no Nemuri (Japan)", NULL, NULL, "1986",
	"Akagawa Jirou Majo-tachi no Nemuri (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Akagawa Jirou Majo-tachi no Nemuri (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAkagawaJirouMajotachinoNemuriJapanRomInfo, rAkagawaJirouMajotachinoNemuriJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAkazukinChachaJapanRomDesc[] = {
	{ "Akazukin Chacha (Japan).sfc",          1572864, 0xeef47b5e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAkazukinChachaJapan)
STD_ROM_FN(rAkazukinChachaJapan)

struct BurnDriver BurnDrvrAkazukinChachaJapan = {
	"Akazukin Chacha (Japan)", NULL, NULL, "1986",
	"Akazukin Chacha (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Akazukin Chacha (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAkazukinChachaJapanRomInfo, rAkazukinChachaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAkumajouDraculaJapanRomDesc[] = {
	{ "Akumajou Dracula (Japan).sfc",          1048576, 0xeda59a2a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAkumajouDraculaJapan)
STD_ROM_FN(rAkumajouDraculaJapan)

struct BurnDriver BurnDrvrAkumajouDraculaJapan = {
	"Akumajou Dracula (Japan)", NULL, NULL, "1986",
	"Akumajou Dracula (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Akumajou Dracula (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAkumajouDraculaJapanRomInfo, rAkumajouDraculaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAkumajouDraculaXXJapanRomDesc[] = {
	{ "Akumajou Dracula XX (Japan).sfc",          2097152, 0xaa75fa8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAkumajouDraculaXXJapan)
STD_ROM_FN(rAkumajouDraculaXXJapan)

struct BurnDriver BurnDrvrAkumajouDraculaXXJapan = {
	"Akumajou Dracula XX (Japan)", NULL, NULL, "1986",
	"Akumajou Dracula XX (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Akumajou Dracula XX (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAkumajouDraculaXXJapanRomInfo, rAkumajouDraculaXXJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlUnserJrsRoadtotheTopEuropeRomDesc[] = {
	{ "Al Unser Jr.'s Road to the Top (Europe).sfc",          1048576, 0x4cf5d45f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlUnserJrsRoadtotheTopEurope)
STD_ROM_FN(rAlUnserJrsRoadtotheTopEurope)

struct BurnDriver BurnDrvrAlUnserJrsRoadtotheTopEurope = {
	"Al Unser Jr.'s Road to the Top (Europe)", NULL, NULL, "1986",
	"Al Unser Jr.'s Road to the Top (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Al Unser Jr.'s Road to the Top (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlUnserJrsRoadtotheTopEuropeRomInfo, rAlUnserJrsRoadtotheTopEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlUnserJrsRoadtotheTopUSARomDesc[] = {
	{ "Al Unser Jr.'s Road to the Top (USA).sfc",          1048576, 0xd0550624, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlUnserJrsRoadtotheTopUSA)
STD_ROM_FN(rAlUnserJrsRoadtotheTopUSA)

struct BurnDriver BurnDrvrAlUnserJrsRoadtotheTopUSA = {
	"Al Unser Jr.'s Road to the Top (USA)", NULL, NULL, "1986",
	"Al Unser Jr.'s Road to the Top (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Al Unser Jr.'s Road to the Top (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlUnserJrsRoadtotheTopUSARomInfo, rAlUnserJrsRoadtotheTopUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAladdinEuropeRomDesc[] = {
	{ "Aladdin (Europe).sfc",          1310720, 0x44ff6e78, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAladdinEurope)
STD_ROM_FN(rAladdinEurope)

struct BurnDriver BurnDrvrAladdinEurope = {
	"Aladdin (Europe)", NULL, NULL, "1986",
	"Aladdin (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aladdin (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAladdinEuropeRomInfo, rAladdinEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAladdinFranceRomDesc[] = {
	{ "Aladdin (France).sfc",          1310720, 0x63069939, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAladdinFrance)
STD_ROM_FN(rAladdinFrance)

struct BurnDriver BurnDrvrAladdinFrance = {
	"Aladdin (France)", NULL, NULL, "1986",
	"Aladdin (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aladdin (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAladdinFranceRomInfo, rAladdinFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAladdinGermanyRomDesc[] = {
	{ "Aladdin (Germany).sfc",          1310720, 0xa7ad3e5d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAladdinGermany)
STD_ROM_FN(rAladdinGermany)

struct BurnDriver BurnDrvrAladdinGermany = {
	"Aladdin (Germany)", NULL, NULL, "1986",
	"Aladdin (Germany)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aladdin (Germany)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAladdinGermanyRomInfo, rAladdinGermanyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAladdinJapanRomDesc[] = {
	{ "Aladdin (Japan).sfc",          1310720, 0x1aeb696b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAladdinJapan)
STD_ROM_FN(rAladdinJapan)

struct BurnDriver BurnDrvrAladdinJapan = {
	"Aladdin (Japan)", NULL, NULL, "1986",
	"Aladdin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aladdin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAladdinJapanRomInfo, rAladdinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAladdinSpainRomDesc[] = {
	{ "Aladdin (Spain).sfc",          1310720, 0x90ee8c61, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAladdinSpain)
STD_ROM_FN(rAladdinSpain)

struct BurnDriver BurnDrvrAladdinSpain = {
	"Aladdin (Spain)", NULL, NULL, "1986",
	"Aladdin (Spain)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aladdin (Spain)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAladdinSpainRomInfo, rAladdinSpainRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAladdinUSABetaRomDesc[] = {
	{ "Aladdin (USA) (Beta).sfc",          1310720, 0x52fdfab4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAladdinUSABeta)
STD_ROM_FN(rAladdinUSABeta)

struct BurnDriver BurnDrvrAladdinUSABeta = {
	"Aladdin (USA) (Beta)", NULL, NULL, "1986",
	"Aladdin (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aladdin (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAladdinUSABetaRomInfo, rAladdinUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAladdinUSARomDesc[] = {
	{ "Aladdin (USA).sfc",          1310720, 0x124d8e4d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAladdinUSA)
STD_ROM_FN(rAladdinUSA)

struct BurnDriver BurnDrvrAladdinUSA = {
	"Aladdin (USA)", NULL, NULL, "1986",
	"Aladdin (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aladdin (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAladdinUSARomInfo, rAladdinUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlbertOdysseyJapanBSRomDesc[] = {
	{ "Albert Odyssey (Japan) (BS).sfc",          1048576, 0xd5f6ad68, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlbertOdysseyJapanBS)
STD_ROM_FN(rAlbertOdysseyJapanBS)

struct BurnDriver BurnDrvrAlbertOdysseyJapanBS = {
	"Albert Odyssey (Japan) (BS)", NULL, NULL, "1986",
	"Albert Odyssey (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Albert Odyssey (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlbertOdysseyJapanBSRomInfo, rAlbertOdysseyJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlbertOdysseyJapanRomDesc[] = {
	{ "Albert Odyssey (Japan).sfc",          1048576, 0x46ca01a9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlbertOdysseyJapan)
STD_ROM_FN(rAlbertOdysseyJapan)

struct BurnDriver BurnDrvrAlbertOdysseyJapan = {
	"Albert Odyssey (Japan)", NULL, NULL, "1986",
	"Albert Odyssey (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Albert Odyssey (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlbertOdysseyJapanRomInfo, rAlbertOdysseyJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlbertOdyssey2JashinnoTaidouJapanRomDesc[] = {
	{ "Albert Odyssey 2 - Jashin no Taidou (Japan).sfc",          2097152, 0x1b6add7b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlbertOdyssey2JashinnoTaidouJapan)
STD_ROM_FN(rAlbertOdyssey2JashinnoTaidouJapan)

struct BurnDriver BurnDrvrAlbertOdyssey2JashinnoTaidouJapan = {
	"Albert Odyssey 2 - Jashin no Taidou (Japan)", NULL, NULL, "1986",
	"Albert Odyssey 2 - Jashin no Taidou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Albert Odyssey 2 - Jashin no Taidou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlbertOdyssey2JashinnoTaidouJapanRomInfo, rAlbertOdyssey2JashinnoTaidouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlcahestJapanRomDesc[] = {
	{ "Alcahest (Japan).sfc",          1048576, 0x870427d0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlcahestJapan)
STD_ROM_FN(rAlcahestJapan)

struct BurnDriver BurnDrvrAlcahestJapan = {
	"Alcahest (Japan)", NULL, NULL, "1986",
	"Alcahest (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Alcahest (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlcahestJapanRomInfo, rAlcahestJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlfredChickenEuropeRomDesc[] = {
	{ "Alfred Chicken (Europe).sfc",          1048576, 0xe344627b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlfredChickenEurope)
STD_ROM_FN(rAlfredChickenEurope)

struct BurnDriver BurnDrvrAlfredChickenEurope = {
	"Alfred Chicken (Europe)", NULL, NULL, "1986",
	"Alfred Chicken (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Alfred Chicken (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlfredChickenEuropeRomInfo, rAlfredChickenEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlicenoPaintAdventureJapanRomDesc[] = {
	{ "Alice no Paint Adventure (Japan).sfc",          1048576, 0x5798da8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlicenoPaintAdventureJapan)
STD_ROM_FN(rAlicenoPaintAdventureJapan)

struct BurnDriver BurnDrvrAlicenoPaintAdventureJapan = {
	"Alice no Paint Adventure (Japan)", NULL, NULL, "1986",
	"Alice no Paint Adventure (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Alice no Paint Adventure (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlicenoPaintAdventureJapanRomInfo, rAlicenoPaintAdventureJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlien3EuropeRomDesc[] = {
	{ "Alien 3 (Europe).sfc",          1048576, 0x378613b0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlien3Europe)
STD_ROM_FN(rAlien3Europe)

struct BurnDriver BurnDrvrAlien3Europe = {
	"Alien 3 (Europe)", NULL, NULL, "1986",
	"Alien 3 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Alien 3 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlien3EuropeRomInfo, rAlien3EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlien3JapanRomDesc[] = {
	{ "Alien 3 (Japan).sfc",          1048576, 0x8a21b63f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlien3Japan)
STD_ROM_FN(rAlien3Japan)

struct BurnDriver BurnDrvrAlien3Japan = {
	"Alien 3 (Japan)", NULL, NULL, "1986",
	"Alien 3 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Alien 3 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlien3JapanRomInfo, rAlien3JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlien3USABetaRomDesc[] = {
	{ "Alien 3 (USA) (Beta).sfc",          1048576, 0x77713c95, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlien3USABeta)
STD_ROM_FN(rAlien3USABeta)

struct BurnDriver BurnDrvrAlien3USABeta = {
	"Alien 3 (USA) (Beta)", NULL, NULL, "1986",
	"Alien 3 (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Alien 3 (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlien3USABetaRomInfo, rAlien3USABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlien3USARomDesc[] = {
	{ "Alien 3 (USA).sfc",          1048576, 0x98e2ac15, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlien3USA)
STD_ROM_FN(rAlien3USA)

struct BurnDriver BurnDrvrAlien3USA = {
	"Alien 3 (USA)", NULL, NULL, "1986",
	"Alien 3 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Alien 3 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlien3USARomInfo, rAlien3USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlienvsPredatorEuropeRomDesc[] = {
	{ "Alien vs. Predator (Europe).sfc",          1048576, 0xa31d1f58, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlienvsPredatorEurope)
STD_ROM_FN(rAlienvsPredatorEurope)

struct BurnDriver BurnDrvrAlienvsPredatorEurope = {
	"Alien vs. Predator (Europe)", NULL, NULL, "1986",
	"Alien vs. Predator (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Alien vs. Predator (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlienvsPredatorEuropeRomInfo, rAlienvsPredatorEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAlienvsPredatorUSARomDesc[] = {
	{ "Alien vs. Predator (USA).sfc",          1048576, 0x1803cf20, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAlienvsPredatorUSA)
STD_ROM_FN(rAlienvsPredatorUSA)

struct BurnDriver BurnDrvrAlienvsPredatorUSA = {
	"Alien vs. Predator (USA)", NULL, NULL, "1986",
	"Alien vs. Predator (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Alien vs. Predator (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAlienvsPredatorUSARomInfo, rAlienvsPredatorUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAliensvsPredatorJapanRomDesc[] = {
	{ "Aliens vs. Predator (Japan).sfc",          1048576, 0x2d5876ff, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAliensvsPredatorJapan)
STD_ROM_FN(rAliensvsPredatorJapan)

struct BurnDriver BurnDrvrAliensvsPredatorJapan = {
	"Aliens vs. Predator (Japan)", NULL, NULL, "1986",
	"Aliens vs. Predator (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aliens vs. Predator (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAliensvsPredatorJapanRomInfo, rAliensvsPredatorJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAllAmericanChampionshipFootballEuropeRomDesc[] = {
	{ "All-American Championship Football (Europe).sfc",          524288, 0xebefbde2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAllAmericanChampionshipFootballEurope)
STD_ROM_FN(rAllAmericanChampionshipFootballEurope)

struct BurnDriver BurnDrvrAllAmericanChampionshipFootballEurope = {
	"All-American Championship Football (Europe)", NULL, NULL, "1986",
	"All-American Championship Football (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"All-American Championship Football (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAllAmericanChampionshipFootballEuropeRomInfo, rAllAmericanChampionshipFootballEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAmazingSpiderManTheLethalFoesJapanRomDesc[] = {
	{ "Amazing Spider-Man, The - Lethal Foes (Japan).sfc",          1572864, 0x82f7f710, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAmazingSpiderManTheLethalFoesJapan)
STD_ROM_FN(rAmazingSpiderManTheLethalFoesJapan)

struct BurnDriver BurnDrvrAmazingSpiderManTheLethalFoesJapan = {
	"Amazing Spider-Man, The - Lethal Foes (Japan)", NULL, NULL, "1986",
	"Amazing Spider-Man, The - Lethal Foes (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Amazing Spider-Man, The - Lethal Foes (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAmazingSpiderManTheLethalFoesJapanRomInfo, rAmazingSpiderManTheLethalFoesJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAmericaOudanUltraQuizJapanRomDesc[] = {
	{ "America Oudan Ultra Quiz (Japan).sfc",          1048576, 0x9624e6ed, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAmericaOudanUltraQuizJapan)
STD_ROM_FN(rAmericaOudanUltraQuizJapan)

struct BurnDriver BurnDrvrAmericaOudanUltraQuizJapan = {
	"America Oudan Ultra Quiz (Japan)", NULL, NULL, "1986",
	"America Oudan Ultra Quiz (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"America Oudan Ultra Quiz (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAmericaOudanUltraQuizJapanRomInfo, rAmericaOudanUltraQuizJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAmericanBattleDomeJapanRomDesc[] = {
	{ "American Battle Dome (Japan).sfc",          1048576, 0x61753981, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAmericanBattleDomeJapan)
STD_ROM_FN(rAmericanBattleDomeJapan)

struct BurnDriver BurnDrvrAmericanBattleDomeJapan = {
	"American Battle Dome (Japan)", NULL, NULL, "1986",
	"American Battle Dome (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"American Battle Dome (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAmericanBattleDomeJapanRomInfo, rAmericanBattleDomeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAmericanGladiatorsUSARomDesc[] = {
	{ "American Gladiators (USA).sfc",          1048576, 0x76b151fd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAmericanGladiatorsUSA)
STD_ROM_FN(rAmericanGladiatorsUSA)

struct BurnDriver BurnDrvrAmericanGladiatorsUSA = {
	"American Gladiators (USA)", NULL, NULL, "1986",
	"American Gladiators (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"American Gladiators (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAmericanGladiatorsUSARomInfo, rAmericanGladiatorsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAmericanTailAnFievelGoesWestEuropeRomDesc[] = {
	{ "American Tail, An - Fievel Goes West (Europe).sfc",          1048576, 0x80ac1b5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAmericanTailAnFievelGoesWestEurope)
STD_ROM_FN(rAmericanTailAnFievelGoesWestEurope)

struct BurnDriver BurnDrvrAmericanTailAnFievelGoesWestEurope = {
	"American Tail, An - Fievel Goes West (Europe)", NULL, NULL, "1986",
	"American Tail, An - Fievel Goes West (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"American Tail, An - Fievel Goes West (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAmericanTailAnFievelGoesWestEuropeRomInfo, rAmericanTailAnFievelGoesWestEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAmericanTailAnFievelGoesWestUSARomDesc[] = {
	{ "American Tail, An - Fievel Goes West (USA).sfc",          1048576, 0xeea38aed, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAmericanTailAnFievelGoesWestUSA)
STD_ROM_FN(rAmericanTailAnFievelGoesWestUSA)

struct BurnDriver BurnDrvrAmericanTailAnFievelGoesWestUSA = {
	"American Tail, An - Fievel Goes West (USA)", NULL, NULL, "1986",
	"American Tail, An - Fievel Goes West (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"American Tail, An - Fievel Goes West (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAmericanTailAnFievelGoesWestUSARomInfo, rAmericanTailAnFievelGoesWestUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAndreAgassiTennisJapanRomDesc[] = {
	{ "Andre Agassi Tennis (Japan).sfc",          524288, 0xd9879a39, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAndreAgassiTennisJapan)
STD_ROM_FN(rAndreAgassiTennisJapan)

struct BurnDriver BurnDrvrAndreAgassiTennisJapan = {
	"Andre Agassi Tennis (Japan)", NULL, NULL, "1986",
	"Andre Agassi Tennis (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Andre Agassi Tennis (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAndreAgassiTennisJapanRomInfo, rAndreAgassiTennisJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAndreAgassiTennisUSARomDesc[] = {
	{ "Andre Agassi Tennis (USA).sfc",          524288, 0xd1ae87be, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAndreAgassiTennisUSA)
STD_ROM_FN(rAndreAgassiTennisUSA)

struct BurnDriver BurnDrvrAndreAgassiTennisUSA = {
	"Andre Agassi Tennis (USA)", NULL, NULL, "1986",
	"Andre Agassi Tennis (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Andre Agassi Tennis (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAndreAgassiTennisUSARomInfo, rAndreAgassiTennisUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAngeliqueJapanPremiumBoxRomDesc[] = {
	{ "Angelique (Japan) (Premium Box).sfc",          2097152, 0x3da108c4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAngeliqueJapanPremiumBox)
STD_ROM_FN(rAngeliqueJapanPremiumBox)

struct BurnDriver BurnDrvrAngeliqueJapanPremiumBox = {
	"Angelique (Japan) (Premium Box)", NULL, NULL, "1986",
	"Angelique (Japan) (Premium Box)\0", NULL, "Nintendo", "Miscellaneous",
	L"Angelique (Japan) (Premium Box)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAngeliqueJapanPremiumBoxRomInfo, rAngeliqueJapanPremiumBoxRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAngeliqueJapanRomDesc[] = {
	{ "Angelique (Japan).sfc",          2097152, 0xec3edb9e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAngeliqueJapan)
STD_ROM_FN(rAngeliqueJapan)

struct BurnDriver BurnDrvrAngeliqueJapan = {
	"Angelique (Japan)", NULL, NULL, "1986",
	"Angelique (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Angelique (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAngeliqueJapanRomInfo, rAngeliqueJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAngeliqueVoiceFantasyJapanRomDesc[] = {
	{ "Angelique - Voice Fantasy (Japan).sfc",          3145728, 0xea6ae8a9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAngeliqueVoiceFantasyJapan)
STD_ROM_FN(rAngeliqueVoiceFantasyJapan)

struct BurnDriver BurnDrvrAngeliqueVoiceFantasyJapan = {
	"Angelique - Voice Fantasy (Japan)", NULL, NULL, "1986",
	"Angelique - Voice Fantasy (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Angelique - Voice Fantasy (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAngeliqueVoiceFantasyJapanRomInfo, rAngeliqueVoiceFantasyJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAnimalBurandenBrutalJapanRomDesc[] = {
	{ "Animal Buranden - Brutal (Japan).sfc",          2097152, 0x78eca50d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAnimalBurandenBrutalJapan)
STD_ROM_FN(rAnimalBurandenBrutalJapan)

struct BurnDriver BurnDrvrAnimalBurandenBrutalJapan = {
	"Animal Buranden - Brutal (Japan)", NULL, NULL, "1986",
	"Animal Buranden - Brutal (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Animal Buranden - Brutal (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAnimalBurandenBrutalJapanRomInfo, rAnimalBurandenBrutalJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAnimaniacsEuropeRomDesc[] = {
	{ "Animaniacs (Europe).sfc",          1048576, 0xc28a80f6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAnimaniacsEurope)
STD_ROM_FN(rAnimaniacsEurope)

struct BurnDriver BurnDrvrAnimaniacsEurope = {
	"Animaniacs (Europe)", NULL, NULL, "1986",
	"Animaniacs (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Animaniacs (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAnimaniacsEuropeRomInfo, rAnimaniacsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAnimaniacsJapanRomDesc[] = {
	{ "Animaniacs (Japan).sfc",          1048576, 0xd93e07a8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAnimaniacsJapan)
STD_ROM_FN(rAnimaniacsJapan)

struct BurnDriver BurnDrvrAnimaniacsJapan = {
	"Animaniacs (Japan)", NULL, NULL, "1986",
	"Animaniacs (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Animaniacs (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAnimaniacsJapanRomInfo, rAnimaniacsJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAnimaniacsUSARomDesc[] = {
	{ "Animaniacs (USA).sfc",          1048576, 0xcf0f14d2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAnimaniacsUSA)
STD_ROM_FN(rAnimaniacsUSA)

struct BurnDriver BurnDrvrAnimaniacsUSA = {
	"Animaniacs (USA)", NULL, NULL, "1986",
	"Animaniacs (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Animaniacs (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAnimaniacsUSARomInfo, rAnimaniacsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAnotherWorldEuropeRomDesc[] = {
	{ "Another World (Europe).sfc",          1048576, 0x83b40af2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAnotherWorldEurope)
STD_ROM_FN(rAnotherWorldEurope)

struct BurnDriver BurnDrvrAnotherWorldEurope = {
	"Another World (Europe)", NULL, NULL, "1986",
	"Another World (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Another World (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAnotherWorldEuropeRomInfo, rAnotherWorldEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAokiDensetsuShootJapanRomDesc[] = {
	{ "Aoki Densetsu Shoot! (Japan).sfc",          1572864, 0x9ea4ad6f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAokiDensetsuShootJapan)
STD_ROM_FN(rAokiDensetsuShootJapan)

struct BurnDriver BurnDrvrAokiDensetsuShootJapan = {
	"Aoki Densetsu Shoot! (Japan)", NULL, NULL, "1986",
	"Aoki Densetsu Shoot! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aoki Densetsu Shoot! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAokiDensetsuShootJapanRomInfo, rAokiDensetsuShootJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rApocalypseIIEuropeProtoRomDesc[] = {
	{ "Apocalypse II (Europe) (Proto).sfc",          1048576, 0x6a53c658, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rApocalypseIIEuropeProto)
STD_ROM_FN(rApocalypseIIEuropeProto)

struct BurnDriver BurnDrvrApocalypseIIEuropeProto = {
	"Apocalypse II (Europe) (Proto)", NULL, NULL, "1986",
	"Apocalypse II (Europe) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Apocalypse II (Europe) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rApocalypseIIEuropeProtoRomInfo, rApocalypseIIEuropeProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAppleseedPrometheusnoShintakuJapanRomDesc[] = {
	{ "Appleseed - Prometheus no Shintaku (Japan).sfc",          2097152, 0xc0e62c02, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAppleseedPrometheusnoShintakuJapan)
STD_ROM_FN(rAppleseedPrometheusnoShintakuJapan)

struct BurnDriver BurnDrvrAppleseedPrometheusnoShintakuJapan = {
	"Appleseed - Prometheus no Shintaku (Japan)", NULL, NULL, "1986",
	"Appleseed - Prometheus no Shintaku (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Appleseed - Prometheus no Shintaku (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAppleseedPrometheusnoShintakuJapanRomInfo, rAppleseedPrometheusnoShintakuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAqutallionJapanRomDesc[] = {
	{ "Aqutallion (Japan).sfc",          1048576, 0x4ca1696f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAqutallionJapan)
STD_ROM_FN(rAqutallionJapan)

struct BurnDriver BurnDrvrAqutallionJapan = {
	"Aqutallion (Japan)", NULL, NULL, "1986",
	"Aqutallion (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aqutallion (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAqutallionJapanRomInfo, rAqutallionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArabianNightsSabakunoSeireiOuJapanRomDesc[] = {
	{ "Arabian Nights - Sabaku no Seirei Ou (Japan).sfc",          2621440, 0xb6dbf57b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArabianNightsSabakunoSeireiOuJapan)
STD_ROM_FN(rArabianNightsSabakunoSeireiOuJapan)

struct BurnDriver BurnDrvrArabianNightsSabakunoSeireiOuJapan = {
	"Arabian Nights - Sabaku no Seirei Ou (Japan)", NULL, NULL, "1986",
	"Arabian Nights - Sabaku no Seirei Ou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arabian Nights - Sabaku no Seirei Ou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArabianNightsSabakunoSeireiOuJapanRomInfo, rArabianNightsSabakunoSeireiOuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAraigumaRascalJapanRomDesc[] = {
	{ "Araiguma Rascal (Japan).sfc",          1048576, 0xde13ec70, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAraigumaRascalJapan)
STD_ROM_FN(rAraigumaRascalJapan)

struct BurnDriver BurnDrvrAraigumaRascalJapan = {
	"Araiguma Rascal (Japan)", NULL, NULL, "1986",
	"Araiguma Rascal (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Araiguma Rascal (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAraigumaRascalJapanRomInfo, rAraigumaRascalJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArcadesGreatestHitsEuropeRomDesc[] = {
	{ "Arcade's Greatest Hits (Europe).sfc",          524288, 0xdc69693f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArcadesGreatestHitsEurope)
STD_ROM_FN(rArcadesGreatestHitsEurope)

struct BurnDriver BurnDrvrArcadesGreatestHitsEurope = {
	"Arcade's Greatest Hits (Europe)", NULL, NULL, "1986",
	"Arcade's Greatest Hits (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arcade's Greatest Hits (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArcadesGreatestHitsEuropeRomInfo, rArcadesGreatestHitsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArcadesGreatestHitsUSARomDesc[] = {
	{ "Arcade's Greatest Hits (USA).sfc",          524288, 0x471b12b0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArcadesGreatestHitsUSA)
STD_ROM_FN(rArcadesGreatestHitsUSA)

struct BurnDriver BurnDrvrArcadesGreatestHitsUSA = {
	"Arcade's Greatest Hits (USA)", NULL, NULL, "1986",
	"Arcade's Greatest Hits (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arcade's Greatest Hits (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArcadesGreatestHitsUSARomInfo, rArcadesGreatestHitsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArcadesGreatestHitsTheAtariCollection1EuropeRomDesc[] = {
	{ "Arcade's Greatest Hits - The Atari Collection 1 (Europe).sfc",          524288, 0xd562233e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArcadesGreatestHitsTheAtariCollection1Europe)
STD_ROM_FN(rArcadesGreatestHitsTheAtariCollection1Europe)

struct BurnDriver BurnDrvrArcadesGreatestHitsTheAtariCollection1Europe = {
	"Arcade's Greatest Hits - The Atari Collection 1 (Europe)", NULL, NULL, "1986",
	"Arcade's Greatest Hits - The Atari Collection 1 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arcade's Greatest Hits - The Atari Collection 1 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArcadesGreatestHitsTheAtariCollection1EuropeRomInfo, rArcadesGreatestHitsTheAtariCollection1EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArcadesGreatestHitsTheAtariCollection1USARomDesc[] = {
	{ "Arcade's Greatest Hits - The Atari Collection 1 (USA).sfc",          524288, 0x2394f36, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArcadesGreatestHitsTheAtariCollection1USA)
STD_ROM_FN(rArcadesGreatestHitsTheAtariCollection1USA)

struct BurnDriver BurnDrvrArcadesGreatestHitsTheAtariCollection1USA = {
	"Arcade's Greatest Hits - The Atari Collection 1 (USA)", NULL, NULL, "1986",
	"Arcade's Greatest Hits - The Atari Collection 1 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arcade's Greatest Hits - The Atari Collection 1 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArcadesGreatestHitsTheAtariCollection1USARomInfo, rArcadesGreatestHitsTheAtariCollection1USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArcanaUSARomDesc[] = {
	{ "Arcana (USA).sfc",          1048576, 0xc891b297, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArcanaUSA)
STD_ROM_FN(rArcanaUSA)

struct BurnDriver BurnDrvrArcanaUSA = {
	"Arcana (USA)", NULL, NULL, "1986",
	"Arcana (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arcana (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArcanaUSARomInfo, rArcanaUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArcusOdysseyUSAProtoRomDesc[] = {
	{ "Arcus Odyssey (USA) (Proto).sfc",          1572864, 0x184ef398, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArcusOdysseyUSAProto)
STD_ROM_FN(rArcusOdysseyUSAProto)

struct BurnDriver BurnDrvrArcusOdysseyUSAProto = {
	"Arcus Odyssey (USA) (Proto)", NULL, NULL, "1986",
	"Arcus Odyssey (USA) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arcus Odyssey (USA) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArcusOdysseyUSAProtoRomInfo, rArcusOdysseyUSAProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArcusSpiritsJapanRomDesc[] = {
	{ "Arcus Spirits (Japan).sfc",          1310720, 0xc9067671, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArcusSpiritsJapan)
STD_ROM_FN(rArcusSpiritsJapan)

struct BurnDriver BurnDrvrArcusSpiritsJapan = {
	"Arcus Spirits (Japan)", NULL, NULL, "1986",
	"Arcus Spirits (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arcus Spirits (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArcusSpiritsJapanRomInfo, rArcusSpiritsJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArdyLightfootEuropeRomDesc[] = {
	{ "Ardy Lightfoot (Europe).sfc",          1048576, 0xd239398f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArdyLightfootEurope)
STD_ROM_FN(rArdyLightfootEurope)

struct BurnDriver BurnDrvrArdyLightfootEurope = {
	"Ardy Lightfoot (Europe)", NULL, NULL, "1986",
	"Ardy Lightfoot (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ardy Lightfoot (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArdyLightfootEuropeRomInfo, rArdyLightfootEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArdyLightfootJapanBetaRomDesc[] = {
	{ "Ardy Lightfoot (Japan) (Beta).sfc",          1048576, 0xf73a6e33, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArdyLightfootJapanBeta)
STD_ROM_FN(rArdyLightfootJapanBeta)

struct BurnDriver BurnDrvrArdyLightfootJapanBeta = {
	"Ardy Lightfoot (Japan) (Beta)", NULL, NULL, "1986",
	"Ardy Lightfoot (Japan) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ardy Lightfoot (Japan) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArdyLightfootJapanBetaRomInfo, rArdyLightfootJapanBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArdyLightfootJapanRomDesc[] = {
	{ "Ardy Lightfoot (Japan).sfc",          1048576, 0x2aa7777b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArdyLightfootJapan)
STD_ROM_FN(rArdyLightfootJapan)

struct BurnDriver BurnDrvrArdyLightfootJapan = {
	"Ardy Lightfoot (Japan)", NULL, NULL, "1986",
	"Ardy Lightfoot (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ardy Lightfoot (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArdyLightfootJapanRomInfo, rArdyLightfootJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArdyLightfootUSARomDesc[] = {
	{ "Ardy Lightfoot (USA).sfc",          1048576, 0x51a5f489, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArdyLightfootUSA)
STD_ROM_FN(rArdyLightfootUSA)

struct BurnDriver BurnDrvrArdyLightfootUSA = {
	"Ardy Lightfoot (USA)", NULL, NULL, "1986",
	"Ardy Lightfoot (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ardy Lightfoot (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArdyLightfootUSARomInfo, rArdyLightfootUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArea88JapanRomDesc[] = {
	{ "Area 88 (Japan).sfc",          1048576, 0x6388f71, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArea88Japan)
STD_ROM_FN(rArea88Japan)

struct BurnDriver BurnDrvrArea88Japan = {
	"Area 88 (Japan)", NULL, NULL, "1986",
	"Area 88 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Area 88 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArea88JapanRomInfo, rArea88JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArethaJapanRomDesc[] = {
	{ "Aretha (Japan).sfc",          2097152, 0x395bade3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArethaJapan)
STD_ROM_FN(rArethaJapan)

struct BurnDriver BurnDrvrArethaJapan = {
	"Aretha (Japan)", NULL, NULL, "1986",
	"Aretha (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aretha (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArethaJapanRomInfo, rArethaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArethaIIArielnoFushiginaTabiJapanBetaAlt1RomDesc[] = {
	{ "Aretha II - Ariel no Fushigi na Tabi (Japan) (Beta) (Alt 1).sfc",          2097152, 0x7b164161, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArethaIIArielnoFushiginaTabiJapanBetaAlt1)
STD_ROM_FN(rArethaIIArielnoFushiginaTabiJapanBetaAlt1)

struct BurnDriver BurnDrvrArethaIIArielnoFushiginaTabiJapanBetaAlt1 = {
	"Aretha II - Ariel no Fushigi na Tabi (Japan) (Beta) (Alt 1)", NULL, NULL, "1986",
	"Aretha II - Ariel no Fushigi na Tabi (Japan) (Beta) (Alt 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aretha II - Ariel no Fushigi na Tabi (Japan) (Beta) (Alt 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArethaIIArielnoFushiginaTabiJapanBetaAlt1RomInfo, rArethaIIArielnoFushiginaTabiJapanBetaAlt1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArethaIIArielnoFushiginaTabiJapanBetaRomDesc[] = {
	{ "Aretha II - Ariel no Fushigi na Tabi (Japan) (Beta).sfc",          2097152, 0x7f5a6f91, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArethaIIArielnoFushiginaTabiJapanBeta)
STD_ROM_FN(rArethaIIArielnoFushiginaTabiJapanBeta)

struct BurnDriver BurnDrvrArethaIIArielnoFushiginaTabiJapanBeta = {
	"Aretha II - Ariel no Fushigi na Tabi (Japan) (Beta)", NULL, NULL, "1986",
	"Aretha II - Ariel no Fushigi na Tabi (Japan) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aretha II - Ariel no Fushigi na Tabi (Japan) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArethaIIArielnoFushiginaTabiJapanBetaRomInfo, rArethaIIArielnoFushiginaTabiJapanBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArethaIIArielnoFushiginaTabiJapanRomDesc[] = {
	{ "Aretha II - Ariel no Fushigi na Tabi (Japan).sfc",          2097152, 0xff63ec26, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArethaIIArielnoFushiginaTabiJapan)
STD_ROM_FN(rArethaIIArielnoFushiginaTabiJapan)

struct BurnDriver BurnDrvrArethaIIArielnoFushiginaTabiJapan = {
	"Aretha II - Ariel no Fushigi na Tabi (Japan)", NULL, NULL, "1986",
	"Aretha II - Ariel no Fushigi na Tabi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aretha II - Ariel no Fushigi na Tabi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArethaIIArielnoFushiginaTabiJapanRomInfo, rArethaIIArielnoFushiginaTabiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArkanoidDohItAgainEuropeRomDesc[] = {
	{ "Arkanoid - Doh It Again (Europe).sfc",          524288, 0xd436489b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArkanoidDohItAgainEurope)
STD_ROM_FN(rArkanoidDohItAgainEurope)

struct BurnDriver BurnDrvrArkanoidDohItAgainEurope = {
	"Arkanoid - Doh It Again (Europe)", NULL, NULL, "1986",
	"Arkanoid - Doh It Again (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arkanoid - Doh It Again (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArkanoidDohItAgainEuropeRomInfo, rArkanoidDohItAgainEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArkanoidDohItAgainJapanBSRomDesc[] = {
	{ "Arkanoid - Doh It Again (Japan) (BS).sfc",          524288, 0xded48e0a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArkanoidDohItAgainJapanBS)
STD_ROM_FN(rArkanoidDohItAgainJapanBS)

struct BurnDriver BurnDrvrArkanoidDohItAgainJapanBS = {
	"Arkanoid - Doh It Again (Japan) (BS)", NULL, NULL, "1986",
	"Arkanoid - Doh It Again (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arkanoid - Doh It Again (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArkanoidDohItAgainJapanBSRomInfo, rArkanoidDohItAgainJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArkanoidDohItAgainJapanRomDesc[] = {
	{ "Arkanoid - Doh It Again (Japan).sfc",          524288, 0x7a8bbafa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArkanoidDohItAgainJapan)
STD_ROM_FN(rArkanoidDohItAgainJapan)

struct BurnDriver BurnDrvrArkanoidDohItAgainJapan = {
	"Arkanoid - Doh It Again (Japan)", NULL, NULL, "1986",
	"Arkanoid - Doh It Again (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arkanoid - Doh It Again (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArkanoidDohItAgainJapanRomInfo, rArkanoidDohItAgainJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArkanoidDohItAgainUSARomDesc[] = {
	{ "Arkanoid - Doh It Again (USA).sfc",          524288, 0xb50503a0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArkanoidDohItAgainUSA)
STD_ROM_FN(rArkanoidDohItAgainUSA)

struct BurnDriver BurnDrvrArkanoidDohItAgainUSA = {
	"Arkanoid - Doh It Again (USA)", NULL, NULL, "1986",
	"Arkanoid - Doh It Again (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Arkanoid - Doh It Again (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArkanoidDohItAgainUSARomInfo, rArkanoidDohItAgainUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArtofFightingEuropeRomDesc[] = {
	{ "Art of Fighting (Europe).sfc",          2097152, 0x143051a5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArtofFightingEurope)
STD_ROM_FN(rArtofFightingEurope)

struct BurnDriver BurnDrvrArtofFightingEurope = {
	"Art of Fighting (Europe)", NULL, NULL, "1986",
	"Art of Fighting (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Art of Fighting (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArtofFightingEuropeRomInfo, rArtofFightingEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rArtofFightingUSARomDesc[] = {
	{ "Art of Fighting (USA).sfc",          2097152, 0x9fa74067, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rArtofFightingUSA)
STD_ROM_FN(rArtofFightingUSA)

struct BurnDriver BurnDrvrArtofFightingUSA = {
	"Art of Fighting (USA)", NULL, NULL, "1986",
	"Art of Fighting (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Art of Fighting (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rArtofFightingUSARomInfo, rArtofFightingUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAryolJapanRomDesc[] = {
	{ "Aryol (Japan).sfc",          1048576, 0x43b1aad9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAryolJapan)
STD_ROM_FN(rAryolJapan)

struct BurnDriver BurnDrvrAryolJapan = {
	"Aryol (Japan)", NULL, NULL, "1986",
	"Aryol (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Aryol (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAryolJapanRomInfo, rAryolJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAsahiShinbunRensaiKatouHifumiKudanShougiShingiryuuJapanRomDesc[] = {
	{ "Asahi Shinbun Rensai - Katou Hifumi Kudan Shougi - Shingiryuu (Japan).sfc",          1048576, 0x506a8f77, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAsahiShinbunRensaiKatouHifumiKudanShougiShingiryuuJapan)
STD_ROM_FN(rAsahiShinbunRensaiKatouHifumiKudanShougiShingiryuuJapan)

struct BurnDriver BurnDrvrAsahiShinbunRensaiKatouHifumiKudanShougiShingiryuuJapan = {
	"Asahi Shinbun Rensai - Katou Hifumi Kudan Shougi - Shingiryuu (Japan)", NULL, NULL, "1986",
	"Asahi Shinbun Rensai - Katou Hifumi Kudan Shougi - Shingiryuu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Asahi Shinbun Rensai - Katou Hifumi Kudan Shougi - Shingiryuu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAsahiShinbunRensaiKatouHifumiKudanShougiShingiryuuJapanRomInfo, rAsahiShinbunRensaiKatouHifumiKudanShougiShingiryuuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAsameshimaeNyankoJapanRomDesc[] = {
	{ "Asameshimae Nyanko (Japan).sfc",          1048576, 0x24fe792f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAsameshimaeNyankoJapan)
STD_ROM_FN(rAsameshimaeNyankoJapan)

struct BurnDriver BurnDrvrAsameshimaeNyankoJapan = {
	"Asameshimae Nyanko (Japan)", NULL, NULL, "1986",
	"Asameshimae Nyanko (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Asameshimae Nyanko (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAsameshimaeNyankoJapanRomInfo, rAsameshimaeNyankoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAshitanoJoeJapanRomDesc[] = {
	{ "Ashita no Joe (Japan).sfc",          1048576, 0x6b54be97, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAshitanoJoeJapan)
STD_ROM_FN(rAshitanoJoeJapan)

struct BurnDriver BurnDrvrAshitanoJoeJapan = {
	"Ashita no Joe (Japan)", NULL, NULL, "1986",
	"Ashita no Joe (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ashita no Joe (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAshitanoJoeJapanRomInfo, rAshitanoJoeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAssaultSuitsValkenJapanRomDesc[] = {
	{ "Assault Suits Valken (Japan).sfc",          1048576, 0xa5f63557, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAssaultSuitsValkenJapan)
STD_ROM_FN(rAssaultSuitsValkenJapan)

struct BurnDriver BurnDrvrAssaultSuitsValkenJapan = {
	"Assault Suits Valken (Japan)", NULL, NULL, "1986",
	"Assault Suits Valken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Assault Suits Valken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAssaultSuitsValkenJapanRomInfo, rAssaultSuitsValkenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAsterixObelixEuropeEnFrDeEsRomDesc[] = {
	{ "Asterix & Obelix (Europe) (En,Fr,De,Es).sfc",          1572864, 0x83af6152, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAsterixObelixEuropeEnFrDeEs)
STD_ROM_FN(rAsterixObelixEuropeEnFrDeEs)

struct BurnDriver BurnDrvrAsterixObelixEuropeEnFrDeEs = {
	"Asterix & Obelix (Europe) (En,Fr,De,Es)", NULL, NULL, "1986",
	"Asterix & Obelix (Europe) (En,Fr,De,Es)\0", NULL, "Nintendo", "Miscellaneous",
	L"Asterix & Obelix (Europe) (En,Fr,De,Es)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAsterixObelixEuropeEnFrDeEsRomInfo, rAsterixObelixEuropeEnFrDeEsRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAsterixEuropeEnFrDeEsRomDesc[] = {
	{ "Asterix (Europe) (En,Fr,De,Es).sfc",          524288, 0x5ddedc28, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAsterixEuropeEnFrDeEs)
STD_ROM_FN(rAsterixEuropeEnFrDeEs)

struct BurnDriver BurnDrvrAsterixEuropeEnFrDeEs = {
	"Asterix (Europe) (En,Fr,De,Es)", NULL, NULL, "1986",
	"Asterix (Europe) (En,Fr,De,Es)\0", NULL, "Nintendo", "Miscellaneous",
	L"Asterix (Europe) (En,Fr,De,Es)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAsterixEuropeEnFrDeEsRomInfo, rAsterixEuropeEnFrDeEsRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAtlasTheRenaissanceVoyagerJapanRomDesc[] = {
	{ "Atlas, The - Renaissance Voyager (Japan).sfc",          2097152, 0x19e09c6b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAtlasTheRenaissanceVoyagerJapan)
STD_ROM_FN(rAtlasTheRenaissanceVoyagerJapan)

struct BurnDriver BurnDrvrAtlasTheRenaissanceVoyagerJapan = {
	"Atlas, The - Renaissance Voyager (Japan)", NULL, NULL, "1986",
	"Atlas, The - Renaissance Voyager (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Atlas, The - Renaissance Voyager (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAtlasTheRenaissanceVoyagerJapanRomInfo, rAtlasTheRenaissanceVoyagerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAxelayEuropeRomDesc[] = {
	{ "Axelay (Europe).sfc",          1048576, 0xf43f6743, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAxelayEurope)
STD_ROM_FN(rAxelayEurope)

struct BurnDriver BurnDrvrAxelayEurope = {
	"Axelay (Europe)", NULL, NULL, "1986",
	"Axelay (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Axelay (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAxelayEuropeRomInfo, rAxelayEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAxelayJapanRomDesc[] = {
	{ "Axelay (Japan).sfc",          1048576, 0xb0a02734, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAxelayJapan)
STD_ROM_FN(rAxelayJapan)

struct BurnDriver BurnDrvrAxelayJapan = {
	"Axelay (Japan)", NULL, NULL, "1986",
	"Axelay (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Axelay (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAxelayJapanRomInfo, rAxelayJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAxelayUSASampleRomDesc[] = {
	{ "Axelay (USA) (Sample).sfc",          1048576, 0xa0677d80, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAxelayUSASample)
STD_ROM_FN(rAxelayUSASample)

struct BurnDriver BurnDrvrAxelayUSASample = {
	"Axelay (USA) (Sample)", NULL, NULL, "1986",
	"Axelay (USA) (Sample)\0", NULL, "Nintendo", "Miscellaneous",
	L"Axelay (USA) (Sample)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAxelayUSASampleRomInfo, rAxelayUSASampleRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rAxelayUSARomDesc[] = {
	{ "Axelay (USA).sfc",          1048576, 0xf812b533, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rAxelayUSA)
STD_ROM_FN(rAxelayUSA)

struct BurnDriver BurnDrvrAxelayUSA = {
	"Axelay (USA)", NULL, NULL, "1986",
	"Axelay (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Axelay (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rAxelayUSARomInfo, rAxelayUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBDash2GatsugouJapanBSRomDesc[] = {
	{ "B Dash - 2 Gatsugou (Japan) (BS).sfc",          1048576, 0x6b16f32b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBDash2GatsugouJapanBS)
STD_ROM_FN(rBDash2GatsugouJapanBS)

struct BurnDriver BurnDrvrBDash2GatsugouJapanBS = {
	"B Dash - 2 Gatsugou (Japan) (BS)", NULL, NULL, "1986",
	"B Dash - 2 Gatsugou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"B Dash - 2 Gatsugou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBDash2GatsugouJapanBSRomInfo, rBDash2GatsugouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBDash3GatsugouJapanBSRomDesc[] = {
	{ "B Dash - 3 Gatsugou (Japan) (BS).sfc",          1048576, 0xf2630bed, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBDash3GatsugouJapanBS)
STD_ROM_FN(rBDash3GatsugouJapanBS)

struct BurnDriver BurnDrvrBDash3GatsugouJapanBS = {
	"B Dash - 3 Gatsugou (Japan) (BS)", NULL, NULL, "1986",
	"B Dash - 3 Gatsugou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"B Dash - 3 Gatsugou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBDash3GatsugouJapanBSRomInfo, rBDash3GatsugouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBOBEuropeRomDesc[] = {
	{ "B.O.B. (Europe).sfc",          1048576, 0x8d56598b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBOBEurope)
STD_ROM_FN(rBOBEurope)

struct BurnDriver BurnDrvrBOBEurope = {
	"B.O.B. (Europe)", NULL, NULL, "1986",
	"B.O.B. (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"B.O.B. (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBOBEuropeRomInfo, rBOBEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBOBUSARomDesc[] = {
	{ "B.O.B. (USA).sfc",          1048576, 0x4f593c46, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBOBUSA)
STD_ROM_FN(rBOBUSA)

struct BurnDriver BurnDrvrBOBUSA = {
	"B.O.B. (USA)", NULL, NULL, "1986",
	"B.O.B. (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"B.O.B. (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBOBUSARomInfo, rBOBUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBahamutLagoonJapanRomDesc[] = {
	{ "Bahamut Lagoon (Japan).sfc",          3145728, 0x1b83c440, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBahamutLagoonJapan)
STD_ROM_FN(rBahamutLagoonJapan)

struct BurnDriver BurnDrvrBahamutLagoonJapan = {
	"Bahamut Lagoon (Japan)", NULL, NULL, "1986",
	"Bahamut Lagoon (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bahamut Lagoon (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBahamutLagoonJapanRomInfo, rBahamutLagoonJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBakukyuuRenpatsuSuperBDamanJapanRomDesc[] = {
	{ "Bakukyuu Renpatsu!! Super B-Daman (Japan).sfc",          2097152, 0x5613f172, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBakukyuuRenpatsuSuperBDamanJapan)
STD_ROM_FN(rBakukyuuRenpatsuSuperBDamanJapan)

struct BurnDriver BurnDrvrBakukyuuRenpatsuSuperBDamanJapan = {
	"Bakukyuu Renpatsu!! Super B-Daman (Japan)", NULL, NULL, "1986",
	"Bakukyuu Renpatsu!! Super B-Daman (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bakukyuu Renpatsu!! Super B-Daman (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBakukyuuRenpatsuSuperBDamanJapanRomInfo, rBakukyuuRenpatsuSuperBDamanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBakumatsuKourindenOniJapanRomDesc[] = {
	{ "Bakumatsu Kourinden Oni (Japan).sfc",          4194304, 0x1cf3c877, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBakumatsuKourindenOniJapan)
STD_ROM_FN(rBakumatsuKourindenOniJapan)

struct BurnDriver BurnDrvrBakumatsuKourindenOniJapan = {
	"Bakumatsu Kourinden Oni (Japan)", NULL, NULL, "1986",
	"Bakumatsu Kourinden Oni (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bakumatsu Kourinden Oni (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBakumatsuKourindenOniJapanRomInfo, rBakumatsuKourindenOniJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBakutouDochersBumpsjimawaOosawagiJapanRomDesc[] = {
	{ "Bakutou Dochers - Bumps-jima wa Oosawagi (Japan).sfc",          1048576, 0x94bfcc92, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBakutouDochersBumpsjimawaOosawagiJapan)
STD_ROM_FN(rBakutouDochersBumpsjimawaOosawagiJapan)

struct BurnDriver BurnDrvrBakutouDochersBumpsjimawaOosawagiJapan = {
	"Bakutou Dochers - Bumps-jima wa Oosawagi (Japan)", NULL, NULL, "1986",
	"Bakutou Dochers - Bumps-jima wa Oosawagi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bakutou Dochers - Bumps-jima wa Oosawagi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBakutouDochersBumpsjimawaOosawagiJapanRomInfo, rBakutouDochersBumpsjimawaOosawagiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBallBulletGunJapanRomDesc[] = {
	{ "Ball Bullet Gun (Japan).sfc",          1572864, 0xc1e2bb56, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBallBulletGunJapan)
STD_ROM_FN(rBallBulletGunJapan)

struct BurnDriver BurnDrvrBallBulletGunJapan = {
	"Ball Bullet Gun (Japan)", NULL, NULL, "1986",
	"Ball Bullet Gun (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ball Bullet Gun (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBallBulletGunJapanRomInfo, rBallBulletGunJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBallz3DFightingatItsBallziestUSARomDesc[] = {
	{ "Ballz 3D - Fighting at Its Ballziest (USA).sfc",          1048576, 0x1c058b7d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBallz3DFightingatItsBallziestUSA)
STD_ROM_FN(rBallz3DFightingatItsBallziestUSA)

struct BurnDriver BurnDrvrBallz3DFightingatItsBallziestUSA = {
	"Ballz 3D - Fighting at Its Ballziest (USA)", NULL, NULL, "1986",
	"Ballz 3D - Fighting at Its Ballziest (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ballz 3D - Fighting at Its Ballziest (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBallz3DFightingatItsBallziestUSARomInfo, rBallz3DFightingatItsBallziestUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBarbarossaJapanRomDesc[] = {
	{ "Barbarossa (Japan).sfc",          1048576, 0x5283e505, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBarbarossaJapan)
STD_ROM_FN(rBarbarossaJapan)

struct BurnDriver BurnDrvrBarbarossaJapan = {
	"Barbarossa (Japan)", NULL, NULL, "1986",
	"Barbarossa (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Barbarossa (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBarbarossaJapanRomInfo, rBarbarossaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBarbieSuperModelUSARomDesc[] = {
	{ "Barbie Super Model (USA).sfc",          1048576, 0x3b73610e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBarbieSuperModelUSA)
STD_ROM_FN(rBarbieSuperModelUSA)

struct BurnDriver BurnDrvrBarbieSuperModelUSA = {
	"Barbie Super Model (USA)", NULL, NULL, "1986",
	"Barbie Super Model (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Barbie Super Model (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBarbieSuperModelUSARomInfo, rBarbieSuperModelUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBarbieVacationAdventureUSAProtoRomDesc[] = {
	{ "Barbie Vacation Adventure (USA) (Proto).sfc",          1048576, 0x8ce1ba79, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBarbieVacationAdventureUSAProto)
STD_ROM_FN(rBarbieVacationAdventureUSAProto)

struct BurnDriver BurnDrvrBarbieVacationAdventureUSAProto = {
	"Barbie Vacation Adventure (USA) (Proto)", NULL, NULL, "1986",
	"Barbie Vacation Adventure (USA) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Barbie Vacation Adventure (USA) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBarbieVacationAdventureUSAProtoRomInfo, rBarbieVacationAdventureUSAProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBarkleynoPowerDunkJapanRomDesc[] = {
	{ "Barkley no Power Dunk (Japan).sfc",          1572864, 0x8aff96d0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBarkleynoPowerDunkJapan)
STD_ROM_FN(rBarkleynoPowerDunkJapan)

struct BurnDriver BurnDrvrBarkleynoPowerDunkJapan = {
	"Barkley no Power Dunk (Japan)", NULL, NULL, "1986",
	"Barkley no Power Dunk (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Barkley no Power Dunk (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBarkleynoPowerDunkJapanRomInfo, rBarkleynoPowerDunkJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBarkleyShutUpandJamEuropeRomDesc[] = {
	{ "Barkley Shut Up and Jam! (Europe).sfc",          1572864, 0x29fbd13d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBarkleyShutUpandJamEurope)
STD_ROM_FN(rBarkleyShutUpandJamEurope)

struct BurnDriver BurnDrvrBarkleyShutUpandJamEurope = {
	"Barkley Shut Up and Jam! (Europe)", NULL, NULL, "1986",
	"Barkley Shut Up and Jam! (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Barkley Shut Up and Jam! (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBarkleyShutUpandJamEuropeRomInfo, rBarkleyShutUpandJamEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBarkleyShutUpandJamUSARomDesc[] = {
	{ "Barkley Shut Up and Jam! (USA).sfc",          1572864, 0x726b6c5a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBarkleyShutUpandJamUSA)
STD_ROM_FN(rBarkleyShutUpandJamUSA)

struct BurnDriver BurnDrvrBarkleyShutUpandJamUSA = {
	"Barkley Shut Up and Jam! (USA)", NULL, NULL, "1986",
	"Barkley Shut Up and Jam! (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Barkley Shut Up and Jam! (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBarkleyShutUpandJamUSARomInfo, rBarkleyShutUpandJamUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBASSMastersClassicJapanRomDesc[] = {
	{ "BASS Masters Classic (Japan).sfc",          1572864, 0x925206ea, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBASSMastersClassicJapan)
STD_ROM_FN(rBASSMastersClassicJapan)

struct BurnDriver BurnDrvrBASSMastersClassicJapan = {
	"BASS Masters Classic (Japan)", NULL, NULL, "1986",
	"BASS Masters Classic (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"BASS Masters Classic (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBASSMastersClassicJapanRomInfo, rBASSMastersClassicJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBASSMastersClassicUSARomDesc[] = {
	{ "BASS Masters Classic (USA).sfc",          1572864, 0x832a27c2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBASSMastersClassicUSA)
STD_ROM_FN(rBASSMastersClassicUSA)

struct BurnDriver BurnDrvrBASSMastersClassicUSA = {
	"BASS Masters Classic (USA)", NULL, NULL, "1986",
	"BASS Masters Classic (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"BASS Masters Classic (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBASSMastersClassicUSARomInfo, rBASSMastersClassicUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBASSMastersClassicProEditionEuropeRomDesc[] = {
	{ "BASS Masters Classic - Pro Edition (Europe).sfc",          2097152, 0xa2d4b003, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBASSMastersClassicProEditionEurope)
STD_ROM_FN(rBASSMastersClassicProEditionEurope)

struct BurnDriver BurnDrvrBASSMastersClassicProEditionEurope = {
	"BASS Masters Classic - Pro Edition (Europe)", NULL, NULL, "1986",
	"BASS Masters Classic - Pro Edition (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"BASS Masters Classic - Pro Edition (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBASSMastersClassicProEditionEuropeRomInfo, rBASSMastersClassicProEditionEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBASSMastersClassicProEditionUSARomDesc[] = {
	{ "BASS Masters Classic - Pro Edition (USA).sfc",          2097152, 0xc5058634, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBASSMastersClassicProEditionUSA)
STD_ROM_FN(rBASSMastersClassicProEditionUSA)

struct BurnDriver BurnDrvrBASSMastersClassicProEditionUSA = {
	"BASS Masters Classic - Pro Edition (USA)", NULL, NULL, "1986",
	"BASS Masters Classic - Pro Edition (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"BASS Masters Classic - Pro Edition (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBASSMastersClassicProEditionUSARomInfo, rBASSMastersClassicProEditionUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBassinsBlackBassUSARomDesc[] = {
	{ "Bassin's Black Bass (USA).sfc",          2097152, 0x7dc5b7b3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBassinsBlackBassUSA)
STD_ROM_FN(rBassinsBlackBassUSA)

struct BurnDriver BurnDrvrBassinsBlackBassUSA = {
	"Bassin's Black Bass (USA)", NULL, NULL, "1986",
	"Bassin's Black Bass (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bassin's Black Bass (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBassinsBlackBassUSARomInfo, rBassinsBlackBassUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBastardAnkokunoHakaishinJapanRomDesc[] = {
	{ "Bastard!! - Ankoku no Hakaishin (Japan).sfc",          1572864, 0x6742d51c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBastardAnkokunoHakaishinJapan)
STD_ROM_FN(rBastardAnkokunoHakaishinJapan)

struct BurnDriver BurnDrvrBastardAnkokunoHakaishinJapan = {
	"Bastard!! - Ankoku no Hakaishin (Japan)", NULL, NULL, "1986",
	"Bastard!! - Ankoku no Hakaishin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bastard!! - Ankoku no Hakaishin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBastardAnkokunoHakaishinJapanRomInfo, rBastardAnkokunoHakaishinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBatmanUSAProtobRomDesc[] = {
	{ "Batman (USA) (Proto) [b].sfc",          524288, 0x9bae4220, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBatmanUSAProtob)
STD_ROM_FN(rBatmanUSAProtob)

struct BurnDriver BurnDrvrBatmanUSAProtob = {
	"Batman (USA) (Proto) [b]", NULL, NULL, "1986",
	"Batman (USA) (Proto) [b]\0", NULL, "Nintendo", "Miscellaneous",
	L"Batman (USA) (Proto) [b]", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBatmanUSAProtobRomInfo, rBatmanUSAProtobRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBatmanRevengeoftheJokerUSAProtoRomDesc[] = {
	{ "Batman - Revenge of the Joker (USA) (Proto).sfc",          1048576, 0x205654dd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBatmanRevengeoftheJokerUSAProto)
STD_ROM_FN(rBatmanRevengeoftheJokerUSAProto)

struct BurnDriver BurnDrvrBatmanRevengeoftheJokerUSAProto = {
	"Batman - Revenge of the Joker (USA) (Proto)", NULL, NULL, "1986",
	"Batman - Revenge of the Joker (USA) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Batman - Revenge of the Joker (USA) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBatmanRevengeoftheJokerUSAProtoRomInfo, rBatmanRevengeoftheJokerUSAProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBatmanForeverEuropeRomDesc[] = {
	{ "Batman Forever (Europe).sfc",          3145728, 0x6288d8ed, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBatmanForeverEurope)
STD_ROM_FN(rBatmanForeverEurope)

struct BurnDriver BurnDrvrBatmanForeverEurope = {
	"Batman Forever (Europe)", NULL, NULL, "1986",
	"Batman Forever (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Batman Forever (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBatmanForeverEuropeRomInfo, rBatmanForeverEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBatmanForeverJapanRomDesc[] = {
	{ "Batman Forever (Japan).sfc",          3145728, 0x903348f5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBatmanForeverJapan)
STD_ROM_FN(rBatmanForeverJapan)

struct BurnDriver BurnDrvrBatmanForeverJapan = {
	"Batman Forever (Japan)", NULL, NULL, "1986",
	"Batman Forever (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Batman Forever (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBatmanForeverJapanRomInfo, rBatmanForeverJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBatmanForeverUSARomDesc[] = {
	{ "Batman Forever (USA).sfc",          3145728, 0xd9b5e9cf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBatmanForeverUSA)
STD_ROM_FN(rBatmanForeverUSA)

struct BurnDriver BurnDrvrBatmanForeverUSA = {
	"Batman Forever (USA)", NULL, NULL, "1986",
	"Batman Forever (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Batman Forever (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBatmanForeverUSARomInfo, rBatmanForeverUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBatmanReturnsEuropeRomDesc[] = {
	{ "Batman Returns (Europe).sfc",          1048576, 0x42f98e71, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBatmanReturnsEurope)
STD_ROM_FN(rBatmanReturnsEurope)

struct BurnDriver BurnDrvrBatmanReturnsEurope = {
	"Batman Returns (Europe)", NULL, NULL, "1986",
	"Batman Returns (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Batman Returns (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBatmanReturnsEuropeRomInfo, rBatmanReturnsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBatmanReturnsJapanSampleRomDesc[] = {
	{ "Batman Returns (Japan) (Sample).sfc",          1048576, 0x9ce7d5ba, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBatmanReturnsJapanSample)
STD_ROM_FN(rBatmanReturnsJapanSample)

struct BurnDriver BurnDrvrBatmanReturnsJapanSample = {
	"Batman Returns (Japan) (Sample)", NULL, NULL, "1986",
	"Batman Returns (Japan) (Sample)\0", NULL, "Nintendo", "Miscellaneous",
	L"Batman Returns (Japan) (Sample)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBatmanReturnsJapanSampleRomInfo, rBatmanReturnsJapanSampleRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBatmanReturnsJapanRomDesc[] = {
	{ "Batman Returns (Japan).sfc",          1048576, 0x5bed3661, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBatmanReturnsJapan)
STD_ROM_FN(rBatmanReturnsJapan)

struct BurnDriver BurnDrvrBatmanReturnsJapan = {
	"Batman Returns (Japan)", NULL, NULL, "1986",
	"Batman Returns (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Batman Returns (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBatmanReturnsJapanRomInfo, rBatmanReturnsJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBatmanReturnsUSARomDesc[] = {
	{ "Batman Returns (USA).sfc",          1048576, 0xe87dfdf6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBatmanReturnsUSA)
STD_ROM_FN(rBatmanReturnsUSA)

struct BurnDriver BurnDrvrBatmanReturnsUSA = {
	"Batman Returns (USA)", NULL, NULL, "1986",
	"Batman Returns (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Batman Returns (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBatmanReturnsUSARomInfo, rBatmanReturnsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleBlazeJapanRomDesc[] = {
	{ "Battle Blaze (Japan).sfc",          1048576, 0xb9cd2ff3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleBlazeJapan)
STD_ROM_FN(rBattleBlazeJapan)

struct BurnDriver BurnDrvrBattleBlazeJapan = {
	"Battle Blaze (Japan)", NULL, NULL, "1986",
	"Battle Blaze (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Blaze (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleBlazeJapanRomInfo, rBattleBlazeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleBlazeUSABetaRomDesc[] = {
	{ "Battle Blaze (USA) (Beta).sfc",          1048576, 0x9f2ba6a9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleBlazeUSABeta)
STD_ROM_FN(rBattleBlazeUSABeta)

struct BurnDriver BurnDrvrBattleBlazeUSABeta = {
	"Battle Blaze (USA) (Beta)", NULL, NULL, "1986",
	"Battle Blaze (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Blaze (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleBlazeUSABetaRomInfo, rBattleBlazeUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleBlazeUSARomDesc[] = {
	{ "Battle Blaze (USA).sfc",          1048576, 0xd933bd8d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleBlazeUSA)
STD_ROM_FN(rBattleBlazeUSA)

struct BurnDriver BurnDrvrBattleBlazeUSA = {
	"Battle Blaze (USA)", NULL, NULL, "1986",
	"Battle Blaze (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Blaze (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleBlazeUSARomInfo, rBattleBlazeUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleCarsUSARomDesc[] = {
	{ "Battle Cars (USA).sfc",          1048576, 0x46043454, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleCarsUSA)
STD_ROM_FN(rBattleCarsUSA)

struct BurnDriver BurnDrvrBattleCarsUSA = {
	"Battle Cars (USA)", NULL, NULL, "1986",
	"Battle Cars (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Cars (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleCarsUSARomInfo, rBattleCarsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleClashEuropeRomDesc[] = {
	{ "Battle Clash (Europe).sfc",          1048576, 0x11e5bc5e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleClashEurope)
STD_ROM_FN(rBattleClashEurope)

struct BurnDriver BurnDrvrBattleClashEurope = {
	"Battle Clash (Europe)", NULL, NULL, "1986",
	"Battle Clash (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Clash (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleClashEuropeRomInfo, rBattleClashEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleClashUSARomDesc[] = {
	{ "Battle Clash (USA).sfc",          1048576, 0x59c00310, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleClashUSA)
STD_ROM_FN(rBattleClashUSA)

struct BurnDriver BurnDrvrBattleClashUSA = {
	"Battle Clash (USA)", NULL, NULL, "1986",
	"Battle Clash (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Clash (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleClashUSARomInfo, rBattleClashUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleCommanderHachibushuuShuranoHeihouJapanRomDesc[] = {
	{ "Battle Commander - Hachibushuu, Shura no Heihou (Japan).sfc",          1048576, 0xad80e50e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleCommanderHachibushuuShuranoHeihouJapan)
STD_ROM_FN(rBattleCommanderHachibushuuShuranoHeihouJapan)

struct BurnDriver BurnDrvrBattleCommanderHachibushuuShuranoHeihouJapan = {
	"Battle Commander - Hachibushuu, Shura no Heihou (Japan)", NULL, NULL, "1986",
	"Battle Commander - Hachibushuu, Shura no Heihou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Commander - Hachibushuu, Shura no Heihou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleCommanderHachibushuuShuranoHeihouJapanRomInfo, rBattleCommanderHachibushuuShuranoHeihouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleCrossJapanRomDesc[] = {
	{ "Battle Cross (Japan).sfc",          1048576, 0x5f5e9b0b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleCrossJapan)
STD_ROM_FN(rBattleCrossJapan)

struct BurnDriver BurnDrvrBattleCrossJapan = {
	"Battle Cross (Japan)", NULL, NULL, "1986",
	"Battle Cross (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Cross (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleCrossJapanRomInfo, rBattleCrossJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleDodgeBallToukyuuDaigekitotsuJapanRomDesc[] = {
	{ "Battle Dodge Ball - Toukyuu Daigekitotsu! (Japan).sfc",          1048576, 0x99a1f158, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleDodgeBallToukyuuDaigekitotsuJapan)
STD_ROM_FN(rBattleDodgeBallToukyuuDaigekitotsuJapan)

struct BurnDriver BurnDrvrBattleDodgeBallToukyuuDaigekitotsuJapan = {
	"Battle Dodge Ball - Toukyuu Daigekitotsu! (Japan)", NULL, NULL, "1986",
	"Battle Dodge Ball - Toukyuu Daigekitotsu! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Dodge Ball - Toukyuu Daigekitotsu! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleDodgeBallToukyuuDaigekitotsuJapanRomInfo, rBattleDodgeBallToukyuuDaigekitotsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleDodgeBallIIJapanRomDesc[] = {
	{ "Battle Dodge Ball II (Japan).sfc",          1572864, 0x43d3f2b2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleDodgeBallIIJapan)
STD_ROM_FN(rBattleDodgeBallIIJapan)

struct BurnDriver BurnDrvrBattleDodgeBallIIJapan = {
	"Battle Dodge Ball II (Japan)", NULL, NULL, "1986",
	"Battle Dodge Ball II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Dodge Ball II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleDodgeBallIIJapanRomInfo, rBattleDodgeBallIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleGrandPrixJapanRomDesc[] = {
	{ "Battle Grand Prix (Japan).sfc",          1048576, 0x8b8afd6f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleGrandPrixJapan)
STD_ROM_FN(rBattleGrandPrixJapan)

struct BurnDriver BurnDrvrBattleGrandPrixJapan = {
	"Battle Grand Prix (Japan)", NULL, NULL, "1986",
	"Battle Grand Prix (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Grand Prix (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleGrandPrixJapanRomInfo, rBattleGrandPrixJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleGrandPrixUSARomDesc[] = {
	{ "Battle Grand Prix (USA).sfc",          1048576, 0x190ff436, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleGrandPrixUSA)
STD_ROM_FN(rBattleGrandPrixUSA)

struct BurnDriver BurnDrvrBattleGrandPrixUSA = {
	"Battle Grand Prix (USA)", NULL, NULL, "1986",
	"Battle Grand Prix (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Grand Prix (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleGrandPrixUSARomInfo, rBattleGrandPrixUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleJockeyJapanRomDesc[] = {
	{ "Battle Jockey (Japan).sfc",          1048576, 0xd79c1ec5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleJockeyJapan)
STD_ROM_FN(rBattleJockeyJapan)

struct BurnDriver BurnDrvrBattleJockeyJapan = {
	"Battle Jockey (Japan)", NULL, NULL, "1986",
	"Battle Jockey (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Jockey (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleJockeyJapanRomInfo, rBattleJockeyJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleMasterKyuukyokunoSenshitachiJapanRomDesc[] = {
	{ "Battle Master - Kyuukyoku no Senshi-tachi (Japan).sfc",          2097152, 0xdbf76bfd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleMasterKyuukyokunoSenshitachiJapan)
STD_ROM_FN(rBattleMasterKyuukyokunoSenshitachiJapan)

struct BurnDriver BurnDrvrBattleMasterKyuukyokunoSenshitachiJapan = {
	"Battle Master - Kyuukyoku no Senshi-tachi (Japan)", NULL, NULL, "1986",
	"Battle Master - Kyuukyoku no Senshi-tachi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Master - Kyuukyoku no Senshi-tachi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleMasterKyuukyokunoSenshitachiJapanRomInfo, rBattleMasterKyuukyokunoSenshitachiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattlePinballJapanRomDesc[] = {
	{ "Battle Pinball (Japan).sfc",          1310720, 0x54901522, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattlePinballJapan)
STD_ROM_FN(rBattlePinballJapan)

struct BurnDriver BurnDrvrBattlePinballJapan = {
	"Battle Pinball (Japan)", NULL, NULL, "1986",
	"Battle Pinball (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Pinball (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattlePinballJapanRomInfo, rBattlePinballJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleRacersJapanRomDesc[] = {
	{ "Battle Racers (Japan).sfc",          1048576, 0x64b76ceb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleRacersJapan)
STD_ROM_FN(rBattleRacersJapan)

struct BurnDriver BurnDrvrBattleRacersJapan = {
	"Battle Racers (Japan)", NULL, NULL, "1986",
	"Battle Racers (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Racers (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleRacersJapanRomInfo, rBattleRacersJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleRobotRetsudenJapanRomDesc[] = {
	{ "Battle Robot Retsuden (Japan).sfc",          3145728, 0xb72bf1f2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleRobotRetsudenJapan)
STD_ROM_FN(rBattleRobotRetsudenJapan)

struct BurnDriver BurnDrvrBattleRobotRetsudenJapan = {
	"Battle Robot Retsuden (Japan)", NULL, NULL, "1986",
	"Battle Robot Retsuden (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Robot Retsuden (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleRobotRetsudenJapanRomInfo, rBattleRobotRetsudenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleSoccerFieldnoHashaJapanRomDesc[] = {
	{ "Battle Soccer - Field no Hasha (Japan).sfc",          1048576, 0xc54ae0f9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleSoccerFieldnoHashaJapan)
STD_ROM_FN(rBattleSoccerFieldnoHashaJapan)

struct BurnDriver BurnDrvrBattleSoccerFieldnoHashaJapan = {
	"Battle Soccer - Field no Hasha (Japan)", NULL, NULL, "1986",
	"Battle Soccer - Field no Hasha (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Soccer - Field no Hasha (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleSoccerFieldnoHashaJapanRomInfo, rBattleSoccerFieldnoHashaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleSoccer2JapanRomDesc[] = {
	{ "Battle Soccer 2 (Japan).sfc",          1310720, 0x5316dd26, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleSoccer2Japan)
STD_ROM_FN(rBattleSoccer2Japan)

struct BurnDriver BurnDrvrBattleSoccer2Japan = {
	"Battle Soccer 2 (Japan)", NULL, NULL, "1986",
	"Battle Soccer 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Soccer 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleSoccer2JapanRomInfo, rBattleSoccer2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleSubmarineJapanRomDesc[] = {
	{ "Battle Submarine (Japan).sfc",          1048576, 0xda2ad2fe, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleSubmarineJapan)
STD_ROM_FN(rBattleSubmarineJapan)

struct BurnDriver BurnDrvrBattleSubmarineJapan = {
	"Battle Submarine (Japan)", NULL, NULL, "1986",
	"Battle Submarine (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Submarine (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleSubmarineJapanRomInfo, rBattleSubmarineJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleTycoonFlashHidersSFXJapanRev1RomDesc[] = {
	{ "Battle Tycoon - Flash Hiders SFX (Japan) (Rev 1).sfc",          3145728, 0x92afab02, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleTycoonFlashHidersSFXJapanRev1)
STD_ROM_FN(rBattleTycoonFlashHidersSFXJapanRev1)

struct BurnDriver BurnDrvrBattleTycoonFlashHidersSFXJapanRev1 = {
	"Battle Tycoon - Flash Hiders SFX (Japan) (Rev 1)", NULL, NULL, "1986",
	"Battle Tycoon - Flash Hiders SFX (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Tycoon - Flash Hiders SFX (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleTycoonFlashHidersSFXJapanRev1RomInfo, rBattleTycoonFlashHidersSFXJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleTycoonFlashHidersSFXJapanRomDesc[] = {
	{ "Battle Tycoon - Flash Hiders SFX (Japan).sfc",          3145728, 0xe38c4a5b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleTycoonFlashHidersSFXJapan)
STD_ROM_FN(rBattleTycoonFlashHidersSFXJapan)

struct BurnDriver BurnDrvrBattleTycoonFlashHidersSFXJapan = {
	"Battle Tycoon - Flash Hiders SFX (Japan)", NULL, NULL, "1986",
	"Battle Tycoon - Flash Hiders SFX (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Tycoon - Flash Hiders SFX (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleTycoonFlashHidersSFXJapanRomInfo, rBattleTycoonFlashHidersSFXJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleZequeDenJapanRomDesc[] = {
	{ "Battle Zeque Den (Japan).sfc",          1572864, 0x8cac063c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleZequeDenJapan)
STD_ROM_FN(rBattleZequeDenJapan)

struct BurnDriver BurnDrvrBattleZequeDenJapan = {
	"Battle Zeque Den (Japan)", NULL, NULL, "1986",
	"Battle Zeque Den (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battle Zeque Den (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleZequeDenJapanRomInfo, rBattleZequeDenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleTechJapanRomDesc[] = {
	{ "BattleTech (Japan).sfc",          1048576, 0xfa29e335, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleTechJapan)
STD_ROM_FN(rBattleTechJapan)

struct BurnDriver BurnDrvrBattleTechJapan = {
	"BattleTech (Japan)", NULL, NULL, "1986",
	"BattleTech (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"BattleTech (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleTechJapanRomInfo, rBattleTechJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattleTech3050JapanRomDesc[] = {
	{ "BattleTech 3050 (Japan).sfc",          1572864, 0x56c7eb66, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattleTech3050Japan)
STD_ROM_FN(rBattleTech3050Japan)

struct BurnDriver BurnDrvrBattleTech3050Japan = {
	"BattleTech 3050 (Japan)", NULL, NULL, "1986",
	"BattleTech 3050 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"BattleTech 3050 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattleTech3050JapanRomInfo, rBattleTech3050JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattletoadsDoubleDragonTheUltimateTeamEuropeRomDesc[] = {
	{ "Battletoads & Double Dragon - The Ultimate Team (Europe).sfc",          1048576, 0x43f3773, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattletoadsDoubleDragonTheUltimateTeamEurope)
STD_ROM_FN(rBattletoadsDoubleDragonTheUltimateTeamEurope)

struct BurnDriver BurnDrvrBattletoadsDoubleDragonTheUltimateTeamEurope = {
	"Battletoads & Double Dragon - The Ultimate Team (Europe)", NULL, NULL, "1986",
	"Battletoads & Double Dragon - The Ultimate Team (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battletoads & Double Dragon - The Ultimate Team (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattletoadsDoubleDragonTheUltimateTeamEuropeRomInfo, rBattletoadsDoubleDragonTheUltimateTeamEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattletoadsDoubleDragonTheUltimateTeamUSARomDesc[] = {
	{ "Battletoads & Double Dragon - The Ultimate Team (USA).sfc",          1048576, 0x8b18ac01, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattletoadsDoubleDragonTheUltimateTeamUSA)
STD_ROM_FN(rBattletoadsDoubleDragonTheUltimateTeamUSA)

struct BurnDriver BurnDrvrBattletoadsDoubleDragonTheUltimateTeamUSA = {
	"Battletoads & Double Dragon - The Ultimate Team (USA)", NULL, NULL, "1986",
	"Battletoads & Double Dragon - The Ultimate Team (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battletoads & Double Dragon - The Ultimate Team (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattletoadsDoubleDragonTheUltimateTeamUSARomInfo, rBattletoadsDoubleDragonTheUltimateTeamUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattletoadsinBattlemaniacsEuropeRomDesc[] = {
	{ "Battletoads in Battlemaniacs (Europe).sfc",          1048576, 0xbbf1cf8d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattletoadsinBattlemaniacsEurope)
STD_ROM_FN(rBattletoadsinBattlemaniacsEurope)

struct BurnDriver BurnDrvrBattletoadsinBattlemaniacsEurope = {
	"Battletoads in Battlemaniacs (Europe)", NULL, NULL, "1986",
	"Battletoads in Battlemaniacs (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battletoads in Battlemaniacs (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattletoadsinBattlemaniacsEuropeRomInfo, rBattletoadsinBattlemaniacsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattletoadsinBattlemaniacsJapanRomDesc[] = {
	{ "Battletoads in Battlemaniacs (Japan).sfc",          1048576, 0x48f15b03, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattletoadsinBattlemaniacsJapan)
STD_ROM_FN(rBattletoadsinBattlemaniacsJapan)

struct BurnDriver BurnDrvrBattletoadsinBattlemaniacsJapan = {
	"Battletoads in Battlemaniacs (Japan)", NULL, NULL, "1986",
	"Battletoads in Battlemaniacs (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battletoads in Battlemaniacs (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattletoadsinBattlemaniacsJapanRomInfo, rBattletoadsinBattlemaniacsJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattletoadsinBattlemaniacsUSABetaRomDesc[] = {
	{ "Battletoads in Battlemaniacs (USA) (Beta).sfc",          1048576, 0x1783e3a2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattletoadsinBattlemaniacsUSABeta)
STD_ROM_FN(rBattletoadsinBattlemaniacsUSABeta)

struct BurnDriver BurnDrvrBattletoadsinBattlemaniacsUSABeta = {
	"Battletoads in Battlemaniacs (USA) (Beta)", NULL, NULL, "1986",
	"Battletoads in Battlemaniacs (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battletoads in Battlemaniacs (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattletoadsinBattlemaniacsUSABetaRomInfo, rBattletoadsinBattlemaniacsUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBattletoadsinBattlemaniacsUSARomDesc[] = {
	{ "Battletoads in Battlemaniacs (USA).sfc",          1048576, 0x617ac925, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBattletoadsinBattlemaniacsUSA)
STD_ROM_FN(rBattletoadsinBattlemaniacsUSA)

struct BurnDriver BurnDrvrBattletoadsinBattlemaniacsUSA = {
	"Battletoads in Battlemaniacs (USA)", NULL, NULL, "1986",
	"Battletoads in Battlemaniacs (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Battletoads in Battlemaniacs (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBattletoadsinBattlemaniacsUSARomInfo, rBattletoadsinBattlemaniacsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBazoeMahouSekaiJapanRomDesc[] = {
	{ "Bazoe! Mahou Sekai (Japan).sfc",          1572864, 0xd5b09eef, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBazoeMahouSekaiJapan)
STD_ROM_FN(rBazoeMahouSekaiJapan)

struct BurnDriver BurnDrvrBazoeMahouSekaiJapan = {
	"Bazoe! Mahou Sekai (Japan)", NULL, NULL, "1986",
	"Bazoe! Mahou Sekai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bazoe! Mahou Sekai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBazoeMahouSekaiJapanRomInfo, rBazoeMahouSekaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBazookaBlitzkriegUSARomDesc[] = {
	{ "Bazooka Blitzkrieg (USA).sfc",          524288, 0x49c187f3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBazookaBlitzkriegUSA)
STD_ROM_FN(rBazookaBlitzkriegUSA)

struct BurnDriver BurnDrvrBazookaBlitzkriegUSA = {
	"Bazooka Blitzkrieg (USA)", NULL, NULL, "1986",
	"Bazooka Blitzkrieg (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bazooka Blitzkrieg (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBazookaBlitzkriegUSARomInfo, rBazookaBlitzkriegUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBeautyandtheBeastEuropeBetaRomDesc[] = {
	{ "Beauty and the Beast (Europe) (Beta).sfc",          1048576, 0xfff9deab, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBeautyandtheBeastEuropeBeta)
STD_ROM_FN(rBeautyandtheBeastEuropeBeta)

struct BurnDriver BurnDrvrBeautyandtheBeastEuropeBeta = {
	"Beauty and the Beast (Europe) (Beta)", NULL, NULL, "1986",
	"Beauty and the Beast (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Beauty and the Beast (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBeautyandtheBeastEuropeBetaRomInfo, rBeautyandtheBeastEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBeautyandtheBeastEuropeRomDesc[] = {
	{ "Beauty and the Beast (Europe).sfc",          1048576, 0x2e70c844, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBeautyandtheBeastEurope)
STD_ROM_FN(rBeautyandtheBeastEurope)

struct BurnDriver BurnDrvrBeautyandtheBeastEurope = {
	"Beauty and the Beast (Europe)", NULL, NULL, "1986",
	"Beauty and the Beast (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Beauty and the Beast (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBeautyandtheBeastEuropeRomInfo, rBeautyandtheBeastEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBeautyandtheBeastUSARomDesc[] = {
	{ "Beauty and the Beast (USA).sfc",          1048576, 0x956e183c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBeautyandtheBeastUSA)
STD_ROM_FN(rBeautyandtheBeastUSA)

struct BurnDriver BurnDrvrBeautyandtheBeastUSA = {
	"Beauty and the Beast (USA)", NULL, NULL, "1986",
	"Beauty and the Beast (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Beauty and the Beast (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBeautyandtheBeastUSARomInfo, rBeautyandtheBeastUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBeavisandButtHeadEuropeRomDesc[] = {
	{ "Beavis and Butt-Head (Europe).sfc",          1572864, 0xf77f160b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBeavisandButtHeadEurope)
STD_ROM_FN(rBeavisandButtHeadEurope)

struct BurnDriver BurnDrvrBeavisandButtHeadEurope = {
	"Beavis and Butt-Head (Europe)", NULL, NULL, "1986",
	"Beavis and Butt-Head (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Beavis and Butt-Head (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBeavisandButtHeadEuropeRomInfo, rBeavisandButtHeadEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBeavisandButtHeadUSARomDesc[] = {
	{ "Beavis and Butt-Head (USA).sfc",          1572864, 0x15cf4bd5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBeavisandButtHeadUSA)
STD_ROM_FN(rBeavisandButtHeadUSA)

struct BurnDriver BurnDrvrBeavisandButtHeadUSA = {
	"Beavis and Butt-Head (USA)", NULL, NULL, "1986",
	"Beavis and Butt-Head (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Beavis and Butt-Head (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBeavisandButtHeadUSARomInfo, rBeavisandButtHeadUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBebesKidsUSARomDesc[] = {
	{ "Bebe's Kids (USA).sfc",          1048576, 0xbda2e412, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBebesKidsUSA)
STD_ROM_FN(rBebesKidsUSA)

struct BurnDriver BurnDrvrBebesKidsUSA = {
	"Bebe's Kids (USA)", NULL, NULL, "1986",
	"Bebe's Kids (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bebe's Kids (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBebesKidsUSARomInfo, rBebesKidsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBeethovenTheUltimateCanineCaperEuropeRomDesc[] = {
	{ "Beethoven - The Ultimate Canine Caper! (Europe).sfc",          524288, 0x4d1352ad, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBeethovenTheUltimateCanineCaperEurope)
STD_ROM_FN(rBeethovenTheUltimateCanineCaperEurope)

struct BurnDriver BurnDrvrBeethovenTheUltimateCanineCaperEurope = {
	"Beethoven - The Ultimate Canine Caper! (Europe)", NULL, NULL, "1986",
	"Beethoven - The Ultimate Canine Caper! (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Beethoven - The Ultimate Canine Caper! (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBeethovenTheUltimateCanineCaperEuropeRomInfo, rBeethovenTheUltimateCanineCaperEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBeethovenTheUltimateCanineCaperUSARomDesc[] = {
	{ "Beethoven - The Ultimate Canine Caper! (USA).sfc",          524288, 0xbeebafa2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBeethovenTheUltimateCanineCaperUSA)
STD_ROM_FN(rBeethovenTheUltimateCanineCaperUSA)

struct BurnDriver BurnDrvrBeethovenTheUltimateCanineCaperUSA = {
	"Beethoven - The Ultimate Canine Caper! (USA)", NULL, NULL, "1986",
	"Beethoven - The Ultimate Canine Caper! (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Beethoven - The Ultimate Canine Caper! (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBeethovenTheUltimateCanineCaperUSARomInfo, rBeethovenTheUltimateCanineCaperUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBenkeiGaidenSunanoShouJapanRomDesc[] = {
	{ "Benkei Gaiden - Suna no Shou (Japan).sfc",          1572864, 0x2743017d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBenkeiGaidenSunanoShouJapan)
STD_ROM_FN(rBenkeiGaidenSunanoShouJapan)

struct BurnDriver BurnDrvrBenkeiGaidenSunanoShouJapan = {
	"Benkei Gaiden - Suna no Shou (Japan)", NULL, NULL, "1986",
	"Benkei Gaiden - Suna no Shou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Benkei Gaiden - Suna no Shou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBenkeiGaidenSunanoShouJapanRomInfo, rBenkeiGaidenSunanoShouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBestoftheBestChampionshipKarateEuropeBetaRomDesc[] = {
	{ "Best of the Best - Championship Karate (Europe) (Beta).sfc",          1048576, 0x20aa9b78, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBestoftheBestChampionshipKarateEuropeBeta)
STD_ROM_FN(rBestoftheBestChampionshipKarateEuropeBeta)

struct BurnDriver BurnDrvrBestoftheBestChampionshipKarateEuropeBeta = {
	"Best of the Best - Championship Karate (Europe) (Beta)", NULL, NULL, "1986",
	"Best of the Best - Championship Karate (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Best of the Best - Championship Karate (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBestoftheBestChampionshipKarateEuropeBetaRomInfo, rBestoftheBestChampionshipKarateEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBestoftheBestChampionshipKarateEuropeRomDesc[] = {
	{ "Best of the Best - Championship Karate (Europe).sfc",          1048576, 0xd63831a5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBestoftheBestChampionshipKarateEurope)
STD_ROM_FN(rBestoftheBestChampionshipKarateEurope)

struct BurnDriver BurnDrvrBestoftheBestChampionshipKarateEurope = {
	"Best of the Best - Championship Karate (Europe)", NULL, NULL, "1986",
	"Best of the Best - Championship Karate (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Best of the Best - Championship Karate (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBestoftheBestChampionshipKarateEuropeRomInfo, rBestoftheBestChampionshipKarateEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBestoftheBestChampionshipKarateUSARomDesc[] = {
	{ "Best of the Best - Championship Karate (USA).sfc",          1048576, 0x7f6ed86e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBestoftheBestChampionshipKarateUSA)
STD_ROM_FN(rBestoftheBestChampionshipKarateUSA)

struct BurnDriver BurnDrvrBestoftheBestChampionshipKarateUSA = {
	"Best of the Best - Championship Karate (USA)", NULL, NULL, "1986",
	"Best of the Best - Championship Karate (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Best of the Best - Championship Karate (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBestoftheBestChampionshipKarateUSARomInfo, rBestoftheBestChampionshipKarateUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBestShotProGolfJapanRomDesc[] = {
	{ "Best Shot Pro Golf (Japan).sfc",          4194304, 0x256d4bc4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBestShotProGolfJapan)
STD_ROM_FN(rBestShotProGolfJapan)

struct BurnDriver BurnDrvrBestShotProGolfJapan = {
	"Best Shot Pro Golf (Japan)", NULL, NULL, "1986",
	"Best Shot Pro Golf (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Best Shot Pro Golf (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBestShotProGolfJapanRomInfo, rBestShotProGolfJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBigIchigekiPachiSlotDaikouryakuJapanRomDesc[] = {
	{ "Big Ichigeki! Pachi-Slot Daikouryaku (Japan).sfc",          524288, 0xfb8ed6aa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBigIchigekiPachiSlotDaikouryakuJapan)
STD_ROM_FN(rBigIchigekiPachiSlotDaikouryakuJapan)

struct BurnDriver BurnDrvrBigIchigekiPachiSlotDaikouryakuJapan = {
	"Big Ichigeki! Pachi-Slot Daikouryaku (Japan)", NULL, NULL, "1986",
	"Big Ichigeki! Pachi-Slot Daikouryaku (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Big Ichigeki! Pachi-Slot Daikouryaku (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBigIchigekiPachiSlotDaikouryakuJapanRomInfo, rBigIchigekiPachiSlotDaikouryakuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBigIchigekiPachiSlotDaikouryaku2UniversalCollectionJapanRomDesc[] = {
	{ "Big Ichigeki! Pachi-Slot Daikouryaku 2 - Universal Collection (Japan).sfc",          1572864, 0x3aee8812, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBigIchigekiPachiSlotDaikouryaku2UniversalCollectionJapan)
STD_ROM_FN(rBigIchigekiPachiSlotDaikouryaku2UniversalCollectionJapan)

struct BurnDriver BurnDrvrBigIchigekiPachiSlotDaikouryaku2UniversalCollectionJapan = {
	"Big Ichigeki! Pachi-Slot Daikouryaku 2 - Universal Collection (Japan)", NULL, NULL, "1986",
	"Big Ichigeki! Pachi-Slot Daikouryaku 2 - Universal Collection (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Big Ichigeki! Pachi-Slot Daikouryaku 2 - Universal Collection (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBigIchigekiPachiSlotDaikouryaku2UniversalCollectionJapanRomInfo, rBigIchigekiPachiSlotDaikouryaku2UniversalCollectionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBigSkyTrooperEuropeRomDesc[] = {
	{ "Big Sky Trooper (Europe).sfc",          1048576, 0x1b565be7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBigSkyTrooperEurope)
STD_ROM_FN(rBigSkyTrooperEurope)

struct BurnDriver BurnDrvrBigSkyTrooperEurope = {
	"Big Sky Trooper (Europe)", NULL, NULL, "1986",
	"Big Sky Trooper (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Big Sky Trooper (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBigSkyTrooperEuropeRomInfo, rBigSkyTrooperEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBigSkyTrooperUSABetaRomDesc[] = {
	{ "Big Sky Trooper (USA) (Beta).sfc",          1048576, 0x7955ebfe, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBigSkyTrooperUSABeta)
STD_ROM_FN(rBigSkyTrooperUSABeta)

struct BurnDriver BurnDrvrBigSkyTrooperUSABeta = {
	"Big Sky Trooper (USA) (Beta)", NULL, NULL, "1986",
	"Big Sky Trooper (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Big Sky Trooper (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBigSkyTrooperUSABetaRomInfo, rBigSkyTrooperUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBigSkyTrooperUSARomDesc[] = {
	{ "Big Sky Trooper (USA).sfc",          1048576, 0x25c69316, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBigSkyTrooperUSA)
STD_ROM_FN(rBigSkyTrooperUSA)

struct BurnDriver BurnDrvrBigSkyTrooperUSA = {
	"Big Sky Trooper (USA)", NULL, NULL, "1986",
	"Big Sky Trooper (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Big Sky Trooper (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBigSkyTrooperUSARomInfo, rBigSkyTrooperUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBijotoYajuuJapanRomDesc[] = {
	{ "Bijo to Yajuu (Japan).sfc",          1048576, 0xb319c546, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBijotoYajuuJapan)
STD_ROM_FN(rBijotoYajuuJapan)

struct BurnDriver BurnDrvrBijotoYajuuJapan = {
	"Bijo to Yajuu (Japan)", NULL, NULL, "1986",
	"Bijo to Yajuu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bijo to Yajuu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBijotoYajuuJapanRomInfo, rBijotoYajuuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBikeDaisukiHashiriyaTamashiiJapanRomDesc[] = {
	{ "Bike Daisuki! Hashiriya Tamashii (Japan).sfc",          524288, 0xb363fc99, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBikeDaisukiHashiriyaTamashiiJapan)
STD_ROM_FN(rBikeDaisukiHashiriyaTamashiiJapan)

struct BurnDriver BurnDrvrBikeDaisukiHashiriyaTamashiiJapan = {
	"Bike Daisuki! Hashiriya Tamashii (Japan)", NULL, NULL, "1986",
	"Bike Daisuki! Hashiriya Tamashii (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bike Daisuki! Hashiriya Tamashii (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBikeDaisukiHashiriyaTamashiiJapanRomInfo, rBikeDaisukiHashiriyaTamashiiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBikerMicefromMarsEuropeRomDesc[] = {
	{ "Biker Mice from Mars (Europe).sfc",          1048576, 0x1a06db31, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBikerMicefromMarsEurope)
STD_ROM_FN(rBikerMicefromMarsEurope)

struct BurnDriver BurnDrvrBikerMicefromMarsEurope = {
	"Biker Mice from Mars (Europe)", NULL, NULL, "1986",
	"Biker Mice from Mars (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Biker Mice from Mars (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBikerMicefromMarsEuropeRomInfo, rBikerMicefromMarsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBikerMicefromMarsUSARomDesc[] = {
	{ "Biker Mice from Mars (USA).sfc",          1048576, 0x4e8b2ecb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBikerMicefromMarsUSA)
STD_ROM_FN(rBikerMicefromMarsUSA)

struct BurnDriver BurnDrvrBikerMicefromMarsUSA = {
	"Biker Mice from Mars (USA)", NULL, NULL, "1986",
	"Biker Mice from Mars (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Biker Mice from Mars (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBikerMicefromMarsUSARomInfo, rBikerMicefromMarsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBillLaimbeersCombatBasketballUSARomDesc[] = {
	{ "Bill Laimbeer's Combat Basketball (USA).sfc",          524288, 0x468d8cdd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBillLaimbeersCombatBasketballUSA)
STD_ROM_FN(rBillLaimbeersCombatBasketballUSA)

struct BurnDriver BurnDrvrBillLaimbeersCombatBasketballUSA = {
	"Bill Laimbeer's Combat Basketball (USA)", NULL, NULL, "1986",
	"Bill Laimbeer's Combat Basketball (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bill Laimbeer's Combat Basketball (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBillLaimbeersCombatBasketballUSARomInfo, rBillLaimbeersCombatBasketballUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBillWalshCollegeFootballUSARomDesc[] = {
	{ "Bill Walsh College Football (USA).sfc",          1048576, 0x25391c9f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBillWalshCollegeFootballUSA)
STD_ROM_FN(rBillWalshCollegeFootballUSA)

struct BurnDriver BurnDrvrBillWalshCollegeFootballUSA = {
	"Bill Walsh College Football (USA)", NULL, NULL, "1986",
	"Bill Walsh College Football (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bill Walsh College Football (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBillWalshCollegeFootballUSARomInfo, rBillWalshCollegeFootballUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBingBingBingoJapanRomDesc[] = {
	{ "Bing Bing! Bingo (Japan).sfc",          1048576, 0xccd77b37, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBingBingBingoJapan)
STD_ROM_FN(rBingBingBingoJapan)

struct BurnDriver BurnDrvrBingBingBingoJapan = {
	"Bing Bing! Bingo (Japan)", NULL, NULL, "1986",
	"Bing Bing! Bingo (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bing Bing! Bingo (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBingBingBingoJapanRomInfo, rBingBingBingoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBioMetalEuropeRomDesc[] = {
	{ "Bio Metal (Europe).sfc",          1048576, 0xe901a947, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBioMetalEurope)
STD_ROM_FN(rBioMetalEurope)

struct BurnDriver BurnDrvrBioMetalEurope = {
	"Bio Metal (Europe)", NULL, NULL, "1986",
	"Bio Metal (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bio Metal (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBioMetalEuropeRomInfo, rBioMetalEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBioMetalJapanRomDesc[] = {
	{ "Bio Metal (Japan).sfc",          1048576, 0x8ba3d382, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBioMetalJapan)
STD_ROM_FN(rBioMetalJapan)

struct BurnDriver BurnDrvrBioMetalJapan = {
	"Bio Metal (Japan)", NULL, NULL, "1986",
	"Bio Metal (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bio Metal (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBioMetalJapanRomInfo, rBioMetalJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBioMetalUSARomDesc[] = {
	{ "Bio Metal (USA).sfc",          1048576, 0x53d8410e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBioMetalUSA)
STD_ROM_FN(rBioMetalUSA)

struct BurnDriver BurnDrvrBioMetalUSA = {
	"Bio Metal (USA)", NULL, NULL, "1986",
	"Bio Metal (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bio Metal (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBioMetalUSARomInfo, rBioMetalUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishinDensetsuZokuJapanRomDesc[] = {
	{ "Bishin Densetsu Zoku (Japan).sfc",          2097152, 0xf02dcb37, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishinDensetsuZokuJapan)
STD_ROM_FN(rBishinDensetsuZokuJapan)

struct BurnDriver BurnDrvrBishinDensetsuZokuJapan = {
	"Bishin Densetsu Zoku (Japan)", NULL, NULL, "1986",
	"Bishin Densetsu Zoku (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishin Densetsu Zoku (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishinDensetsuZokuJapanRomInfo, rBishinDensetsuZokuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoJanshiSuchiePaiJapanRev1RomDesc[] = {
	{ "Bishoujo Janshi Suchie-Pai (Japan) (Rev 1).sfc",          2097152, 0x80e66c55, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoJanshiSuchiePaiJapanRev1)
STD_ROM_FN(rBishoujoJanshiSuchiePaiJapanRev1)

struct BurnDriver BurnDrvrBishoujoJanshiSuchiePaiJapanRev1 = {
	"Bishoujo Janshi Suchie-Pai (Japan) (Rev 1)", NULL, NULL, "1986",
	"Bishoujo Janshi Suchie-Pai (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Janshi Suchie-Pai (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoJanshiSuchiePaiJapanRev1RomInfo, rBishoujoJanshiSuchiePaiJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoJanshiSuchiePaiJapanRomDesc[] = {
	{ "Bishoujo Janshi Suchie-Pai (Japan).sfc",          2097152, 0x11713982, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoJanshiSuchiePaiJapan)
STD_ROM_FN(rBishoujoJanshiSuchiePaiJapan)

struct BurnDriver BurnDrvrBishoujoJanshiSuchiePaiJapan = {
	"Bishoujo Janshi Suchie-Pai (Japan)", NULL, NULL, "1986",
	"Bishoujo Janshi Suchie-Pai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Janshi Suchie-Pai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoJanshiSuchiePaiJapanRomInfo, rBishoujoJanshiSuchiePaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoSenshiSailormoonJapanRomDesc[] = {
	{ "Bishoujo Senshi Sailormoon (Japan).sfc",          1572864, 0xa56323c1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoSenshiSailormoonJapan)
STD_ROM_FN(rBishoujoSenshiSailormoonJapan)

struct BurnDriver BurnDrvrBishoujoSenshiSailormoonJapan = {
	"Bishoujo Senshi Sailormoon (Japan)", NULL, NULL, "1986",
	"Bishoujo Senshi Sailormoon (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Senshi Sailormoon (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoSenshiSailormoonJapanRomInfo, rBishoujoSenshiSailormoonJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoSenshiSailormoonAnotherStoryJapanRomDesc[] = {
	{ "Bishoujo Senshi Sailormoon - Another Story (Japan).sfc",          3145728, 0x2a442b8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoSenshiSailormoonAnotherStoryJapan)
STD_ROM_FN(rBishoujoSenshiSailormoonAnotherStoryJapan)

struct BurnDriver BurnDrvrBishoujoSenshiSailormoonAnotherStoryJapan = {
	"Bishoujo Senshi Sailormoon - Another Story (Japan)", NULL, NULL, "1986",
	"Bishoujo Senshi Sailormoon - Another Story (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Senshi Sailormoon - Another Story (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoSenshiSailormoonAnotherStoryJapanRomInfo, rBishoujoSenshiSailormoonAnotherStoryJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoSenshiSailormoonRJapanRomDesc[] = {
	{ "Bishoujo Senshi Sailormoon R (Japan).sfc",          2097152, 0x4aee5abb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoSenshiSailormoonRJapan)
STD_ROM_FN(rBishoujoSenshiSailormoonRJapan)

struct BurnDriver BurnDrvrBishoujoSenshiSailormoonRJapan = {
	"Bishoujo Senshi Sailormoon R (Japan)", NULL, NULL, "1986",
	"Bishoujo Senshi Sailormoon R (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Senshi Sailormoon R (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoSenshiSailormoonRJapanRomInfo, rBishoujoSenshiSailormoonRJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoSenshiSailormoonSJougaiRantouShuyakuSoudatsusenJapanRomDesc[] = {
	{ "Bishoujo Senshi Sailormoon S - Jougai Rantou! Shuyaku Soudatsusen (Japan).sfc",          2621440, 0xb0fd1854, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoSenshiSailormoonSJougaiRantouShuyakuSoudatsusenJapan)
STD_ROM_FN(rBishoujoSenshiSailormoonSJougaiRantouShuyakuSoudatsusenJapan)

struct BurnDriver BurnDrvrBishoujoSenshiSailormoonSJougaiRantouShuyakuSoudatsusenJapan = {
	"Bishoujo Senshi Sailormoon S - Jougai Rantou! Shuyaku Soudatsusen (Japan)", NULL, NULL, "1986",
	"Bishoujo Senshi Sailormoon S - Jougai Rantou! Shuyaku Soudatsusen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Senshi Sailormoon S - Jougai Rantou! Shuyaku Soudatsusen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoSenshiSailormoonSJougaiRantouShuyakuSoudatsusenJapanRomInfo, rBishoujoSenshiSailormoonSJougaiRantouShuyakuSoudatsusenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoSenshiSailormoonSKondowaPuzzledeOshiokiyoJapanRomDesc[] = {
	{ "Bishoujo Senshi Sailormoon S - Kondo wa Puzzle de Oshioki yo! (Japan).sfc",          524288, 0x10f03e3c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoSenshiSailormoonSKondowaPuzzledeOshiokiyoJapan)
STD_ROM_FN(rBishoujoSenshiSailormoonSKondowaPuzzledeOshiokiyoJapan)

struct BurnDriver BurnDrvrBishoujoSenshiSailormoonSKondowaPuzzledeOshiokiyoJapan = {
	"Bishoujo Senshi Sailormoon S - Kondo wa Puzzle de Oshioki yo! (Japan)", NULL, NULL, "1986",
	"Bishoujo Senshi Sailormoon S - Kondo wa Puzzle de Oshioki yo! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Senshi Sailormoon S - Kondo wa Puzzle de Oshioki yo! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoSenshiSailormoonSKondowaPuzzledeOshiokiyoJapanRomInfo, rBishoujoSenshiSailormoonSKondowaPuzzledeOshiokiyoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoSenshiSailormoonSKurukkurinJapanRomDesc[] = {
	{ "Bishoujo Senshi Sailormoon S - Kurukkurin (Japan).sfc",          524288, 0xe4a271bf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoSenshiSailormoonSKurukkurinJapan)
STD_ROM_FN(rBishoujoSenshiSailormoonSKurukkurinJapan)

struct BurnDriver BurnDrvrBishoujoSenshiSailormoonSKurukkurinJapan = {
	"Bishoujo Senshi Sailormoon S - Kurukkurin (Japan)", NULL, NULL, "1986",
	"Bishoujo Senshi Sailormoon S - Kurukkurin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Senshi Sailormoon S - Kurukkurin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoSenshiSailormoonSKurukkurinJapanRomInfo, rBishoujoSenshiSailormoonSKurukkurinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoSenshiSailormoonSailorstarsFuwafuwaPanic2JapanSTRomDesc[] = {
	{ "Bishoujo Senshi Sailormoon Sailorstars - Fuwafuwa Panic 2 (Japan) (ST).sfc",          1048576, 0xbb5c4238, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoSenshiSailormoonSailorstarsFuwafuwaPanic2JapanST)
STD_ROM_FN(rBishoujoSenshiSailormoonSailorstarsFuwafuwaPanic2JapanST)

struct BurnDriver BurnDrvrBishoujoSenshiSailormoonSailorstarsFuwafuwaPanic2JapanST = {
	"Bishoujo Senshi Sailormoon Sailorstars - Fuwafuwa Panic 2 (Japan) (ST)", NULL, NULL, "1986",
	"Bishoujo Senshi Sailormoon Sailorstars - Fuwafuwa Panic 2 (Japan) (ST)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Senshi Sailormoon Sailorstars - Fuwafuwa Panic 2 (Japan) (ST)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoSenshiSailormoonSailorstarsFuwafuwaPanic2JapanSTRomInfo, rBishoujoSenshiSailormoonSailorstarsFuwafuwaPanic2JapanSTRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoSenshiSailormoonSuperSFuwafuwaPanicJapanRomDesc[] = {
	{ "Bishoujo Senshi Sailormoon Super S - Fuwafuwa Panic (Japan).sfc",          1048576, 0xb6b92ae0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoSenshiSailormoonSuperSFuwafuwaPanicJapan)
STD_ROM_FN(rBishoujoSenshiSailormoonSuperSFuwafuwaPanicJapan)

struct BurnDriver BurnDrvrBishoujoSenshiSailormoonSuperSFuwafuwaPanicJapan = {
	"Bishoujo Senshi Sailormoon Super S - Fuwafuwa Panic (Japan)", NULL, NULL, "1986",
	"Bishoujo Senshi Sailormoon Super S - Fuwafuwa Panic (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Senshi Sailormoon Super S - Fuwafuwa Panic (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoSenshiSailormoonSuperSFuwafuwaPanicJapanRomInfo, rBishoujoSenshiSailormoonSuperSFuwafuwaPanicJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoSenshiSailormoonSuperSZeninSankaShuyakuSoudatsusenJapanRomDesc[] = {
	{ "Bishoujo Senshi Sailormoon Super S - Zenin Sanka!! Shuyaku Soudatsusen (Japan).sfc",          3145728, 0x25440331, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoSenshiSailormoonSuperSZeninSankaShuyakuSoudatsusenJapan)
STD_ROM_FN(rBishoujoSenshiSailormoonSuperSZeninSankaShuyakuSoudatsusenJapan)

struct BurnDriver BurnDrvrBishoujoSenshiSailormoonSuperSZeninSankaShuyakuSoudatsusenJapan = {
	"Bishoujo Senshi Sailormoon Super S - Zenin Sanka!! Shuyaku Soudatsusen (Japan)", NULL, NULL, "1986",
	"Bishoujo Senshi Sailormoon Super S - Zenin Sanka!! Shuyaku Soudatsusen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Senshi Sailormoon Super S - Zenin Sanka!! Shuyaku Soudatsusen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoSenshiSailormoonSuperSZeninSankaShuyakuSoudatsusenJapanRomInfo, rBishoujoSenshiSailormoonSuperSZeninSankaShuyakuSoudatsusenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBishoujoWrestlerRetsudenBlizzardYukiRannyuuJapanRomDesc[] = {
	{ "Bishoujo Wrestler Retsuden - Blizzard Yuki Rannyuu!! (Japan).sfc",          2621440, 0xf4d20413, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBishoujoWrestlerRetsudenBlizzardYukiRannyuuJapan)
STD_ROM_FN(rBishoujoWrestlerRetsudenBlizzardYukiRannyuuJapan)

struct BurnDriver BurnDrvrBishoujoWrestlerRetsudenBlizzardYukiRannyuuJapan = {
	"Bishoujo Wrestler Retsuden - Blizzard Yuki Rannyuu!! (Japan)", NULL, NULL, "1986",
	"Bishoujo Wrestler Retsuden - Blizzard Yuki Rannyuu!! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bishoujo Wrestler Retsuden - Blizzard Yuki Rannyuu!! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBishoujoWrestlerRetsudenBlizzardYukiRannyuuJapanRomInfo, rBishoujoWrestlerRetsudenBlizzardYukiRannyuuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBlackhawkEuropeEnFrDeRomDesc[] = {
	{ "Blackhawk (Europe) (En,Fr,De).sfc",          1048576, 0x2d1dd10a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBlackhawkEuropeEnFrDe)
STD_ROM_FN(rBlackhawkEuropeEnFrDe)

struct BurnDriver BurnDrvrBlackhawkEuropeEnFrDe = {
	"Blackhawk (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Blackhawk (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Blackhawk (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBlackhawkEuropeEnFrDeRomInfo, rBlackhawkEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBlackthorneUSABetaCESVersionRomDesc[] = {
	{ "Blackthorne (USA) (Beta) (CES Version).sfc",          1048576, 0xb39af3fa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBlackthorneUSABetaCESVersion)
STD_ROM_FN(rBlackthorneUSABetaCESVersion)

struct BurnDriver BurnDrvrBlackthorneUSABetaCESVersion = {
	"Blackthorne (USA) (Beta) (CES Version)", NULL, NULL, "1986",
	"Blackthorne (USA) (Beta) (CES Version)\0", NULL, "Nintendo", "Miscellaneous",
	L"Blackthorne (USA) (Beta) (CES Version)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBlackthorneUSABetaCESVersionRomInfo, rBlackthorneUSABetaCESVersionRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBlackthorneUSARomDesc[] = {
	{ "Blackthorne (USA).sfc",          1048576, 0x856beab1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBlackthorneUSA)
STD_ROM_FN(rBlackthorneUSA)

struct BurnDriver BurnDrvrBlackthorneUSA = {
	"Blackthorne (USA)", NULL, NULL, "1986",
	"Blackthorne (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Blackthorne (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBlackthorneUSARomInfo, rBlackthorneUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBlackthorneFukushuunoKurokiTogeJapanRomDesc[] = {
	{ "Blackthorne - Fukushuu no Kuroki Toge (Japan).sfc",          1048576, 0xedf476b3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBlackthorneFukushuunoKurokiTogeJapan)
STD_ROM_FN(rBlackthorneFukushuunoKurokiTogeJapan)

struct BurnDriver BurnDrvrBlackthorneFukushuunoKurokiTogeJapan = {
	"Blackthorne - Fukushuu no Kuroki Toge (Japan)", NULL, NULL, "1986",
	"Blackthorne - Fukushuu no Kuroki Toge (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Blackthorne - Fukushuu no Kuroki Toge (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBlackthorneFukushuunoKurokiTogeJapanRomInfo, rBlackthorneFukushuunoKurokiTogeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBlaZeonJapanRomDesc[] = {
	{ "BlaZeon (Japan).sfc",          1048576, 0xad2effc3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBlaZeonJapan)
STD_ROM_FN(rBlaZeonJapan)

struct BurnDriver BurnDrvrBlaZeonJapan = {
	"BlaZeon (Japan)", NULL, NULL, "1986",
	"BlaZeon (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"BlaZeon (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBlaZeonJapanRomInfo, rBlaZeonJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBlaZeonTheBioCyborgChallengeUSARomDesc[] = {
	{ "BlaZeon - The Bio-Cyborg Challenge (USA).sfc",          1048576, 0x3b01d0a3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBlaZeonTheBioCyborgChallengeUSA)
STD_ROM_FN(rBlaZeonTheBioCyborgChallengeUSA)

struct BurnDriver BurnDrvrBlaZeonTheBioCyborgChallengeUSA = {
	"BlaZeon - The Bio-Cyborg Challenge (USA)", NULL, NULL, "1986",
	"BlaZeon - The Bio-Cyborg Challenge (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"BlaZeon - The Bio-Cyborg Challenge (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBlaZeonTheBioCyborgChallengeUSARomInfo, rBlaZeonTheBioCyborgChallengeUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBlazingSkiesEuropeRomDesc[] = {
	{ "Blazing Skies (Europe).sfc",          524288, 0xbeb16e2d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBlazingSkiesEurope)
STD_ROM_FN(rBlazingSkiesEurope)

struct BurnDriver BurnDrvrBlazingSkiesEurope = {
	"Blazing Skies (Europe)", NULL, NULL, "1986",
	"Blazing Skies (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Blazing Skies (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBlazingSkiesEuropeRomInfo, rBlazingSkiesEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBlockKuzushiJapanRomDesc[] = {
	{ "Block Kuzushi (Japan).sfc",          524288, 0x5cce2e55, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBlockKuzushiJapan)
STD_ROM_FN(rBlockKuzushiJapan)

struct BurnDriver BurnDrvrBlockKuzushiJapan = {
	"Block Kuzushi (Japan)", NULL, NULL, "1986",
	"Block Kuzushi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Block Kuzushi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBlockKuzushiJapanRomInfo, rBlockKuzushiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBlueCrystalrodTheJapanRomDesc[] = {
	{ "Blue Crystalrod, The (Japan).sfc",          2097152, 0xefc21f71, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBlueCrystalrodTheJapan)
STD_ROM_FN(rBlueCrystalrodTheJapan)

struct BurnDriver BurnDrvrBlueCrystalrodTheJapan = {
	"Blue Crystalrod, The (Japan)", NULL, NULL, "1986",
	"Blue Crystalrod, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Blue Crystalrod, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBlueCrystalrodTheJapanRomInfo, rBlueCrystalrodTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBluesBrothersTheEuropeBetaRomDesc[] = {
	{ "Blues Brothers, The (Europe) (Beta).sfc",          524288, 0x1351da2a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBluesBrothersTheEuropeBeta)
STD_ROM_FN(rBluesBrothersTheEuropeBeta)

struct BurnDriver BurnDrvrBluesBrothersTheEuropeBeta = {
	"Blues Brothers, The (Europe) (Beta)", NULL, NULL, "1986",
	"Blues Brothers, The (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Blues Brothers, The (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBluesBrothersTheEuropeBetaRomInfo, rBluesBrothersTheEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBluesBrothersTheEuropeRomDesc[] = {
	{ "Blues Brothers, The (Europe).sfc",          524288, 0x4a62057d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBluesBrothersTheEurope)
STD_ROM_FN(rBluesBrothersTheEurope)

struct BurnDriver BurnDrvrBluesBrothersTheEurope = {
	"Blues Brothers, The (Europe)", NULL, NULL, "1986",
	"Blues Brothers, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Blues Brothers, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBluesBrothersTheEuropeRomInfo, rBluesBrothersTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBluesBrothersTheJapanRomDesc[] = {
	{ "Blues Brothers, The (Japan).sfc",          524288, 0x362620d2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBluesBrothersTheJapan)
STD_ROM_FN(rBluesBrothersTheJapan)

struct BurnDriver BurnDrvrBluesBrothersTheJapan = {
	"Blues Brothers, The (Japan)", NULL, NULL, "1986",
	"Blues Brothers, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Blues Brothers, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBluesBrothersTheJapanRomInfo, rBluesBrothersTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBluesBrothersTheUSARomDesc[] = {
	{ "Blues Brothers, The (USA).sfc",          524288, 0x82b97464, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBluesBrothersTheUSA)
STD_ROM_FN(rBluesBrothersTheUSA)

struct BurnDriver BurnDrvrBluesBrothersTheUSA = {
	"Blues Brothers, The (USA)", NULL, NULL, "1986",
	"Blues Brothers, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Blues Brothers, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBluesBrothersTheUSARomInfo, rBluesBrothersTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBobbysWorldUSAProtoRomDesc[] = {
	{ "Bobby's World (USA) (Proto).sfc",          1048576, 0x18bbee33, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBobbysWorldUSAProto)
STD_ROM_FN(rBobbysWorldUSAProto)

struct BurnDriver BurnDrvrBobbysWorldUSAProto = {
	"Bobby's World (USA) (Proto)", NULL, NULL, "1986",
	"Bobby's World (USA) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bobby's World (USA) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBobbysWorldUSAProtoRomInfo, rBobbysWorldUSAProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBokujouMonogatariJapanRev1RomDesc[] = {
	{ "Bokujou Monogatari (Japan) (Rev 1).sfc",          2097152, 0x9485ec0f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBokujouMonogatariJapanRev1)
STD_ROM_FN(rBokujouMonogatariJapanRev1)

struct BurnDriver BurnDrvrBokujouMonogatariJapanRev1 = {
	"Bokujou Monogatari (Japan) (Rev 1)", NULL, NULL, "1986",
	"Bokujou Monogatari (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bokujou Monogatari (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBokujouMonogatariJapanRev1RomInfo, rBokujouMonogatariJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBokujouMonogatariJapanRomDesc[] = {
	{ "Bokujou Monogatari (Japan).sfc",          2097152, 0xd10c3cfa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBokujouMonogatariJapan)
STD_ROM_FN(rBokujouMonogatariJapan)

struct BurnDriver BurnDrvrBokujouMonogatariJapan = {
	"Bokujou Monogatari (Japan)", NULL, NULL, "1986",
	"Bokujou Monogatari (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bokujou Monogatari (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBokujouMonogatariJapanRomInfo, rBokujouMonogatariJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBombermanBDamanJapanRomDesc[] = {
	{ "Bomberman B-Daman (Japan).sfc",          1048576, 0x9fea854d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBombermanBDamanJapan)
STD_ROM_FN(rBombermanBDamanJapan)

struct BurnDriver BurnDrvrBombermanBDamanJapan = {
	"Bomberman B-Daman (Japan)", NULL, NULL, "1986",
	"Bomberman B-Daman (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bomberman B-Daman (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBombermanBDamanJapanRomInfo, rBombermanBDamanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBombuzalJapanRomDesc[] = {
	{ "Bombuzal (Japan).sfc",          524288, 0x5d7b8bcb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBombuzalJapan)
STD_ROM_FN(rBombuzalJapan)

struct BurnDriver BurnDrvrBombuzalJapan = {
	"Bombuzal (Japan)", NULL, NULL, "1986",
	"Bombuzal (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bombuzal (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBombuzalJapanRomInfo, rBombuzalJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBonkersUSARomDesc[] = {
	{ "Bonkers (USA).sfc",          1048576, 0x597aa981, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBonkersUSA)
STD_ROM_FN(rBonkersUSA)

struct BurnDriver BurnDrvrBonkersUSA = {
	"Bonkers (USA)", NULL, NULL, "1986",
	"Bonkers (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bonkers (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBonkersUSARomInfo, rBonkersUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBonkersHollywoodDaisakusenJapanRomDesc[] = {
	{ "Bonkers - Hollywood Daisakusen! (Japan).sfc",          1048576, 0x9401d956, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBonkersHollywoodDaisakusenJapan)
STD_ROM_FN(rBonkersHollywoodDaisakusenJapan)

struct BurnDriver BurnDrvrBonkersHollywoodDaisakusenJapan = {
	"Bonkers - Hollywood Daisakusen! (Japan)", NULL, NULL, "1986",
	"Bonkers - Hollywood Daisakusen! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bonkers - Hollywood Daisakusen! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBonkersHollywoodDaisakusenJapanRomInfo, rBonkersHollywoodDaisakusenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBoogermanAPickandFlickAdventureEuropeRomDesc[] = {
	{ "Boogerman - A Pick and Flick Adventure (Europe).sfc",          3145728, 0x4328bd1b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBoogermanAPickandFlickAdventureEurope)
STD_ROM_FN(rBoogermanAPickandFlickAdventureEurope)

struct BurnDriver BurnDrvrBoogermanAPickandFlickAdventureEurope = {
	"Boogerman - A Pick and Flick Adventure (Europe)", NULL, NULL, "1986",
	"Boogerman - A Pick and Flick Adventure (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Boogerman - A Pick and Flick Adventure (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBoogermanAPickandFlickAdventureEuropeRomInfo, rBoogermanAPickandFlickAdventureEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBoogermanAPickandFlickAdventureUSARomDesc[] = {
	{ "Boogerman - A Pick and Flick Adventure (USA).sfc",          3145728, 0x1899aaff, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBoogermanAPickandFlickAdventureUSA)
STD_ROM_FN(rBoogermanAPickandFlickAdventureUSA)

struct BurnDriver BurnDrvrBoogermanAPickandFlickAdventureUSA = {
	"Boogerman - A Pick and Flick Adventure (USA)", NULL, NULL, "1986",
	"Boogerman - A Pick and Flick Adventure (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Boogerman - A Pick and Flick Adventure (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBoogermanAPickandFlickAdventureUSARomInfo, rBoogermanAPickandFlickAdventureUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBountySwordJapanRomDesc[] = {
	{ "Bounty Sword (Japan).sfc",          3145728, 0xf3ddf35f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBountySwordJapan)
STD_ROM_FN(rBountySwordJapan)

struct BurnDriver BurnDrvrBountySwordJapan = {
	"Bounty Sword (Japan)", NULL, NULL, "1986",
	"Bounty Sword (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bounty Sword (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBountySwordJapanRomInfo, rBountySwordJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBoxingLegendsoftheRingEuropeRomDesc[] = {
	{ "Boxing Legends of the Ring (Europe).sfc",          1048576, 0xcc468b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBoxingLegendsoftheRingEurope)
STD_ROM_FN(rBoxingLegendsoftheRingEurope)

struct BurnDriver BurnDrvrBoxingLegendsoftheRingEurope = {
	"Boxing Legends of the Ring (Europe)", NULL, NULL, "1986",
	"Boxing Legends of the Ring (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Boxing Legends of the Ring (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBoxingLegendsoftheRingEuropeRomInfo, rBoxingLegendsoftheRingEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBoxingLegendsoftheRingUSARomDesc[] = {
	{ "Boxing Legends of the Ring (USA).sfc",          1048576, 0xc0b632c0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBoxingLegendsoftheRingUSA)
STD_ROM_FN(rBoxingLegendsoftheRingUSA)

struct BurnDriver BurnDrvrBoxingLegendsoftheRingUSA = {
	"Boxing Legends of the Ring (USA)", NULL, NULL, "1986",
	"Boxing Legends of the Ring (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Boxing Legends of the Ring (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBoxingLegendsoftheRingUSARomInfo, rBoxingLegendsoftheRingUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrainLordJapanRomDesc[] = {
	{ "Brain Lord (Japan).sfc",          1572864, 0x9540e59d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrainLordJapan)
STD_ROM_FN(rBrainLordJapan)

struct BurnDriver BurnDrvrBrainLordJapan = {
	"Brain Lord (Japan)", NULL, NULL, "1986",
	"Brain Lord (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brain Lord (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrainLordJapanRomInfo, rBrainLordJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrainLordUSARomDesc[] = {
	{ "Brain Lord (USA).sfc",          1572864, 0xac443d87, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrainLordUSA)
STD_ROM_FN(rBrainLordUSA)

struct BurnDriver BurnDrvrBrainLordUSA = {
	"Brain Lord (USA)", NULL, NULL, "1986",
	"Brain Lord (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brain Lord (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrainLordUSARomInfo, rBrainLordUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrainiesTheEuropeRomDesc[] = {
	{ "Brainies, The (Europe).sfc",          524288, 0xde551746, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrainiesTheEurope)
STD_ROM_FN(rBrainiesTheEurope)

struct BurnDriver BurnDrvrBrainiesTheEurope = {
	"Brainies, The (Europe)", NULL, NULL, "1986",
	"Brainies, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brainies, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrainiesTheEuropeRomInfo, rBrainiesTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrainiesTheUSARomDesc[] = {
	{ "Brainies, The (USA).sfc",          524288, 0x718cb0df, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrainiesTheUSA)
STD_ROM_FN(rBrainiesTheUSA)

struct BurnDriver BurnDrvrBrainiesTheUSA = {
	"Brainies, The (USA)", NULL, NULL, "1986",
	"Brainies, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brainies, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrainiesTheUSARomInfo, rBrainiesTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBramStokersDraculaEuropeRomDesc[] = {
	{ "Bram Stoker's Dracula (Europe).sfc",          1048576, 0x9ee3835d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBramStokersDraculaEurope)
STD_ROM_FN(rBramStokersDraculaEurope)

struct BurnDriver BurnDrvrBramStokersDraculaEurope = {
	"Bram Stoker's Dracula (Europe)", NULL, NULL, "1986",
	"Bram Stoker's Dracula (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bram Stoker's Dracula (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBramStokersDraculaEuropeRomInfo, rBramStokersDraculaEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBramStokersDraculaUSABetaRomDesc[] = {
	{ "Bram Stoker's Dracula (USA) (Beta).sfc",          1048576, 0x6e4650a2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBramStokersDraculaUSABeta)
STD_ROM_FN(rBramStokersDraculaUSABeta)

struct BurnDriver BurnDrvrBramStokersDraculaUSABeta = {
	"Bram Stoker's Dracula (USA) (Beta)", NULL, NULL, "1986",
	"Bram Stoker's Dracula (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bram Stoker's Dracula (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBramStokersDraculaUSABetaRomInfo, rBramStokersDraculaUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBramStokersDraculaUSARomDesc[] = {
	{ "Bram Stoker's Dracula (USA).sfc",          1048576, 0x5cece690, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBramStokersDraculaUSA)
STD_ROM_FN(rBramStokersDraculaUSA)

struct BurnDriver BurnDrvrBramStokersDraculaUSA = {
	"Bram Stoker's Dracula (USA)", NULL, NULL, "1986",
	"Bram Stoker's Dracula (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bram Stoker's Dracula (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBramStokersDraculaUSARomInfo, rBramStokersDraculaUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrandishJapanRomDesc[] = {
	{ "Brandish (Japan).sfc",          1572864, 0xa087b6ad, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrandishJapan)
STD_ROM_FN(rBrandishJapan)

struct BurnDriver BurnDrvrBrandishJapan = {
	"Brandish (Japan)", NULL, NULL, "1986",
	"Brandish (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brandish (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrandishJapanRomInfo, rBrandishJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrandishUSARomDesc[] = {
	{ "Brandish (USA).sfc",          1572864, 0x74f70a0b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrandishUSA)
STD_ROM_FN(rBrandishUSA)

struct BurnDriver BurnDrvrBrandishUSA = {
	"Brandish (USA)", NULL, NULL, "1986",
	"Brandish (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brandish (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrandishUSARomInfo, rBrandishUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrandish2ExpertJapanRomDesc[] = {
	{ "Brandish 2 - Expert (Japan).sfc",          3145728, 0xab43e910, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrandish2ExpertJapan)
STD_ROM_FN(rBrandish2ExpertJapan)

struct BurnDriver BurnDrvrBrandish2ExpertJapan = {
	"Brandish 2 - Expert (Japan)", NULL, NULL, "1986",
	"Brandish 2 - Expert (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brandish 2 - Expert (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrandish2ExpertJapanRomInfo, rBrandish2ExpertJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrandish2ThePlanetBusterJapanRomDesc[] = {
	{ "Brandish 2 - The Planet Buster (Japan).sfc",          3145728, 0xbb89e67e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrandish2ThePlanetBusterJapan)
STD_ROM_FN(rBrandish2ThePlanetBusterJapan)

struct BurnDriver BurnDrvrBrandish2ThePlanetBusterJapan = {
	"Brandish 2 - The Planet Buster (Japan)", NULL, NULL, "1986",
	"Brandish 2 - The Planet Buster (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brandish 2 - The Planet Buster (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrandish2ThePlanetBusterJapanRomInfo, rBrandish2ThePlanetBusterJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrawlBrothersUSARomDesc[] = {
	{ "Brawl Brothers (USA).sfc",          1572864, 0xe822065c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrawlBrothersUSA)
STD_ROM_FN(rBrawlBrothersUSA)

struct BurnDriver BurnDrvrBrawlBrothersUSA = {
	"Brawl Brothers (USA)", NULL, NULL, "1986",
	"Brawl Brothers (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brawl Brothers (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrawlBrothersUSARomInfo, rBrawlBrothersUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrawlBrothersRivalTurf2EuropeRomDesc[] = {
	{ "Brawl Brothers - Rival Turf! 2 (Europe).sfc",          1572864, 0x410cee18, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrawlBrothersRivalTurf2Europe)
STD_ROM_FN(rBrawlBrothersRivalTurf2Europe)

struct BurnDriver BurnDrvrBrawlBrothersRivalTurf2Europe = {
	"Brawl Brothers - Rival Turf! 2 (Europe)", NULL, NULL, "1986",
	"Brawl Brothers - Rival Turf! 2 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brawl Brothers - Rival Turf! 2 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrawlBrothersRivalTurf2EuropeRomInfo, rBrawlBrothersRivalTurf2EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBreakThruUSARomDesc[] = {
	{ "BreakThru! (USA).sfc",          524288, 0xe6c0b5da, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBreakThruUSA)
STD_ROM_FN(rBreakThruUSA)

struct BurnDriver BurnDrvrBreakThruUSA = {
	"BreakThru! (USA)", NULL, NULL, "1986",
	"BreakThru! (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"BreakThru! (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBreakThruUSARomInfo, rBreakThruUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBreathofFireUSARomDesc[] = {
	{ "Breath of Fire (USA).sfc",          1572864, 0xc788b696, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBreathofFireUSA)
STD_ROM_FN(rBreathofFireUSA)

struct BurnDriver BurnDrvrBreathofFireUSA = {
	"Breath of Fire (USA)", NULL, NULL, "1986",
	"Breath of Fire (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Breath of Fire (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBreathofFireUSARomInfo, rBreathofFireUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBreathofFireRyuunoSenshiJapanRev1RomDesc[] = {
	{ "Breath of Fire - Ryuu no Senshi (Japan) (Rev 1).sfc",          1572864, 0xe0b0bbec, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBreathofFireRyuunoSenshiJapanRev1)
STD_ROM_FN(rBreathofFireRyuunoSenshiJapanRev1)

struct BurnDriver BurnDrvrBreathofFireRyuunoSenshiJapanRev1 = {
	"Breath of Fire - Ryuu no Senshi (Japan) (Rev 1)", NULL, NULL, "1986",
	"Breath of Fire - Ryuu no Senshi (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Breath of Fire - Ryuu no Senshi (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBreathofFireRyuunoSenshiJapanRev1RomInfo, rBreathofFireRyuunoSenshiJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBreathofFireRyuunoSenshiJapanRomDesc[] = {
	{ "Breath of Fire - Ryuu no Senshi (Japan).sfc",          1572864, 0xfd96a42f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBreathofFireRyuunoSenshiJapan)
STD_ROM_FN(rBreathofFireRyuunoSenshiJapan)

struct BurnDriver BurnDrvrBreathofFireRyuunoSenshiJapan = {
	"Breath of Fire - Ryuu no Senshi (Japan)", NULL, NULL, "1986",
	"Breath of Fire - Ryuu no Senshi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Breath of Fire - Ryuu no Senshi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBreathofFireRyuunoSenshiJapanRomInfo, rBreathofFireRyuunoSenshiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBreathofFireIIEuropeRomDesc[] = {
	{ "Breath of Fire II (Europe).sfc",          3145728, 0xa4ab3b33, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBreathofFireIIEurope)
STD_ROM_FN(rBreathofFireIIEurope)

struct BurnDriver BurnDrvrBreathofFireIIEurope = {
	"Breath of Fire II (Europe)", NULL, NULL, "1986",
	"Breath of Fire II (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Breath of Fire II (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBreathofFireIIEuropeRomInfo, rBreathofFireIIEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBreathofFireIIUSABetaRomDesc[] = {
	{ "Breath of Fire II (USA) (Beta).sfc",          3145728, 0xf44859af, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBreathofFireIIUSABeta)
STD_ROM_FN(rBreathofFireIIUSABeta)

struct BurnDriver BurnDrvrBreathofFireIIUSABeta = {
	"Breath of Fire II (USA) (Beta)", NULL, NULL, "1986",
	"Breath of Fire II (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Breath of Fire II (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBreathofFireIIUSABetaRomInfo, rBreathofFireIIUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBreathofFireIIUSARomDesc[] = {
	{ "Breath of Fire II (USA).sfc",          3145728, 0x67cdacc5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBreathofFireIIUSA)
STD_ROM_FN(rBreathofFireIIUSA)

struct BurnDriver BurnDrvrBreathofFireIIUSA = {
	"Breath of Fire II (USA)", NULL, NULL, "1986",
	"Breath of Fire II (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Breath of Fire II (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBreathofFireIIUSARomInfo, rBreathofFireIIUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBreathofFireIIShimeinoKoJapanRev1RomDesc[] = {
	{ "Breath of Fire II - Shimei no Ko (Japan) (Rev 1).sfc",          2621440, 0x9b846e8c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBreathofFireIIShimeinoKoJapanRev1)
STD_ROM_FN(rBreathofFireIIShimeinoKoJapanRev1)

struct BurnDriver BurnDrvrBreathofFireIIShimeinoKoJapanRev1 = {
	"Breath of Fire II - Shimei no Ko (Japan) (Rev 1)", NULL, NULL, "1986",
	"Breath of Fire II - Shimei no Ko (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Breath of Fire II - Shimei no Ko (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBreathofFireIIShimeinoKoJapanRev1RomInfo, rBreathofFireIIShimeinoKoJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBreathofFireIIShimeinoKoJapanRomDesc[] = {
	{ "Breath of Fire II - Shimei no Ko (Japan).sfc",          2621440, 0x1d8014f6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBreathofFireIIShimeinoKoJapan)
STD_ROM_FN(rBreathofFireIIShimeinoKoJapan)

struct BurnDriver BurnDrvrBreathofFireIIShimeinoKoJapan = {
	"Breath of Fire II - Shimei no Ko (Japan)", NULL, NULL, "1986",
	"Breath of Fire II - Shimei no Ko (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Breath of Fire II - Shimei no Ko (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBreathofFireIIShimeinoKoJapanRomInfo, rBreathofFireIIShimeinoKoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrettHullHockey95USARomDesc[] = {
	{ "Brett Hull Hockey '95 (USA).sfc",          2097152, 0x9ebfe809, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrettHullHockey95USA)
STD_ROM_FN(rBrettHullHockey95USA)

struct BurnDriver BurnDrvrBrettHullHockey95USA = {
	"Brett Hull Hockey '95 (USA)", NULL, NULL, "1986",
	"Brett Hull Hockey '95 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brett Hull Hockey '95 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrettHullHockey95USARomInfo, rBrettHullHockey95USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrettHullHockeyEuropeRomDesc[] = {
	{ "Brett Hull Hockey (Europe).sfc",          2097152, 0x77bbf192, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrettHullHockeyEurope)
STD_ROM_FN(rBrettHullHockeyEurope)

struct BurnDriver BurnDrvrBrettHullHockeyEurope = {
	"Brett Hull Hockey (Europe)", NULL, NULL, "1986",
	"Brett Hull Hockey (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brett Hull Hockey (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrettHullHockeyEuropeRomInfo, rBrettHullHockeyEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrettHullHockeyUSARomDesc[] = {
	{ "Brett Hull Hockey (USA).sfc",          2097152, 0xfbe35998, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrettHullHockeyUSA)
STD_ROM_FN(rBrettHullHockeyUSA)

struct BurnDriver BurnDrvrBrettHullHockeyUSA = {
	"Brett Hull Hockey (USA)", NULL, NULL, "1986",
	"Brett Hull Hockey (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brett Hull Hockey (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrettHullHockeyUSARomInfo, rBrettHullHockeyUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBronkietheBronchiasaurusUSAEnEsRomDesc[] = {
	{ "Bronkie the Bronchiasaurus (USA) (En,Es).sfc",          1048576, 0x1200f3cf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBronkietheBronchiasaurusUSAEnEs)
STD_ROM_FN(rBronkietheBronchiasaurusUSAEnEs)

struct BurnDriver BurnDrvrBronkietheBronchiasaurusUSAEnEs = {
	"Bronkie the Bronchiasaurus (USA) (En,Es)", NULL, NULL, "1986",
	"Bronkie the Bronchiasaurus (USA) (En,Es)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bronkie the Bronchiasaurus (USA) (En,Es)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBronkietheBronchiasaurusUSAEnEsRomInfo, rBronkietheBronchiasaurusUSAEnEsRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrunswickWorldTournamentofChampionsUSARomDesc[] = {
	{ "Brunswick World Tournament of Champions (USA).sfc",          2097152, 0x52e4dc92, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrunswickWorldTournamentofChampionsUSA)
STD_ROM_FN(rBrunswickWorldTournamentofChampionsUSA)

struct BurnDriver BurnDrvrBrunswickWorldTournamentofChampionsUSA = {
	"Brunswick World Tournament of Champions (USA)", NULL, NULL, "1986",
	"Brunswick World Tournament of Champions (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brunswick World Tournament of Champions (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrunswickWorldTournamentofChampionsUSARomInfo, rBrunswickWorldTournamentofChampionsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrutalPawsofFuryEuropeEnFrDeRomDesc[] = {
	{ "Brutal - Paws of Fury (Europe) (En,Fr,De).sfc",          2097152, 0x2f6326b1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrutalPawsofFuryEuropeEnFrDe)
STD_ROM_FN(rBrutalPawsofFuryEuropeEnFrDe)

struct BurnDriver BurnDrvrBrutalPawsofFuryEuropeEnFrDe = {
	"Brutal - Paws of Fury (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Brutal - Paws of Fury (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brutal - Paws of Fury (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrutalPawsofFuryEuropeEnFrDeRomInfo, rBrutalPawsofFuryEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrutalPawsofFuryUSABetaRomDesc[] = {
	{ "Brutal - Paws of Fury (USA) (Beta).sfc",          2097152, 0x49ad3f9c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrutalPawsofFuryUSABeta)
STD_ROM_FN(rBrutalPawsofFuryUSABeta)

struct BurnDriver BurnDrvrBrutalPawsofFuryUSABeta = {
	"Brutal - Paws of Fury (USA) (Beta)", NULL, NULL, "1986",
	"Brutal - Paws of Fury (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brutal - Paws of Fury (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrutalPawsofFuryUSABetaRomInfo, rBrutalPawsofFuryUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBrutalPawsofFuryUSARomDesc[] = {
	{ "Brutal - Paws of Fury (USA).sfc",          2097152, 0x8fe49f80, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBrutalPawsofFuryUSA)
STD_ROM_FN(rBrutalPawsofFuryUSA)

struct BurnDriver BurnDrvrBrutalPawsofFuryUSA = {
	"Brutal - Paws of Fury (USA)", NULL, NULL, "1986",
	"Brutal - Paws of Fury (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Brutal - Paws of Fury (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBrutalPawsofFuryUSARomInfo, rBrutalPawsofFuryUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSDragonQuestIJapanBSbRomDesc[] = {
	{ "BS Dragon Quest I (Japan) (BS) [b].sfc",          1048576, 0x577f6d20, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSDragonQuestIJapanBSb)
STD_ROM_FN(rBSDragonQuestIJapanBSb)

struct BurnDriver BurnDrvrBSDragonQuestIJapanBSb = {
	"BS Dragon Quest I (Japan) (BS) [b]", NULL, NULL, "1986",
	"BS Dragon Quest I (Japan) (BS) [b]\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Dragon Quest I (Japan) (BS) [b]", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSDragonQuestIJapanBSbRomInfo, rBSDragonQuestIJapanBSbRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSFZeroGrandPrixAceLeagueDai4shuuJapanBSRomDesc[] = {
	{ "BS F-Zero Grand Prix - Ace League - Dai-4-shuu (Japan) (BS).sfc",          1048576, 0xf57d28dc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSFZeroGrandPrixAceLeagueDai4shuuJapanBS)
STD_ROM_FN(rBSFZeroGrandPrixAceLeagueDai4shuuJapanBS)

struct BurnDriver BurnDrvrBSFZeroGrandPrixAceLeagueDai4shuuJapanBS = {
	"BS F-Zero Grand Prix - Ace League - Dai-4-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS F-Zero Grand Prix - Ace League - Dai-4-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS F-Zero Grand Prix - Ace League - Dai-4-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSFZeroGrandPrixAceLeagueDai4shuuJapanBSRomInfo, rBSFZeroGrandPrixAceLeagueDai4shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSFZeroGrandPrixKingLeagueDai3shuuJapanBSRomDesc[] = {
	{ "BS F-Zero Grand Prix - King League - Dai-3-shuu (Japan) (BS).sfc",          1048576, 0xf75713db, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSFZeroGrandPrixKingLeagueDai3shuuJapanBS)
STD_ROM_FN(rBSFZeroGrandPrixKingLeagueDai3shuuJapanBS)

struct BurnDriver BurnDrvrBSFZeroGrandPrixKingLeagueDai3shuuJapanBS = {
	"BS F-Zero Grand Prix - King League - Dai-3-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS F-Zero Grand Prix - King League - Dai-3-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS F-Zero Grand Prix - King League - Dai-3-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSFZeroGrandPrixKingLeagueDai3shuuJapanBSRomInfo, rBSFZeroGrandPrixKingLeagueDai3shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSFZeroGrandPrixKnightLeagueDai1shuuJapanBSRomDesc[] = {
	{ "BS F-Zero Grand Prix - Knight League - Dai-1-shuu (Japan) (BS).sfc",          1048576, 0xdbacf9f0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSFZeroGrandPrixKnightLeagueDai1shuuJapanBS)
STD_ROM_FN(rBSFZeroGrandPrixKnightLeagueDai1shuuJapanBS)

struct BurnDriver BurnDrvrBSFZeroGrandPrixKnightLeagueDai1shuuJapanBS = {
	"BS F-Zero Grand Prix - Knight League - Dai-1-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS F-Zero Grand Prix - Knight League - Dai-1-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS F-Zero Grand Prix - Knight League - Dai-1-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSFZeroGrandPrixKnightLeagueDai1shuuJapanBSRomInfo, rBSFZeroGrandPrixKnightLeagueDai1shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSFZeroGrandPrixQueenLeagueDai2shuuJapanBSRomDesc[] = {
	{ "BS F-Zero Grand Prix - Queen League - Dai-2-shuu (Japan) (BS).sfc",          1048576, 0xee6c9473, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSFZeroGrandPrixQueenLeagueDai2shuuJapanBS)
STD_ROM_FN(rBSFZeroGrandPrixQueenLeagueDai2shuuJapanBS)

struct BurnDriver BurnDrvrBSFZeroGrandPrixQueenLeagueDai2shuuJapanBS = {
	"BS F-Zero Grand Prix - Queen League - Dai-2-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS F-Zero Grand Prix - Queen League - Dai-2-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS F-Zero Grand Prix - Queen League - Dai-2-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSFZeroGrandPrixQueenLeagueDai2shuuJapanBSRomInfo, rBSFZeroGrandPrixQueenLeagueDai2shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSFZeroGrandPrix2PracticeJapanBSRomDesc[] = {
	{ "BS F-Zero Grand Prix 2 - Practice (Japan) (BS).sfc",          1048576, 0xc4808858, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSFZeroGrandPrix2PracticeJapanBS)
STD_ROM_FN(rBSFZeroGrandPrix2PracticeJapanBS)

struct BurnDriver BurnDrvrBSFZeroGrandPrix2PracticeJapanBS = {
	"BS F-Zero Grand Prix 2 - Practice (Japan) (BS)", NULL, NULL, "1986",
	"BS F-Zero Grand Prix 2 - Practice (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS F-Zero Grand Prix 2 - Practice (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSFZeroGrandPrix2PracticeJapanBSRomInfo, rBSFZeroGrandPrix2PracticeJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSFireEmblemAkaneiaSenkiHenDai1waPalaceKanrakuJapanBSRomDesc[] = {
	{ "BS Fire Emblem - Akaneia Senki Hen - Dai-1-wa - Palace Kanraku (Japan) (BS).sfc",          1048576, 0x14915411, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSFireEmblemAkaneiaSenkiHenDai1waPalaceKanrakuJapanBS)
STD_ROM_FN(rBSFireEmblemAkaneiaSenkiHenDai1waPalaceKanrakuJapanBS)

struct BurnDriver BurnDrvrBSFireEmblemAkaneiaSenkiHenDai1waPalaceKanrakuJapanBS = {
	"BS Fire Emblem - Akaneia Senki Hen - Dai-1-wa - Palace Kanraku (Japan) (BS)", NULL, NULL, "1986",
	"BS Fire Emblem - Akaneia Senki Hen - Dai-1-wa - Palace Kanraku (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Fire Emblem - Akaneia Senki Hen - Dai-1-wa - Palace Kanraku (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSFireEmblemAkaneiaSenkiHenDai1waPalaceKanrakuJapanBSRomInfo, rBSFireEmblemAkaneiaSenkiHenDai1waPalaceKanrakuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSFireEmblemAkaneiaSenkiHenDai2waAkaiRyuuKishiJapanBSRomDesc[] = {
	{ "BS Fire Emblem - Akaneia Senki Hen - Dai-2-wa - Akai Ryuu Kishi (Japan) (BS).sfc",          1048576, 0xbb73aadf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSFireEmblemAkaneiaSenkiHenDai2waAkaiRyuuKishiJapanBS)
STD_ROM_FN(rBSFireEmblemAkaneiaSenkiHenDai2waAkaiRyuuKishiJapanBS)

struct BurnDriver BurnDrvrBSFireEmblemAkaneiaSenkiHenDai2waAkaiRyuuKishiJapanBS = {
	"BS Fire Emblem - Akaneia Senki Hen - Dai-2-wa - Akai Ryuu Kishi (Japan) (BS)", NULL, NULL, "1986",
	"BS Fire Emblem - Akaneia Senki Hen - Dai-2-wa - Akai Ryuu Kishi (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Fire Emblem - Akaneia Senki Hen - Dai-2-wa - Akai Ryuu Kishi (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSFireEmblemAkaneiaSenkiHenDai2waAkaiRyuuKishiJapanBSRomInfo, rBSFireEmblemAkaneiaSenkiHenDai2waAkaiRyuuKishiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSFireEmblemAkaneiaSenkiHenDai3waSeiginoTouzokudanJapanBSRomDesc[] = {
	{ "BS Fire Emblem - Akaneia Senki Hen - Dai-3-wa - Seigi no Touzokudan (Japan) (BS).sfc",          1048576, 0x4ac9d49c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSFireEmblemAkaneiaSenkiHenDai3waSeiginoTouzokudanJapanBS)
STD_ROM_FN(rBSFireEmblemAkaneiaSenkiHenDai3waSeiginoTouzokudanJapanBS)

struct BurnDriver BurnDrvrBSFireEmblemAkaneiaSenkiHenDai3waSeiginoTouzokudanJapanBS = {
	"BS Fire Emblem - Akaneia Senki Hen - Dai-3-wa - Seigi no Touzokudan (Japan) (BS)", NULL, NULL, "1986",
	"BS Fire Emblem - Akaneia Senki Hen - Dai-3-wa - Seigi no Touzokudan (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Fire Emblem - Akaneia Senki Hen - Dai-3-wa - Seigi no Touzokudan (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSFireEmblemAkaneiaSenkiHenDai3waSeiginoTouzokudanJapanBSRomInfo, rBSFireEmblemAkaneiaSenkiHenDai3waSeiginoTouzokudanJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSFireEmblemAkaneiaSenkiHenDai4waHajimarinoTokiJapanBSRomDesc[] = {
	{ "BS Fire Emblem - Akaneia Senki Hen - Dai-4-wa - Hajimari no Toki (Japan) (BS).sfc",          1048576, 0xb4b6c1f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSFireEmblemAkaneiaSenkiHenDai4waHajimarinoTokiJapanBS)
STD_ROM_FN(rBSFireEmblemAkaneiaSenkiHenDai4waHajimarinoTokiJapanBS)

struct BurnDriver BurnDrvrBSFireEmblemAkaneiaSenkiHenDai4waHajimarinoTokiJapanBS = {
	"BS Fire Emblem - Akaneia Senki Hen - Dai-4-wa - Hajimari no Toki (Japan) (BS)", NULL, NULL, "1986",
	"BS Fire Emblem - Akaneia Senki Hen - Dai-4-wa - Hajimari no Toki (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Fire Emblem - Akaneia Senki Hen - Dai-4-wa - Hajimari no Toki (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSFireEmblemAkaneiaSenkiHenDai4waHajimarinoTokiJapanBSRomInfo, rBSFireEmblemAkaneiaSenkiHenDai4waHajimarinoTokiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSFuurainoShirenSuraraoSukueDai2shuuJapanBSRomDesc[] = {
	{ "BS Fuurai no Shiren - Surara o Sukue - Dai-2-shuu (Japan) (BS).sfc",          1048576, 0x882bf819, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSFuurainoShirenSuraraoSukueDai2shuuJapanBS)
STD_ROM_FN(rBSFuurainoShirenSuraraoSukueDai2shuuJapanBS)

struct BurnDriver BurnDrvrBSFuurainoShirenSuraraoSukueDai2shuuJapanBS = {
	"BS Fuurai no Shiren - Surara o Sukue - Dai-2-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Fuurai no Shiren - Surara o Sukue - Dai-2-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Fuurai no Shiren - Surara o Sukue - Dai-2-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSFuurainoShirenSuraraoSukueDai2shuuJapanBSRomInfo, rBSFuurainoShirenSuraraoSukueDai2shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSMarvelousCampArnoldCourseDai1shuuJapanBSRomDesc[] = {
	{ "BS Marvelous - Camp Arnold Course - Dai-1-shuu (Japan) (BS).sfc",          1048576, 0x6b90c767, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSMarvelousCampArnoldCourseDai1shuuJapanBS)
STD_ROM_FN(rBSMarvelousCampArnoldCourseDai1shuuJapanBS)

struct BurnDriver BurnDrvrBSMarvelousCampArnoldCourseDai1shuuJapanBS = {
	"BS Marvelous - Camp Arnold Course - Dai-1-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Marvelous - Camp Arnold Course - Dai-1-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Marvelous - Camp Arnold Course - Dai-1-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSMarvelousCampArnoldCourseDai1shuuJapanBSRomInfo, rBSMarvelousCampArnoldCourseDai1shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSMarvelousCampArnoldCourseDai2shuuJapanBSRomDesc[] = {
	{ "BS Marvelous - Camp Arnold Course - Dai-2-shuu (Japan) (BS).sfc",          1048576, 0xf5357704, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSMarvelousCampArnoldCourseDai2shuuJapanBS)
STD_ROM_FN(rBSMarvelousCampArnoldCourseDai2shuuJapanBS)

struct BurnDriver BurnDrvrBSMarvelousCampArnoldCourseDai2shuuJapanBS = {
	"BS Marvelous - Camp Arnold Course - Dai-2-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Marvelous - Camp Arnold Course - Dai-2-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Marvelous - Camp Arnold Course - Dai-2-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSMarvelousCampArnoldCourseDai2shuuJapanBSRomInfo, rBSMarvelousCampArnoldCourseDai2shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSMarvelousCampArnoldCourseDai3shuuJapanBSRomDesc[] = {
	{ "BS Marvelous - Camp Arnold Course - Dai-3-shuu (Japan) (BS).sfc",          1048576, 0x2b87dbaa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSMarvelousCampArnoldCourseDai3shuuJapanBS)
STD_ROM_FN(rBSMarvelousCampArnoldCourseDai3shuuJapanBS)

struct BurnDriver BurnDrvrBSMarvelousCampArnoldCourseDai3shuuJapanBS = {
	"BS Marvelous - Camp Arnold Course - Dai-3-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Marvelous - Camp Arnold Course - Dai-3-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Marvelous - Camp Arnold Course - Dai-3-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSMarvelousCampArnoldCourseDai3shuuJapanBSRomInfo, rBSMarvelousCampArnoldCourseDai3shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSMarvelousCampArnoldCourseDai4shuuJapanBSRomDesc[] = {
	{ "BS Marvelous - Camp Arnold Course - Dai-4-shuu (Japan) (BS).sfc",          1048576, 0x6986937e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSMarvelousCampArnoldCourseDai4shuuJapanBS)
STD_ROM_FN(rBSMarvelousCampArnoldCourseDai4shuuJapanBS)

struct BurnDriver BurnDrvrBSMarvelousCampArnoldCourseDai4shuuJapanBS = {
	"BS Marvelous - Camp Arnold Course - Dai-4-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Marvelous - Camp Arnold Course - Dai-4-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Marvelous - Camp Arnold Course - Dai-4-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSMarvelousCampArnoldCourseDai4shuuJapanBSRomInfo, rBSMarvelousCampArnoldCourseDai4shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSMarvelousTimeAthleticCourseDai1shuuJapanBSRomDesc[] = {
	{ "BS Marvelous - Time Athletic Course - Dai-1-shuu (Japan) (BS).sfc",          1048576, 0x1639db9d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSMarvelousTimeAthleticCourseDai1shuuJapanBS)
STD_ROM_FN(rBSMarvelousTimeAthleticCourseDai1shuuJapanBS)

struct BurnDriver BurnDrvrBSMarvelousTimeAthleticCourseDai1shuuJapanBS = {
	"BS Marvelous - Time Athletic Course - Dai-1-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Marvelous - Time Athletic Course - Dai-1-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Marvelous - Time Athletic Course - Dai-1-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSMarvelousTimeAthleticCourseDai1shuuJapanBSRomInfo, rBSMarvelousTimeAthleticCourseDai1shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSMarvelousTimeAthleticCourseDai2shuuJapanBSRomDesc[] = {
	{ "BS Marvelous - Time Athletic Course - Dai-2-shuu (Japan) (BS).sfc",          1048576, 0x27d62709, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSMarvelousTimeAthleticCourseDai2shuuJapanBS)
STD_ROM_FN(rBSMarvelousTimeAthleticCourseDai2shuuJapanBS)

struct BurnDriver BurnDrvrBSMarvelousTimeAthleticCourseDai2shuuJapanBS = {
	"BS Marvelous - Time Athletic Course - Dai-2-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Marvelous - Time Athletic Course - Dai-2-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Marvelous - Time Athletic Course - Dai-2-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSMarvelousTimeAthleticCourseDai2shuuJapanBSRomInfo, rBSMarvelousTimeAthleticCourseDai2shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSMarvelousTimeAthleticCourseDai3shuuJapanBSRomDesc[] = {
	{ "BS Marvelous - Time Athletic Course - Dai-3-shuu (Japan) (BS).sfc",          1048576, 0x5a88e3fb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSMarvelousTimeAthleticCourseDai3shuuJapanBS)
STD_ROM_FN(rBSMarvelousTimeAthleticCourseDai3shuuJapanBS)

struct BurnDriver BurnDrvrBSMarvelousTimeAthleticCourseDai3shuuJapanBS = {
	"BS Marvelous - Time Athletic Course - Dai-3-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Marvelous - Time Athletic Course - Dai-3-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Marvelous - Time Athletic Course - Dai-3-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSMarvelousTimeAthleticCourseDai3shuuJapanBSRomInfo, rBSMarvelousTimeAthleticCourseDai3shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSMarvelousTimeAthleticCourseDai4shuuJapanBSRomDesc[] = {
	{ "BS Marvelous - Time Athletic Course - Dai-4-shuu (Japan) (BS).sfc",          1048576, 0xfba7789e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSMarvelousTimeAthleticCourseDai4shuuJapanBS)
STD_ROM_FN(rBSMarvelousTimeAthleticCourseDai4shuuJapanBS)

struct BurnDriver BurnDrvrBSMarvelousTimeAthleticCourseDai4shuuJapanBS = {
	"BS Marvelous - Time Athletic Course - Dai-4-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Marvelous - Time Athletic Course - Dai-4-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Marvelous - Time Athletic Course - Dai-4-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSMarvelousTimeAthleticCourseDai4shuuJapanBSRomInfo, rBSMarvelousTimeAthleticCourseDai4shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSNichibutsuMahjongMahjongTaikaiJapanBSRomDesc[] = {
	{ "BS Nichibutsu Mahjong - Mahjong Taikai (Japan) (BS).sfc",          1048576, 0xf10028b1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSNichibutsuMahjongMahjongTaikaiJapanBS)
STD_ROM_FN(rBSNichibutsuMahjongMahjongTaikaiJapanBS)

struct BurnDriver BurnDrvrBSNichibutsuMahjongMahjongTaikaiJapanBS = {
	"BS Nichibutsu Mahjong - Mahjong Taikai (Japan) (BS)", NULL, NULL, "1986",
	"BS Nichibutsu Mahjong - Mahjong Taikai (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Nichibutsu Mahjong - Mahjong Taikai (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSNichibutsuMahjongMahjongTaikaiJapanBSRomInfo, rBSNichibutsuMahjongMahjongTaikaiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSNichibutsuMahjongRenshuuMahjongIchimantouJapanBSRomDesc[] = {
	{ "BS Nichibutsu Mahjong - Renshuu Mahjong - Ichimantou (Japan) (BS).sfc",          1048576, 0xa0b0e5ca, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSNichibutsuMahjongRenshuuMahjongIchimantouJapanBS)
STD_ROM_FN(rBSNichibutsuMahjongRenshuuMahjongIchimantouJapanBS)

struct BurnDriver BurnDrvrBSNichibutsuMahjongRenshuuMahjongIchimantouJapanBS = {
	"BS Nichibutsu Mahjong - Renshuu Mahjong - Ichimantou (Japan) (BS)", NULL, NULL, "1986",
	"BS Nichibutsu Mahjong - Renshuu Mahjong - Ichimantou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Nichibutsu Mahjong - Renshuu Mahjong - Ichimantou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSNichibutsuMahjongRenshuuMahjongIchimantouJapanBSRomInfo, rBSNichibutsuMahjongRenshuuMahjongIchimantouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSNichibutsuMahjongRenshuuMahjongNimantouJapanBSRomDesc[] = {
	{ "BS Nichibutsu Mahjong - Renshuu Mahjong - Nimantou (Japan) (BS).sfc",          1048576, 0x3cec7861, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSNichibutsuMahjongRenshuuMahjongNimantouJapanBS)
STD_ROM_FN(rBSNichibutsuMahjongRenshuuMahjongNimantouJapanBS)

struct BurnDriver BurnDrvrBSNichibutsuMahjongRenshuuMahjongNimantouJapanBS = {
	"BS Nichibutsu Mahjong - Renshuu Mahjong - Nimantou (Japan) (BS)", NULL, NULL, "1986",
	"BS Nichibutsu Mahjong - Renshuu Mahjong - Nimantou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Nichibutsu Mahjong - Renshuu Mahjong - Nimantou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSNichibutsuMahjongRenshuuMahjongNimantouJapanBSRomInfo, rBSNichibutsuMahjongRenshuuMahjongNimantouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSNintendoHP517GouJapanBSRomDesc[] = {
	{ "BS Nintendo HP - 5-17 Gou (Japan) (BS).sfc",          1048576, 0x768f50f4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSNintendoHP517GouJapanBS)
STD_ROM_FN(rBSNintendoHP517GouJapanBS)

struct BurnDriver BurnDrvrBSNintendoHP517GouJapanBS = {
	"BS Nintendo HP - 5-17 Gou (Japan) (BS)", NULL, NULL, "1986",
	"BS Nintendo HP - 5-17 Gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Nintendo HP - 5-17 Gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSNintendoHP517GouJapanBSRomInfo, rBSNintendoHP517GouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSNintendoHP531GouJapanBSRomDesc[] = {
	{ "BS Nintendo HP - 5-31 Gou (Japan) (BS).sfc",          1048576, 0xc9b05ce4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSNintendoHP531GouJapanBS)
STD_ROM_FN(rBSNintendoHP531GouJapanBS)

struct BurnDriver BurnDrvrBSNintendoHP531GouJapanBS = {
	"BS Nintendo HP - 5-31 Gou (Japan) (BS)", NULL, NULL, "1986",
	"BS Nintendo HP - 5-31 Gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Nintendo HP - 5-31 Gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSNintendoHP531GouJapanBSRomInfo, rBSNintendoHP531GouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSParlorParlorDai2shuuJapanBSRomDesc[] = {
	{ "BS Parlor! Parlor! - Dai-2-shuu (Japan) (BS).sfc",          1048576, 0x3ed9a005, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSParlorParlorDai2shuuJapanBS)
STD_ROM_FN(rBSParlorParlorDai2shuuJapanBS)

struct BurnDriver BurnDrvrBSParlorParlorDai2shuuJapanBS = {
	"BS Parlor! Parlor! - Dai-2-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Parlor! Parlor! - Dai-2-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Parlor! Parlor! - Dai-2-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSParlorParlorDai2shuuJapanBSRomInfo, rBSParlorParlorDai2shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSShinOnigashimaDai1waKataribenoKoyaJapanBSRomDesc[] = {
	{ "BS Shin Onigashima - Dai-1-wa - Kataribe no Koya (Japan) (BS).sfc",          1048576, 0x514eb6c8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSShinOnigashimaDai1waKataribenoKoyaJapanBS)
STD_ROM_FN(rBSShinOnigashimaDai1waKataribenoKoyaJapanBS)

struct BurnDriver BurnDrvrBSShinOnigashimaDai1waKataribenoKoyaJapanBS = {
	"BS Shin Onigashima - Dai-1-wa - Kataribe no Koya (Japan) (BS)", NULL, NULL, "1986",
	"BS Shin Onigashima - Dai-1-wa - Kataribe no Koya (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Shin Onigashima - Dai-1-wa - Kataribe no Koya (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSShinOnigashimaDai1waKataribenoKoyaJapanBSRomInfo, rBSShinOnigashimaDai1waKataribenoKoyaJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSShinOnigashimaDai2waKataribenoKoyaJapanBSRomDesc[] = {
	{ "BS Shin Onigashima - Dai-2-wa - Kataribe no Koya (Japan) (BS).sfc",          1048576, 0x67a5b7c4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSShinOnigashimaDai2waKataribenoKoyaJapanBS)
STD_ROM_FN(rBSShinOnigashimaDai2waKataribenoKoyaJapanBS)

struct BurnDriver BurnDrvrBSShinOnigashimaDai2waKataribenoKoyaJapanBS = {
	"BS Shin Onigashima - Dai-2-wa - Kataribe no Koya (Japan) (BS)", NULL, NULL, "1986",
	"BS Shin Onigashima - Dai-2-wa - Kataribe no Koya (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Shin Onigashima - Dai-2-wa - Kataribe no Koya (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSShinOnigashimaDai2waKataribenoKoyaJapanBSRomInfo, rBSShinOnigashimaDai2waKataribenoKoyaJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSShinOnigashimaDai3waKataribenoKoyaJapanBSRomDesc[] = {
	{ "BS Shin Onigashima - Dai-3-wa - Kataribe no Koya (Japan) (BS).sfc",          1048576, 0xabe60813, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSShinOnigashimaDai3waKataribenoKoyaJapanBS)
STD_ROM_FN(rBSShinOnigashimaDai3waKataribenoKoyaJapanBS)

struct BurnDriver BurnDrvrBSShinOnigashimaDai3waKataribenoKoyaJapanBS = {
	"BS Shin Onigashima - Dai-3-wa - Kataribe no Koya (Japan) (BS)", NULL, NULL, "1986",
	"BS Shin Onigashima - Dai-3-wa - Kataribe no Koya (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Shin Onigashima - Dai-3-wa - Kataribe no Koya (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSShinOnigashimaDai3waKataribenoKoyaJapanBSRomInfo, rBSShinOnigashimaDai3waKataribenoKoyaJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSShinOnigashimaDai4waKataribenoKoyaJapanBSRomDesc[] = {
	{ "BS Shin Onigashima - Dai-4-wa - Kataribe no Koya (Japan) (BS).sfc",          1048576, 0xf9ab3b92, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSShinOnigashimaDai4waKataribenoKoyaJapanBS)
STD_ROM_FN(rBSShinOnigashimaDai4waKataribenoKoyaJapanBS)

struct BurnDriver BurnDrvrBSShinOnigashimaDai4waKataribenoKoyaJapanBS = {
	"BS Shin Onigashima - Dai-4-wa - Kataribe no Koya (Japan) (BS)", NULL, NULL, "1986",
	"BS Shin Onigashima - Dai-4-wa - Kataribe no Koya (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Shin Onigashima - Dai-4-wa - Kataribe no Koya (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSShinOnigashimaDai4waKataribenoKoyaJapanBSRomInfo, rBSShinOnigashimaDai4waKataribenoKoyaJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSStGigaPG10GatsugouJapanBSRomDesc[] = {
	{ "BS St. Giga PG - 10 Gatsugou (Japan) (BS).sfc",          1048576, 0x8dabd48a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSStGigaPG10GatsugouJapanBS)
STD_ROM_FN(rBSStGigaPG10GatsugouJapanBS)

struct BurnDriver BurnDrvrBSStGigaPG10GatsugouJapanBS = {
	"BS St. Giga PG - 10 Gatsugou (Japan) (BS)", NULL, NULL, "1986",
	"BS St. Giga PG - 10 Gatsugou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS St. Giga PG - 10 Gatsugou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSStGigaPG10GatsugouJapanBSRomInfo, rBSStGigaPG10GatsugouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSSuperMarioCollectionDai3shuuJapanBSRomDesc[] = {
	{ "BS Super Mario Collection - Dai-3-shuu (Japan) (BS).sfc",          1048576, 0xa40a3089, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSSuperMarioCollectionDai3shuuJapanBS)
STD_ROM_FN(rBSSuperMarioCollectionDai3shuuJapanBS)

struct BurnDriver BurnDrvrBSSuperMarioCollectionDai3shuuJapanBS = {
	"BS Super Mario Collection - Dai-3-shuu (Japan) (BS)", NULL, NULL, "1986",
	"BS Super Mario Collection - Dai-3-shuu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Super Mario Collection - Dai-3-shuu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSSuperMarioCollectionDai3shuuJapanBSRomInfo, rBSSuperMarioCollectionDai3shuuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSSuperMarioUSAPowerChallengeDai1kaiJapanBSRomDesc[] = {
	{ "BS Super Mario USA - Power Challenge - Dai-1-kai (Japan) (BS).sfc",          1048576, 0x8f85a235, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSSuperMarioUSAPowerChallengeDai1kaiJapanBS)
STD_ROM_FN(rBSSuperMarioUSAPowerChallengeDai1kaiJapanBS)

struct BurnDriver BurnDrvrBSSuperMarioUSAPowerChallengeDai1kaiJapanBS = {
	"BS Super Mario USA - Power Challenge - Dai-1-kai (Japan) (BS)", NULL, NULL, "1986",
	"BS Super Mario USA - Power Challenge - Dai-1-kai (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Super Mario USA - Power Challenge - Dai-1-kai (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSSuperMarioUSAPowerChallengeDai1kaiJapanBSRomInfo, rBSSuperMarioUSAPowerChallengeDai1kaiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSSuperMarioUSAPowerChallengeDai2kaiJapanBSRomDesc[] = {
	{ "BS Super Mario USA - Power Challenge - Dai-2-kai (Japan) (BS).sfc",          1048576, 0xb967025a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSSuperMarioUSAPowerChallengeDai2kaiJapanBS)
STD_ROM_FN(rBSSuperMarioUSAPowerChallengeDai2kaiJapanBS)

struct BurnDriver BurnDrvrBSSuperMarioUSAPowerChallengeDai2kaiJapanBS = {
	"BS Super Mario USA - Power Challenge - Dai-2-kai (Japan) (BS)", NULL, NULL, "1986",
	"BS Super Mario USA - Power Challenge - Dai-2-kai (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Super Mario USA - Power Challenge - Dai-2-kai (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSSuperMarioUSAPowerChallengeDai2kaiJapanBSRomInfo, rBSSuperMarioUSAPowerChallengeDai2kaiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSSuperMarioUSAPowerChallengeDai3kaiJapanBSRomDesc[] = {
	{ "BS Super Mario USA - Power Challenge - Dai-3-kai (Japan) (BS).sfc",          1048576, 0x8b22a708, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSSuperMarioUSAPowerChallengeDai3kaiJapanBS)
STD_ROM_FN(rBSSuperMarioUSAPowerChallengeDai3kaiJapanBS)

struct BurnDriver BurnDrvrBSSuperMarioUSAPowerChallengeDai3kaiJapanBS = {
	"BS Super Mario USA - Power Challenge - Dai-3-kai (Japan) (BS)", NULL, NULL, "1986",
	"BS Super Mario USA - Power Challenge - Dai-3-kai (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Super Mario USA - Power Challenge - Dai-3-kai (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSSuperMarioUSAPowerChallengeDai3kaiJapanBSRomInfo, rBSSuperMarioUSAPowerChallengeDai3kaiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSSuperMarioUSAPowerChallengeDai4kaiJapanBSRomDesc[] = {
	{ "BS Super Mario USA - Power Challenge - Dai-4-kai (Japan) (BS).sfc",          1048576, 0xff1ded46, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSSuperMarioUSAPowerChallengeDai4kaiJapanBS)
STD_ROM_FN(rBSSuperMarioUSAPowerChallengeDai4kaiJapanBS)

struct BurnDriver BurnDrvrBSSuperMarioUSAPowerChallengeDai4kaiJapanBS = {
	"BS Super Mario USA - Power Challenge - Dai-4-kai (Japan) (BS)", NULL, NULL, "1986",
	"BS Super Mario USA - Power Challenge - Dai-4-kai (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Super Mario USA - Power Challenge - Dai-4-kai (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSSuperMarioUSAPowerChallengeDai4kaiJapanBSRomInfo, rBSSuperMarioUSAPowerChallengeDai4kaiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSTanteiClubYukiniKietaKakoChuuhenJapanBSRomDesc[] = {
	{ "BS Tantei Club - Yuki ni Kieta Kako - Chuuhen (Japan) (BS).sfc",          1048576, 0x7947abd1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSTanteiClubYukiniKietaKakoChuuhenJapanBS)
STD_ROM_FN(rBSTanteiClubYukiniKietaKakoChuuhenJapanBS)

struct BurnDriver BurnDrvrBSTanteiClubYukiniKietaKakoChuuhenJapanBS = {
	"BS Tantei Club - Yuki ni Kieta Kako - Chuuhen (Japan) (BS)", NULL, NULL, "1986",
	"BS Tantei Club - Yuki ni Kieta Kako - Chuuhen (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Tantei Club - Yuki ni Kieta Kako - Chuuhen (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSTanteiClubYukiniKietaKakoChuuhenJapanBSRomInfo, rBSTanteiClubYukiniKietaKakoChuuhenJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSTanteiClubYukiniKietaKakoKouhenJapanBSRomDesc[] = {
	{ "BS Tantei Club - Yuki ni Kieta Kako - Kouhen (Japan) (BS).sfc",          1048576, 0xcd818cf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSTanteiClubYukiniKietaKakoKouhenJapanBS)
STD_ROM_FN(rBSTanteiClubYukiniKietaKakoKouhenJapanBS)

struct BurnDriver BurnDrvrBSTanteiClubYukiniKietaKakoKouhenJapanBS = {
	"BS Tantei Club - Yuki ni Kieta Kako - Kouhen (Japan) (BS)", NULL, NULL, "1986",
	"BS Tantei Club - Yuki ni Kieta Kako - Kouhen (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Tantei Club - Yuki ni Kieta Kako - Kouhen (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSTanteiClubYukiniKietaKakoKouhenJapanBSRomInfo, rBSTanteiClubYukiniKietaKakoKouhenJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSTanteiClubYukiniKietaKakoZenpenJapanBSRomDesc[] = {
	{ "BS Tantei Club - Yuki ni Kieta Kako - Zenpen (Japan) (BS).sfc",          1048576, 0xf26300c8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSTanteiClubYukiniKietaKakoZenpenJapanBS)
STD_ROM_FN(rBSTanteiClubYukiniKietaKakoZenpenJapanBS)

struct BurnDriver BurnDrvrBSTanteiClubYukiniKietaKakoZenpenJapanBS = {
	"BS Tantei Club - Yuki ni Kieta Kako - Zenpen (Japan) (BS)", NULL, NULL, "1986",
	"BS Tantei Club - Yuki ni Kieta Kako - Zenpen (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Tantei Club - Yuki ni Kieta Kako - Zenpen (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSTanteiClubYukiniKietaKakoZenpenJapanBSRomInfo, rBSTanteiClubYukiniKietaKakoZenpenJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSZeldanoDensetsuDai3waJapanBSRomDesc[] = {
	{ "BS Zelda no Densetsu - Dai-3-wa (Japan) (BS).sfc",          1048576, 0xddc54398, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSZeldanoDensetsuDai3waJapanBS)
STD_ROM_FN(rBSZeldanoDensetsuDai3waJapanBS)

struct BurnDriver BurnDrvrBSZeldanoDensetsuDai3waJapanBS = {
	"BS Zelda no Densetsu - Dai-3-wa (Japan) (BS)", NULL, NULL, "1986",
	"BS Zelda no Densetsu - Dai-3-wa (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Zelda no Densetsu - Dai-3-wa (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSZeldanoDensetsuDai3waJapanBSRomInfo, rBSZeldanoDensetsuDai3waJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSZeldanoDensetsuKodainoSekibanDai1waJapanBSRomDesc[] = {
	{ "BS Zelda no Densetsu - Kodai no Sekiban - Dai-1-wa (Japan) (BS).sfc",          1048576, 0xd2b95a8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSZeldanoDensetsuKodainoSekibanDai1waJapanBS)
STD_ROM_FN(rBSZeldanoDensetsuKodainoSekibanDai1waJapanBS)

struct BurnDriver BurnDrvrBSZeldanoDensetsuKodainoSekibanDai1waJapanBS = {
	"BS Zelda no Densetsu - Kodai no Sekiban - Dai-1-wa (Japan) (BS)", NULL, NULL, "1986",
	"BS Zelda no Densetsu - Kodai no Sekiban - Dai-1-wa (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Zelda no Densetsu - Kodai no Sekiban - Dai-1-wa (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSZeldanoDensetsuKodainoSekibanDai1waJapanBSRomInfo, rBSZeldanoDensetsuKodainoSekibanDai1waJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSZeldanoDensetsuKodainoSekibanDai2waJapanBSRomDesc[] = {
	{ "BS Zelda no Densetsu - Kodai no Sekiban - Dai-2-wa (Japan) (BS).sfc",          1048576, 0x1b71a609, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSZeldanoDensetsuKodainoSekibanDai2waJapanBS)
STD_ROM_FN(rBSZeldanoDensetsuKodainoSekibanDai2waJapanBS)

struct BurnDriver BurnDrvrBSZeldanoDensetsuKodainoSekibanDai2waJapanBS = {
	"BS Zelda no Densetsu - Kodai no Sekiban - Dai-2-wa (Japan) (BS)", NULL, NULL, "1986",
	"BS Zelda no Densetsu - Kodai no Sekiban - Dai-2-wa (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Zelda no Densetsu - Kodai no Sekiban - Dai-2-wa (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSZeldanoDensetsuKodainoSekibanDai2waJapanBSRomInfo, rBSZeldanoDensetsuKodainoSekibanDai2waJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSZeldanoDensetsuKodainoSekibanDai3waJapanBSRomDesc[] = {
	{ "BS Zelda no Densetsu - Kodai no Sekiban - Dai-3-wa (Japan) (BS).sfc",          1048576, 0xc251d4fa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSZeldanoDensetsuKodainoSekibanDai3waJapanBS)
STD_ROM_FN(rBSZeldanoDensetsuKodainoSekibanDai3waJapanBS)

struct BurnDriver BurnDrvrBSZeldanoDensetsuKodainoSekibanDai3waJapanBS = {
	"BS Zelda no Densetsu - Kodai no Sekiban - Dai-3-wa (Japan) (BS)", NULL, NULL, "1986",
	"BS Zelda no Densetsu - Kodai no Sekiban - Dai-3-wa (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Zelda no Densetsu - Kodai no Sekiban - Dai-3-wa (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSZeldanoDensetsuKodainoSekibanDai3waJapanBSRomInfo, rBSZeldanoDensetsuKodainoSekibanDai3waJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSZeldanoDensetsuKodainoSekibanDai4waJapanBSRomDesc[] = {
	{ "BS Zelda no Densetsu - Kodai no Sekiban - Dai-4-wa (Japan) (BS).sfc",          1048576, 0x8385bbf4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSZeldanoDensetsuKodainoSekibanDai4waJapanBS)
STD_ROM_FN(rBSZeldanoDensetsuKodainoSekibanDai4waJapanBS)

struct BurnDriver BurnDrvrBSZeldanoDensetsuKodainoSekibanDai4waJapanBS = {
	"BS Zelda no Densetsu - Kodai no Sekiban - Dai-4-wa (Japan) (BS)", NULL, NULL, "1986",
	"BS Zelda no Densetsu - Kodai no Sekiban - Dai-4-wa (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Zelda no Densetsu - Kodai no Sekiban - Dai-4-wa (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSZeldanoDensetsuKodainoSekibanDai4waJapanBSRomInfo, rBSZeldanoDensetsuKodainoSekibanDai4waJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSZeldanoDensetsuMap2Dai4waJapanBSbRomDesc[] = {
	{ "BS Zelda no Densetsu Map 2 - Dai-4-wa (Japan) (BS) [b].sfc",          1048576, 0x670b51ca, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSZeldanoDensetsuMap2Dai4waJapanBSb)
STD_ROM_FN(rBSZeldanoDensetsuMap2Dai4waJapanBSb)

struct BurnDriver BurnDrvrBSZeldanoDensetsuMap2Dai4waJapanBSb = {
	"BS Zelda no Densetsu Map 2 - Dai-4-wa (Japan) (BS) [b]", NULL, NULL, "1986",
	"BS Zelda no Densetsu Map 2 - Dai-4-wa (Japan) (BS) [b]\0", NULL, "Nintendo", "Miscellaneous",
	L"BS Zelda no Densetsu Map 2 - Dai-4-wa (Japan) (BS) [b]", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSZeldanoDensetsuMap2Dai4waJapanBSbRomInfo, rBSZeldanoDensetsuMap2Dai4waJapanBSbRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBSXSorewaNamaeoNusumaretaMachinoMonogatariJapanRev1RomDesc[] = {
	{ "BS-X - Sore wa Namae o Nusumareta Machi no Monogatari (Japan) (Rev 1).sfc",          1048576, 0xf51f07a0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBSXSorewaNamaeoNusumaretaMachinoMonogatariJapanRev1)
STD_ROM_FN(rBSXSorewaNamaeoNusumaretaMachinoMonogatariJapanRev1)

struct BurnDriver BurnDrvrBSXSorewaNamaeoNusumaretaMachinoMonogatariJapanRev1 = {
	"BS-X - Sore wa Namae o Nusumareta Machi no Monogatari (Japan) (Rev 1)", NULL, NULL, "1986",
	"BS-X - Sore wa Namae o Nusumareta Machi no Monogatari (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"BS-X - Sore wa Namae o Nusumareta Machi no Monogatari (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBSXSorewaNamaeoNusumaretaMachinoMonogatariJapanRev1RomInfo, rBSXSorewaNamaeoNusumaretaMachinoMonogatariJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBubsyIIEuropeRomDesc[] = {
	{ "Bubsy II (Europe).sfc",          2097152, 0xe278e9b4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBubsyIIEurope)
STD_ROM_FN(rBubsyIIEurope)

struct BurnDriver BurnDrvrBubsyIIEurope = {
	"Bubsy II (Europe)", NULL, NULL, "1986",
	"Bubsy II (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bubsy II (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBubsyIIEuropeRomInfo, rBubsyIIEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBubsyIIUSARomDesc[] = {
	{ "Bubsy II (USA).sfc",          2097152, 0xd0d172fa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBubsyIIUSA)
STD_ROM_FN(rBubsyIIUSA)

struct BurnDriver BurnDrvrBubsyIIUSA = {
	"Bubsy II (USA)", NULL, NULL, "1986",
	"Bubsy II (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bubsy II (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBubsyIIUSARomInfo, rBubsyIIUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBubsyinClawsEncountersoftheFurredKindEuropeAccoladeRomDesc[] = {
	{ "Bubsy in Claws Encounters of the Furred Kind (Europe) (Accolade).sfc",          2097152, 0xab124be7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBubsyinClawsEncountersoftheFurredKindEuropeAccolade)
STD_ROM_FN(rBubsyinClawsEncountersoftheFurredKindEuropeAccolade)

struct BurnDriver BurnDrvrBubsyinClawsEncountersoftheFurredKindEuropeAccolade = {
	"Bubsy in Claws Encounters of the Furred Kind (Europe) (Accolade)", NULL, NULL, "1986",
	"Bubsy in Claws Encounters of the Furred Kind (Europe) (Accolade)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bubsy in Claws Encounters of the Furred Kind (Europe) (Accolade)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBubsyinClawsEncountersoftheFurredKindEuropeAccoladeRomInfo, rBubsyinClawsEncountersoftheFurredKindEuropeAccoladeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBubsyinClawsEncountersoftheFurredKindEuropeRomDesc[] = {
	{ "Bubsy in Claws Encounters of the Furred Kind (Europe).sfc",          2097152, 0x74a94d60, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBubsyinClawsEncountersoftheFurredKindEurope)
STD_ROM_FN(rBubsyinClawsEncountersoftheFurredKindEurope)

struct BurnDriver BurnDrvrBubsyinClawsEncountersoftheFurredKindEurope = {
	"Bubsy in Claws Encounters of the Furred Kind (Europe)", NULL, NULL, "1986",
	"Bubsy in Claws Encounters of the Furred Kind (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bubsy in Claws Encounters of the Furred Kind (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBubsyinClawsEncountersoftheFurredKindEuropeRomInfo, rBubsyinClawsEncountersoftheFurredKindEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBubsyinClawsEncountersoftheFurredKindUSABetaRomDesc[] = {
	{ "Bubsy in Claws Encounters of the Furred Kind (USA) (Beta).sfc",          2097152, 0x3f3a7180, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBubsyinClawsEncountersoftheFurredKindUSABeta)
STD_ROM_FN(rBubsyinClawsEncountersoftheFurredKindUSABeta)

struct BurnDriver BurnDrvrBubsyinClawsEncountersoftheFurredKindUSABeta = {
	"Bubsy in Claws Encounters of the Furred Kind (USA) (Beta)", NULL, NULL, "1986",
	"Bubsy in Claws Encounters of the Furred Kind (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bubsy in Claws Encounters of the Furred Kind (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBubsyinClawsEncountersoftheFurredKindUSABetaRomInfo, rBubsyinClawsEncountersoftheFurredKindUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBubsyinClawsEncountersoftheFurredKindUSARomDesc[] = {
	{ "Bubsy in Claws Encounters of the Furred Kind (USA).sfc",          2097152, 0x444a52c1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBubsyinClawsEncountersoftheFurredKindUSA)
STD_ROM_FN(rBubsyinClawsEncountersoftheFurredKindUSA)

struct BurnDriver BurnDrvrBubsyinClawsEncountersoftheFurredKindUSA = {
	"Bubsy in Claws Encounters of the Furred Kind (USA)", NULL, NULL, "1986",
	"Bubsy in Claws Encounters of the Furred Kind (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bubsy in Claws Encounters of the Furred Kind (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBubsyinClawsEncountersoftheFurredKindUSARomInfo, rBubsyinClawsEncountersoftheFurredKindUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBugsBunnyHachamechaDaiboukenJapanRomDesc[] = {
	{ "Bugs Bunny - Hachamecha Daibouken (Japan).sfc",          1572864, 0x528b029b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBugsBunnyHachamechaDaiboukenJapan)
STD_ROM_FN(rBugsBunnyHachamechaDaiboukenJapan)

struct BurnDriver BurnDrvrBugsBunnyHachamechaDaiboukenJapan = {
	"Bugs Bunny - Hachamecha Daibouken (Japan)", NULL, NULL, "1986",
	"Bugs Bunny - Hachamecha Daibouken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bugs Bunny - Hachamecha Daibouken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBugsBunnyHachamechaDaiboukenJapanRomInfo, rBugsBunnyHachamechaDaiboukenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBugsBunnyRabbitRampageEuropeRomDesc[] = {
	{ "Bugs Bunny - Rabbit Rampage (Europe).sfc",          1572864, 0x91b3db54, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBugsBunnyRabbitRampageEurope)
STD_ROM_FN(rBugsBunnyRabbitRampageEurope)

struct BurnDriver BurnDrvrBugsBunnyRabbitRampageEurope = {
	"Bugs Bunny - Rabbit Rampage (Europe)", NULL, NULL, "1986",
	"Bugs Bunny - Rabbit Rampage (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bugs Bunny - Rabbit Rampage (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBugsBunnyRabbitRampageEuropeRomInfo, rBugsBunnyRabbitRampageEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBugsBunnyRabbitRampageUSARomDesc[] = {
	{ "Bugs Bunny - Rabbit Rampage (USA).sfc",          1572864, 0x832c0cb6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBugsBunnyRabbitRampageUSA)
STD_ROM_FN(rBugsBunnyRabbitRampageUSA)

struct BurnDriver BurnDrvrBugsBunnyRabbitRampageUSA = {
	"Bugs Bunny - Rabbit Rampage (USA)", NULL, NULL, "1986",
	"Bugs Bunny - Rabbit Rampage (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bugs Bunny - Rabbit Rampage (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBugsBunnyRabbitRampageUSARomInfo, rBugsBunnyRabbitRampageUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBullsvsBlazersandtheNBAPlayoffsEuropeRev1RomDesc[] = {
	{ "Bulls vs Blazers and the NBA Playoffs (Europe) (Rev 1).sfc",          1048576, 0xc4b876b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBullsvsBlazersandtheNBAPlayoffsEuropeRev1)
STD_ROM_FN(rBullsvsBlazersandtheNBAPlayoffsEuropeRev1)

struct BurnDriver BurnDrvrBullsvsBlazersandtheNBAPlayoffsEuropeRev1 = {
	"Bulls vs Blazers and the NBA Playoffs (Europe) (Rev 1)", NULL, NULL, "1986",
	"Bulls vs Blazers and the NBA Playoffs (Europe) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bulls vs Blazers and the NBA Playoffs (Europe) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBullsvsBlazersandtheNBAPlayoffsEuropeRev1RomInfo, rBullsvsBlazersandtheNBAPlayoffsEuropeRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBullsvsBlazersandtheNBAPlayoffsEuropeRomDesc[] = {
	{ "Bulls vs Blazers and the NBA Playoffs (Europe).sfc",          1048576, 0xf605c0ac, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBullsvsBlazersandtheNBAPlayoffsEurope)
STD_ROM_FN(rBullsvsBlazersandtheNBAPlayoffsEurope)

struct BurnDriver BurnDrvrBullsvsBlazersandtheNBAPlayoffsEurope = {
	"Bulls vs Blazers and the NBA Playoffs (Europe)", NULL, NULL, "1986",
	"Bulls vs Blazers and the NBA Playoffs (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bulls vs Blazers and the NBA Playoffs (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBullsvsBlazersandtheNBAPlayoffsEuropeRomInfo, rBullsvsBlazersandtheNBAPlayoffsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBullsvsBlazersandtheNBAPlayoffsUSARev1RomDesc[] = {
	{ "Bulls vs Blazers and the NBA Playoffs (USA) (Rev 1).sfc",          1048576, 0xc2e91694, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBullsvsBlazersandtheNBAPlayoffsUSARev1)
STD_ROM_FN(rBullsvsBlazersandtheNBAPlayoffsUSARev1)

struct BurnDriver BurnDrvrBullsvsBlazersandtheNBAPlayoffsUSARev1 = {
	"Bulls vs Blazers and the NBA Playoffs (USA) (Rev 1)", NULL, NULL, "1986",
	"Bulls vs Blazers and the NBA Playoffs (USA) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bulls vs Blazers and the NBA Playoffs (USA) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBullsvsBlazersandtheNBAPlayoffsUSARev1RomInfo, rBullsvsBlazersandtheNBAPlayoffsUSARev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBullsvsBlazersandtheNBAPlayoffsUSARomDesc[] = {
	{ "Bulls vs Blazers and the NBA Playoffs (USA).sfc",          1048576, 0x15484afd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBullsvsBlazersandtheNBAPlayoffsUSA)
STD_ROM_FN(rBullsvsBlazersandtheNBAPlayoffsUSA)

struct BurnDriver BurnDrvrBullsvsBlazersandtheNBAPlayoffsUSA = {
	"Bulls vs Blazers and the NBA Playoffs (USA)", NULL, NULL, "1986",
	"Bulls vs Blazers and the NBA Playoffs (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bulls vs Blazers and the NBA Playoffs (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBullsvsBlazersandtheNBAPlayoffsUSARomInfo, rBullsvsBlazersandtheNBAPlayoffsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBuraiHachigyokunoYuushiDensetsuJapanRomDesc[] = {
	{ "Burai - Hachigyoku no Yuushi Densetsu (Japan).sfc",          1048576, 0x8005054d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBuraiHachigyokunoYuushiDensetsuJapan)
STD_ROM_FN(rBuraiHachigyokunoYuushiDensetsuJapan)

struct BurnDriver BurnDrvrBuraiHachigyokunoYuushiDensetsuJapan = {
	"Burai - Hachigyoku no Yuushi Densetsu (Japan)", NULL, NULL, "1986",
	"Burai - Hachigyoku no Yuushi Densetsu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Burai - Hachigyoku no Yuushi Densetsu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBuraiHachigyokunoYuushiDensetsuJapanRomInfo, rBuraiHachigyokunoYuushiDensetsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBushiSeiryuudenFutarinoYuushaJapanRomDesc[] = {
	{ "Bushi Seiryuuden - Futari no Yuusha (Japan).sfc",          3145728, 0x62d31295, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBushiSeiryuudenFutarinoYuushaJapan)
STD_ROM_FN(rBushiSeiryuudenFutarinoYuushaJapan)

struct BurnDriver BurnDrvrBushiSeiryuudenFutarinoYuushaJapan = {
	"Bushi Seiryuuden - Futari no Yuusha (Japan)", NULL, NULL, "1986",
	"Bushi Seiryuuden - Futari no Yuusha (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bushi Seiryuuden - Futari no Yuusha (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBushiSeiryuudenFutarinoYuushaJapanRomInfo, rBushiSeiryuudenFutarinoYuushaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rBustAMoveUSARomDesc[] = {
	{ "Bust-A-Move (USA).sfc",          524288, 0x3266fd23, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rBustAMoveUSA)
STD_ROM_FN(rBustAMoveUSA)

struct BurnDriver BurnDrvrBustAMoveUSA = {
	"Bust-A-Move (USA)", NULL, NULL, "1986",
	"Bust-A-Move (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Bust-A-Move (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rBustAMoveUSARomInfo, rBustAMoveUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCacomaKnightJapanRomDesc[] = {
	{ "Cacoma Knight (Japan).sfc",          524288, 0x6b3b7b52, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCacomaKnightJapan)
STD_ROM_FN(rCacomaKnightJapan)

struct BurnDriver BurnDrvrCacomaKnightJapan = {
	"Cacoma Knight (Japan)", NULL, NULL, "1986",
	"Cacoma Knight (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cacoma Knight (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCacomaKnightJapanRomInfo, rCacomaKnightJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCacomaKnightinBizylandUSARomDesc[] = {
	{ "Cacoma Knight in Bizyland (USA).sfc",          524288, 0xba921443, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCacomaKnightinBizylandUSA)
STD_ROM_FN(rCacomaKnightinBizylandUSA)

struct BurnDriver BurnDrvrCacomaKnightinBizylandUSA = {
	"Cacoma Knight in Bizyland (USA)", NULL, NULL, "1986",
	"Cacoma Knight in Bizyland (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cacoma Knight in Bizyland (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCacomaKnightinBizylandUSARomInfo, rCacomaKnightinBizylandUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCalRipkenJrBaseballEuropeRomDesc[] = {
	{ "Cal Ripken Jr. Baseball (Europe).sfc",          1048576, 0xc1357473, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCalRipkenJrBaseballEurope)
STD_ROM_FN(rCalRipkenJrBaseballEurope)

struct BurnDriver BurnDrvrCalRipkenJrBaseballEurope = {
	"Cal Ripken Jr. Baseball (Europe)", NULL, NULL, "1986",
	"Cal Ripken Jr. Baseball (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cal Ripken Jr. Baseball (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCalRipkenJrBaseballEuropeRomInfo, rCalRipkenJrBaseballEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCalRipkenJrBaseballUSABetaRomDesc[] = {
	{ "Cal Ripken Jr. Baseball (USA) (Beta).sfc",          1048576, 0xf48dc221, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCalRipkenJrBaseballUSABeta)
STD_ROM_FN(rCalRipkenJrBaseballUSABeta)

struct BurnDriver BurnDrvrCalRipkenJrBaseballUSABeta = {
	"Cal Ripken Jr. Baseball (USA) (Beta)", NULL, NULL, "1986",
	"Cal Ripken Jr. Baseball (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cal Ripken Jr. Baseball (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCalRipkenJrBaseballUSABetaRomInfo, rCalRipkenJrBaseballUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCalRipkenJrBaseballUSARomDesc[] = {
	{ "Cal Ripken Jr. Baseball (USA).sfc",          1048576, 0xce2eaa41, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCalRipkenJrBaseballUSA)
STD_ROM_FN(rCalRipkenJrBaseballUSA)

struct BurnDriver BurnDrvrCalRipkenJrBaseballUSA = {
	"Cal Ripken Jr. Baseball (USA)", NULL, NULL, "1986",
	"Cal Ripken Jr. Baseball (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cal Ripken Jr. Baseball (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCalRipkenJrBaseballUSARomInfo, rCalRipkenJrBaseballUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaliforniaGamesIIEuropeEnFrDeRomDesc[] = {
	{ "California Games II (Europe) (En,Fr,De).sfc",          1048576, 0xdb0814c5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaliforniaGamesIIEuropeEnFrDe)
STD_ROM_FN(rCaliforniaGamesIIEuropeEnFrDe)

struct BurnDriver BurnDrvrCaliforniaGamesIIEuropeEnFrDe = {
	"California Games II (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"California Games II (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"California Games II (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaliforniaGamesIIEuropeEnFrDeRomInfo, rCaliforniaGamesIIEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaliforniaGamesIIJapanEnJaRomDesc[] = {
	{ "California Games II (Japan) (En,Ja).sfc",          1048576, 0x5fa9485c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaliforniaGamesIIJapanEnJa)
STD_ROM_FN(rCaliforniaGamesIIJapanEnJa)

struct BurnDriver BurnDrvrCaliforniaGamesIIJapanEnJa = {
	"California Games II (Japan) (En,Ja)", NULL, NULL, "1986",
	"California Games II (Japan) (En,Ja)\0", NULL, "Nintendo", "Miscellaneous",
	L"California Games II (Japan) (En,Ja)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaliforniaGamesIIJapanEnJaRomInfo, rCaliforniaGamesIIJapanEnJaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaliforniaGamesIIUSARomDesc[] = {
	{ "California Games II (USA).sfc",          1048576, 0x21392b00, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaliforniaGamesIIUSA)
STD_ROM_FN(rCaliforniaGamesIIUSA)

struct BurnDriver BurnDrvrCaliforniaGamesIIUSA = {
	"California Games II (USA)", NULL, NULL, "1986",
	"California Games II (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"California Games II (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaliforniaGamesIIUSARomInfo, rCaliforniaGamesIIUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCameltryJapanRomDesc[] = {
	{ "Cameltry (Japan).sfc",          1048576, 0xa95c1fff, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCameltryJapan)
STD_ROM_FN(rCameltryJapan)

struct BurnDriver BurnDrvrCameltryJapan = {
	"Cameltry (Japan)", NULL, NULL, "1986",
	"Cameltry (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cameltry (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCameltryJapanRomInfo, rCameltryJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCannonFodderEuropeRomDesc[] = {
	{ "Cannon Fodder (Europe).sfc",          1572864, 0xf3b5cbb1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCannonFodderEurope)
STD_ROM_FN(rCannonFodderEurope)

struct BurnDriver BurnDrvrCannonFodderEurope = {
	"Cannon Fodder (Europe)", NULL, NULL, "1986",
	"Cannon Fodder (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cannon Fodder (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCannonFodderEuropeRomInfo, rCannonFodderEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCannondaleCupUSARomDesc[] = {
	{ "Cannondale Cup (USA).sfc",          1572864, 0xb95fe0a0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCannondaleCupUSA)
STD_ROM_FN(rCannondaleCupUSA)

struct BurnDriver BurnDrvrCannondaleCupUSA = {
	"Cannondale Cup (USA)", NULL, NULL, "1986",
	"Cannondale Cup (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cannondale Cup (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCannondaleCupUSARomInfo, rCannondaleCupUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCapcomsMVPFootballUSARomDesc[] = {
	{ "Capcom's MVP Football (USA).sfc",          1048576, 0xbd0a0c0e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCapcomsMVPFootballUSA)
STD_ROM_FN(rCapcomsMVPFootballUSA)

struct BurnDriver BurnDrvrCapcomsMVPFootballUSA = {
	"Capcom's MVP Football (USA)", NULL, NULL, "1986",
	"Capcom's MVP Football (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Capcom's MVP Football (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCapcomsMVPFootballUSARomInfo, rCapcomsMVPFootballUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCapcomsSoccerShootoutUSABetaRomDesc[] = {
	{ "Capcom's Soccer Shootout (USA) (Beta).sfc",          1572864, 0x89178bc0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCapcomsSoccerShootoutUSABeta)
STD_ROM_FN(rCapcomsSoccerShootoutUSABeta)

struct BurnDriver BurnDrvrCapcomsSoccerShootoutUSABeta = {
	"Capcom's Soccer Shootout (USA) (Beta)", NULL, NULL, "1986",
	"Capcom's Soccer Shootout (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Capcom's Soccer Shootout (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCapcomsSoccerShootoutUSABetaRomInfo, rCapcomsSoccerShootoutUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCapcomsSoccerShootoutUSARomDesc[] = {
	{ "Capcom's Soccer Shootout (USA).sfc",          1572864, 0xee314ae5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCapcomsSoccerShootoutUSA)
STD_ROM_FN(rCapcomsSoccerShootoutUSA)

struct BurnDriver BurnDrvrCapcomsSoccerShootoutUSA = {
	"Capcom's Soccer Shootout (USA)", NULL, NULL, "1986",
	"Capcom's Soccer Shootout (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Capcom's Soccer Shootout (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCapcomsSoccerShootoutUSARomInfo, rCapcomsSoccerShootoutUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaptainAmericaandtheAvengersEuropeRomDesc[] = {
	{ "Captain America and the Avengers (Europe).sfc",          1048576, 0xacb31f2a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaptainAmericaandtheAvengersEurope)
STD_ROM_FN(rCaptainAmericaandtheAvengersEurope)

struct BurnDriver BurnDrvrCaptainAmericaandtheAvengersEurope = {
	"Captain America and the Avengers (Europe)", NULL, NULL, "1986",
	"Captain America and the Avengers (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Captain America and the Avengers (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaptainAmericaandtheAvengersEuropeRomInfo, rCaptainAmericaandtheAvengersEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaptainAmericaandtheAvengersUSARomDesc[] = {
	{ "Captain America and the Avengers (USA).sfc",          1048576, 0x456ab5c8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaptainAmericaandtheAvengersUSA)
STD_ROM_FN(rCaptainAmericaandtheAvengersUSA)

struct BurnDriver BurnDrvrCaptainAmericaandtheAvengersUSA = {
	"Captain America and the Avengers (USA)", NULL, NULL, "1986",
	"Captain America and the Avengers (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Captain America and the Avengers (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaptainAmericaandtheAvengersUSARomInfo, rCaptainAmericaandtheAvengersUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaptainCommandoEuropeRomDesc[] = {
	{ "Captain Commando (Europe).sfc",          2097152, 0x5b9aa73a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaptainCommandoEurope)
STD_ROM_FN(rCaptainCommandoEurope)

struct BurnDriver BurnDrvrCaptainCommandoEurope = {
	"Captain Commando (Europe)", NULL, NULL, "1986",
	"Captain Commando (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Captain Commando (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaptainCommandoEuropeRomInfo, rCaptainCommandoEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaptainCommandoJapanRomDesc[] = {
	{ "Captain Commando (Japan).sfc",          2097152, 0xe5423eb6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaptainCommandoJapan)
STD_ROM_FN(rCaptainCommandoJapan)

struct BurnDriver BurnDrvrCaptainCommandoJapan = {
	"Captain Commando (Japan)", NULL, NULL, "1986",
	"Captain Commando (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Captain Commando (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaptainCommandoJapanRomInfo, rCaptainCommandoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaptainCommandoUSARomDesc[] = {
	{ "Captain Commando (USA).sfc",          2097152, 0x81db73c7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaptainCommandoUSA)
STD_ROM_FN(rCaptainCommandoUSA)

struct BurnDriver BurnDrvrCaptainCommandoUSA = {
	"Captain Commando (USA)", NULL, NULL, "1986",
	"Captain Commando (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Captain Commando (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaptainCommandoUSARomInfo, rCaptainCommandoUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaptainNovolinUSAEnFrEsRomDesc[] = {
	{ "Captain Novolin (USA) (En,Fr,Es).sfc",          524288, 0x9fd460a4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaptainNovolinUSAEnFrEs)
STD_ROM_FN(rCaptainNovolinUSAEnFrEs)

struct BurnDriver BurnDrvrCaptainNovolinUSAEnFrEs = {
	"Captain Novolin (USA) (En,Fr,Es)", NULL, NULL, "1986",
	"Captain Novolin (USA) (En,Fr,Es)\0", NULL, "Nintendo", "Miscellaneous",
	L"Captain Novolin (USA) (En,Fr,Es)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaptainNovolinUSAEnFrEsRomInfo, rCaptainNovolinUSAEnFrEsRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaptainTsubasaIIIKouteinoChousenJapanRomDesc[] = {
	{ "Captain Tsubasa III - Koutei no Chousen (Japan).sfc",          1048576, 0x26b0cee3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaptainTsubasaIIIKouteinoChousenJapan)
STD_ROM_FN(rCaptainTsubasaIIIKouteinoChousenJapan)

struct BurnDriver BurnDrvrCaptainTsubasaIIIKouteinoChousenJapan = {
	"Captain Tsubasa III - Koutei no Chousen (Japan)", NULL, NULL, "1986",
	"Captain Tsubasa III - Koutei no Chousen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Captain Tsubasa III - Koutei no Chousen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaptainTsubasaIIIKouteinoChousenJapanRomInfo, rCaptainTsubasaIIIKouteinoChousenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaptainTsubasaIVPronoRivaltachiJapanRomDesc[] = {
	{ "Captain Tsubasa IV - Pro no Rival-tachi (Japan).sfc",          1572864, 0x3e04b246, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaptainTsubasaIVPronoRivaltachiJapan)
STD_ROM_FN(rCaptainTsubasaIVPronoRivaltachiJapan)

struct BurnDriver BurnDrvrCaptainTsubasaIVPronoRivaltachiJapan = {
	"Captain Tsubasa IV - Pro no Rival-tachi (Japan)", NULL, NULL, "1986",
	"Captain Tsubasa IV - Pro no Rival-tachi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Captain Tsubasa IV - Pro no Rival-tachi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaptainTsubasaIVPronoRivaltachiJapanRomInfo, rCaptainTsubasaIVPronoRivaltachiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaptainTsubasaJTheWaytoWorldYouthJapanRomDesc[] = {
	{ "Captain Tsubasa J - The Way to World Youth (Japan).sfc",          2097152, 0x16c63d9c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaptainTsubasaJTheWaytoWorldYouthJapan)
STD_ROM_FN(rCaptainTsubasaJTheWaytoWorldYouthJapan)

struct BurnDriver BurnDrvrCaptainTsubasaJTheWaytoWorldYouthJapan = {
	"Captain Tsubasa J - The Way to World Youth (Japan)", NULL, NULL, "1986",
	"Captain Tsubasa J - The Way to World Youth (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Captain Tsubasa J - The Way to World Youth (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaptainTsubasaJTheWaytoWorldYouthJapanRomInfo, rCaptainTsubasaJTheWaytoWorldYouthJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaptainTsubasaVHashanoShougouCampioneJapanRomDesc[] = {
	{ "Captain Tsubasa V - Hasha no Shougou Campione (Japan).sfc",          2097152, 0xe2b26d99, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaptainTsubasaVHashanoShougouCampioneJapan)
STD_ROM_FN(rCaptainTsubasaVHashanoShougouCampioneJapan)

struct BurnDriver BurnDrvrCaptainTsubasaVHashanoShougouCampioneJapan = {
	"Captain Tsubasa V - Hasha no Shougou Campione (Japan)", NULL, NULL, "1986",
	"Captain Tsubasa V - Hasha no Shougou Campione (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Captain Tsubasa V - Hasha no Shougou Campione (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaptainTsubasaVHashanoShougouCampioneJapanRomInfo, rCaptainTsubasaVHashanoShougouCampioneJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCaravanShootingCollectionJapanRomDesc[] = {
	{ "Caravan Shooting Collection (Japan).sfc",          524288, 0x8675b9df, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCaravanShootingCollectionJapan)
STD_ROM_FN(rCaravanShootingCollectionJapan)

struct BurnDriver BurnDrvrCaravanShootingCollectionJapan = {
	"Caravan Shooting Collection (Japan)", NULL, NULL, "1986",
	"Caravan Shooting Collection (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Caravan Shooting Collection (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCaravanShootingCollectionJapanRomInfo, rCaravanShootingCollectionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCardMasterRimusarianoFuuinJapanRomDesc[] = {
	{ "Card Master - Rimusaria no Fuuin (Japan).sfc",          1048576, 0x9e772b8f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCardMasterRimusarianoFuuinJapan)
STD_ROM_FN(rCardMasterRimusarianoFuuinJapan)

struct BurnDriver BurnDrvrCardMasterRimusarianoFuuinJapan = {
	"Card Master - Rimusaria no Fuuin (Japan)", NULL, NULL, "1986",
	"Card Master - Rimusaria no Fuuin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Card Master - Rimusaria no Fuuin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCardMasterRimusarianoFuuinJapanRomInfo, rCardMasterRimusarianoFuuinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCarrierAcesEuropeRomDesc[] = {
	{ "Carrier Aces (Europe).sfc",          2097152, 0x4da4a34f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCarrierAcesEurope)
STD_ROM_FN(rCarrierAcesEurope)

struct BurnDriver BurnDrvrCarrierAcesEurope = {
	"Carrier Aces (Europe)", NULL, NULL, "1986",
	"Carrier Aces (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Carrier Aces (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCarrierAcesEuropeRomInfo, rCarrierAcesEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCarrierAcesJapanRomDesc[] = {
	{ "Carrier Aces (Japan).sfc",          2097152, 0x89b31066, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCarrierAcesJapan)
STD_ROM_FN(rCarrierAcesJapan)

struct BurnDriver BurnDrvrCarrierAcesJapan = {
	"Carrier Aces (Japan)", NULL, NULL, "1986",
	"Carrier Aces (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Carrier Aces (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCarrierAcesJapanRomInfo, rCarrierAcesJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCarrierAcesUSARomDesc[] = {
	{ "Carrier Aces (USA).sfc",          2097152, 0x8bc5b8de, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCarrierAcesUSA)
STD_ROM_FN(rCarrierAcesUSA)

struct BurnDriver BurnDrvrCarrierAcesUSA = {
	"Carrier Aces (USA)", NULL, NULL, "1986",
	"Carrier Aces (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Carrier Aces (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCarrierAcesUSARomInfo, rCarrierAcesUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCasperEuropeRomDesc[] = {
	{ "Casper (Europe).sfc",          1048576, 0xa7677e65, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCasperEurope)
STD_ROM_FN(rCasperEurope)

struct BurnDriver BurnDrvrCasperEurope = {
	"Casper (Europe)", NULL, NULL, "1986",
	"Casper (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Casper (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCasperEuropeRomInfo, rCasperEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCasperJapanRomDesc[] = {
	{ "Casper (Japan).sfc",          1048576, 0x696458b3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCasperJapan)
STD_ROM_FN(rCasperJapan)

struct BurnDriver BurnDrvrCasperJapan = {
	"Casper (Japan)", NULL, NULL, "1986",
	"Casper (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Casper (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCasperJapanRomInfo, rCasperJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCasperUSARomDesc[] = {
	{ "Casper (USA).sfc",          1048576, 0xa3b745bc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCasperUSA)
STD_ROM_FN(rCasperUSA)

struct BurnDriver BurnDrvrCasperUSA = {
	"Casper (USA)", NULL, NULL, "1986",
	"Casper (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Casper (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCasperUSARomInfo, rCasperUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCastlevaniaDraculaXUSARomDesc[] = {
	{ "Castlevania - Dracula X (USA).sfc",          2097152, 0x7c4887e1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCastlevaniaDraculaXUSA)
STD_ROM_FN(rCastlevaniaDraculaXUSA)

struct BurnDriver BurnDrvrCastlevaniaDraculaXUSA = {
	"Castlevania - Dracula X (USA)", NULL, NULL, "1986",
	"Castlevania - Dracula X (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Castlevania - Dracula X (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCastlevaniaDraculaXUSARomInfo, rCastlevaniaDraculaXUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCastlevaniaVampiresKissEuropeRomDesc[] = {
	{ "Castlevania - Vampire's Kiss (Europe).sfc",          2097152, 0x4ee9ee99, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCastlevaniaVampiresKissEurope)
STD_ROM_FN(rCastlevaniaVampiresKissEurope)

struct BurnDriver BurnDrvrCastlevaniaVampiresKissEurope = {
	"Castlevania - Vampire's Kiss (Europe)", NULL, NULL, "1986",
	"Castlevania - Vampire's Kiss (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Castlevania - Vampire's Kiss (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCastlevaniaVampiresKissEuropeRomInfo, rCastlevaniaVampiresKissEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCBCharaWarsUshinawaretaGagJapanRomDesc[] = {
	{ "CB Chara Wars - Ushinawareta Gag (Japan).sfc",          1048576, 0x85ac87d5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCBCharaWarsUshinawaretaGagJapan)
STD_ROM_FN(rCBCharaWarsUshinawaretaGagJapan)

struct BurnDriver BurnDrvrCBCharaWarsUshinawaretaGagJapan = {
	"CB Chara Wars - Ushinawareta Gag (Japan)", NULL, NULL, "1986",
	"CB Chara Wars - Ushinawareta Gag (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"CB Chara Wars - Ushinawareta Gag (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCBCharaWarsUshinawaretaGagJapanRomInfo, rCBCharaWarsUshinawaretaGagJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChampionsWorldClassSoccerEuropeEnFrDeEsRomDesc[] = {
	{ "Champions - World Class Soccer (Europe) (En,Fr,De,Es).sfc",          1048576, 0xd89c8156, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChampionsWorldClassSoccerEuropeEnFrDeEs)
STD_ROM_FN(rChampionsWorldClassSoccerEuropeEnFrDeEs)

struct BurnDriver BurnDrvrChampionsWorldClassSoccerEuropeEnFrDeEs = {
	"Champions - World Class Soccer (Europe) (En,Fr,De,Es)", NULL, NULL, "1986",
	"Champions - World Class Soccer (Europe) (En,Fr,De,Es)\0", NULL, "Nintendo", "Miscellaneous",
	L"Champions - World Class Soccer (Europe) (En,Fr,De,Es)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChampionsWorldClassSoccerEuropeEnFrDeEsRomInfo, rChampionsWorldClassSoccerEuropeEnFrDeEsRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChampionsWorldClassSoccerJapanRomDesc[] = {
	{ "Champions - World Class Soccer (Japan).sfc",          1048576, 0x7cad002, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChampionsWorldClassSoccerJapan)
STD_ROM_FN(rChampionsWorldClassSoccerJapan)

struct BurnDriver BurnDrvrChampionsWorldClassSoccerJapan = {
	"Champions - World Class Soccer (Japan)", NULL, NULL, "1986",
	"Champions - World Class Soccer (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Champions - World Class Soccer (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChampionsWorldClassSoccerJapanRomInfo, rChampionsWorldClassSoccerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChampionsWorldClassSoccerUSAEnFrDeEsRomDesc[] = {
	{ "Champions - World Class Soccer (USA) (En,Fr,De,Es).sfc",          1048576, 0xbcd59d08, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChampionsWorldClassSoccerUSAEnFrDeEs)
STD_ROM_FN(rChampionsWorldClassSoccerUSAEnFrDeEs)

struct BurnDriver BurnDrvrChampionsWorldClassSoccerUSAEnFrDeEs = {
	"Champions - World Class Soccer (USA) (En,Fr,De,Es)", NULL, NULL, "1986",
	"Champions - World Class Soccer (USA) (En,Fr,De,Es)\0", NULL, "Nintendo", "Miscellaneous",
	L"Champions - World Class Soccer (USA) (En,Fr,De,Es)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChampionsWorldClassSoccerUSAEnFrDeEsRomInfo, rChampionsWorldClassSoccerUSAEnFrDeEsRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChampionshipPoolEuropeRomDesc[] = {
	{ "Championship Pool (Europe).sfc",          1048576, 0x2905c3dd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChampionshipPoolEurope)
STD_ROM_FN(rChampionshipPoolEurope)

struct BurnDriver BurnDrvrChampionshipPoolEurope = {
	"Championship Pool (Europe)", NULL, NULL, "1986",
	"Championship Pool (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Championship Pool (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChampionshipPoolEuropeRomInfo, rChampionshipPoolEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChampionshipPoolUSARomDesc[] = {
	{ "Championship Pool (USA).sfc",          1048576, 0x98ef8414, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChampionshipPoolUSA)
STD_ROM_FN(rChampionshipPoolUSA)

struct BurnDriver BurnDrvrChampionshipPoolUSA = {
	"Championship Pool (USA)", NULL, NULL, "1986",
	"Championship Pool (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Championship Pool (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChampionshipPoolUSARomInfo, rChampionshipPoolUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChampionshipSoccer94USAEnFrDeItRomDesc[] = {
	{ "Championship Soccer '94 (USA) (En,Fr,De,It).sfc",          524288, 0x6b953095, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChampionshipSoccer94USAEnFrDeIt)
STD_ROM_FN(rChampionshipSoccer94USAEnFrDeIt)

struct BurnDriver BurnDrvrChampionshipSoccer94USAEnFrDeIt = {
	"Championship Soccer '94 (USA) (En,Fr,De,It)", NULL, NULL, "1986",
	"Championship Soccer '94 (USA) (En,Fr,De,It)\0", NULL, "Nintendo", "Miscellaneous",
	L"Championship Soccer '94 (USA) (En,Fr,De,It)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChampionshipSoccer94USAEnFrDeItRomInfo, rChampionshipSoccer94USAEnFrDeItRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChaosEngineTheEuropeRomDesc[] = {
	{ "Chaos Engine, The (Europe).sfc",          1572864, 0x8900f073, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChaosEngineTheEurope)
STD_ROM_FN(rChaosEngineTheEurope)

struct BurnDriver BurnDrvrChaosEngineTheEurope = {
	"Chaos Engine, The (Europe)", NULL, NULL, "1986",
	"Chaos Engine, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chaos Engine, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChaosEngineTheEuropeRomInfo, rChaosEngineTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChaosSeedFengShuiKairoukiJapanRomDesc[] = {
	{ "Chaos Seed - Feng Shui Kairouki (Japan).sfc",          2621440, 0x76e01ccb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChaosSeedFengShuiKairoukiJapan)
STD_ROM_FN(rChaosSeedFengShuiKairoukiJapan)

struct BurnDriver BurnDrvrChaosSeedFengShuiKairoukiJapan = {
	"Chaos Seed - Feng Shui Kairouki (Japan)", NULL, NULL, "1986",
	"Chaos Seed - Feng Shui Kairouki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chaos Seed - Feng Shui Kairouki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChaosSeedFengShuiKairoukiJapanRomInfo, rChaosSeedFengShuiKairoukiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChavezUSABetaRomDesc[] = {
	{ "Chavez (USA) (Beta).sfc",          524288, 0x1f74e668, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChavezUSABeta)
STD_ROM_FN(rChavezUSABeta)

struct BurnDriver BurnDrvrChavezUSABeta = {
	"Chavez (USA) (Beta)", NULL, NULL, "1986",
	"Chavez (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chavez (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChavezUSABetaRomInfo, rChavezUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChavezUSARomDesc[] = {
	{ "Chavez (USA).sfc",          524288, 0xa9d604ea, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChavezUSA)
STD_ROM_FN(rChavezUSA)

struct BurnDriver BurnDrvrChavezUSA = {
	"Chavez (USA)", NULL, NULL, "1986",
	"Chavez (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chavez (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChavezUSARomInfo, rChavezUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChavezIIUSARomDesc[] = {
	{ "Chavez II (USA).sfc",          1048576, 0x86981887, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChavezIIUSA)
STD_ROM_FN(rChavezIIUSA)

struct BurnDriver BurnDrvrChavezIIUSA = {
	"Chavez II (USA)", NULL, NULL, "1986",
	"Chavez II (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chavez II (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChavezIIUSARomInfo, rChavezIIUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCheapdeGorgeousVol1JapanBSRomDesc[] = {
	{ "Cheap de Gorgeous Vol. 1 (Japan) (BS).sfc",          1048576, 0xee02126e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCheapdeGorgeousVol1JapanBS)
STD_ROM_FN(rCheapdeGorgeousVol1JapanBS)

struct BurnDriver BurnDrvrCheapdeGorgeousVol1JapanBS = {
	"Cheap de Gorgeous Vol. 1 (Japan) (BS)", NULL, NULL, "1986",
	"Cheap de Gorgeous Vol. 1 (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cheap de Gorgeous Vol. 1 (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCheapdeGorgeousVol1JapanBSRomInfo, rCheapdeGorgeousVol1JapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChessmasterTheEuropeRomDesc[] = {
	{ "Chessmaster, The (Europe).sfc",          524288, 0xd84bdfd5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChessmasterTheEurope)
STD_ROM_FN(rChessmasterTheEurope)

struct BurnDriver BurnDrvrChessmasterTheEurope = {
	"Chessmaster, The (Europe)", NULL, NULL, "1986",
	"Chessmaster, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chessmaster, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChessmasterTheEuropeRomInfo, rChessmasterTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChessmasterTheJapanRomDesc[] = {
	{ "Chessmaster, The (Japan).sfc",          524288, 0x15c93942, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChessmasterTheJapan)
STD_ROM_FN(rChessmasterTheJapan)

struct BurnDriver BurnDrvrChessmasterTheJapan = {
	"Chessmaster, The (Japan)", NULL, NULL, "1986",
	"Chessmaster, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chessmaster, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChessmasterTheJapanRomInfo, rChessmasterTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChessmasterTheUSARomDesc[] = {
	{ "Chessmaster, The (USA).sfc",          524288, 0xbc671e15, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChessmasterTheUSA)
STD_ROM_FN(rChessmasterTheUSA)

struct BurnDriver BurnDrvrChessmasterTheUSA = {
	"Chessmaster, The (USA)", NULL, NULL, "1986",
	"Chessmaster, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chessmaster, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChessmasterTheUSARomInfo, rChessmasterTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChesterCheetahTooCooltoFoolUSARomDesc[] = {
	{ "Chester Cheetah - Too Cool to Fool (USA).sfc",          1048576, 0x552bf16a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChesterCheetahTooCooltoFoolUSA)
STD_ROM_FN(rChesterCheetahTooCooltoFoolUSA)

struct BurnDriver BurnDrvrChesterCheetahTooCooltoFoolUSA = {
	"Chester Cheetah - Too Cool to Fool (USA)", NULL, NULL, "1986",
	"Chester Cheetah - Too Cool to Fool (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chester Cheetah - Too Cool to Fool (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChesterCheetahTooCooltoFoolUSARomInfo, rChesterCheetahTooCooltoFoolUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChesterCheetahWildWildQuestUSABetaRomDesc[] = {
	{ "Chester Cheetah - Wild Wild Quest (USA) (Beta).sfc",          1310720, 0xbc27bca6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChesterCheetahWildWildQuestUSABeta)
STD_ROM_FN(rChesterCheetahWildWildQuestUSABeta)

struct BurnDriver BurnDrvrChesterCheetahWildWildQuestUSABeta = {
	"Chester Cheetah - Wild Wild Quest (USA) (Beta)", NULL, NULL, "1986",
	"Chester Cheetah - Wild Wild Quest (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chester Cheetah - Wild Wild Quest (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChesterCheetahWildWildQuestUSABetaRomInfo, rChesterCheetahWildWildQuestUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChesterCheetahWildWildQuestUSARomDesc[] = {
	{ "Chester Cheetah - Wild Wild Quest (USA).sfc",          1310720, 0x557fe962, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChesterCheetahWildWildQuestUSA)
STD_ROM_FN(rChesterCheetahWildWildQuestUSA)

struct BurnDriver BurnDrvrChesterCheetahWildWildQuestUSA = {
	"Chester Cheetah - Wild Wild Quest (USA)", NULL, NULL, "1986",
	"Chester Cheetah - Wild Wild Quest (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chester Cheetah - Wild Wild Quest (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChesterCheetahWildWildQuestUSARomInfo, rChesterCheetahWildWildQuestUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChibiMarukochanHarikiri365nichinoMakiJapanRomDesc[] = {
	{ "Chibi Maruko-chan - Harikiri 365-nichi no Maki (Japan).sfc",          524288, 0x846151c8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChibiMarukochanHarikiri365nichinoMakiJapan)
STD_ROM_FN(rChibiMarukochanHarikiri365nichinoMakiJapan)

struct BurnDriver BurnDrvrChibiMarukochanHarikiri365nichinoMakiJapan = {
	"Chibi Maruko-chan - Harikiri 365-nichi no Maki (Japan)", NULL, NULL, "1986",
	"Chibi Maruko-chan - Harikiri 365-nichi no Maki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chibi Maruko-chan - Harikiri 365-nichi no Maki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChibiMarukochanHarikiri365nichinoMakiJapanRomInfo, rChibiMarukochanHarikiri365nichinoMakiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChibiMarukochanMezaseMinaminoIslandJapanRomDesc[] = {
	{ "Chibi Maruko-chan - Mezase! Minami no Island!! (Japan).sfc",          2097152, 0xf4defcae, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChibiMarukochanMezaseMinaminoIslandJapan)
STD_ROM_FN(rChibiMarukochanMezaseMinaminoIslandJapan)

struct BurnDriver BurnDrvrChibiMarukochanMezaseMinaminoIslandJapan = {
	"Chibi Maruko-chan - Mezase! Minami no Island!! (Japan)", NULL, NULL, "1986",
	"Chibi Maruko-chan - Mezase! Minami no Island!! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chibi Maruko-chan - Mezase! Minami no Island!! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChibiMarukochanMezaseMinaminoIslandJapanRomInfo, rChibiMarukochanMezaseMinaminoIslandJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChinhaiJapanRomDesc[] = {
	{ "Chinhai (Japan).sfc",          524288, 0xd7452215, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChinhaiJapan)
STD_ROM_FN(rChinhaiJapan)

struct BurnDriver BurnDrvrChinhaiJapan = {
	"Chinhai (Japan)", NULL, NULL, "1986",
	"Chinhai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chinhai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChinhaiJapanRomInfo, rChinhaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChoplifterIIIRescueSurviveEuropeRomDesc[] = {
	{ "Choplifter III - Rescue & Survive (Europe).sfc",          524288, 0x788e42c9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChoplifterIIIRescueSurviveEurope)
STD_ROM_FN(rChoplifterIIIRescueSurviveEurope)

struct BurnDriver BurnDrvrChoplifterIIIRescueSurviveEurope = {
	"Choplifter III - Rescue & Survive (Europe)", NULL, NULL, "1986",
	"Choplifter III - Rescue & Survive (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Choplifter III - Rescue & Survive (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChoplifterIIIRescueSurviveEuropeRomInfo, rChoplifterIIIRescueSurviveEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChoplifterIIIRescueSurviveJapanRomDesc[] = {
	{ "Choplifter III - Rescue & Survive (Japan).sfc",          524288, 0xad26cc9e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChoplifterIIIRescueSurviveJapan)
STD_ROM_FN(rChoplifterIIIRescueSurviveJapan)

struct BurnDriver BurnDrvrChoplifterIIIRescueSurviveJapan = {
	"Choplifter III - Rescue & Survive (Japan)", NULL, NULL, "1986",
	"Choplifter III - Rescue & Survive (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Choplifter III - Rescue & Survive (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChoplifterIIIRescueSurviveJapanRomInfo, rChoplifterIIIRescueSurviveJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChoplifterIIIRescueSurviveUSABetabRomDesc[] = {
	{ "Choplifter III - Rescue & Survive (USA) (Beta) [b].sfc",          524288, 0x3280c18f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChoplifterIIIRescueSurviveUSABetab)
STD_ROM_FN(rChoplifterIIIRescueSurviveUSABetab)

struct BurnDriver BurnDrvrChoplifterIIIRescueSurviveUSABetab = {
	"Choplifter III - Rescue & Survive (USA) (Beta) [b]", NULL, NULL, "1986",
	"Choplifter III - Rescue & Survive (USA) (Beta) [b]\0", NULL, "Nintendo", "Miscellaneous",
	L"Choplifter III - Rescue & Survive (USA) (Beta) [b]", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChoplifterIIIRescueSurviveUSABetabRomInfo, rChoplifterIIIRescueSurviveUSABetabRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChoplifterIIIRescueSurviveUSARomDesc[] = {
	{ "Choplifter III - Rescue & Survive (USA).sfc",          524288, 0x1d2eae52, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChoplifterIIIRescueSurviveUSA)
STD_ROM_FN(rChoplifterIIIRescueSurviveUSA)

struct BurnDriver BurnDrvrChoplifterIIIRescueSurviveUSA = {
	"Choplifter III - Rescue & Survive (USA)", NULL, NULL, "1986",
	"Choplifter III - Rescue & Survive (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Choplifter III - Rescue & Survive (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChoplifterIIIRescueSurviveUSARomInfo, rChoplifterIIIRescueSurviveUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChouAnikiBakuretsuRantouHenJapanRomDesc[] = {
	{ "Chou Aniki - Bakuretsu Rantou Hen (Japan).sfc",          2097152, 0x70f5d440, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChouAnikiBakuretsuRantouHenJapan)
STD_ROM_FN(rChouAnikiBakuretsuRantouHenJapan)

struct BurnDriver BurnDrvrChouAnikiBakuretsuRantouHenJapan = {
	"Chou Aniki - Bakuretsu Rantou Hen (Japan)", NULL, NULL, "1986",
	"Chou Aniki - Bakuretsu Rantou Hen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chou Aniki - Bakuretsu Rantou Hen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChouAnikiBakuretsuRantouHenJapanRomInfo, rChouAnikiBakuretsuRantouHenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChouMahouTairikuWozzJapanRomDesc[] = {
	{ "Chou Mahou Tairiku Wozz (Japan).sfc",          3145728, 0xb3258f38, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChouMahouTairikuWozzJapan)
STD_ROM_FN(rChouMahouTairikuWozzJapan)

struct BurnDriver BurnDrvrChouMahouTairikuWozzJapan = {
	"Chou Mahou Tairiku Wozz (Japan)", NULL, NULL, "1986",
	"Chou Mahou Tairiku Wozz (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chou Mahou Tairiku Wozz (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChouMahouTairikuWozzJapanRomInfo, rChouMahouTairikuWozzJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChouMakaiMuraJapanRomDesc[] = {
	{ "Chou Makai Mura (Japan).sfc",          1048576, 0xcf8a8dba, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChouMakaiMuraJapan)
STD_ROM_FN(rChouMakaiMuraJapan)

struct BurnDriver BurnDrvrChouMakaiMuraJapan = {
	"Chou Makai Mura (Japan)", NULL, NULL, "1986",
	"Chou Makai Mura (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chou Makai Mura (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChouMakaiMuraJapanRomInfo, rChouMakaiMuraJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChouMakaiTaisenDorabocchanJapanBeta19921221RomDesc[] = {
	{ "Chou Makai Taisen! Dorabocchan (Japan) (Beta) (1992-12-21).sfc",          1048576, 0xc34d7b5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChouMakaiTaisenDorabocchanJapanBeta19921221)
STD_ROM_FN(rChouMakaiTaisenDorabocchanJapanBeta19921221)

struct BurnDriver BurnDrvrChouMakaiTaisenDorabocchanJapanBeta19921221 = {
	"Chou Makai Taisen! Dorabocchan (Japan) (Beta) (1992-12-21)", NULL, NULL, "1986",
	"Chou Makai Taisen! Dorabocchan (Japan) (Beta) (1992-12-21)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chou Makai Taisen! Dorabocchan (Japan) (Beta) (1992-12-21)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChouMakaiTaisenDorabocchanJapanBeta19921221RomInfo, rChouMakaiTaisenDorabocchanJapanBeta19921221RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChouMakaiTaisenDorabocchanJapanRomDesc[] = {
	{ "Chou Makai Taisen! Dorabocchan (Japan).sfc",          1048576, 0x497d7c95, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChouMakaiTaisenDorabocchanJapan)
STD_ROM_FN(rChouMakaiTaisenDorabocchanJapan)

struct BurnDriver BurnDrvrChouMakaiTaisenDorabocchanJapan = {
	"Chou Makai Taisen! Dorabocchan (Japan)", NULL, NULL, "1986",
	"Chou Makai Taisen! Dorabocchan (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chou Makai Taisen! Dorabocchan (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChouMakaiTaisenDorabocchanJapanRomInfo, rChouMakaiTaisenDorabocchanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChoujikuuYousaiMacrossScrambledValkyrieJapanRomDesc[] = {
	{ "Choujikuu Yousai Macross - Scrambled Valkyrie (Japan).sfc",          1048576, 0xa5db02e9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChoujikuuYousaiMacrossScrambledValkyrieJapan)
STD_ROM_FN(rChoujikuuYousaiMacrossScrambledValkyrieJapan)

struct BurnDriver BurnDrvrChoujikuuYousaiMacrossScrambledValkyrieJapan = {
	"Choujikuu Yousai Macross - Scrambled Valkyrie (Japan)", NULL, NULL, "1986",
	"Choujikuu Yousai Macross - Scrambled Valkyrie (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Choujikuu Yousai Macross - Scrambled Valkyrie (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChoujikuuYousaiMacrossScrambledValkyrieJapanRomInfo, rChoujikuuYousaiMacrossScrambledValkyrieJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChoukouGasshinXardionJapanRomDesc[] = {
	{ "Choukou Gasshin Xardion (Japan).sfc",          1048576, 0xd5f808ca, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChoukouGasshinXardionJapan)
STD_ROM_FN(rChoukouGasshinXardionJapan)

struct BurnDriver BurnDrvrChoukouGasshinXardionJapan = {
	"Choukou Gasshin Xardion (Japan)", NULL, NULL, "1986",
	"Choukou Gasshin Xardion (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Choukou Gasshin Xardion (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChoukouGasshinXardionJapanRomInfo, rChoukouGasshinXardionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChronoTriggerJapanSampleRomDesc[] = {
	{ "Chrono Trigger (Japan) (Sample).sfc",          4194304, 0x17c9f363, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChronoTriggerJapanSample)
STD_ROM_FN(rChronoTriggerJapanSample)

struct BurnDriver BurnDrvrChronoTriggerJapanSample = {
	"Chrono Trigger (Japan) (Sample)", NULL, NULL, "1986",
	"Chrono Trigger (Japan) (Sample)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chrono Trigger (Japan) (Sample)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChronoTriggerJapanSampleRomInfo, rChronoTriggerJapanSampleRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChronoTriggerJapanRomDesc[] = {
	{ "Chrono Trigger (Japan).sfc",          4194304, 0x4d014c20, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChronoTriggerJapan)
STD_ROM_FN(rChronoTriggerJapan)

struct BurnDriver BurnDrvrChronoTriggerJapan = {
	"Chrono Trigger (Japan)", NULL, NULL, "1986",
	"Chrono Trigger (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chrono Trigger (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChronoTriggerJapanRomInfo, rChronoTriggerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChronoTriggerUSARomDesc[] = {
	{ "Chrono Trigger (USA).sfc",          4194304, 0x2d206bf7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChronoTriggerUSA)
STD_ROM_FN(rChronoTriggerUSA)

struct BurnDriver BurnDrvrChronoTriggerUSA = {
	"Chrono Trigger (USA)", NULL, NULL, "1986",
	"Chrono Trigger (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chrono Trigger (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChronoTriggerUSARomInfo, rChronoTriggerUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChronoTriggerCharacterZukanJapanBSRomDesc[] = {
	{ "Chrono Trigger - Character Zukan (Japan) (BS).sfc",          1048576, 0x6d46f88b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChronoTriggerCharacterZukanJapanBS)
STD_ROM_FN(rChronoTriggerCharacterZukanJapanBS)

struct BurnDriver BurnDrvrChronoTriggerCharacterZukanJapanBS = {
	"Chrono Trigger - Character Zukan (Japan) (BS)", NULL, NULL, "1986",
	"Chrono Trigger - Character Zukan (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chrono Trigger - Character Zukan (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChronoTriggerCharacterZukanJapanBSRomInfo, rChronoTriggerCharacterZukanJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChronoTriggerJetBikeSpecialJapanBSRomDesc[] = {
	{ "Chrono Trigger - Jet Bike Special (Japan) (BS).sfc",          262144, 0x9dfb3014, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChronoTriggerJetBikeSpecialJapanBS)
STD_ROM_FN(rChronoTriggerJetBikeSpecialJapanBS)

struct BurnDriver BurnDrvrChronoTriggerJetBikeSpecialJapanBS = {
	"Chrono Trigger - Jet Bike Special (Japan) (BS)", NULL, NULL, "1986",
	"Chrono Trigger - Jet Bike Special (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chrono Trigger - Jet Bike Special (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChronoTriggerJetBikeSpecialJapanBSRomInfo, rChronoTriggerJetBikeSpecialJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChronoTriggerMusicLibraryJapanBSRomDesc[] = {
	{ "Chrono Trigger - Music Library (Japan) (BS).sfc",          524288, 0x27b726b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChronoTriggerMusicLibraryJapanBS)
STD_ROM_FN(rChronoTriggerMusicLibraryJapanBS)

struct BurnDriver BurnDrvrChronoTriggerMusicLibraryJapanBS = {
	"Chrono Trigger - Music Library (Japan) (BS)", NULL, NULL, "1986",
	"Chrono Trigger - Music Library (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chrono Trigger - Music Library (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChronoTriggerMusicLibraryJapanBSRomInfo, rChronoTriggerMusicLibraryJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChuckRockEuropeRomDesc[] = {
	{ "Chuck Rock (Europe).sfc",          1048576, 0xfba012cd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChuckRockEurope)
STD_ROM_FN(rChuckRockEurope)

struct BurnDriver BurnDrvrChuckRockEurope = {
	"Chuck Rock (Europe)", NULL, NULL, "1986",
	"Chuck Rock (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chuck Rock (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChuckRockEuropeRomInfo, rChuckRockEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChuckRockUSABetaRomDesc[] = {
	{ "Chuck Rock (USA) (Beta).sfc",          1048576, 0xc024f88f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChuckRockUSABeta)
STD_ROM_FN(rChuckRockUSABeta)

struct BurnDriver BurnDrvrChuckRockUSABeta = {
	"Chuck Rock (USA) (Beta)", NULL, NULL, "1986",
	"Chuck Rock (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chuck Rock (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChuckRockUSABetaRomInfo, rChuckRockUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rChuckRockUSARomDesc[] = {
	{ "Chuck Rock (USA).sfc",          1048576, 0xe237ec45, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rChuckRockUSA)
STD_ROM_FN(rChuckRockUSA)

struct BurnDriver BurnDrvrChuckRockUSA = {
	"Chuck Rock (USA)", NULL, NULL, "1986",
	"Chuck Rock (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Chuck Rock (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rChuckRockUSARomInfo, rChuckRockUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCircuitUSAJapanRomDesc[] = {
	{ "Circuit USA (Japan).sfc",          2097152, 0x5a13366c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCircuitUSAJapan)
STD_ROM_FN(rCircuitUSAJapan)

struct BurnDriver BurnDrvrCircuitUSAJapan = {
	"Circuit USA (Japan)", NULL, NULL, "1986",
	"Circuit USA (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Circuit USA (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCircuitUSAJapanRomInfo, rCircuitUSAJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCivilizationUSABetaRomDesc[] = {
	{ "Civilization (USA) (Beta).sfc",          1310720, 0x5855f7ea, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCivilizationUSABeta)
STD_ROM_FN(rCivilizationUSABeta)

struct BurnDriver BurnDrvrCivilizationUSABeta = {
	"Civilization (USA) (Beta)", NULL, NULL, "1986",
	"Civilization (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Civilization (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCivilizationUSABetaRomInfo, rCivilizationUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCivilizationUSARomDesc[] = {
	{ "Civilization (USA).sfc",          1572864, 0x41fdba82, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCivilizationUSA)
STD_ROM_FN(rCivilizationUSA)

struct BurnDriver BurnDrvrCivilizationUSA = {
	"Civilization (USA)", NULL, NULL, "1986",
	"Civilization (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Civilization (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCivilizationUSARomInfo, rCivilizationUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCivilizationSekaiShichiDaibunmeiJapanRomDesc[] = {
	{ "Civilization - Sekai Shichi Daibunmei (Japan).sfc",          1310720, 0x9d5ce088, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCivilizationSekaiShichiDaibunmeiJapan)
STD_ROM_FN(rCivilizationSekaiShichiDaibunmeiJapan)

struct BurnDriver BurnDrvrCivilizationSekaiShichiDaibunmeiJapan = {
	"Civilization - Sekai Shichi Daibunmei (Japan)", NULL, NULL, "1986",
	"Civilization - Sekai Shichi Daibunmei (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Civilization - Sekai Shichi Daibunmei (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCivilizationSekaiShichiDaibunmeiJapanRomInfo, rCivilizationSekaiShichiDaibunmeiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClassicRoadJapanRomDesc[] = {
	{ "Classic Road (Japan).sfc",          1048576, 0x3af7c64a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClassicRoadJapan)
STD_ROM_FN(rClassicRoadJapan)

struct BurnDriver BurnDrvrClassicRoadJapan = {
	"Classic Road (Japan)", NULL, NULL, "1986",
	"Classic Road (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Classic Road (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClassicRoadJapanRomInfo, rClassicRoadJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClassicRoadIIJapanRomDesc[] = {
	{ "Classic Road II (Japan).sfc",          2097152, 0xae782895, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClassicRoadIIJapan)
STD_ROM_FN(rClassicRoadIIJapan)

struct BurnDriver BurnDrvrClassicRoadIIJapan = {
	"Classic Road II (Japan)", NULL, NULL, "1986",
	"Classic Road II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Classic Road II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClassicRoadIIJapanRomInfo, rClassicRoadIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClayFighterEuropeRomDesc[] = {
	{ "Clay Fighter (Europe).sfc",          2097152, 0xb581e100, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClayFighterEurope)
STD_ROM_FN(rClayFighterEurope)

struct BurnDriver BurnDrvrClayFighterEurope = {
	"Clay Fighter (Europe)", NULL, NULL, "1986",
	"Clay Fighter (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Clay Fighter (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClayFighterEuropeRomInfo, rClayFighterEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClayFighterUSARomDesc[] = {
	{ "Clay Fighter (USA).sfc",          2097152, 0xc814e3c2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClayFighterUSA)
STD_ROM_FN(rClayFighterUSA)

struct BurnDriver BurnDrvrClayFighterUSA = {
	"Clay Fighter (USA)", NULL, NULL, "1986",
	"Clay Fighter (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Clay Fighter (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClayFighterUSARomInfo, rClayFighterUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClayFighterTournamentEditionUSARomDesc[] = {
	{ "Clay Fighter - Tournament Edition (USA).sfc",          3145728, 0xb360f7af, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClayFighterTournamentEditionUSA)
STD_ROM_FN(rClayFighterTournamentEditionUSA)

struct BurnDriver BurnDrvrClayFighterTournamentEditionUSA = {
	"Clay Fighter - Tournament Edition (USA)", NULL, NULL, "1986",
	"Clay Fighter - Tournament Edition (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Clay Fighter - Tournament Edition (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClayFighterTournamentEditionUSARomInfo, rClayFighterTournamentEditionUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClayFighter2JudgmentClayEuropeRomDesc[] = {
	{ "Clay Fighter 2 - Judgment Clay (Europe).sfc",          3145728, 0xcaa9abf1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClayFighter2JudgmentClayEurope)
STD_ROM_FN(rClayFighter2JudgmentClayEurope)

struct BurnDriver BurnDrvrClayFighter2JudgmentClayEurope = {
	"Clay Fighter 2 - Judgment Clay (Europe)", NULL, NULL, "1986",
	"Clay Fighter 2 - Judgment Clay (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Clay Fighter 2 - Judgment Clay (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClayFighter2JudgmentClayEuropeRomInfo, rClayFighter2JudgmentClayEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClayFighter2JudgmentClayUSARomDesc[] = {
	{ "Clay Fighter 2 - Judgment Clay (USA).sfc",          3145728, 0x20b5c364, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClayFighter2JudgmentClayUSA)
STD_ROM_FN(rClayFighter2JudgmentClayUSA)

struct BurnDriver BurnDrvrClayFighter2JudgmentClayUSA = {
	"Clay Fighter 2 - Judgment Clay (USA)", NULL, NULL, "1986",
	"Clay Fighter 2 - Judgment Clay (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Clay Fighter 2 - Judgment Clay (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClayFighter2JudgmentClayUSARomInfo, rClayFighter2JudgmentClayUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClaymatesEuropeRomDesc[] = {
	{ "Claymates (Europe).sfc",          1048576, 0x3a571132, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClaymatesEurope)
STD_ROM_FN(rClaymatesEurope)

struct BurnDriver BurnDrvrClaymatesEurope = {
	"Claymates (Europe)", NULL, NULL, "1986",
	"Claymates (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Claymates (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClaymatesEuropeRomInfo, rClaymatesEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClaymatesUSASampleRomDesc[] = {
	{ "Claymates (USA) (Sample).sfc",          1048576, 0x5c00f14c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClaymatesUSASample)
STD_ROM_FN(rClaymatesUSASample)

struct BurnDriver BurnDrvrClaymatesUSASample = {
	"Claymates (USA) (Sample)", NULL, NULL, "1986",
	"Claymates (USA) (Sample)\0", NULL, "Nintendo", "Miscellaneous",
	L"Claymates (USA) (Sample)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClaymatesUSASampleRomInfo, rClaymatesUSASampleRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClaymatesUSARomDesc[] = {
	{ "Claymates (USA).sfc",          1048576, 0x7ad5ccac, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClaymatesUSA)
STD_ROM_FN(rClaymatesUSA)

struct BurnDriver BurnDrvrClaymatesUSA = {
	"Claymates (USA)", NULL, NULL, "1986",
	"Claymates (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Claymates (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClaymatesUSARomInfo, rClaymatesUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCliffhangerEuropeRomDesc[] = {
	{ "Cliffhanger (Europe).sfc",          1048576, 0xa9e67214, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCliffhangerEurope)
STD_ROM_FN(rCliffhangerEurope)

struct BurnDriver BurnDrvrCliffhangerEurope = {
	"Cliffhanger (Europe)", NULL, NULL, "1986",
	"Cliffhanger (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cliffhanger (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCliffhangerEuropeRomInfo, rCliffhangerEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCliffhangerUSARomDesc[] = {
	{ "Cliffhanger (USA).sfc",          1048576, 0x12f8a26c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCliffhangerUSA)
STD_ROM_FN(rCliffhangerUSA)

struct BurnDriver BurnDrvrCliffhangerUSA = {
	"Cliffhanger (USA)", NULL, NULL, "1986",
	"Cliffhanger (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cliffhanger (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCliffhangerUSARomInfo, rCliffhangerUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClockTowerJapanRomDesc[] = {
	{ "Clock Tower (Japan).sfc",          3145728, 0xcbcd0dad, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClockTowerJapan)
STD_ROM_FN(rClockTowerJapan)

struct BurnDriver BurnDrvrClockTowerJapan = {
	"Clock Tower (Japan)", NULL, NULL, "1986",
	"Clock Tower (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Clock Tower (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClockTowerJapanRomInfo, rClockTowerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClockwerxJapanRomDesc[] = {
	{ "Clockwerx (Japan).sfc",          524288, 0xa62b84ff, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClockwerxJapan)
STD_ROM_FN(rClockwerxJapan)

struct BurnDriver BurnDrvrClockwerxJapan = {
	"Clockwerx (Japan)", NULL, NULL, "1986",
	"Clockwerx (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Clockwerx (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClockwerxJapanRomInfo, rClockwerxJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rClueUSARomDesc[] = {
	{ "Clue (USA).sfc",          524288, 0xa4fbe827, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rClueUSA)
STD_ROM_FN(rClueUSA)

struct BurnDriver BurnDrvrClueUSA = {
	"Clue (USA)", NULL, NULL, "1986",
	"Clue (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Clue (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rClueUSARomInfo, rClueUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCollegeFootballUSA97TheRoadtoNewOrleansUSARomDesc[] = {
	{ "College Football USA '97 - The Road to New Orleans (USA).sfc",          2097152, 0xa27940c1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCollegeFootballUSA97TheRoadtoNewOrleansUSA)
STD_ROM_FN(rCollegeFootballUSA97TheRoadtoNewOrleansUSA)

struct BurnDriver BurnDrvrCollegeFootballUSA97TheRoadtoNewOrleansUSA = {
	"College Football USA '97 - The Road to New Orleans (USA)", NULL, NULL, "1986",
	"College Football USA '97 - The Road to New Orleans (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"College Football USA '97 - The Road to New Orleans (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCollegeFootballUSA97TheRoadtoNewOrleansUSARomInfo, rCollegeFootballUSA97TheRoadtoNewOrleansUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCollegeSlamUSARomDesc[] = {
	{ "College Slam (USA).sfc",          3145728, 0xce842c6d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCollegeSlamUSA)
STD_ROM_FN(rCollegeSlamUSA)

struct BurnDriver BurnDrvrCollegeSlamUSA = {
	"College Slam (USA)", NULL, NULL, "1986",
	"College Slam (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"College Slam (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCollegeSlamUSARomInfo, rCollegeSlamUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rColumbusnoTamagoyakiDai1kaiJapanBSRomDesc[] = {
	{ "Columbus no Tamagoyaki - Dai-1-kai (Japan) (BS).sfc",          1048576, 0x2289c65f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rColumbusnoTamagoyakiDai1kaiJapanBS)
STD_ROM_FN(rColumbusnoTamagoyakiDai1kaiJapanBS)

struct BurnDriver BurnDrvrColumbusnoTamagoyakiDai1kaiJapanBS = {
	"Columbus no Tamagoyaki - Dai-1-kai (Japan) (BS)", NULL, NULL, "1986",
	"Columbus no Tamagoyaki - Dai-1-kai (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Columbus no Tamagoyaki - Dai-1-kai (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rColumbusnoTamagoyakiDai1kaiJapanBSRomInfo, rColumbusnoTamagoyakiDai1kaiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rColumbusnoTamagoyakiDai2kaiJapanBSRomDesc[] = {
	{ "Columbus no Tamagoyaki - Dai-2-kai (Japan) (BS).sfc",          1048576, 0xec69ee76, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rColumbusnoTamagoyakiDai2kaiJapanBS)
STD_ROM_FN(rColumbusnoTamagoyakiDai2kaiJapanBS)

struct BurnDriver BurnDrvrColumbusnoTamagoyakiDai2kaiJapanBS = {
	"Columbus no Tamagoyaki - Dai-2-kai (Japan) (BS)", NULL, NULL, "1986",
	"Columbus no Tamagoyaki - Dai-2-kai (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Columbus no Tamagoyaki - Dai-2-kai (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rColumbusnoTamagoyakiDai2kaiJapanBSRomInfo, rColumbusnoTamagoyakiDai2kaiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rColumbusnoTamagoyakiDai3kaiJapanBSRomDesc[] = {
	{ "Columbus no Tamagoyaki - Dai-3-kai (Japan) (BS).sfc",          1048576, 0xd3a32b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rColumbusnoTamagoyakiDai3kaiJapanBS)
STD_ROM_FN(rColumbusnoTamagoyakiDai3kaiJapanBS)

struct BurnDriver BurnDrvrColumbusnoTamagoyakiDai3kaiJapanBS = {
	"Columbus no Tamagoyaki - Dai-3-kai (Japan) (BS)", NULL, NULL, "1986",
	"Columbus no Tamagoyaki - Dai-3-kai (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Columbus no Tamagoyaki - Dai-3-kai (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rColumbusnoTamagoyakiDai3kaiJapanBSRomInfo, rColumbusnoTamagoyakiDai3kaiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rColumnsJapanNPRomDesc[] = {
	{ "Columns (Japan) (NP).sfc",          524288, 0x5c77f5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rColumnsJapanNP)
STD_ROM_FN(rColumnsJapanNP)

struct BurnDriver BurnDrvrColumnsJapanNP = {
	"Columns (Japan) (NP)", NULL, NULL, "1986",
	"Columns (Japan) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Columns (Japan) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rColumnsJapanNPRomInfo, rColumnsJapanNPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCombatribesTheJapanRomDesc[] = {
	{ "Combatribes, The (Japan).sfc",          1572864, 0x5e2c24f6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCombatribesTheJapan)
STD_ROM_FN(rCombatribesTheJapan)

struct BurnDriver BurnDrvrCombatribesTheJapan = {
	"Combatribes, The (Japan)", NULL, NULL, "1986",
	"Combatribes, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Combatribes, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCombatribesTheJapanRomInfo, rCombatribesTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCombatribesTheUSARomDesc[] = {
	{ "Combatribes, The (USA).sfc",          1572864, 0x9304044a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCombatribesTheUSA)
STD_ROM_FN(rCombatribesTheUSA)

struct BurnDriver BurnDrvrCombatribesTheUSA = {
	"Combatribes, The (USA)", NULL, NULL, "1986",
	"Combatribes, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Combatribes, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCombatribesTheUSARomInfo, rCombatribesTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rComputerNouryokuKaisekiUltraBakenJapanRomDesc[] = {
	{ "Computer Nouryoku Kaiseki - Ultra Baken (Japan).sfc",          1048576, 0x937a72f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rComputerNouryokuKaisekiUltraBakenJapan)
STD_ROM_FN(rComputerNouryokuKaisekiUltraBakenJapan)

struct BurnDriver BurnDrvrComputerNouryokuKaisekiUltraBakenJapan = {
	"Computer Nouryoku Kaiseki - Ultra Baken (Japan)", NULL, NULL, "1986",
	"Computer Nouryoku Kaiseki - Ultra Baken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Computer Nouryoku Kaiseki - Ultra Baken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rComputerNouryokuKaisekiUltraBakenJapanRomInfo, rComputerNouryokuKaisekiUltraBakenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCongoTheMovieTheSecretofZinjUSAProtoRomDesc[] = {
	{ "Congo - The Movie - The Secret of Zinj (USA) (Proto).sfc",          2097152, 0x2a075f4b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCongoTheMovieTheSecretofZinjUSAProto)
STD_ROM_FN(rCongoTheMovieTheSecretofZinjUSAProto)

struct BurnDriver BurnDrvrCongoTheMovieTheSecretofZinjUSAProto = {
	"Congo - The Movie - The Secret of Zinj (USA) (Proto)", NULL, NULL, "1986",
	"Congo - The Movie - The Secret of Zinj (USA) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Congo - The Movie - The Secret of Zinj (USA) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCongoTheMovieTheSecretofZinjUSAProtoRomInfo, rCongoTheMovieTheSecretofZinjUSAProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCongosCaperEuropeRomDesc[] = {
	{ "Congo's Caper (Europe).sfc",          524288, 0x549a163e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCongosCaperEurope)
STD_ROM_FN(rCongosCaperEurope)

struct BurnDriver BurnDrvrCongosCaperEurope = {
	"Congo's Caper (Europe)", NULL, NULL, "1986",
	"Congo's Caper (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Congo's Caper (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCongosCaperEuropeRomInfo, rCongosCaperEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCongosCaperUSARomDesc[] = {
	{ "Congo's Caper (USA).sfc",          524288, 0x8a24fba8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCongosCaperUSA)
STD_ROM_FN(rCongosCaperUSA)

struct BurnDriver BurnDrvrCongosCaperUSA = {
	"Congo's Caper (USA)", NULL, NULL, "1986",
	"Congo's Caper (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Congo's Caper (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCongosCaperUSARomInfo, rCongosCaperUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rContraIIITheAlienWarsUSARomDesc[] = {
	{ "Contra III - The Alien Wars (USA).sfc",          1048576, 0x84da7cfe, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rContraIIITheAlienWarsUSA)
STD_ROM_FN(rContraIIITheAlienWarsUSA)

struct BurnDriver BurnDrvrContraIIITheAlienWarsUSA = {
	"Contra III - The Alien Wars (USA)", NULL, NULL, "1986",
	"Contra III - The Alien Wars (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Contra III - The Alien Wars (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rContraIIITheAlienWarsUSARomInfo, rContraIIITheAlienWarsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rContraSpiritsJapanRomDesc[] = {
	{ "Contra Spirits (Japan).sfc",          1048576, 0xb8cfe377, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rContraSpiritsJapan)
STD_ROM_FN(rContraSpiritsJapan)

struct BurnDriver BurnDrvrContraSpiritsJapan = {
	"Contra Spirits (Japan)", NULL, NULL, "1986",
	"Contra Spirits (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Contra Spirits (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rContraSpiritsJapanRomInfo, rContraSpiritsJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rControllerTestCassetteJapanRomDesc[] = {
	{ "Controller Test Cassette (Japan).sfc",          131072, 0xedf7ebb9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rControllerTestCassetteJapan)
STD_ROM_FN(rControllerTestCassetteJapan)

struct BurnDriver BurnDrvrControllerTestCassetteJapan = {
	"Controller Test Cassette (Japan)", NULL, NULL, "1986",
	"Controller Test Cassette (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Controller Test Cassette (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rControllerTestCassetteJapanRomInfo, rControllerTestCassetteJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rConveniWarsBarcodeBattlerSenkiSuperSenshiShutsugekiseyoJapanRomDesc[] = {
	{ "Conveni Wars Barcode Battler Senki - Super Senshi Shutsugeki seyo! (Japan).sfc",          524288, 0x115233db, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rConveniWarsBarcodeBattlerSenkiSuperSenshiShutsugekiseyoJapan)
STD_ROM_FN(rConveniWarsBarcodeBattlerSenkiSuperSenshiShutsugekiseyoJapan)

struct BurnDriver BurnDrvrConveniWarsBarcodeBattlerSenkiSuperSenshiShutsugekiseyoJapan = {
	"Conveni Wars Barcode Battler Senki - Super Senshi Shutsugeki seyo! (Japan)", NULL, NULL, "1986",
	"Conveni Wars Barcode Battler Senki - Super Senshi Shutsugeki seyo! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Conveni Wars Barcode Battler Senki - Super Senshi Shutsugeki seyo! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rConveniWarsBarcodeBattlerSenkiSuperSenshiShutsugekiseyoJapanRomInfo, rConveniWarsBarcodeBattlerSenkiSuperSenshiShutsugekiseyoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCoolSpotEuropeRomDesc[] = {
	{ "Cool Spot (Europe).sfc",          1048576, 0x281244b0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCoolSpotEurope)
STD_ROM_FN(rCoolSpotEurope)

struct BurnDriver BurnDrvrCoolSpotEurope = {
	"Cool Spot (Europe)", NULL, NULL, "1986",
	"Cool Spot (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cool Spot (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCoolSpotEuropeRomInfo, rCoolSpotEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCoolSpotJapanRomDesc[] = {
	{ "Cool Spot (Japan).sfc",          1048576, 0x55964905, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCoolSpotJapan)
STD_ROM_FN(rCoolSpotJapan)

struct BurnDriver BurnDrvrCoolSpotJapan = {
	"Cool Spot (Japan)", NULL, NULL, "1986",
	"Cool Spot (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cool Spot (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCoolSpotJapanRomInfo, rCoolSpotJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCoolSpotUSABetaRomDesc[] = {
	{ "Cool Spot (USA) (Beta).sfc",          1048576, 0x9a14c57d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCoolSpotUSABeta)
STD_ROM_FN(rCoolSpotUSABeta)

struct BurnDriver BurnDrvrCoolSpotUSABeta = {
	"Cool Spot (USA) (Beta)", NULL, NULL, "1986",
	"Cool Spot (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cool Spot (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCoolSpotUSABetaRomInfo, rCoolSpotUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCoolSpotUSARomDesc[] = {
	{ "Cool Spot (USA).sfc",          1048576, 0x44e60e58, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCoolSpotUSA)
STD_ROM_FN(rCoolSpotUSA)

struct BurnDriver BurnDrvrCoolSpotUSA = {
	"Cool Spot (USA)", NULL, NULL, "1986",
	"Cool Spot (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cool Spot (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCoolSpotUSARomInfo, rCoolSpotUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCoolWorldSpainRomDesc[] = {
	{ "Cool World (Spain).sfc",          1048576, 0xbc2e1304, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCoolWorldSpain)
STD_ROM_FN(rCoolWorldSpain)

struct BurnDriver BurnDrvrCoolWorldSpain = {
	"Cool World (Spain)", NULL, NULL, "1986",
	"Cool World (Spain)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cool World (Spain)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCoolWorldSpainRomInfo, rCoolWorldSpainRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCoolWorldUSARomDesc[] = {
	{ "Cool World (USA).sfc",          1048576, 0x730c37c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCoolWorldUSA)
STD_ROM_FN(rCoolWorldUSA)

struct BurnDriver BurnDrvrCoolWorldUSA = {
	"Cool World (USA)", NULL, NULL, "1986",
	"Cool World (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cool World (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCoolWorldUSARomInfo, rCoolWorldUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCornBusterEuropeProtoRomDesc[] = {
	{ "Corn Buster (Europe) (Proto).sfc",          2031616, 0xb5fbad04, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCornBusterEuropeProto)
STD_ROM_FN(rCornBusterEuropeProto)

struct BurnDriver BurnDrvrCornBusterEuropeProto = {
	"Corn Buster (Europe) (Proto)", NULL, NULL, "1986",
	"Corn Buster (Europe) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Corn Buster (Europe) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCornBusterEuropeProtoRomInfo, rCornBusterEuropeProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCoronLandJapanRomDesc[] = {
	{ "Coron Land (Japan).sfc",          1048576, 0x236932e0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCoronLandJapan)
STD_ROM_FN(rCoronLandJapan)

struct BurnDriver BurnDrvrCoronLandJapan = {
	"Coron Land (Japan)", NULL, NULL, "1986",
	"Coron Land (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Coron Land (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCoronLandJapanRomInfo, rCoronLandJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCosmoGangThePuzzleJapanRomDesc[] = {
	{ "Cosmo Gang - The Puzzle (Japan).sfc",          524288, 0x61b26167, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCosmoGangThePuzzleJapan)
STD_ROM_FN(rCosmoGangThePuzzleJapan)

struct BurnDriver BurnDrvrCosmoGangThePuzzleJapan = {
	"Cosmo Gang - The Puzzle (Japan)", NULL, NULL, "1986",
	"Cosmo Gang - The Puzzle (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cosmo Gang - The Puzzle (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCosmoGangThePuzzleJapanRomInfo, rCosmoGangThePuzzleJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCosmoGangTheVideoJapanRomDesc[] = {
	{ "Cosmo Gang - The Video (Japan).sfc",          1048576, 0xa26dc1de, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCosmoGangTheVideoJapan)
STD_ROM_FN(rCosmoGangTheVideoJapan)

struct BurnDriver BurnDrvrCosmoGangTheVideoJapan = {
	"Cosmo Gang - The Video (Japan)", NULL, NULL, "1986",
	"Cosmo Gang - The Video (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cosmo Gang - The Video (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCosmoGangTheVideoJapanRomInfo, rCosmoGangTheVideoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCosmoPoliceGalivanIIArrowofJusticeJapanRomDesc[] = {
	{ "Cosmo Police Galivan II - Arrow of Justice (Japan).sfc",          1048576, 0x582eed3d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCosmoPoliceGalivanIIArrowofJusticeJapan)
STD_ROM_FN(rCosmoPoliceGalivanIIArrowofJusticeJapan)

struct BurnDriver BurnDrvrCosmoPoliceGalivanIIArrowofJusticeJapan = {
	"Cosmo Police Galivan II - Arrow of Justice (Japan)", NULL, NULL, "1986",
	"Cosmo Police Galivan II - Arrow of Justice (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cosmo Police Galivan II - Arrow of Justice (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCosmoPoliceGalivanIIArrowofJusticeJapanRomInfo, rCosmoPoliceGalivanIIArrowofJusticeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCrayonShinchanArashioYobuEnjiJapanRomDesc[] = {
	{ "Crayon Shin-chan - Arashi o Yobu Enji (Japan).sfc",          1572864, 0x36c23f9a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCrayonShinchanArashioYobuEnjiJapan)
STD_ROM_FN(rCrayonShinchanArashioYobuEnjiJapan)

struct BurnDriver BurnDrvrCrayonShinchanArashioYobuEnjiJapan = {
	"Crayon Shin-chan - Arashi o Yobu Enji (Japan)", NULL, NULL, "1986",
	"Crayon Shin-chan - Arashi o Yobu Enji (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Crayon Shin-chan - Arashi o Yobu Enji (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCrayonShinchanArashioYobuEnjiJapanRomInfo, rCrayonShinchanArashioYobuEnjiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCrayonShinchanNagagutsuDobonJapanSTRomDesc[] = {
	{ "Crayon Shin-chan - Nagagutsu Dobon!! (Japan) (ST).sfc",          524288, 0x8eb753f3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCrayonShinchanNagagutsuDobonJapanST)
STD_ROM_FN(rCrayonShinchanNagagutsuDobonJapanST)

struct BurnDriver BurnDrvrCrayonShinchanNagagutsuDobonJapanST = {
	"Crayon Shin-chan - Nagagutsu Dobon!! (Japan) (ST)", NULL, NULL, "1986",
	"Crayon Shin-chan - Nagagutsu Dobon!! (Japan) (ST)\0", NULL, "Nintendo", "Miscellaneous",
	L"Crayon Shin-chan - Nagagutsu Dobon!! (Japan) (ST)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCrayonShinchanNagagutsuDobonJapanSTRomInfo, rCrayonShinchanNagagutsuDobonJapanSTRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCrayonShinchan2DaimaounoGyakushuuJapanRomDesc[] = {
	{ "Crayon Shin-chan 2 - Daimaou no Gyakushuu (Japan).sfc",          524288, 0x24373cc6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCrayonShinchan2DaimaounoGyakushuuJapan)
STD_ROM_FN(rCrayonShinchan2DaimaounoGyakushuuJapan)

struct BurnDriver BurnDrvrCrayonShinchan2DaimaounoGyakushuuJapan = {
	"Crayon Shin-chan 2 - Daimaou no Gyakushuu (Japan)", NULL, NULL, "1986",
	"Crayon Shin-chan 2 - Daimaou no Gyakushuu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Crayon Shin-chan 2 - Daimaou no Gyakushuu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCrayonShinchan2DaimaounoGyakushuuJapanRomInfo, rCrayonShinchan2DaimaounoGyakushuuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCrystalBeansFromDungeonExplorerJapanRomDesc[] = {
	{ "Crystal Beans From Dungeon Explorer (Japan).sfc",          1572864, 0x79663a93, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCrystalBeansFromDungeonExplorerJapan)
STD_ROM_FN(rCrystalBeansFromDungeonExplorerJapan)

struct BurnDriver BurnDrvrCrystalBeansFromDungeonExplorerJapan = {
	"Crystal Beans From Dungeon Explorer (Japan)", NULL, NULL, "1986",
	"Crystal Beans From Dungeon Explorer (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Crystal Beans From Dungeon Explorer (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCrystalBeansFromDungeonExplorerJapanRomInfo, rCrystalBeansFromDungeonExplorerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCuOnPaSFCJapanBSRomDesc[] = {
	{ "Cu-On-Pa SFC (Japan) (BS).sfc",          1048576, 0x5f31e1d8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCuOnPaSFCJapanBS)
STD_ROM_FN(rCuOnPaSFCJapanBS)

struct BurnDriver BurnDrvrCuOnPaSFCJapanBS = {
	"Cu-On-Pa SFC (Japan) (BS)", NULL, NULL, "1986",
	"Cu-On-Pa SFC (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cu-On-Pa SFC (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCuOnPaSFCJapanBSRomInfo, rCuOnPaSFCJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCuOnPaSFCJapanRomDesc[] = {
	{ "Cu-On-Pa SFC (Japan).sfc",          1048576, 0x42d0c418, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCuOnPaSFCJapan)
STD_ROM_FN(rCuOnPaSFCJapan)

struct BurnDriver BurnDrvrCuOnPaSFCJapan = {
	"Cu-On-Pa SFC (Japan)", NULL, NULL, "1986",
	"Cu-On-Pa SFC (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cu-On-Pa SFC (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCuOnPaSFCJapanRomInfo, rCuOnPaSFCJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCutthroatIslandEuropeRomDesc[] = {
	{ "Cutthroat Island (Europe).sfc",          2097152, 0xb5799f9c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCutthroatIslandEurope)
STD_ROM_FN(rCutthroatIslandEurope)

struct BurnDriver BurnDrvrCutthroatIslandEurope = {
	"Cutthroat Island (Europe)", NULL, NULL, "1986",
	"Cutthroat Island (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cutthroat Island (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCutthroatIslandEuropeRomInfo, rCutthroatIslandEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCutthroatIslandUSARomDesc[] = {
	{ "Cutthroat Island (USA).sfc",          2097152, 0x19ea457b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCutthroatIslandUSA)
STD_ROM_FN(rCutthroatIslandUSA)

struct BurnDriver BurnDrvrCutthroatIslandUSA = {
	"Cutthroat Island (USA)", NULL, NULL, "1986",
	"Cutthroat Island (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cutthroat Island (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCutthroatIslandUSARomInfo, rCutthroatIslandUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCyberKnightJapanRomDesc[] = {
	{ "Cyber Knight (Japan).sfc",          1048576, 0x64034b07, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCyberKnightJapan)
STD_ROM_FN(rCyberKnightJapan)

struct BurnDriver BurnDrvrCyberKnightJapan = {
	"Cyber Knight (Japan)", NULL, NULL, "1986",
	"Cyber Knight (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cyber Knight (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCyberKnightJapanRomInfo, rCyberKnightJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCyberKnightIIChikyuuTeikokunoYabouJapanRomDesc[] = {
	{ "Cyber Knight II - Chikyuu Teikoku no Yabou (Japan).sfc",          2097152, 0xed8bcbf4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCyberKnightIIChikyuuTeikokunoYabouJapan)
STD_ROM_FN(rCyberKnightIIChikyuuTeikokunoYabouJapan)

struct BurnDriver BurnDrvrCyberKnightIIChikyuuTeikokunoYabouJapan = {
	"Cyber Knight II - Chikyuu Teikoku no Yabou (Japan)", NULL, NULL, "1986",
	"Cyber Knight II - Chikyuu Teikoku no Yabou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cyber Knight II - Chikyuu Teikoku no Yabou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCyberKnightIIChikyuuTeikokunoYabouJapanRomInfo, rCyberKnightIIChikyuuTeikokunoYabouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCyberSpinUSARomDesc[] = {
	{ "Cyber Spin (USA).sfc",          524288, 0x44018650, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCyberSpinUSA)
STD_ROM_FN(rCyberSpinUSA)

struct BurnDriver BurnDrvrCyberSpinUSA = {
	"Cyber Spin (USA)", NULL, NULL, "1986",
	"Cyber Spin (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cyber Spin (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCyberSpinUSARomInfo, rCyberSpinUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCybernatorEuropeRomDesc[] = {
	{ "Cybernator (Europe).sfc",          1048576, 0xf493414b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCybernatorEurope)
STD_ROM_FN(rCybernatorEurope)

struct BurnDriver BurnDrvrCybernatorEurope = {
	"Cybernator (Europe)", NULL, NULL, "1986",
	"Cybernator (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cybernator (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCybernatorEuropeRomInfo, rCybernatorEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCybernatorUSABetaRomDesc[] = {
	{ "Cybernator (USA) (Beta).sfc",          1048576, 0xaca397e8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCybernatorUSABeta)
STD_ROM_FN(rCybernatorUSABeta)

struct BurnDriver BurnDrvrCybernatorUSABeta = {
	"Cybernator (USA) (Beta)", NULL, NULL, "1986",
	"Cybernator (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cybernator (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCybernatorUSABetaRomInfo, rCybernatorUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCybernatorUSARomDesc[] = {
	{ "Cybernator (USA).sfc",          1048576, 0x4dfa05b3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCybernatorUSA)
STD_ROM_FN(rCybernatorUSA)

struct BurnDriver BurnDrvrCybernatorUSA = {
	"Cybernator (USA)", NULL, NULL, "1986",
	"Cybernator (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cybernator (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCybernatorUSARomInfo, rCybernatorUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCyborg009JapanBetaRomDesc[] = {
	{ "Cyborg 009 (Japan) (Beta).sfc",          1048576, 0x48eeccb3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCyborg009JapanBeta)
STD_ROM_FN(rCyborg009JapanBeta)

struct BurnDriver BurnDrvrCyborg009JapanBeta = {
	"Cyborg 009 (Japan) (Beta)", NULL, NULL, "1986",
	"Cyborg 009 (Japan) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cyborg 009 (Japan) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCyborg009JapanBetaRomInfo, rCyborg009JapanBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rCyborg009JapanRomDesc[] = {
	{ "Cyborg 009 (Japan).sfc",          1048576, 0x4a5263db, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rCyborg009Japan)
STD_ROM_FN(rCyborg009Japan)

struct BurnDriver BurnDrvrCyborg009Japan = {
	"Cyborg 009 (Japan)", NULL, NULL, "1986",
	"Cyborg 009 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Cyborg 009 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rCyborg009JapanRomInfo, rCyborg009JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDForceUSARomDesc[] = {
	{ "D-Force (USA).sfc",          1048576, 0x24230807, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDForceUSA)
STD_ROM_FN(rDForceUSA)

struct BurnDriver BurnDrvrDForceUSA = {
	"D-Force (USA)", NULL, NULL, "1986",
	"D-Force (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"D-Force (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDForceUSARomInfo, rDForceUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaffyDuckTheMarvinMissionsEuropeRomDesc[] = {
	{ "Daffy Duck - The Marvin Missions (Europe).sfc",          1048576, 0xf8dee029, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaffyDuckTheMarvinMissionsEurope)
STD_ROM_FN(rDaffyDuckTheMarvinMissionsEurope)

struct BurnDriver BurnDrvrDaffyDuckTheMarvinMissionsEurope = {
	"Daffy Duck - The Marvin Missions (Europe)", NULL, NULL, "1986",
	"Daffy Duck - The Marvin Missions (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daffy Duck - The Marvin Missions (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaffyDuckTheMarvinMissionsEuropeRomInfo, rDaffyDuckTheMarvinMissionsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaffyDuckTheMarvinMissionsUSARomDesc[] = {
	{ "Daffy Duck - The Marvin Missions (USA).sfc",          1048576, 0x5f02a044, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaffyDuckTheMarvinMissionsUSA)
STD_ROM_FN(rDaffyDuckTheMarvinMissionsUSA)

struct BurnDriver BurnDrvrDaffyDuckTheMarvinMissionsUSA = {
	"Daffy Duck - The Marvin Missions (USA)", NULL, NULL, "1986",
	"Daffy Duck - The Marvin Missions (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daffy Duck - The Marvin Missions (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaffyDuckTheMarvinMissionsUSARomInfo, rDaffyDuckTheMarvinMissionsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDai3jiSuperRobotTaisenJapanRev1RomDesc[] = {
	{ "Dai-3-ji Super Robot Taisen (Japan) (Rev 1).sfc",          1572864, 0x8813029c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDai3jiSuperRobotTaisenJapanRev1)
STD_ROM_FN(rDai3jiSuperRobotTaisenJapanRev1)

struct BurnDriver BurnDrvrDai3jiSuperRobotTaisenJapanRev1 = {
	"Dai-3-ji Super Robot Taisen (Japan) (Rev 1)", NULL, NULL, "1986",
	"Dai-3-ji Super Robot Taisen (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dai-3-ji Super Robot Taisen (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDai3jiSuperRobotTaisenJapanRev1RomInfo, rDai3jiSuperRobotTaisenJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDai3jiSuperRobotTaisenJapanRev2RomDesc[] = {
	{ "Dai-3-ji Super Robot Taisen (Japan) (Rev 2).sfc",          1572864, 0xc577d666, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDai3jiSuperRobotTaisenJapanRev2)
STD_ROM_FN(rDai3jiSuperRobotTaisenJapanRev2)

struct BurnDriver BurnDrvrDai3jiSuperRobotTaisenJapanRev2 = {
	"Dai-3-ji Super Robot Taisen (Japan) (Rev 2)", NULL, NULL, "1986",
	"Dai-3-ji Super Robot Taisen (Japan) (Rev 2)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dai-3-ji Super Robot Taisen (Japan) (Rev 2)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDai3jiSuperRobotTaisenJapanRev2RomInfo, rDai3jiSuperRobotTaisenJapanRev2RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDai3jiSuperRobotTaisenJapanRomDesc[] = {
	{ "Dai-3-ji Super Robot Taisen (Japan).sfc",          1572864, 0xdfe9cc90, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDai3jiSuperRobotTaisenJapan)
STD_ROM_FN(rDai3jiSuperRobotTaisenJapan)

struct BurnDriver BurnDrvrDai3jiSuperRobotTaisenJapan = {
	"Dai-3-ji Super Robot Taisen (Japan)", NULL, NULL, "1986",
	"Dai-3-ji Super Robot Taisen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dai-3-ji Super Robot Taisen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDai3jiSuperRobotTaisenJapanRomInfo, rDai3jiSuperRobotTaisenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDai4jiSuperRobotTaisenJapanRev1RomDesc[] = {
	{ "Dai-4-ji Super Robot Taisen (Japan) (Rev 1).sfc",          3145728, 0x63883e1e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDai4jiSuperRobotTaisenJapanRev1)
STD_ROM_FN(rDai4jiSuperRobotTaisenJapanRev1)

struct BurnDriver BurnDrvrDai4jiSuperRobotTaisenJapanRev1 = {
	"Dai-4-ji Super Robot Taisen (Japan) (Rev 1)", NULL, NULL, "1986",
	"Dai-4-ji Super Robot Taisen (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dai-4-ji Super Robot Taisen (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDai4jiSuperRobotTaisenJapanRev1RomInfo, rDai4jiSuperRobotTaisenJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDai4jiSuperRobotTaisenJapanRomDesc[] = {
	{ "Dai-4-ji Super Robot Taisen (Japan).sfc",          3145728, 0xbe764d4c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDai4jiSuperRobotTaisenJapan)
STD_ROM_FN(rDai4jiSuperRobotTaisenJapan)

struct BurnDriver BurnDrvrDai4jiSuperRobotTaisenJapan = {
	"Dai-4-ji Super Robot Taisen (Japan)", NULL, NULL, "1986",
	"Dai-4-ji Super Robot Taisen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dai-4-ji Super Robot Taisen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDai4jiSuperRobotTaisenJapanRomInfo, rDai4jiSuperRobotTaisenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaibakushouJinseiGekijouJapanBSRomDesc[] = {
	{ "Daibakushou Jinsei Gekijou (Japan) (BS).sfc",          1048576, 0x93c4df65, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaibakushouJinseiGekijouJapanBS)
STD_ROM_FN(rDaibakushouJinseiGekijouJapanBS)

struct BurnDriver BurnDrvrDaibakushouJinseiGekijouJapanBS = {
	"Daibakushou Jinsei Gekijou (Japan) (BS)", NULL, NULL, "1986",
	"Daibakushou Jinsei Gekijou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daibakushou Jinsei Gekijou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaibakushouJinseiGekijouJapanBSRomInfo, rDaibakushouJinseiGekijouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaibakushouJinseiGekijouJapanRomDesc[] = {
	{ "Daibakushou Jinsei Gekijou (Japan).sfc",          1048576, 0xa5d41d2f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaibakushouJinseiGekijouJapan)
STD_ROM_FN(rDaibakushouJinseiGekijouJapan)

struct BurnDriver BurnDrvrDaibakushouJinseiGekijouJapan = {
	"Daibakushou Jinsei Gekijou (Japan)", NULL, NULL, "1986",
	"Daibakushou Jinsei Gekijou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daibakushou Jinsei Gekijou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaibakushouJinseiGekijouJapanRomInfo, rDaibakushouJinseiGekijouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaibakushouJinseiGekijouDokidokiSeishunHenJapanRomDesc[] = {
	{ "Daibakushou Jinsei Gekijou - Dokidoki Seishun Hen (Japan).sfc",          1310720, 0x2763fd4f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaibakushouJinseiGekijouDokidokiSeishunHenJapan)
STD_ROM_FN(rDaibakushouJinseiGekijouDokidokiSeishunHenJapan)

struct BurnDriver BurnDrvrDaibakushouJinseiGekijouDokidokiSeishunHenJapan = {
	"Daibakushou Jinsei Gekijou - Dokidoki Seishun Hen (Japan)", NULL, NULL, "1986",
	"Daibakushou Jinsei Gekijou - Dokidoki Seishun Hen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daibakushou Jinsei Gekijou - Dokidoki Seishun Hen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaibakushouJinseiGekijouDokidokiSeishunHenJapanRomInfo, rDaibakushouJinseiGekijouDokidokiSeishunHenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaibakushouJinseiGekijouOoedoNikkiJapanRomDesc[] = {
	{ "Daibakushou Jinsei Gekijou - Ooedo Nikki (Japan).sfc",          1048576, 0x34f2685e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaibakushouJinseiGekijouOoedoNikkiJapan)
STD_ROM_FN(rDaibakushouJinseiGekijouOoedoNikkiJapan)

struct BurnDriver BurnDrvrDaibakushouJinseiGekijouOoedoNikkiJapan = {
	"Daibakushou Jinsei Gekijou - Ooedo Nikki (Japan)", NULL, NULL, "1986",
	"Daibakushou Jinsei Gekijou - Ooedo Nikki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daibakushou Jinsei Gekijou - Ooedo Nikki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaibakushouJinseiGekijouOoedoNikkiJapanRomInfo, rDaibakushouJinseiGekijouOoedoNikkiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaibakushouJinseiGekijouZukkokeSalarymanHenJapanRomDesc[] = {
	{ "Daibakushou Jinsei Gekijou - Zukkoke Salaryman Hen (Japan).sfc",          2097152, 0xeba309c0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaibakushouJinseiGekijouZukkokeSalarymanHenJapan)
STD_ROM_FN(rDaibakushouJinseiGekijouZukkokeSalarymanHenJapan)

struct BurnDriver BurnDrvrDaibakushouJinseiGekijouZukkokeSalarymanHenJapan = {
	"Daibakushou Jinsei Gekijou - Zukkoke Salaryman Hen (Japan)", NULL, NULL, "1986",
	"Daibakushou Jinsei Gekijou - Zukkoke Salaryman Hen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daibakushou Jinsei Gekijou - Zukkoke Salaryman Hen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaibakushouJinseiGekijouZukkokeSalarymanHenJapanRomInfo, rDaibakushouJinseiGekijouZukkokeSalarymanHenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaikaijuuMonogatariJapanRev1RomDesc[] = {
	{ "Daikaijuu Monogatari (Japan) (Rev 1).sfc",          3145728, 0x5b09f3ad, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaikaijuuMonogatariJapanRev1)
STD_ROM_FN(rDaikaijuuMonogatariJapanRev1)

struct BurnDriver BurnDrvrDaikaijuuMonogatariJapanRev1 = {
	"Daikaijuu Monogatari (Japan) (Rev 1)", NULL, NULL, "1986",
	"Daikaijuu Monogatari (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daikaijuu Monogatari (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaikaijuuMonogatariJapanRev1RomInfo, rDaikaijuuMonogatariJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaikaijuuMonogatariJapanRomDesc[] = {
	{ "Daikaijuu Monogatari (Japan).sfc",          3145728, 0x39ca5291, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaikaijuuMonogatariJapan)
STD_ROM_FN(rDaikaijuuMonogatariJapan)

struct BurnDriver BurnDrvrDaikaijuuMonogatariJapan = {
	"Daikaijuu Monogatari (Japan)", NULL, NULL, "1986",
	"Daikaijuu Monogatari (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daikaijuu Monogatari (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaikaijuuMonogatariJapanRomInfo, rDaikaijuuMonogatariJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaikaijuuMonogatariIIJapanRomDesc[] = {
	{ "Daikaijuu Monogatari II (Japan).sfc",          5242880, 0xa6c98ffe, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaikaijuuMonogatariIIJapan)
STD_ROM_FN(rDaikaijuuMonogatariIIJapan)

struct BurnDriver BurnDrvrDaikaijuuMonogatariIIJapan = {
	"Daikaijuu Monogatari II (Japan)", NULL, NULL, "1986",
	"Daikaijuu Monogatari II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daikaijuu Monogatari II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaikaijuuMonogatariIIJapanRomInfo, rDaikaijuuMonogatariIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaikoukaiJidaiIIJapanRomDesc[] = {
	{ "Daikoukai Jidai II (Japan).sfc",          2097152, 0xeebc4170, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaikoukaiJidaiIIJapan)
STD_ROM_FN(rDaikoukaiJidaiIIJapan)

struct BurnDriver BurnDrvrDaikoukaiJidaiIIJapan = {
	"Daikoukai Jidai II (Japan)", NULL, NULL, "1986",
	"Daikoukai Jidai II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daikoukai Jidai II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaikoukaiJidaiIIJapanRomInfo, rDaikoukaiJidaiIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaisenryakuExpertJapanRomDesc[] = {
	{ "Daisenryaku Expert (Japan).sfc",          1048576, 0x164771b5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaisenryakuExpertJapan)
STD_ROM_FN(rDaisenryakuExpertJapan)

struct BurnDriver BurnDrvrDaisenryakuExpertJapan = {
	"Daisenryaku Expert (Japan)", NULL, NULL, "1986",
	"Daisenryaku Expert (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daisenryaku Expert (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaisenryakuExpertJapanRomInfo, rDaisenryakuExpertJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDaisenryakuExpertWWIIWarinEuropeJapanRomDesc[] = {
	{ "Daisenryaku Expert WWII - War in Europe (Japan).sfc",          2097152, 0x4cd45939, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDaisenryakuExpertWWIIWarinEuropeJapan)
STD_ROM_FN(rDaisenryakuExpertWWIIWarinEuropeJapan)

struct BurnDriver BurnDrvrDaisenryakuExpertWWIIWarinEuropeJapan = {
	"Daisenryaku Expert WWII - War in Europe (Japan)", NULL, NULL, "1986",
	"Daisenryaku Expert WWII - War in Europe (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daisenryaku Expert WWII - War in Europe (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDaisenryakuExpertWWIIWarinEuropeJapanRomInfo, rDaisenryakuExpertWWIIWarinEuropeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDandanBeltConveyorGyuunyuunoMakiJapanBSRomDesc[] = {
	{ "Dandan Belt Conveyor - Gyuunyuu no Maki (Japan) (BS).sfc",          1048576, 0x380c8c79, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDandanBeltConveyorGyuunyuunoMakiJapanBS)
STD_ROM_FN(rDandanBeltConveyorGyuunyuunoMakiJapanBS)

struct BurnDriver BurnDrvrDandanBeltConveyorGyuunyuunoMakiJapanBS = {
	"Dandan Belt Conveyor - Gyuunyuu no Maki (Japan) (BS)", NULL, NULL, "1986",
	"Dandan Belt Conveyor - Gyuunyuu no Maki (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dandan Belt Conveyor - Gyuunyuu no Maki (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDandanBeltConveyorGyuunyuunoMakiJapanBSRomInfo, rDandanBeltConveyorGyuunyuunoMakiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDandanBeltConveyorUkulelenoMakiJapanBSbRomDesc[] = {
	{ "Dandan Belt Conveyor - Ukulele no Maki (Japan) (BS) [b].sfc",          1048576, 0x10205b4b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDandanBeltConveyorUkulelenoMakiJapanBSb)
STD_ROM_FN(rDandanBeltConveyorUkulelenoMakiJapanBSb)

struct BurnDriver BurnDrvrDandanBeltConveyorUkulelenoMakiJapanBSb = {
	"Dandan Belt Conveyor - Ukulele no Maki (Japan) (BS) [b]", NULL, NULL, "1986",
	"Dandan Belt Conveyor - Ukulele no Maki (Japan) (BS) [b]\0", NULL, "Nintendo", "Miscellaneous",
	L"Dandan Belt Conveyor - Ukulele no Maki (Japan) (BS) [b]", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDandanBeltConveyorUkulelenoMakiJapanBSbRomInfo, rDandanBeltConveyorUkulelenoMakiJapanBSbRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDariusForceJapanRomDesc[] = {
	{ "Darius Force (Japan).sfc",          1048576, 0x3e828e49, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDariusForceJapan)
STD_ROM_FN(rDariusForceJapan)

struct BurnDriver BurnDrvrDariusForceJapan = {
	"Darius Force (Japan)", NULL, NULL, "1986",
	"Darius Force (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Darius Force (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDariusForceJapanRomInfo, rDariusForceJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDariusTwinEuropeRomDesc[] = {
	{ "Darius Twin (Europe).sfc",          1048576, 0xcf54f1b2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDariusTwinEurope)
STD_ROM_FN(rDariusTwinEurope)

struct BurnDriver BurnDrvrDariusTwinEurope = {
	"Darius Twin (Europe)", NULL, NULL, "1986",
	"Darius Twin (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Darius Twin (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDariusTwinEuropeRomInfo, rDariusTwinEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDariusTwinJapanRomDesc[] = {
	{ "Darius Twin (Japan).sfc",          1048576, 0x299df5fe, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDariusTwinJapan)
STD_ROM_FN(rDariusTwinJapan)

struct BurnDriver BurnDrvrDariusTwinJapan = {
	"Darius Twin (Japan)", NULL, NULL, "1986",
	"Darius Twin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Darius Twin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDariusTwinJapanRomInfo, rDariusTwinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDariusTwinUSARomDesc[] = {
	{ "Darius Twin (USA).sfc",          1048576, 0xc5341764, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDariusTwinUSA)
STD_ROM_FN(rDariusTwinUSA)

struct BurnDriver BurnDrvrDariusTwinUSA = {
	"Darius Twin (USA)", NULL, NULL, "1986",
	"Darius Twin (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Darius Twin (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDariusTwinUSARomInfo, rDariusTwinUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDarkHalfJapanRomDesc[] = {
	{ "Dark Half (Japan).sfc",          3145728, 0x7b9793b1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDarkHalfJapan)
STD_ROM_FN(rDarkHalfJapan)

struct BurnDriver BurnDrvrDarkHalfJapan = {
	"Dark Half (Japan)", NULL, NULL, "1986",
	"Dark Half (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dark Half (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDarkHalfJapanRomInfo, rDarkHalfJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDarkKingdomJapanRomDesc[] = {
	{ "Dark Kingdom (Japan).sfc",          1572864, 0xf77aca0a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDarkKingdomJapan)
STD_ROM_FN(rDarkKingdomJapan)

struct BurnDriver BurnDrvrDarkKingdomJapan = {
	"Dark Kingdom (Japan)", NULL, NULL, "1986",
	"Dark Kingdom (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dark Kingdom (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDarkKingdomJapanRomInfo, rDarkKingdomJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDarkLawMeaningofDeathJapanRomDesc[] = {
	{ "Dark Law - Meaning of Death (Japan).sfc",          4194304, 0x125a0c22, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDarkLawMeaningofDeathJapan)
STD_ROM_FN(rDarkLawMeaningofDeathJapan)

struct BurnDriver BurnDrvrDarkLawMeaningofDeathJapan = {
	"Dark Law - Meaning of Death (Japan)", NULL, NULL, "1986",
	"Dark Law - Meaning of Death (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dark Law - Meaning of Death (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDarkLawMeaningofDeathJapanRomInfo, rDarkLawMeaningofDeathJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDateKimikonoVirtualTennisJapanRomDesc[] = {
	{ "Date Kimiko no Virtual Tennis (Japan).sfc",          1048576, 0xef77535e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDateKimikonoVirtualTennisJapan)
STD_ROM_FN(rDateKimikonoVirtualTennisJapan)

struct BurnDriver BurnDrvrDateKimikonoVirtualTennisJapan = {
	"Date Kimiko no Virtual Tennis (Japan)", NULL, NULL, "1986",
	"Date Kimiko no Virtual Tennis (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Date Kimiko no Virtual Tennis (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDateKimikonoVirtualTennisJapanRomInfo, rDateKimikonoVirtualTennisJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDavidCranesAmazingTennisEuropeRomDesc[] = {
	{ "David Crane's Amazing Tennis (Europe).sfc",          1048576, 0x42c25ac1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDavidCranesAmazingTennisEurope)
STD_ROM_FN(rDavidCranesAmazingTennisEurope)

struct BurnDriver BurnDrvrDavidCranesAmazingTennisEurope = {
	"David Crane's Amazing Tennis (Europe)", NULL, NULL, "1986",
	"David Crane's Amazing Tennis (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"David Crane's Amazing Tennis (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDavidCranesAmazingTennisEuropeRomInfo, rDavidCranesAmazingTennisEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDavidCranesAmazingTennisJapanRomDesc[] = {
	{ "David Crane's Amazing Tennis (Japan).sfc",          1048576, 0x72839930, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDavidCranesAmazingTennisJapan)
STD_ROM_FN(rDavidCranesAmazingTennisJapan)

struct BurnDriver BurnDrvrDavidCranesAmazingTennisJapan = {
	"David Crane's Amazing Tennis (Japan)", NULL, NULL, "1986",
	"David Crane's Amazing Tennis (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"David Crane's Amazing Tennis (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDavidCranesAmazingTennisJapanRomInfo, rDavidCranesAmazingTennisJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDavidCranesAmazingTennisUSARomDesc[] = {
	{ "David Crane's Amazing Tennis (USA).sfc",          1048576, 0xcaad18dc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDavidCranesAmazingTennisUSA)
STD_ROM_FN(rDavidCranesAmazingTennisUSA)

struct BurnDriver BurnDrvrDavidCranesAmazingTennisUSA = {
	"David Crane's Amazing Tennis (USA)", NULL, NULL, "1986",
	"David Crane's Amazing Tennis (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"David Crane's Amazing Tennis (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDavidCranesAmazingTennisUSARomInfo, rDavidCranesAmazingTennisUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDazeBeforeChristmasEuropeRomDesc[] = {
	{ "Daze Before Christmas (Europe).sfc",          2097152, 0x59909eb5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDazeBeforeChristmasEurope)
STD_ROM_FN(rDazeBeforeChristmasEurope)

struct BurnDriver BurnDrvrDazeBeforeChristmasEurope = {
	"Daze Before Christmas (Europe)", NULL, NULL, "1986",
	"Daze Before Christmas (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Daze Before Christmas (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDazeBeforeChristmasEuropeRomInfo, rDazeBeforeChristmasEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDeadDanceJapanRomDesc[] = {
	{ "Dead Dance (Japan).sfc",          2097152, 0x7019b1f1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDeadDanceJapan)
STD_ROM_FN(rDeadDanceJapan)

struct BurnDriver BurnDrvrDeadDanceJapan = {
	"Dead Dance (Japan)", NULL, NULL, "1986",
	"Dead Dance (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dead Dance (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDeadDanceJapanRomInfo, rDeadDanceJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDeaeTonosamaAppareIchibanJapanRomDesc[] = {
	{ "Deae Tonosama - Appare Ichiban (Japan).sfc",          1572864, 0x6e42d71b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDeaeTonosamaAppareIchibanJapan)
STD_ROM_FN(rDeaeTonosamaAppareIchibanJapan)

struct BurnDriver BurnDrvrDeaeTonosamaAppareIchibanJapan = {
	"Deae Tonosama - Appare Ichiban (Japan)", NULL, NULL, "1986",
	"Deae Tonosama - Appare Ichiban (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Deae Tonosama - Appare Ichiban (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDeaeTonosamaAppareIchibanJapanRomInfo, rDeaeTonosamaAppareIchibanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDearBoysJapanRomDesc[] = {
	{ "Dear Boys (Japan).sfc",          1572864, 0x9ed82c00, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDearBoysJapan)
STD_ROM_FN(rDearBoysJapan)

struct BurnDriver BurnDrvrDearBoysJapan = {
	"Dear Boys (Japan)", NULL, NULL, "1986",
	"Dear Boys (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dear Boys (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDearBoysJapanRomInfo, rDearBoysJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDeathandReturnofSupermanTheEuropeRomDesc[] = {
	{ "Death and Return of Superman, The (Europe).sfc",          2097152, 0x65792d05, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDeathandReturnofSupermanTheEurope)
STD_ROM_FN(rDeathandReturnofSupermanTheEurope)

struct BurnDriver BurnDrvrDeathandReturnofSupermanTheEurope = {
	"Death and Return of Superman, The (Europe)", NULL, NULL, "1986",
	"Death and Return of Superman, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Death and Return of Superman, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDeathandReturnofSupermanTheEuropeRomInfo, rDeathandReturnofSupermanTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDeathandReturnofSupermanTheUSARomDesc[] = {
	{ "Death and Return of Superman, The (USA).sfc",          2097152, 0xa567957c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDeathandReturnofSupermanTheUSA)
STD_ROM_FN(rDeathandReturnofSupermanTheUSA)

struct BurnDriver BurnDrvrDeathandReturnofSupermanTheUSA = {
	"Death and Return of Superman, The (USA)", NULL, NULL, "1986",
	"Death and Return of Superman, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Death and Return of Superman, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDeathandReturnofSupermanTheUSARomInfo, rDeathandReturnofSupermanTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDeathBradeJapanRomDesc[] = {
	{ "Death Brade (Japan).sfc",          1572864, 0xca46fd3b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDeathBradeJapan)
STD_ROM_FN(rDeathBradeJapan)

struct BurnDriver BurnDrvrDeathBradeJapan = {
	"Death Brade (Japan)", NULL, NULL, "1986",
	"Death Brade (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Death Brade (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDeathBradeJapanRomInfo, rDeathBradeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDekitateHighSchoolJapanRomDesc[] = {
	{ "Dekitate High School (Japan).sfc",          2097152, 0x5a2b7dac, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDekitateHighSchoolJapan)
STD_ROM_FN(rDekitateHighSchoolJapan)

struct BurnDriver BurnDrvrDekitateHighSchoolJapan = {
	"Dekitate High School (Japan)", NULL, NULL, "1986",
	"Dekitate High School (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dekitate High School (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDekitateHighSchoolJapanRomInfo, rDekitateHighSchoolJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDemolitionManEuropeRomDesc[] = {
	{ "Demolition Man (Europe).sfc",          2097152, 0x31a1b85a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDemolitionManEurope)
STD_ROM_FN(rDemolitionManEurope)

struct BurnDriver BurnDrvrDemolitionManEurope = {
	"Demolition Man (Europe)", NULL, NULL, "1986",
	"Demolition Man (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Demolition Man (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDemolitionManEuropeRomInfo, rDemolitionManEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDemolitionManUSARomDesc[] = {
	{ "Demolition Man (USA).sfc",          2097152, 0x8afe2f91, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDemolitionManUSA)
STD_ROM_FN(rDemolitionManUSA)

struct BurnDriver BurnDrvrDemolitionManUSA = {
	"Demolition Man (USA)", NULL, NULL, "1986",
	"Demolition Man (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Demolition Man (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDemolitionManUSARomInfo, rDemolitionManUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDemonsBlazonMakaiMuraMonshouHenJapanSampleRomDesc[] = {
	{ "Demon's Blazon - Makai Mura Monshou Hen (Japan) (Sample).sfc",          2097152, 0xd5bae4ff, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDemonsBlazonMakaiMuraMonshouHenJapanSample)
STD_ROM_FN(rDemonsBlazonMakaiMuraMonshouHenJapanSample)

struct BurnDriver BurnDrvrDemonsBlazonMakaiMuraMonshouHenJapanSample = {
	"Demon's Blazon - Makai Mura Monshou Hen (Japan) (Sample)", NULL, NULL, "1986",
	"Demon's Blazon - Makai Mura Monshou Hen (Japan) (Sample)\0", NULL, "Nintendo", "Miscellaneous",
	L"Demon's Blazon - Makai Mura Monshou Hen (Japan) (Sample)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDemonsBlazonMakaiMuraMonshouHenJapanSampleRomInfo, rDemonsBlazonMakaiMuraMonshouHenJapanSampleRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDemonsBlazonMakaiMuraMonshouHenJapanRomDesc[] = {
	{ "Demon's Blazon - Makai Mura Monshou Hen (Japan).sfc",          2097152, 0x287f10cc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDemonsBlazonMakaiMuraMonshouHenJapan)
STD_ROM_FN(rDemonsBlazonMakaiMuraMonshouHenJapan)

struct BurnDriver BurnDrvrDemonsBlazonMakaiMuraMonshouHenJapan = {
	"Demon's Blazon - Makai Mura Monshou Hen (Japan)", NULL, NULL, "1986",
	"Demon's Blazon - Makai Mura Monshou Hen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Demon's Blazon - Makai Mura Monshou Hen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDemonsBlazonMakaiMuraMonshouHenJapanRomInfo, rDemonsBlazonMakaiMuraMonshouHenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDemonsCrestEuropeRomDesc[] = {
	{ "Demon's Crest (Europe).sfc",          2097152, 0xc8386172, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDemonsCrestEurope)
STD_ROM_FN(rDemonsCrestEurope)

struct BurnDriver BurnDrvrDemonsCrestEurope = {
	"Demon's Crest (Europe)", NULL, NULL, "1986",
	"Demon's Crest (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Demon's Crest (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDemonsCrestEuropeRomInfo, rDemonsCrestEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDemonsCrestUSARomDesc[] = {
	{ "Demon's Crest (USA).sfc",          2097152, 0xe8236ad2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDemonsCrestUSA)
STD_ROM_FN(rDemonsCrestUSA)

struct BurnDriver BurnDrvrDemonsCrestUSA = {
	"Demon's Crest (USA)", NULL, NULL, "1986",
	"Demon's Crest (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Demon's Crest (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDemonsCrestUSARomInfo, rDemonsCrestUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDennisEuropeRomDesc[] = {
	{ "Dennis (Europe).sfc",          1048576, 0xccda70a8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDennisEurope)
STD_ROM_FN(rDennisEurope)

struct BurnDriver BurnDrvrDennisEurope = {
	"Dennis (Europe)", NULL, NULL, "1986",
	"Dennis (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dennis (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDennisEuropeRomInfo, rDennisEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDennistheMenaceUSARomDesc[] = {
	{ "Dennis the Menace (USA).sfc",          1048576, 0x8ee7faa5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDennistheMenaceUSA)
STD_ROM_FN(rDennistheMenaceUSA)

struct BurnDriver BurnDrvrDennistheMenaceUSA = {
	"Dennis the Menace (USA)", NULL, NULL, "1986",
	"Dennis the Menace (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dennis the Menace (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDennistheMenaceUSARomInfo, rDennistheMenaceUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDensetsunoOgreBattleTheMarchoftheBlackQueenJapanNPRomDesc[] = {
	{ "Densetsu no Ogre Battle - The March of the Black Queen (Japan) (NP).sfc",          2097152, 0x3e50c7c2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDensetsunoOgreBattleTheMarchoftheBlackQueenJapanNP)
STD_ROM_FN(rDensetsunoOgreBattleTheMarchoftheBlackQueenJapanNP)

struct BurnDriver BurnDrvrDensetsunoOgreBattleTheMarchoftheBlackQueenJapanNP = {
	"Densetsu no Ogre Battle - The March of the Black Queen (Japan) (NP)", NULL, NULL, "1986",
	"Densetsu no Ogre Battle - The March of the Black Queen (Japan) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Densetsu no Ogre Battle - The March of the Black Queen (Japan) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDensetsunoOgreBattleTheMarchoftheBlackQueenJapanNPRomInfo, rDensetsunoOgreBattleTheMarchoftheBlackQueenJapanNPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDensetsunoOgreBattleTheMarchoftheBlackQueenJapanRomDesc[] = {
	{ "Densetsu no Ogre Battle - The March of the Black Queen (Japan).sfc",          1572864, 0x65cd17e3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDensetsunoOgreBattleTheMarchoftheBlackQueenJapan)
STD_ROM_FN(rDensetsunoOgreBattleTheMarchoftheBlackQueenJapan)

struct BurnDriver BurnDrvrDensetsunoOgreBattleTheMarchoftheBlackQueenJapan = {
	"Densetsu no Ogre Battle - The March of the Black Queen (Japan)", NULL, NULL, "1986",
	"Densetsu no Ogre Battle - The March of the Black Queen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Densetsu no Ogre Battle - The March of the Black Queen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDensetsunoOgreBattleTheMarchoftheBlackQueenJapanRomInfo, rDensetsunoOgreBattleTheMarchoftheBlackQueenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDerbyJockeyKishuOuenoMichiJapanRev1RomDesc[] = {
	{ "Derby Jockey - Kishu Ou e no Michi (Japan) (Rev 1).sfc",          1048576, 0x8516c373, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDerbyJockeyKishuOuenoMichiJapanRev1)
STD_ROM_FN(rDerbyJockeyKishuOuenoMichiJapanRev1)

struct BurnDriver BurnDrvrDerbyJockeyKishuOuenoMichiJapanRev1 = {
	"Derby Jockey - Kishu Ou e no Michi (Japan) (Rev 1)", NULL, NULL, "1986",
	"Derby Jockey - Kishu Ou e no Michi (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Derby Jockey - Kishu Ou e no Michi (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDerbyJockeyKishuOuenoMichiJapanRev1RomInfo, rDerbyJockeyKishuOuenoMichiJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDerbyJockeyKishuOuenoMichiJapanRomDesc[] = {
	{ "Derby Jockey - Kishu Ou e no Michi (Japan).sfc",          1048576, 0x7d6c9203, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDerbyJockeyKishuOuenoMichiJapan)
STD_ROM_FN(rDerbyJockeyKishuOuenoMichiJapan)

struct BurnDriver BurnDrvrDerbyJockeyKishuOuenoMichiJapan = {
	"Derby Jockey - Kishu Ou e no Michi (Japan)", NULL, NULL, "1986",
	"Derby Jockey - Kishu Ou e no Michi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Derby Jockey - Kishu Ou e no Michi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDerbyJockeyKishuOuenoMichiJapanRomInfo, rDerbyJockeyKishuOuenoMichiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDerbyJockey2JapanRomDesc[] = {
	{ "Derby Jockey 2 (Japan).sfc",          1572864, 0x32129967, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDerbyJockey2Japan)
STD_ROM_FN(rDerbyJockey2Japan)

struct BurnDriver BurnDrvrDerbyJockey2Japan = {
	"Derby Jockey 2 (Japan)", NULL, NULL, "1986",
	"Derby Jockey 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Derby Jockey 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDerbyJockey2JapanRomInfo, rDerbyJockey2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDerbyStallion96JapanRomDesc[] = {
	{ "Derby Stallion 96 (Japan).sfc",          3145728, 0x19bdcb19, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDerbyStallion96Japan)
STD_ROM_FN(rDerbyStallion96Japan)

struct BurnDriver BurnDrvrDerbyStallion96Japan = {
	"Derby Stallion 96 (Japan)", NULL, NULL, "1986",
	"Derby Stallion 96 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Derby Stallion 96 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDerbyStallion96JapanRomInfo, rDerbyStallion96JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDerbyStallion98JapanNPRomDesc[] = {
	{ "Derby Stallion 98 (Japan) (NP).sfc",          3145728, 0x525ffb26, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDerbyStallion98JapanNP)
STD_ROM_FN(rDerbyStallion98JapanNP)

struct BurnDriver BurnDrvrDerbyStallion98JapanNP = {
	"Derby Stallion 98 (Japan) (NP)", NULL, NULL, "1986",
	"Derby Stallion 98 (Japan) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Derby Stallion 98 (Japan) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDerbyStallion98JapanNPRomInfo, rDerbyStallion98JapanNPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDerbyStallionIIJapanRomDesc[] = {
	{ "Derby Stallion II (Japan).sfc",          1572864, 0x32e29079, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDerbyStallionIIJapan)
STD_ROM_FN(rDerbyStallionIIJapan)

struct BurnDriver BurnDrvrDerbyStallionIIJapan = {
	"Derby Stallion II (Japan)", NULL, NULL, "1986",
	"Derby Stallion II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Derby Stallion II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDerbyStallionIIJapanRomInfo, rDerbyStallionIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDerbyStallionIIIJapanRev1RomDesc[] = {
	{ "Derby Stallion III (Japan) (Rev 1).sfc",          3145728, 0x7e97ae6a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDerbyStallionIIIJapanRev1)
STD_ROM_FN(rDerbyStallionIIIJapanRev1)

struct BurnDriver BurnDrvrDerbyStallionIIIJapanRev1 = {
	"Derby Stallion III (Japan) (Rev 1)", NULL, NULL, "1986",
	"Derby Stallion III (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Derby Stallion III (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDerbyStallionIIIJapanRev1RomInfo, rDerbyStallionIIIJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDerbyStallionIIIJapanRev2RomDesc[] = {
	{ "Derby Stallion III (Japan) (Rev 2).sfc",          3145728, 0x5f3e5279, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDerbyStallionIIIJapanRev2)
STD_ROM_FN(rDerbyStallionIIIJapanRev2)

struct BurnDriver BurnDrvrDerbyStallionIIIJapanRev2 = {
	"Derby Stallion III (Japan) (Rev 2)", NULL, NULL, "1986",
	"Derby Stallion III (Japan) (Rev 2)\0", NULL, "Nintendo", "Miscellaneous",
	L"Derby Stallion III (Japan) (Rev 2)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDerbyStallionIIIJapanRev2RomInfo, rDerbyStallionIIIJapanRev2RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDerbyStallionIIIJapanRev3RomDesc[] = {
	{ "Derby Stallion III (Japan) (Rev 3).sfc",          3145728, 0x36768b55, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDerbyStallionIIIJapanRev3)
STD_ROM_FN(rDerbyStallionIIIJapanRev3)

struct BurnDriver BurnDrvrDerbyStallionIIIJapanRev3 = {
	"Derby Stallion III (Japan) (Rev 3)", NULL, NULL, "1986",
	"Derby Stallion III (Japan) (Rev 3)\0", NULL, "Nintendo", "Miscellaneous",
	L"Derby Stallion III (Japan) (Rev 3)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDerbyStallionIIIJapanRev3RomInfo, rDerbyStallionIIIJapanRev3RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDerbyStallionIIIJapanRomDesc[] = {
	{ "Derby Stallion III (Japan).sfc",          3145728, 0x75eeeb3f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDerbyStallionIIIJapan)
STD_ROM_FN(rDerbyStallionIIIJapan)

struct BurnDriver BurnDrvrDerbyStallionIIIJapan = {
	"Derby Stallion III (Japan)", NULL, NULL, "1986",
	"Derby Stallion III (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Derby Stallion III (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDerbyStallionIIIJapanRomInfo, rDerbyStallionIIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDesertFighterEuropeBetaRomDesc[] = {
	{ "Desert Fighter (Europe) (Beta).sfc",          1048576, 0xcd989804, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDesertFighterEuropeBeta)
STD_ROM_FN(rDesertFighterEuropeBeta)

struct BurnDriver BurnDrvrDesertFighterEuropeBeta = {
	"Desert Fighter (Europe) (Beta)", NULL, NULL, "1986",
	"Desert Fighter (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Desert Fighter (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDesertFighterEuropeBetaRomInfo, rDesertFighterEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDesertFighterEuropeRomDesc[] = {
	{ "Desert Fighter (Europe).sfc",          1048576, 0xb78bae0e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDesertFighterEurope)
STD_ROM_FN(rDesertFighterEurope)

struct BurnDriver BurnDrvrDesertFighterEurope = {
	"Desert Fighter (Europe)", NULL, NULL, "1986",
	"Desert Fighter (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Desert Fighter (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDesertFighterEuropeRomInfo, rDesertFighterEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDesertFighterSunanoArashiSakusenJapanRomDesc[] = {
	{ "Desert Fighter - Suna no Arashi Sakusen (Japan).sfc",          1048576, 0x9edc5a7d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDesertFighterSunanoArashiSakusenJapan)
STD_ROM_FN(rDesertFighterSunanoArashiSakusenJapan)

struct BurnDriver BurnDrvrDesertFighterSunanoArashiSakusenJapan = {
	"Desert Fighter - Suna no Arashi Sakusen (Japan)", NULL, NULL, "1986",
	"Desert Fighter - Suna no Arashi Sakusen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Desert Fighter - Suna no Arashi Sakusen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDesertFighterSunanoArashiSakusenJapanRomInfo, rDesertFighterSunanoArashiSakusenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDesertStrikeReturntotheGulfEuropeRomDesc[] = {
	{ "Desert Strike - Return to the Gulf (Europe).sfc",          1048576, 0x8eed024a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDesertStrikeReturntotheGulfEurope)
STD_ROM_FN(rDesertStrikeReturntotheGulfEurope)

struct BurnDriver BurnDrvrDesertStrikeReturntotheGulfEurope = {
	"Desert Strike - Return to the Gulf (Europe)", NULL, NULL, "1986",
	"Desert Strike - Return to the Gulf (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Desert Strike - Return to the Gulf (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDesertStrikeReturntotheGulfEuropeRomInfo, rDesertStrikeReturntotheGulfEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDesertStrikeReturntotheGulfUSARomDesc[] = {
	{ "Desert Strike - Return to the Gulf (USA).sfc",          1048576, 0x4ce26787, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDesertStrikeReturntotheGulfUSA)
STD_ROM_FN(rDesertStrikeReturntotheGulfUSA)

struct BurnDriver BurnDrvrDesertStrikeReturntotheGulfUSA = {
	"Desert Strike - Return to the Gulf (USA)", NULL, NULL, "1986",
	"Desert Strike - Return to the Gulf (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Desert Strike - Return to the Gulf (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDesertStrikeReturntotheGulfUSARomInfo, rDesertStrikeReturntotheGulfUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDesertStrikeWanganSakusenJapanRomDesc[] = {
	{ "Desert Strike - Wangan Sakusen (Japan).sfc",          1048576, 0xfcdf43ca, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDesertStrikeWanganSakusenJapan)
STD_ROM_FN(rDesertStrikeWanganSakusenJapan)

struct BurnDriver BurnDrvrDesertStrikeWanganSakusenJapan = {
	"Desert Strike - Wangan Sakusen (Japan)", NULL, NULL, "1986",
	"Desert Strike - Wangan Sakusen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Desert Strike - Wangan Sakusen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDesertStrikeWanganSakusenJapanRomInfo, rDesertStrikeWanganSakusenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDestructiveJapanRomDesc[] = {
	{ "Destructive (Japan).sfc",          524288, 0x21b47e62, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDestructiveJapan)
STD_ROM_FN(rDestructiveJapan)

struct BurnDriver BurnDrvrDestructiveJapan = {
	"Destructive (Japan)", NULL, NULL, "1986",
	"Destructive (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Destructive (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDestructiveJapanRomInfo, rDestructiveJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDharmaDoujouJapanRomDesc[] = {
	{ "Dharma Doujou (Japan).sfc",          1048576, 0xb800a4fb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDharmaDoujouJapan)
STD_ROM_FN(rDharmaDoujouJapan)

struct BurnDriver BurnDrvrDharmaDoujouJapan = {
	"Dharma Doujou (Japan)", NULL, NULL, "1986",
	"Dharma Doujou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dharma Doujou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDharmaDoujouJapanRomInfo, rDharmaDoujouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDigSpikeVolleyballUSARomDesc[] = {
	{ "Dig & Spike Volleyball (USA).sfc",          1048576, 0x954340f8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDigSpikeVolleyballUSA)
STD_ROM_FN(rDigSpikeVolleyballUSA)

struct BurnDriver BurnDrvrDigSpikeVolleyballUSA = {
	"Dig & Spike Volleyball (USA)", NULL, NULL, "1986",
	"Dig & Spike Volleyball (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dig & Spike Volleyball (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDigSpikeVolleyballUSARomInfo, rDigSpikeVolleyballUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDigitalMagazineBustersBS412GouJapanBSRomDesc[] = {
	{ "Digital Magazine Busters BS - 4-12 Gou (Japan) (BS).sfc",          1048576, 0x1976866a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDigitalMagazineBustersBS412GouJapanBS)
STD_ROM_FN(rDigitalMagazineBustersBS412GouJapanBS)

struct BurnDriver BurnDrvrDigitalMagazineBustersBS412GouJapanBS = {
	"Digital Magazine Busters BS - 4-12 Gou (Japan) (BS)", NULL, NULL, "1986",
	"Digital Magazine Busters BS - 4-12 Gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Digital Magazine Busters BS - 4-12 Gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDigitalMagazineBustersBS412GouJapanBSRomInfo, rDigitalMagazineBustersBS412GouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDigitalMagazineBustersBS510GouJapanBSRomDesc[] = {
	{ "Digital Magazine Busters BS - 5-10 Gou (Japan) (BS).sfc",          1048576, 0x3f3f4608, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDigitalMagazineBustersBS510GouJapanBS)
STD_ROM_FN(rDigitalMagazineBustersBS510GouJapanBS)

struct BurnDriver BurnDrvrDigitalMagazineBustersBS510GouJapanBS = {
	"Digital Magazine Busters BS - 5-10 Gou (Japan) (BS)", NULL, NULL, "1986",
	"Digital Magazine Busters BS - 5-10 Gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Digital Magazine Busters BS - 5-10 Gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDigitalMagazineBustersBS510GouJapanBSRomInfo, rDigitalMagazineBustersBS510GouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDigitalMagazineBustersBS524GouJapanBSRomDesc[] = {
	{ "Digital Magazine Busters BS - 5-24 Gou (Japan) (BS).sfc",          1048576, 0x8e8f27e9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDigitalMagazineBustersBS524GouJapanBS)
STD_ROM_FN(rDigitalMagazineBustersBS524GouJapanBS)

struct BurnDriver BurnDrvrDigitalMagazineBustersBS524GouJapanBS = {
	"Digital Magazine Busters BS - 5-24 Gou (Japan) (BS)", NULL, NULL, "1986",
	"Digital Magazine Busters BS - 5-24 Gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Digital Magazine Busters BS - 5-24 Gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDigitalMagazineBustersBS524GouJapanBSRomInfo, rDigitalMagazineBustersBS524GouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDigitalMagazineBustersBS823GouJapanBSRomDesc[] = {
	{ "Digital Magazine Busters BS - 8-23 Gou (Japan) (BS).sfc",          1048576, 0x6f7f6c5d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDigitalMagazineBustersBS823GouJapanBS)
STD_ROM_FN(rDigitalMagazineBustersBS823GouJapanBS)

struct BurnDriver BurnDrvrDigitalMagazineBustersBS823GouJapanBS = {
	"Digital Magazine Busters BS - 8-23 Gou (Japan) (BS)", NULL, NULL, "1986",
	"Digital Magazine Busters BS - 8-23 Gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Digital Magazine Busters BS - 8-23 Gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDigitalMagazineBustersBS823GouJapanBSRomInfo, rDigitalMagazineBustersBS823GouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDimensionForceJapanRomDesc[] = {
	{ "Dimension-Force (Japan).sfc",          1048576, 0x3d0d6fdc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDimensionForceJapan)
STD_ROM_FN(rDimensionForceJapan)

struct BurnDriver BurnDrvrDimensionForceJapan = {
	"Dimension-Force (Japan)", NULL, NULL, "1986",
	"Dimension-Force (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dimension-Force (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDimensionForceJapanRomInfo, rDimensionForceJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDinoCityEuropeRomDesc[] = {
	{ "Dino City (Europe).sfc",          1048576, 0xc495320a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDinoCityEurope)
STD_ROM_FN(rDinoCityEurope)

struct BurnDriver BurnDrvrDinoCityEurope = {
	"Dino City (Europe)", NULL, NULL, "1986",
	"Dino City (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dino City (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDinoCityEuropeRomInfo, rDinoCityEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDinoCityUSARomDesc[] = {
	{ "Dino City (USA).sfc",          1048576, 0x94152717, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDinoCityUSA)
STD_ROM_FN(rDinoCityUSA)

struct BurnDriver BurnDrvrDinoCityUSA = {
	"Dino City (USA)", NULL, NULL, "1986",
	"Dino City (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dino City (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDinoCityUSARomInfo, rDinoCityUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDinoDinisSoccerEuropeEnFrDeRomDesc[] = {
	{ "Dino Dini's Soccer! (Europe) (En,Fr,De).sfc",          1048576, 0xdbf4a8ab, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDinoDinisSoccerEuropeEnFrDe)
STD_ROM_FN(rDinoDinisSoccerEuropeEnFrDe)

struct BurnDriver BurnDrvrDinoDinisSoccerEuropeEnFrDe = {
	"Dino Dini's Soccer! (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Dino Dini's Soccer! (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dino Dini's Soccer! (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDinoDinisSoccerEuropeEnFrDeRomInfo, rDinoDinisSoccerEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDinowarsKyouryuuOukokuenoDaiboukenJapanRomDesc[] = {
	{ "Dinowars - Kyouryuu Oukoku e no Daibouken (Japan).sfc",          1048576, 0x6c043bf1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDinowarsKyouryuuOukokuenoDaiboukenJapan)
STD_ROM_FN(rDinowarsKyouryuuOukokuenoDaiboukenJapan)

struct BurnDriver BurnDrvrDinowarsKyouryuuOukokuenoDaiboukenJapan = {
	"Dinowars - Kyouryuu Oukoku e no Daibouken (Japan)", NULL, NULL, "1986",
	"Dinowars - Kyouryuu Oukoku e no Daibouken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dinowars - Kyouryuu Oukoku e no Daibouken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDinowarsKyouryuuOukokuenoDaiboukenJapanRomInfo, rDinowarsKyouryuuOukokuenoDaiboukenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDirtRacerEuropeEnFrDeRomDesc[] = {
	{ "Dirt Racer (Europe) (En,Fr,De).sfc",          524288, 0x354f4b1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDirtRacerEuropeEnFrDe)
STD_ROM_FN(rDirtRacerEuropeEnFrDe)

struct BurnDriver BurnDrvrDirtRacerEuropeEnFrDe = {
	"Dirt Racer (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Dirt Racer (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dirt Racer (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDirtRacerEuropeEnFrDeRomInfo, rDirtRacerEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDirtTraxFXEuropeRomDesc[] = {
	{ "Dirt Trax FX (Europe).sfc",          524288, 0x9dbc2330, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDirtTraxFXEurope)
STD_ROM_FN(rDirtTraxFXEurope)

struct BurnDriver BurnDrvrDirtTraxFXEurope = {
	"Dirt Trax FX (Europe)", NULL, NULL, "1986",
	"Dirt Trax FX (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dirt Trax FX (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDirtTraxFXEuropeRomInfo, rDirtTraxFXEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDirtTraxFXUSARomDesc[] = {
	{ "Dirt Trax FX (USA).sfc",          524288, 0x61a86c7f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDirtTraxFXUSA)
STD_ROM_FN(rDirtTraxFXUSA)

struct BurnDriver BurnDrvrDirtTraxFXUSA = {
	"Dirt Trax FX (USA)", NULL, NULL, "1986",
	"Dirt Trax FX (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dirt Trax FX (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDirtTraxFXUSARomInfo, rDirtTraxFXUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoReMideFaa2510GouJapanBSRomDesc[] = {
	{ "Do-Re-Mi de Faa 2~! - 5-10 Gou (Japan) (BS).sfc",          1048576, 0x25401316, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoReMideFaa2510GouJapanBS)
STD_ROM_FN(rDoReMideFaa2510GouJapanBS)

struct BurnDriver BurnDrvrDoReMideFaa2510GouJapanBS = {
	"Do-Re-Mi de Faa 2~! - 5-10 Gou (Japan) (BS)", NULL, NULL, "1986",
	"Do-Re-Mi de Faa 2~! - 5-10 Gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Do-Re-Mi de Faa 2~! - 5-10 Gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoReMideFaa2510GouJapanBSRomInfo, rDoReMideFaa2510GouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoReMideFaa2525GouJapanBSRomDesc[] = {
	{ "Do-Re-Mi de Faa 2~! - 5-25 Gou (Japan) (BS).sfc",          1048576, 0xf8b048f5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoReMideFaa2525GouJapanBS)
STD_ROM_FN(rDoReMideFaa2525GouJapanBS)

struct BurnDriver BurnDrvrDoReMideFaa2525GouJapanBS = {
	"Do-Re-Mi de Faa 2~! - 5-25 Gou (Japan) (BS)", NULL, NULL, "1986",
	"Do-Re-Mi de Faa 2~! - 5-25 Gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Do-Re-Mi de Faa 2~! - 5-25 Gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoReMideFaa2525GouJapanBSRomInfo, rDoReMideFaa2525GouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoReMiFantasyMilonnoDokidokiDaiboukenJapanRomDesc[] = {
	{ "Do-Re-Mi Fantasy - Milon no Dokidoki Daibouken (Japan).sfc",          2097152, 0x9f2c2633, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoReMiFantasyMilonnoDokidokiDaiboukenJapan)
STD_ROM_FN(rDoReMiFantasyMilonnoDokidokiDaiboukenJapan)

struct BurnDriver BurnDrvrDoReMiFantasyMilonnoDokidokiDaiboukenJapan = {
	"Do-Re-Mi Fantasy - Milon no Dokidoki Daibouken (Japan)", NULL, NULL, "1986",
	"Do-Re-Mi Fantasy - Milon no Dokidoki Daibouken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Do-Re-Mi Fantasy - Milon no Dokidoki Daibouken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoReMiFantasyMilonnoDokidokiDaiboukenJapanRomInfo, rDoReMiFantasyMilonnoDokidokiDaiboukenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDokapon321ArashioYobuYuujouJapanRomDesc[] = {
	{ "Dokapon 3-2-1 - Arashi o Yobu Yuujou (Japan).sfc",          1572864, 0xfc353400, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDokapon321ArashioYobuYuujouJapan)
STD_ROM_FN(rDokapon321ArashioYobuYuujouJapan)

struct BurnDriver BurnDrvrDokapon321ArashioYobuYuujouJapan = {
	"Dokapon 3-2-1 - Arashi o Yobu Yuujou (Japan)", NULL, NULL, "1986",
	"Dokapon 3-2-1 - Arashi o Yobu Yuujou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dokapon 3-2-1 - Arashi o Yobu Yuujou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDokapon321ArashioYobuYuujouJapanRomInfo, rDokapon321ArashioYobuYuujouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDokaponGaidenHonoonoAuditionJapanBSRomDesc[] = {
	{ "Dokapon Gaiden - Honoo no Audition (Japan) (BS).sfc",          1048576, 0x9457f9e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDokaponGaidenHonoonoAuditionJapanBS)
STD_ROM_FN(rDokaponGaidenHonoonoAuditionJapanBS)

struct BurnDriver BurnDrvrDokaponGaidenHonoonoAuditionJapanBS = {
	"Dokapon Gaiden - Honoo no Audition (Japan) (BS)", NULL, NULL, "1986",
	"Dokapon Gaiden - Honoo no Audition (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dokapon Gaiden - Honoo no Audition (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDokaponGaidenHonoonoAuditionJapanBSRomInfo, rDokaponGaidenHonoonoAuditionJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDokaponGaidenHonoonoAuditionJapanRomDesc[] = {
	{ "Dokapon Gaiden - Honoo no Audition (Japan).sfc",          1048576, 0xa1684b6c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDokaponGaidenHonoonoAuditionJapan)
STD_ROM_FN(rDokaponGaidenHonoonoAuditionJapan)

struct BurnDriver BurnDrvrDokaponGaidenHonoonoAuditionJapan = {
	"Dokapon Gaiden - Honoo no Audition (Japan)", NULL, NULL, "1986",
	"Dokapon Gaiden - Honoo no Audition (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dokapon Gaiden - Honoo no Audition (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDokaponGaidenHonoonoAuditionJapanRomInfo, rDokaponGaidenHonoonoAuditionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDokuritsuSensouLibertyorDeathJapanRomDesc[] = {
	{ "Dokuritsu Sensou - Liberty or Death (Japan).sfc",          1310720, 0x37ab70e5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDokuritsuSensouLibertyorDeathJapan)
STD_ROM_FN(rDokuritsuSensouLibertyorDeathJapan)

struct BurnDriver BurnDrvrDokuritsuSensouLibertyorDeathJapan = {
	"Dokuritsu Sensou - Liberty or Death (Japan)", NULL, NULL, "1986",
	"Dokuritsu Sensou - Liberty or Death (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dokuritsu Sensou - Liberty or Death (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDokuritsuSensouLibertyorDeathJapanRomInfo, rDokuritsuSensouLibertyorDeathJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoluckynoALeagueSoccerJapanRomDesc[] = {
	{ "Dolucky no A.League Soccer (Japan).sfc",          1572864, 0xbc19d72, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoluckynoALeagueSoccerJapan)
STD_ROM_FN(rDoluckynoALeagueSoccerJapan)

struct BurnDriver BurnDrvrDoluckynoALeagueSoccerJapan = {
	"Dolucky no A.League Soccer (Japan)", NULL, NULL, "1986",
	"Dolucky no A.League Soccer (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dolucky no A.League Soccer (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoluckynoALeagueSoccerJapanRomInfo, rDoluckynoALeagueSoccerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoluckynoKusayakiuJapanRomDesc[] = {
	{ "Dolucky no Kusayakiu (Japan).sfc",          2097152, 0xc2d2150c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoluckynoKusayakiuJapan)
STD_ROM_FN(rDoluckynoKusayakiuJapan)

struct BurnDriver BurnDrvrDoluckynoKusayakiuJapan = {
	"Dolucky no Kusayakiu (Japan)", NULL, NULL, "1986",
	"Dolucky no Kusayakiu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dolucky no Kusayakiu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoluckynoKusayakiuJapanRomInfo, rDoluckynoKusayakiuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoluckynoPuzzleTour94JapanRomDesc[] = {
	{ "Dolucky no Puzzle Tour '94 (Japan).sfc",          524288, 0xf716c24d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoluckynoPuzzleTour94Japan)
STD_ROM_FN(rDoluckynoPuzzleTour94Japan)

struct BurnDriver BurnDrvrDoluckynoPuzzleTour94Japan = {
	"Dolucky no Puzzle Tour '94 (Japan)", NULL, NULL, "1986",
	"Dolucky no Puzzle Tour '94 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dolucky no Puzzle Tour '94 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoluckynoPuzzleTour94JapanRomInfo, rDoluckynoPuzzleTour94JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonaldDucknoMahounoBoushiJapanRomDesc[] = {
	{ "Donald Duck no Mahou no Boushi (Japan).sfc",          1572864, 0x1ed5d2fa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonaldDucknoMahounoBoushiJapan)
STD_ROM_FN(rDonaldDucknoMahounoBoushiJapan)

struct BurnDriver BurnDrvrDonaldDucknoMahounoBoushiJapan = {
	"Donald Duck no Mahou no Boushi (Japan)", NULL, NULL, "1986",
	"Donald Duck no Mahou no Boushi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donald Duck no Mahou no Boushi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonaldDucknoMahounoBoushiJapanRomInfo, rDonaldDucknoMahounoBoushiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonaldDucknoMauiMallardJapanRomDesc[] = {
	{ "Donald Duck no Maui Mallard (Japan).sfc",          3145728, 0xd60a27a6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonaldDucknoMauiMallardJapan)
STD_ROM_FN(rDonaldDucknoMauiMallardJapan)

struct BurnDriver BurnDrvrDonaldDucknoMauiMallardJapan = {
	"Donald Duck no Maui Mallard (Japan)", NULL, NULL, "1986",
	"Donald Duck no Maui Mallard (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donald Duck no Maui Mallard (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonaldDucknoMauiMallardJapanRomInfo, rDonaldDucknoMauiMallardJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonaldinMauiMallardEuropeRomDesc[] = {
	{ "Donald in Maui Mallard (Europe).sfc",          3145728, 0xd56c21a1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonaldinMauiMallardEurope)
STD_ROM_FN(rDonaldinMauiMallardEurope)

struct BurnDriver BurnDrvrDonaldinMauiMallardEurope = {
	"Donald in Maui Mallard (Europe)", NULL, NULL, "1986",
	"Donald in Maui Mallard (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donald in Maui Mallard (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonaldinMauiMallardEuropeRomInfo, rDonaldinMauiMallardEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountryEuropeEnFrDeRev1RomDesc[] = {
	{ "Donkey Kong Country (Europe) (En,Fr,De) (Rev 1).sfc",          4194304, 0x17657db6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountryEuropeEnFrDeRev1)
STD_ROM_FN(rDonkeyKongCountryEuropeEnFrDeRev1)

struct BurnDriver BurnDrvrDonkeyKongCountryEuropeEnFrDeRev1 = {
	"Donkey Kong Country (Europe) (En,Fr,De) (Rev 1)", NULL, NULL, "1986",
	"Donkey Kong Country (Europe) (En,Fr,De) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country (Europe) (En,Fr,De) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountryEuropeEnFrDeRev1RomInfo, rDonkeyKongCountryEuropeEnFrDeRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountryEuropeEnFrDeRomDesc[] = {
	{ "Donkey Kong Country (Europe) (En,Fr,De).sfc",          4194304, 0x7a33e836, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountryEuropeEnFrDe)
STD_ROM_FN(rDonkeyKongCountryEuropeEnFrDe)

struct BurnDriver BurnDrvrDonkeyKongCountryEuropeEnFrDe = {
	"Donkey Kong Country (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Donkey Kong Country (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountryEuropeEnFrDeRomInfo, rDonkeyKongCountryEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountryUSACompetitionEditionRomDesc[] = {
	{ "Donkey Kong Country (USA) (Competition Edition).sfc",          4194304, 0xe204fbd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountryUSACompetitionEdition)
STD_ROM_FN(rDonkeyKongCountryUSACompetitionEdition)

struct BurnDriver BurnDrvrDonkeyKongCountryUSACompetitionEdition = {
	"Donkey Kong Country (USA) (Competition Edition)", NULL, NULL, "1986",
	"Donkey Kong Country (USA) (Competition Edition)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country (USA) (Competition Edition)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountryUSACompetitionEditionRomInfo, rDonkeyKongCountryUSACompetitionEditionRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountryUSARev1RomDesc[] = {
	{ "Donkey Kong Country (USA) (Rev 1).sfc",          4194304, 0x3eaa5697, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountryUSARev1)
STD_ROM_FN(rDonkeyKongCountryUSARev1)

struct BurnDriver BurnDrvrDonkeyKongCountryUSARev1 = {
	"Donkey Kong Country (USA) (Rev 1)", NULL, NULL, "1986",
	"Donkey Kong Country (USA) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country (USA) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountryUSARev1RomInfo, rDonkeyKongCountryUSARev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountryUSARev2RomDesc[] = {
	{ "Donkey Kong Country (USA) (Rev 2).sfc",          4194304, 0x762af827, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountryUSARev2)
STD_ROM_FN(rDonkeyKongCountryUSARev2)

struct BurnDriver BurnDrvrDonkeyKongCountryUSARev2 = {
	"Donkey Kong Country (USA) (Rev 2)", NULL, NULL, "1986",
	"Donkey Kong Country (USA) (Rev 2)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country (USA) (Rev 2)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountryUSARev2RomInfo, rDonkeyKongCountryUSARev2RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountryUSARomDesc[] = {
	{ "Donkey Kong Country (USA).sfc",          4194304, 0xc946dca0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountryUSA)
STD_ROM_FN(rDonkeyKongCountryUSA)

struct BurnDriver BurnDrvrDonkeyKongCountryUSA = {
	"Donkey Kong Country (USA)", NULL, NULL, "1986",
	"Donkey Kong Country (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountryUSARomInfo, rDonkeyKongCountryUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountry2DiddysKongQuestEuropeEnFrRev1RomDesc[] = {
	{ "Donkey Kong Country 2 - Diddy's Kong Quest (Europe) (En,Fr) (Rev 1).sfc",          4194304, 0x2ea6b7e8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountry2DiddysKongQuestEuropeEnFrRev1)
STD_ROM_FN(rDonkeyKongCountry2DiddysKongQuestEuropeEnFrRev1)

struct BurnDriver BurnDrvrDonkeyKongCountry2DiddysKongQuestEuropeEnFrRev1 = {
	"Donkey Kong Country 2 - Diddy's Kong Quest (Europe) (En,Fr) (Rev 1)", NULL, NULL, "1986",
	"Donkey Kong Country 2 - Diddy's Kong Quest (Europe) (En,Fr) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country 2 - Diddy's Kong Quest (Europe) (En,Fr) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountry2DiddysKongQuestEuropeEnFrRev1RomInfo, rDonkeyKongCountry2DiddysKongQuestEuropeEnFrRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountry2DiddysKongQuestGermanyEnDeRev1RomDesc[] = {
	{ "Donkey Kong Country 2 - Diddy's Kong Quest (Germany) (En,De) (Rev 1).sfc",          4194304, 0x2eb33785, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountry2DiddysKongQuestGermanyEnDeRev1)
STD_ROM_FN(rDonkeyKongCountry2DiddysKongQuestGermanyEnDeRev1)

struct BurnDriver BurnDrvrDonkeyKongCountry2DiddysKongQuestGermanyEnDeRev1 = {
	"Donkey Kong Country 2 - Diddy's Kong Quest (Germany) (En,De) (Rev 1)", NULL, NULL, "1986",
	"Donkey Kong Country 2 - Diddy's Kong Quest (Germany) (En,De) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country 2 - Diddy's Kong Quest (Germany) (En,De) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountry2DiddysKongQuestGermanyEnDeRev1RomInfo, rDonkeyKongCountry2DiddysKongQuestGermanyEnDeRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountry2DiddysKongQuestGermanyEnDeRomDesc[] = {
	{ "Donkey Kong Country 2 - Diddy's Kong Quest (Germany) (En,De).sfc",          4194304, 0x4c794a4d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountry2DiddysKongQuestGermanyEnDe)
STD_ROM_FN(rDonkeyKongCountry2DiddysKongQuestGermanyEnDe)

struct BurnDriver BurnDrvrDonkeyKongCountry2DiddysKongQuestGermanyEnDe = {
	"Donkey Kong Country 2 - Diddy's Kong Quest (Germany) (En,De)", NULL, NULL, "1986",
	"Donkey Kong Country 2 - Diddy's Kong Quest (Germany) (En,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country 2 - Diddy's Kong Quest (Germany) (En,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountry2DiddysKongQuestGermanyEnDeRomInfo, rDonkeyKongCountry2DiddysKongQuestGermanyEnDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountry2DiddysKongQuestUSAEnFrRev1RomDesc[] = {
	{ "Donkey Kong Country 2 - Diddy's Kong Quest (USA) (En,Fr) (Rev 1).sfc",          4194304, 0x4e2d90f4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountry2DiddysKongQuestUSAEnFrRev1)
STD_ROM_FN(rDonkeyKongCountry2DiddysKongQuestUSAEnFrRev1)

struct BurnDriver BurnDrvrDonkeyKongCountry2DiddysKongQuestUSAEnFrRev1 = {
	"Donkey Kong Country 2 - Diddy's Kong Quest (USA) (En,Fr) (Rev 1)", NULL, NULL, "1986",
	"Donkey Kong Country 2 - Diddy's Kong Quest (USA) (En,Fr) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country 2 - Diddy's Kong Quest (USA) (En,Fr) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountry2DiddysKongQuestUSAEnFrRev1RomInfo, rDonkeyKongCountry2DiddysKongQuestUSAEnFrRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountry2DiddysKongQuestUSAEnFrRomDesc[] = {
	{ "Donkey Kong Country 2 - Diddy's Kong Quest (USA) (En,Fr).sfc",          4194304, 0x6364db, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountry2DiddysKongQuestUSAEnFr)
STD_ROM_FN(rDonkeyKongCountry2DiddysKongQuestUSAEnFr)

struct BurnDriver BurnDrvrDonkeyKongCountry2DiddysKongQuestUSAEnFr = {
	"Donkey Kong Country 2 - Diddy's Kong Quest (USA) (En,Fr)", NULL, NULL, "1986",
	"Donkey Kong Country 2 - Diddy's Kong Quest (USA) (En,Fr)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country 2 - Diddy's Kong Quest (USA) (En,Fr)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountry2DiddysKongQuestUSAEnFrRomInfo, rDonkeyKongCountry2DiddysKongQuestUSAEnFrRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountry3DixieKongsDoubleTroubleEuropeEnFrDeRomDesc[] = {
	{ "Donkey Kong Country 3 - Dixie Kong's Double Trouble! (Europe) (En,Fr,De).sfc",          4194304, 0x551fe84, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountry3DixieKongsDoubleTroubleEuropeEnFrDe)
STD_ROM_FN(rDonkeyKongCountry3DixieKongsDoubleTroubleEuropeEnFrDe)

struct BurnDriver BurnDrvrDonkeyKongCountry3DixieKongsDoubleTroubleEuropeEnFrDe = {
	"Donkey Kong Country 3 - Dixie Kong's Double Trouble! (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Donkey Kong Country 3 - Dixie Kong's Double Trouble! (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country 3 - Dixie Kong's Double Trouble! (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountry3DixieKongsDoubleTroubleEuropeEnFrDeRomInfo, rDonkeyKongCountry3DixieKongsDoubleTroubleEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDonkeyKongCountry3DixieKongsDoubleTroubleUSAEnFrRomDesc[] = {
	{ "Donkey Kong Country 3 - Dixie Kong's Double Trouble! (USA) (En,Fr).sfc",          4194304, 0x448eec19, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDonkeyKongCountry3DixieKongsDoubleTroubleUSAEnFr)
STD_ROM_FN(rDonkeyKongCountry3DixieKongsDoubleTroubleUSAEnFr)

struct BurnDriver BurnDrvrDonkeyKongCountry3DixieKongsDoubleTroubleUSAEnFr = {
	"Donkey Kong Country 3 - Dixie Kong's Double Trouble! (USA) (En,Fr)", NULL, NULL, "1986",
	"Donkey Kong Country 3 - Dixie Kong's Double Trouble! (USA) (En,Fr)\0", NULL, "Nintendo", "Miscellaneous",
	L"Donkey Kong Country 3 - Dixie Kong's Double Trouble! (USA) (En,Fr)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDonkeyKongCountry3DixieKongsDoubleTroubleUSAEnFrRomInfo, rDonkeyKongCountry3DixieKongsDoubleTroubleUSAEnFrRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoomEuropeRomDesc[] = {
	{ "Doom (Europe).sfc",          2097152, 0x360243e4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoomEurope)
STD_ROM_FN(rDoomEurope)

struct BurnDriver BurnDrvrDoomEurope = {
	"Doom (Europe)", NULL, NULL, "1986",
	"Doom (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Doom (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoomEuropeRomInfo, rDoomEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoomJapanRomDesc[] = {
	{ "Doom (Japan).sfc",          2097152, 0xe5d722b2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoomJapan)
STD_ROM_FN(rDoomJapan)

struct BurnDriver BurnDrvrDoomJapan = {
	"Doom (Japan)", NULL, NULL, "1986",
	"Doom (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Doom (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoomJapanRomInfo, rDoomJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoomUSARomDesc[] = {
	{ "Doom (USA).sfc",          2097152, 0x9e85ea6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoomUSA)
STD_ROM_FN(rDoomUSA)

struct BurnDriver BurnDrvrDoomUSA = {
	"Doom (USA)", NULL, NULL, "1986",
	"Doom (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Doom (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoomUSARomInfo, rDoomUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoomTroopersUSARomDesc[] = {
	{ "Doom Troopers (USA).sfc",          2097152, 0x1889feef, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoomTroopersUSA)
STD_ROM_FN(rDoomTroopersUSA)

struct BurnDriver BurnDrvrDoomTroopersUSA = {
	"Doom Troopers (USA)", NULL, NULL, "1986",
	"Doom Troopers (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Doom Troopers (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoomTroopersUSARomInfo, rDoomTroopersUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoomsdayWarriorUSARomDesc[] = {
	{ "Doomsday Warrior (USA).sfc",          1048576, 0xceeb7c32, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoomsdayWarriorUSA)
STD_ROM_FN(rDoomsdayWarriorUSA)

struct BurnDriver BurnDrvrDoomsdayWarriorUSA = {
	"Doomsday Warrior (USA)", NULL, NULL, "1986",
	"Doomsday Warrior (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Doomsday Warrior (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoomsdayWarriorUSARomInfo, rDoomsdayWarriorUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoraemonNobitatoYouseinoKuniJapanRomDesc[] = {
	{ "Doraemon - Nobita to Yousei no Kuni (Japan).sfc",          524288, 0x51bc2909, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoraemonNobitatoYouseinoKuniJapan)
STD_ROM_FN(rDoraemonNobitatoYouseinoKuniJapan)

struct BurnDriver BurnDrvrDoraemonNobitatoYouseinoKuniJapan = {
	"Doraemon - Nobita to Yousei no Kuni (Japan)", NULL, NULL, "1986",
	"Doraemon - Nobita to Yousei no Kuni (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Doraemon - Nobita to Yousei no Kuni (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoraemonNobitatoYouseinoKuniJapanRomInfo, rDoraemonNobitatoYouseinoKuniJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoraemon2NobitanoToysLandDaiboukenJapanRomDesc[] = {
	{ "Doraemon 2 - Nobita no Toys Land Daibouken (Japan).sfc",          1048576, 0xd343b398, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoraemon2NobitanoToysLandDaiboukenJapan)
STD_ROM_FN(rDoraemon2NobitanoToysLandDaiboukenJapan)

struct BurnDriver BurnDrvrDoraemon2NobitanoToysLandDaiboukenJapan = {
	"Doraemon 2 - Nobita no Toys Land Daibouken (Japan)", NULL, NULL, "1986",
	"Doraemon 2 - Nobita no Toys Land Daibouken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Doraemon 2 - Nobita no Toys Land Daibouken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoraemon2NobitanoToysLandDaiboukenJapanRomInfo, rDoraemon2NobitanoToysLandDaiboukenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoraemon3NobitatoTokinoHougyokuJapanRomDesc[] = {
	{ "Doraemon 3 - Nobita to Toki no Hougyoku (Japan).sfc",          1572864, 0x560c5eab, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoraemon3NobitatoTokinoHougyokuJapan)
STD_ROM_FN(rDoraemon3NobitatoTokinoHougyokuJapan)

struct BurnDriver BurnDrvrDoraemon3NobitatoTokinoHougyokuJapan = {
	"Doraemon 3 - Nobita to Toki no Hougyoku (Japan)", NULL, NULL, "1986",
	"Doraemon 3 - Nobita to Toki no Hougyoku (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Doraemon 3 - Nobita to Toki no Hougyoku (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoraemon3NobitatoTokinoHougyokuJapanRomInfo, rDoraemon3NobitatoTokinoHougyokuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoraemon4NobitatoTsukinoOukokuJapanRomDesc[] = {
	{ "Doraemon 4 - Nobita to Tsuki no Oukoku (Japan).sfc",          1572864, 0x4097bc01, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoraemon4NobitatoTsukinoOukokuJapan)
STD_ROM_FN(rDoraemon4NobitatoTsukinoOukokuJapan)

struct BurnDriver BurnDrvrDoraemon4NobitatoTsukinoOukokuJapan = {
	"Doraemon 4 - Nobita to Tsuki no Oukoku (Japan)", NULL, NULL, "1986",
	"Doraemon 4 - Nobita to Tsuki no Oukoku (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Doraemon 4 - Nobita to Tsuki no Oukoku (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoraemon4NobitatoTsukinoOukokuJapanRomInfo, rDoraemon4NobitatoTsukinoOukokuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDossunGansekiBattleJapanRomDesc[] = {
	{ "Dossun! Ganseki Battle (Japan).sfc",          1048576, 0x1aa002d6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDossunGansekiBattleJapan)
STD_ROM_FN(rDossunGansekiBattleJapan)

struct BurnDriver BurnDrvrDossunGansekiBattleJapan = {
	"Dossun! Ganseki Battle (Japan)", NULL, NULL, "1986",
	"Dossun! Ganseki Battle (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dossun! Ganseki Battle (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDossunGansekiBattleJapanRomInfo, rDossunGansekiBattleJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoubleDragonVTheShadowFallsEuropeRomDesc[] = {
	{ "Double Dragon V - The Shadow Falls (Europe).sfc",          2097152, 0xe80f6b65, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoubleDragonVTheShadowFallsEurope)
STD_ROM_FN(rDoubleDragonVTheShadowFallsEurope)

struct BurnDriver BurnDrvrDoubleDragonVTheShadowFallsEurope = {
	"Double Dragon V - The Shadow Falls (Europe)", NULL, NULL, "1986",
	"Double Dragon V - The Shadow Falls (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Double Dragon V - The Shadow Falls (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoubleDragonVTheShadowFallsEuropeRomInfo, rDoubleDragonVTheShadowFallsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoubleDragonVTheShadowFallsUSARomDesc[] = {
	{ "Double Dragon V - The Shadow Falls (USA).sfc",          3145728, 0x98a96ae8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoubleDragonVTheShadowFallsUSA)
STD_ROM_FN(rDoubleDragonVTheShadowFallsUSA)

struct BurnDriver BurnDrvrDoubleDragonVTheShadowFallsUSA = {
	"Double Dragon V - The Shadow Falls (USA)", NULL, NULL, "1986",
	"Double Dragon V - The Shadow Falls (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Double Dragon V - The Shadow Falls (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoubleDragonVTheShadowFallsUSARomInfo, rDoubleDragonVTheShadowFallsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDoukyuusei2JapanNPRomDesc[] = {
	{ "Doukyuusei 2 (Japan) (NP).sfc",          4194304, 0xca1eb161, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDoukyuusei2JapanNP)
STD_ROM_FN(rDoukyuusei2JapanNP)

struct BurnDriver BurnDrvrDoukyuusei2JapanNP = {
	"Doukyuusei 2 (Japan) (NP)", NULL, NULL, "1986",
	"Doukyuusei 2 (Japan) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Doukyuusei 2 (Japan) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDoukyuusei2JapanNPRomInfo, rDoukyuusei2JapanNPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDowntheWorldMervilsAmbitionJapanRomDesc[] = {
	{ "Down the World - Mervil's Ambition (Japan).sfc",          2097152, 0xf1110fad, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDowntheWorldMervilsAmbitionJapan)
STD_ROM_FN(rDowntheWorldMervilsAmbitionJapan)

struct BurnDriver BurnDrvrDowntheWorldMervilsAmbitionJapan = {
	"Down the World - Mervil's Ambition (Japan)", NULL, NULL, "1986",
	"Down the World - Mervil's Ambition (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Down the World - Mervil's Ambition (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDowntheWorldMervilsAmbitionJapanRomInfo, rDowntheWorldMervilsAmbitionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDowntownNekketsuBaseballMonogatariYakyuudeShoubudaKuniokunJapanRomDesc[] = {
	{ "Downtown Nekketsu Baseball Monogatari - Yakyuu de Shoubu da! Kunio-kun (Japan).sfc",          1572864, 0xe71b7c31, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDowntownNekketsuBaseballMonogatariYakyuudeShoubudaKuniokunJapan)
STD_ROM_FN(rDowntownNekketsuBaseballMonogatariYakyuudeShoubudaKuniokunJapan)

struct BurnDriver BurnDrvrDowntownNekketsuBaseballMonogatariYakyuudeShoubudaKuniokunJapan = {
	"Downtown Nekketsu Baseball Monogatari - Yakyuu de Shoubu da! Kunio-kun (Japan)", NULL, NULL, "1986",
	"Downtown Nekketsu Baseball Monogatari - Yakyuu de Shoubu da! Kunio-kun (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Downtown Nekketsu Baseball Monogatari - Yakyuu de Shoubu da! Kunio-kun (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDowntownNekketsuBaseballMonogatariYakyuudeShoubudaKuniokunJapanRomInfo, rDowntownNekketsuBaseballMonogatariYakyuudeShoubudaKuniokunJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDrMarioJapanBSRomDesc[] = {
	{ "Dr. Mario (Japan) (BS).sfc",          1048576, 0x6ea452a4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDrMarioJapanBS)
STD_ROM_FN(rDrMarioJapanBS)

struct BurnDriver BurnDrvrDrMarioJapanBS = {
	"Dr. Mario (Japan) (BS)", NULL, NULL, "1986",
	"Dr. Mario (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dr. Mario (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDrMarioJapanBSRomInfo, rDrMarioJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDrMarioJapanNPRomDesc[] = {
	{ "Dr. Mario (Japan) (NP).sfc",          524288, 0x63ce5132, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDrMarioJapanNP)
STD_ROM_FN(rDrMarioJapanNP)

struct BurnDriver BurnDrvrDrMarioJapanNP = {
	"Dr. Mario (Japan) (NP)", NULL, NULL, "1986",
	"Dr. Mario (Japan) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dr. Mario (Japan) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDrMarioJapanNPRomInfo, rDrMarioJapanNPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonTheBruceLeeStoryEuropeRomDesc[] = {
	{ "Dragon - The Bruce Lee Story (Europe).sfc",          2097152, 0x38212ea, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonTheBruceLeeStoryEurope)
STD_ROM_FN(rDragonTheBruceLeeStoryEurope)

struct BurnDriver BurnDrvrDragonTheBruceLeeStoryEurope = {
	"Dragon - The Bruce Lee Story (Europe)", NULL, NULL, "1986",
	"Dragon - The Bruce Lee Story (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon - The Bruce Lee Story (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonTheBruceLeeStoryEuropeRomInfo, rDragonTheBruceLeeStoryEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonTheBruceLeeStoryUSARomDesc[] = {
	{ "Dragon - The Bruce Lee Story (USA).sfc",          2097152, 0x407c5c24, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonTheBruceLeeStoryUSA)
STD_ROM_FN(rDragonTheBruceLeeStoryUSA)

struct BurnDriver BurnDrvrDragonTheBruceLeeStoryUSA = {
	"Dragon - The Bruce Lee Story (USA)", NULL, NULL, "1986",
	"Dragon - The Bruce Lee Story (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon - The Bruce Lee Story (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonTheBruceLeeStoryUSARomInfo, rDragonTheBruceLeeStoryUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZChomutujeonKoreaRomDesc[] = {
	{ "Dragon Ball Z - Chomutujeon (Korea).sfc",          2097152, 0x2bf7cd65, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZChomutujeonKorea)
STD_ROM_FN(rDragonBallZChomutujeonKorea)

struct BurnDriver BurnDrvrDragonBallZChomutujeonKorea = {
	"Dragon Ball Z - Chomutujeon (Korea)", NULL, NULL, "1986",
	"Dragon Ball Z - Chomutujeon (Korea)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Chomutujeon (Korea)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZChomutujeonKoreaRomInfo, rDragonBallZChomutujeonKoreaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZHyperDimensionFranceRomDesc[] = {
	{ "Dragon Ball Z - Hyper Dimension (France).sfc",          3145728, 0xa6dc166b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZHyperDimensionFrance)
STD_ROM_FN(rDragonBallZHyperDimensionFrance)

struct BurnDriver BurnDrvrDragonBallZHyperDimensionFrance = {
	"Dragon Ball Z - Hyper Dimension (France)", NULL, NULL, "1986",
	"Dragon Ball Z - Hyper Dimension (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Hyper Dimension (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZHyperDimensionFranceRomInfo, rDragonBallZHyperDimensionFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZHyperDimensionJapanRomDesc[] = {
	{ "Dragon Ball Z - Hyper Dimension (Japan).sfc",          3145728, 0xf4ab1557, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZHyperDimensionJapan)
STD_ROM_FN(rDragonBallZHyperDimensionJapan)

struct BurnDriver BurnDrvrDragonBallZHyperDimensionJapan = {
	"Dragon Ball Z - Hyper Dimension (Japan)", NULL, NULL, "1986",
	"Dragon Ball Z - Hyper Dimension (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Hyper Dimension (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZHyperDimensionJapanRomInfo, rDragonBallZHyperDimensionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZLaLegendeSaienFranceRomDesc[] = {
	{ "Dragon Ball Z - La Legende Saien (France).sfc",          2097152, 0x8f24f886, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZLaLegendeSaienFrance)
STD_ROM_FN(rDragonBallZLaLegendeSaienFrance)

struct BurnDriver BurnDrvrDragonBallZLaLegendeSaienFrance = {
	"Dragon Ball Z - La Legende Saien (France)", NULL, NULL, "1986",
	"Dragon Ball Z - La Legende Saien (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - La Legende Saien (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZLaLegendeSaienFranceRomInfo, rDragonBallZLaLegendeSaienFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZSuperButoudenFranceRomDesc[] = {
	{ "Dragon Ball Z - Super Butouden (France).sfc",          2097152, 0xea7abad1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZSuperButoudenFrance)
STD_ROM_FN(rDragonBallZSuperButoudenFrance)

struct BurnDriver BurnDrvrDragonBallZSuperButoudenFrance = {
	"Dragon Ball Z - Super Butouden (France)", NULL, NULL, "1986",
	"Dragon Ball Z - Super Butouden (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Super Butouden (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZSuperButoudenFranceRomInfo, rDragonBallZSuperButoudenFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZSuperButoudenJapanSampleRomDesc[] = {
	{ "Dragon Ball Z - Super Butouden (Japan) (Sample).sfc",          1048576, 0xd6e464b7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZSuperButoudenJapanSample)
STD_ROM_FN(rDragonBallZSuperButoudenJapanSample)

struct BurnDriver BurnDrvrDragonBallZSuperButoudenJapanSample = {
	"Dragon Ball Z - Super Butouden (Japan) (Sample)", NULL, NULL, "1986",
	"Dragon Ball Z - Super Butouden (Japan) (Sample)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Super Butouden (Japan) (Sample)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZSuperButoudenJapanSampleRomInfo, rDragonBallZSuperButoudenJapanSampleRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZSuperButoudenJapanRomDesc[] = {
	{ "Dragon Ball Z - Super Butouden (Japan).sfc",          2097152, 0x8c7780bd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZSuperButoudenJapan)
STD_ROM_FN(rDragonBallZSuperButoudenJapan)

struct BurnDriver BurnDrvrDragonBallZSuperButoudenJapan = {
	"Dragon Ball Z - Super Butouden (Japan)", NULL, NULL, "1986",
	"Dragon Ball Z - Super Butouden (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Super Butouden (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZSuperButoudenJapanRomInfo, rDragonBallZSuperButoudenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZSuperButouden2JapanRev1RomDesc[] = {
	{ "Dragon Ball Z - Super Butouden 2 (Japan) (Rev 1).sfc",          2097152, 0x81fde86, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZSuperButouden2JapanRev1)
STD_ROM_FN(rDragonBallZSuperButouden2JapanRev1)

struct BurnDriver BurnDrvrDragonBallZSuperButouden2JapanRev1 = {
	"Dragon Ball Z - Super Butouden 2 (Japan) (Rev 1)", NULL, NULL, "1986",
	"Dragon Ball Z - Super Butouden 2 (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Super Butouden 2 (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZSuperButouden2JapanRev1RomInfo, rDragonBallZSuperButouden2JapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZSuperButouden2JapanRomDesc[] = {
	{ "Dragon Ball Z - Super Butouden 2 (Japan).sfc",          2097152, 0xa5e37609, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZSuperButouden2Japan)
STD_ROM_FN(rDragonBallZSuperButouden2Japan)

struct BurnDriver BurnDrvrDragonBallZSuperButouden2Japan = {
	"Dragon Ball Z - Super Butouden 2 (Japan)", NULL, NULL, "1986",
	"Dragon Ball Z - Super Butouden 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Super Butouden 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZSuperButouden2JapanRomInfo, rDragonBallZSuperButouden2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZSuperButouden3JapanRomDesc[] = {
	{ "Dragon Ball Z - Super Butouden 3 (Japan).sfc",          2097152, 0xcbfde2d0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZSuperButouden3Japan)
STD_ROM_FN(rDragonBallZSuperButouden3Japan)

struct BurnDriver BurnDrvrDragonBallZSuperButouden3Japan = {
	"Dragon Ball Z - Super Butouden 3 (Japan)", NULL, NULL, "1986",
	"Dragon Ball Z - Super Butouden 3 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Super Butouden 3 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZSuperButouden3JapanRomInfo, rDragonBallZSuperButouden3JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZSuperGokuuDenKakuseiHenJapanRomDesc[] = {
	{ "Dragon Ball Z - Super Gokuu Den - Kakusei Hen (Japan).sfc",          2097152, 0x3172cd4f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZSuperGokuuDenKakuseiHenJapan)
STD_ROM_FN(rDragonBallZSuperGokuuDenKakuseiHenJapan)

struct BurnDriver BurnDrvrDragonBallZSuperGokuuDenKakuseiHenJapan = {
	"Dragon Ball Z - Super Gokuu Den - Kakusei Hen (Japan)", NULL, NULL, "1986",
	"Dragon Ball Z - Super Gokuu Den - Kakusei Hen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Super Gokuu Den - Kakusei Hen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZSuperGokuuDenKakuseiHenJapanRomInfo, rDragonBallZSuperGokuuDenKakuseiHenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZSuperGokuuDenTotsugekiHenJapanRomDesc[] = {
	{ "Dragon Ball Z - Super Gokuu Den - Totsugeki Hen (Japan).sfc",          2097152, 0xd531289b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZSuperGokuuDenTotsugekiHenJapan)
STD_ROM_FN(rDragonBallZSuperGokuuDenTotsugekiHenJapan)

struct BurnDriver BurnDrvrDragonBallZSuperGokuuDenTotsugekiHenJapan = {
	"Dragon Ball Z - Super Gokuu Den - Totsugeki Hen (Japan)", NULL, NULL, "1986",
	"Dragon Ball Z - Super Gokuu Den - Totsugeki Hen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Super Gokuu Den - Totsugeki Hen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZSuperGokuuDenTotsugekiHenJapanRomInfo, rDragonBallZSuperGokuuDenTotsugekiHenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZSuperSaiyaDensetsuJapanRev1RomDesc[] = {
	{ "Dragon Ball Z - Super Saiya Densetsu (Japan) (Rev 1).sfc",          1048576, 0xade7b968, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZSuperSaiyaDensetsuJapanRev1)
STD_ROM_FN(rDragonBallZSuperSaiyaDensetsuJapanRev1)

struct BurnDriver BurnDrvrDragonBallZSuperSaiyaDensetsuJapanRev1 = {
	"Dragon Ball Z - Super Saiya Densetsu (Japan) (Rev 1)", NULL, NULL, "1986",
	"Dragon Ball Z - Super Saiya Densetsu (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Super Saiya Densetsu (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZSuperSaiyaDensetsuJapanRev1RomInfo, rDragonBallZSuperSaiyaDensetsuJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZSuperSaiyaDensetsuJapanRomDesc[] = {
	{ "Dragon Ball Z - Super Saiya Densetsu (Japan).sfc",          1048576, 0x32b17409, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZSuperSaiyaDensetsuJapan)
STD_ROM_FN(rDragonBallZSuperSaiyaDensetsuJapan)

struct BurnDriver BurnDrvrDragonBallZSuperSaiyaDensetsuJapan = {
	"Dragon Ball Z - Super Saiya Densetsu (Japan)", NULL, NULL, "1986",
	"Dragon Ball Z - Super Saiya Densetsu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Super Saiya Densetsu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZSuperSaiyaDensetsuJapanRomInfo, rDragonBallZSuperSaiyaDensetsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonBallZUltimeMenaceFranceRomDesc[] = {
	{ "Dragon Ball Z - Ultime Menace (France).sfc",          2097152, 0x593eefe0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonBallZUltimeMenaceFrance)
STD_ROM_FN(rDragonBallZUltimeMenaceFrance)

struct BurnDriver BurnDrvrDragonBallZUltimeMenaceFrance = {
	"Dragon Ball Z - Ultime Menace (France)", NULL, NULL, "1986",
	"Dragon Ball Z - Ultime Menace (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Ball Z - Ultime Menace (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonBallZUltimeMenaceFranceRomInfo, rDragonBallZUltimeMenaceFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonKnight4JapanRomDesc[] = {
	{ "Dragon Knight 4 (Japan).sfc",          3145728, 0x52fc7228, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonKnight4Japan)
STD_ROM_FN(rDragonKnight4Japan)

struct BurnDriver BurnDrvrDragonKnight4Japan = {
	"Dragon Knight 4 (Japan)", NULL, NULL, "1986",
	"Dragon Knight 4 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Knight 4 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonKnight4JapanRomInfo, rDragonKnight4JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonQuestIIIJapanRomDesc[] = {
	{ "Dragon Quest I & II (Japan).sfc",          1572864, 0x98bb6853, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonQuestIIIJapan)
STD_ROM_FN(rDragonQuestIIIJapan)

struct BurnDriver BurnDrvrDragonQuestIIIJapan = {
	"Dragon Quest I & II (Japan)", NULL, NULL, "1986",
	"Dragon Quest I & II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Quest I & II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonQuestIIIJapanRomInfo, rDragonQuestIIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonQuestIIISoshiteDensetsueJapanRomDesc[] = {
	{ "Dragon Quest III - Soshite Densetsu e... (Japan).sfc",          4194304, 0x13836bd2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonQuestIIISoshiteDensetsueJapan)
STD_ROM_FN(rDragonQuestIIISoshiteDensetsueJapan)

struct BurnDriver BurnDrvrDragonQuestIIISoshiteDensetsueJapan = {
	"Dragon Quest III - Soshite Densetsu e... (Japan)", NULL, NULL, "1986",
	"Dragon Quest III - Soshite Densetsu e... (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Quest III - Soshite Densetsu e... (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonQuestIIISoshiteDensetsueJapanRomInfo, rDragonQuestIIISoshiteDensetsueJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonQuestVTenkuunoHanayomeJapanRomDesc[] = {
	{ "Dragon Quest V - Tenkuu no Hanayome (Japan).sfc",          1572864, 0xbc955f3b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonQuestVTenkuunoHanayomeJapan)
STD_ROM_FN(rDragonQuestVTenkuunoHanayomeJapan)

struct BurnDriver BurnDrvrDragonQuestVTenkuunoHanayomeJapan = {
	"Dragon Quest V - Tenkuu no Hanayome (Japan)", NULL, NULL, "1986",
	"Dragon Quest V - Tenkuu no Hanayome (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Quest V - Tenkuu no Hanayome (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonQuestVTenkuunoHanayomeJapanRomInfo, rDragonQuestVTenkuunoHanayomeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonQuestVIMaboroshinoDaichiJapanRomDesc[] = {
	{ "Dragon Quest VI - Maboroshi no Daichi (Japan).sfc",          4194304, 0x33304519, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonQuestVIMaboroshinoDaichiJapan)
STD_ROM_FN(rDragonQuestVIMaboroshinoDaichiJapan)

struct BurnDriver BurnDrvrDragonQuestVIMaboroshinoDaichiJapan = {
	"Dragon Quest VI - Maboroshi no Daichi (Japan)", NULL, NULL, "1986",
	"Dragon Quest VI - Maboroshi no Daichi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Quest VI - Maboroshi no Daichi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonQuestVIMaboroshinoDaichiJapanRomInfo, rDragonQuestVIMaboroshinoDaichiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonSlayerEiyuuDensetsuJapanBSRomDesc[] = {
	{ "Dragon Slayer - Eiyuu Densetsu (Japan) (BS).sfc",          1048576, 0xa6fc28cb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonSlayerEiyuuDensetsuJapanBS)
STD_ROM_FN(rDragonSlayerEiyuuDensetsuJapanBS)

struct BurnDriver BurnDrvrDragonSlayerEiyuuDensetsuJapanBS = {
	"Dragon Slayer - Eiyuu Densetsu (Japan) (BS)", NULL, NULL, "1986",
	"Dragon Slayer - Eiyuu Densetsu (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Slayer - Eiyuu Densetsu (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonSlayerEiyuuDensetsuJapanBSRomInfo, rDragonSlayerEiyuuDensetsuJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonSlayerEiyuuDensetsuJapanRev1NPRomDesc[] = {
	{ "Dragon Slayer - Eiyuu Densetsu (Japan) (Rev 1) (NP).sfc",          1048576, 0x9b306e64, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonSlayerEiyuuDensetsuJapanRev1NP)
STD_ROM_FN(rDragonSlayerEiyuuDensetsuJapanRev1NP)

struct BurnDriver BurnDrvrDragonSlayerEiyuuDensetsuJapanRev1NP = {
	"Dragon Slayer - Eiyuu Densetsu (Japan) (Rev 1) (NP)", NULL, NULL, "1986",
	"Dragon Slayer - Eiyuu Densetsu (Japan) (Rev 1) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Slayer - Eiyuu Densetsu (Japan) (Rev 1) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonSlayerEiyuuDensetsuJapanRev1NPRomInfo, rDragonSlayerEiyuuDensetsuJapanRev1NPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonSlayerEiyuuDensetsuJapanRomDesc[] = {
	{ "Dragon Slayer - Eiyuu Densetsu (Japan).sfc",          1048576, 0x70bba233, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonSlayerEiyuuDensetsuJapan)
STD_ROM_FN(rDragonSlayerEiyuuDensetsuJapan)

struct BurnDriver BurnDrvrDragonSlayerEiyuuDensetsuJapan = {
	"Dragon Slayer - Eiyuu Densetsu (Japan)", NULL, NULL, "1986",
	"Dragon Slayer - Eiyuu Densetsu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Slayer - Eiyuu Densetsu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonSlayerEiyuuDensetsuJapanRomInfo, rDragonSlayerEiyuuDensetsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonSlayerEiyuuDensetsuIIJapanRomDesc[] = {
	{ "Dragon Slayer - Eiyuu Densetsu II (Japan).sfc",          1572864, 0xf409c139, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonSlayerEiyuuDensetsuIIJapan)
STD_ROM_FN(rDragonSlayerEiyuuDensetsuIIJapan)

struct BurnDriver BurnDrvrDragonSlayerEiyuuDensetsuIIJapan = {
	"Dragon Slayer - Eiyuu Densetsu II (Japan)", NULL, NULL, "1986",
	"Dragon Slayer - Eiyuu Densetsu II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon Slayer - Eiyuu Densetsu II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonSlayerEiyuuDensetsuIIJapanRomInfo, rDragonSlayerEiyuuDensetsuIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonViewUSARomDesc[] = {
	{ "Dragon View (USA).sfc",          2097152, 0xab893412, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonViewUSA)
STD_ROM_FN(rDragonViewUSA)

struct BurnDriver BurnDrvrDragonViewUSA = {
	"Dragon View (USA)", NULL, NULL, "1986",
	"Dragon View (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon View (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonViewUSARomInfo, rDragonViewUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonsEarthJapanRomDesc[] = {
	{ "Dragon's Earth (Japan).sfc",          1048576, 0x81bf8718, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonsEarthJapan)
STD_ROM_FN(rDragonsEarthJapan)

struct BurnDriver BurnDrvrDragonsEarthJapan = {
	"Dragon's Earth (Japan)", NULL, NULL, "1986",
	"Dragon's Earth (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon's Earth (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonsEarthJapanRomInfo, rDragonsEarthJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonsLairEuropeBetaRomDesc[] = {
	{ "Dragon's Lair (Europe) (Beta).sfc",          524288, 0x4aef99f3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonsLairEuropeBeta)
STD_ROM_FN(rDragonsLairEuropeBeta)

struct BurnDriver BurnDrvrDragonsLairEuropeBeta = {
	"Dragon's Lair (Europe) (Beta)", NULL, NULL, "1986",
	"Dragon's Lair (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon's Lair (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonsLairEuropeBetaRomInfo, rDragonsLairEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonsLairEuropeEnFrDeEsItNlSvRomDesc[] = {
	{ "Dragon's Lair (Europe) (En,Fr,De,Es,It,Nl,Sv).sfc",          524288, 0x304fdb92, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonsLairEuropeEnFrDeEsItNlSv)
STD_ROM_FN(rDragonsLairEuropeEnFrDeEsItNlSv)

struct BurnDriver BurnDrvrDragonsLairEuropeEnFrDeEsItNlSv = {
	"Dragon's Lair (Europe) (En,Fr,De,Es,It,Nl,Sv)", NULL, NULL, "1986",
	"Dragon's Lair (Europe) (En,Fr,De,Es,It,Nl,Sv)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon's Lair (Europe) (En,Fr,De,Es,It,Nl,Sv)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonsLairEuropeEnFrDeEsItNlSvRomInfo, rDragonsLairEuropeEnFrDeEsItNlSvRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonsLairUSARomDesc[] = {
	{ "Dragon's Lair (USA).sfc",          524288, 0x24ffe7fd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonsLairUSA)
STD_ROM_FN(rDragonsLairUSA)

struct BurnDriver BurnDrvrDragonsLairUSA = {
	"Dragon's Lair (USA)", NULL, NULL, "1986",
	"Dragon's Lair (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon's Lair (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonsLairUSARomInfo, rDragonsLairUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDragonsMagicJapanRomDesc[] = {
	{ "Dragon's Magic (Japan).sfc",          524288, 0xcf53835, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDragonsMagicJapan)
STD_ROM_FN(rDragonsMagicJapan)

struct BurnDriver BurnDrvrDragonsMagicJapan = {
	"Dragon's Magic (Japan)", NULL, NULL, "1986",
	"Dragon's Magic (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dragon's Magic (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDragonsMagicJapanRomInfo, rDragonsMagicJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDrakkhenEuropeRomDesc[] = {
	{ "Drakkhen (Europe).sfc",          1048576, 0xc6cd0bed, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDrakkhenEurope)
STD_ROM_FN(rDrakkhenEurope)

struct BurnDriver BurnDrvrDrakkhenEurope = {
	"Drakkhen (Europe)", NULL, NULL, "1986",
	"Drakkhen (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Drakkhen (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDrakkhenEuropeRomInfo, rDrakkhenEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDrakkhenGermanyRomDesc[] = {
	{ "Drakkhen (Germany).sfc",          1048576, 0x9d291732, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDrakkhenGermany)
STD_ROM_FN(rDrakkhenGermany)

struct BurnDriver BurnDrvrDrakkhenGermany = {
	"Drakkhen (Germany)", NULL, NULL, "1986",
	"Drakkhen (Germany)\0", NULL, "Nintendo", "Miscellaneous",
	L"Drakkhen (Germany)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDrakkhenGermanyRomInfo, rDrakkhenGermanyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDrakkhenJapanRomDesc[] = {
	{ "Drakkhen (Japan).sfc",          1048576, 0xb0a016a2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDrakkhenJapan)
STD_ROM_FN(rDrakkhenJapan)

struct BurnDriver BurnDrvrDrakkhenJapan = {
	"Drakkhen (Japan)", NULL, NULL, "1986",
	"Drakkhen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Drakkhen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDrakkhenJapanRomInfo, rDrakkhenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDrakkhenUSARomDesc[] = {
	{ "Drakkhen (USA).sfc",          1048576, 0x7dae5c2a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDrakkhenUSA)
STD_ROM_FN(rDrakkhenUSA)

struct BurnDriver BurnDrvrDrakkhenUSA = {
	"Drakkhen (USA)", NULL, NULL, "1986",
	"Drakkhen (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Drakkhen (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDrakkhenUSARomInfo, rDrakkhenUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDreamBasketballDunkHoopJapanRomDesc[] = {
	{ "Dream Basketball - Dunk & Hoop (Japan).sfc",          1572864, 0xcc24110a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDreamBasketballDunkHoopJapan)
STD_ROM_FN(rDreamBasketballDunkHoopJapan)

struct BurnDriver BurnDrvrDreamBasketballDunkHoopJapan = {
	"Dream Basketball - Dunk & Hoop (Japan)", NULL, NULL, "1986",
	"Dream Basketball - Dunk & Hoop (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dream Basketball - Dunk & Hoop (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDreamBasketballDunkHoopJapanRomInfo, rDreamBasketballDunkHoopJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDreamMazeKigurumiDaiboukenJapanRomDesc[] = {
	{ "Dream Maze - Kigurumi Daibouken (Japan).sfc",          1048576, 0x4b17a200, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDreamMazeKigurumiDaiboukenJapan)
STD_ROM_FN(rDreamMazeKigurumiDaiboukenJapan)

struct BurnDriver BurnDrvrDreamMazeKigurumiDaiboukenJapan = {
	"Dream Maze - Kigurumi Daibouken (Japan)", NULL, NULL, "1986",
	"Dream Maze - Kigurumi Daibouken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dream Maze - Kigurumi Daibouken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDreamMazeKigurumiDaiboukenJapanRomInfo, rDreamMazeKigurumiDaiboukenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDreamTVUSABetaAlt1RomDesc[] = {
	{ "Dream TV (USA) (Beta) (Alt 1).sfc",          524288, 0x78aea085, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDreamTVUSABetaAlt1)
STD_ROM_FN(rDreamTVUSABetaAlt1)

struct BurnDriver BurnDrvrDreamTVUSABetaAlt1 = {
	"Dream TV (USA) (Beta) (Alt 1)", NULL, NULL, "1986",
	"Dream TV (USA) (Beta) (Alt 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dream TV (USA) (Beta) (Alt 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDreamTVUSABetaAlt1RomInfo, rDreamTVUSABetaAlt1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDreamTVUSABetaRomDesc[] = {
	{ "Dream TV (USA) (Beta).sfc",          524288, 0xc62f138e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDreamTVUSABeta)
STD_ROM_FN(rDreamTVUSABeta)

struct BurnDriver BurnDrvrDreamTVUSABeta = {
	"Dream TV (USA) (Beta)", NULL, NULL, "1986",
	"Dream TV (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dream TV (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDreamTVUSABetaRomInfo, rDreamTVUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDreamTVUSARomDesc[] = {
	{ "Dream TV (USA).sfc",          524288, 0xab5a9e40, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDreamTVUSA)
STD_ROM_FN(rDreamTVUSA)

struct BurnDriver BurnDrvrDreamTVUSA = {
	"Dream TV (USA)", NULL, NULL, "1986",
	"Dream TV (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dream TV (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDreamTVUSARomInfo, rDreamTVUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDriftKingShutokouBattle94TsuchiyaKeiichiBandouMasaakiJapanRomDesc[] = {
	{ "Drift King Shutokou Battle '94 - Tsuchiya Keiichi & Bandou Masaaki (Japan).sfc",          1572864, 0x33ce298f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDriftKingShutokouBattle94TsuchiyaKeiichiBandouMasaakiJapan)
STD_ROM_FN(rDriftKingShutokouBattle94TsuchiyaKeiichiBandouMasaakiJapan)

struct BurnDriver BurnDrvrDriftKingShutokouBattle94TsuchiyaKeiichiBandouMasaakiJapan = {
	"Drift King Shutokou Battle '94 - Tsuchiya Keiichi & Bandou Masaaki (Japan)", NULL, NULL, "1986",
	"Drift King Shutokou Battle '94 - Tsuchiya Keiichi & Bandou Masaaki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Drift King Shutokou Battle '94 - Tsuchiya Keiichi & Bandou Masaaki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDriftKingShutokouBattle94TsuchiyaKeiichiBandouMasaakiJapanRomInfo, rDriftKingShutokouBattle94TsuchiyaKeiichiBandouMasaakiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDriftKingShutokouBattle2TsuchiyaKeiichiBandouMasaakiJapanRomDesc[] = {
	{ "Drift King Shutokou Battle 2 - Tsuchiya Keiichi & Bandou Masaaki (Japan).sfc",          1572864, 0x87aab79a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDriftKingShutokouBattle2TsuchiyaKeiichiBandouMasaakiJapan)
STD_ROM_FN(rDriftKingShutokouBattle2TsuchiyaKeiichiBandouMasaakiJapan)

struct BurnDriver BurnDrvrDriftKingShutokouBattle2TsuchiyaKeiichiBandouMasaakiJapan = {
	"Drift King Shutokou Battle 2 - Tsuchiya Keiichi & Bandou Masaaki (Japan)", NULL, NULL, "1986",
	"Drift King Shutokou Battle 2 - Tsuchiya Keiichi & Bandou Masaaki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Drift King Shutokou Battle 2 - Tsuchiya Keiichi & Bandou Masaaki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDriftKingShutokouBattle2TsuchiyaKeiichiBandouMasaakiJapanRomInfo, rDriftKingShutokouBattle2TsuchiyaKeiichiBandouMasaakiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDualOrbSeireiTamaDensetsuJapanRomDesc[] = {
	{ "Dual Orb - Seirei Tama Densetsu (Japan).sfc",          1572864, 0x9d7bd920, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDualOrbSeireiTamaDensetsuJapan)
STD_ROM_FN(rDualOrbSeireiTamaDensetsuJapan)

struct BurnDriver BurnDrvrDualOrbSeireiTamaDensetsuJapan = {
	"Dual Orb - Seirei Tama Densetsu (Japan)", NULL, NULL, "1986",
	"Dual Orb - Seirei Tama Densetsu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dual Orb - Seirei Tama Densetsu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDualOrbSeireiTamaDensetsuJapanRomInfo, rDualOrbSeireiTamaDensetsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDualOrbIIJapanRomDesc[] = {
	{ "Dual Orb II (Japan).sfc",          2621440, 0xe8798f65, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDualOrbIIJapan)
STD_ROM_FN(rDualOrbIIJapan)

struct BurnDriver BurnDrvrDualOrbIIJapan = {
	"Dual Orb II (Japan)", NULL, NULL, "1986",
	"Dual Orb II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dual Orb II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDualOrbIIJapanRomInfo, rDualOrbIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDuelTheTestDriveIIEuropeRomDesc[] = {
	{ "Duel, The - Test Drive II (Europe).sfc",          1048576, 0x57cbd9af, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDuelTheTestDriveIIEurope)
STD_ROM_FN(rDuelTheTestDriveIIEurope)

struct BurnDriver BurnDrvrDuelTheTestDriveIIEurope = {
	"Duel, The - Test Drive II (Europe)", NULL, NULL, "1986",
	"Duel, The - Test Drive II (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Duel, The - Test Drive II (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDuelTheTestDriveIIEuropeRomInfo, rDuelTheTestDriveIIEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDuelTheTestDriveIIUSARomDesc[] = {
	{ "Duel, The - Test Drive II (USA).sfc",          1048576, 0xba093e24, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDuelTheTestDriveIIUSA)
STD_ROM_FN(rDuelTheTestDriveIIUSA)

struct BurnDriver BurnDrvrDuelTheTestDriveIIUSA = {
	"Duel, The - Test Drive II (USA)", NULL, NULL, "1986",
	"Duel, The - Test Drive II (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Duel, The - Test Drive II (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDuelTheTestDriveIIUSARomInfo, rDuelTheTestDriveIIUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDunQuestMajinFuuinnoDensetsuJapanRomDesc[] = {
	{ "Dun Quest - Majin Fuuin no Densetsu (Japan).sfc",          2097152, 0xb708add4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDunQuestMajinFuuinnoDensetsuJapan)
STD_ROM_FN(rDunQuestMajinFuuinnoDensetsuJapan)

struct BurnDriver BurnDrvrDunQuestMajinFuuinnoDensetsuJapan = {
	"Dun Quest - Majin Fuuin no Densetsu (Japan)", NULL, NULL, "1986",
	"Dun Quest - Majin Fuuin no Densetsu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dun Quest - Majin Fuuin no Densetsu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDunQuestMajinFuuinnoDensetsuJapanRomInfo, rDunQuestMajinFuuinnoDensetsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDungeonMasterEuropeRomDesc[] = {
	{ "Dungeon Master (Europe).sfc",          1048576, 0x89a67adf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDungeonMasterEurope)
STD_ROM_FN(rDungeonMasterEurope)

struct BurnDriver BurnDrvrDungeonMasterEurope = {
	"Dungeon Master (Europe)", NULL, NULL, "1986",
	"Dungeon Master (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dungeon Master (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDungeonMasterEuropeRomInfo, rDungeonMasterEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDungeonMasterJapanRev1RomDesc[] = {
	{ "Dungeon Master (Japan) (Rev 1).sfc",          1048576, 0xaa79fa33, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDungeonMasterJapanRev1)
STD_ROM_FN(rDungeonMasterJapanRev1)

struct BurnDriver BurnDrvrDungeonMasterJapanRev1 = {
	"Dungeon Master (Japan) (Rev 1)", NULL, NULL, "1986",
	"Dungeon Master (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dungeon Master (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDungeonMasterJapanRev1RomInfo, rDungeonMasterJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDungeonMasterJapanRomDesc[] = {
	{ "Dungeon Master (Japan).sfc",          1048576, 0x7a1ba194, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDungeonMasterJapan)
STD_ROM_FN(rDungeonMasterJapan)

struct BurnDriver BurnDrvrDungeonMasterJapan = {
	"Dungeon Master (Japan)", NULL, NULL, "1986",
	"Dungeon Master (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dungeon Master (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDungeonMasterJapanRomInfo, rDungeonMasterJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDungeonMasterUSARomDesc[] = {
	{ "Dungeon Master (USA).sfc",          1048576, 0xdfd9ceb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDungeonMasterUSA)
STD_ROM_FN(rDungeonMasterUSA)

struct BurnDriver BurnDrvrDungeonMasterUSA = {
	"Dungeon Master (USA)", NULL, NULL, "1986",
	"Dungeon Master (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dungeon Master (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDungeonMasterUSARomInfo, rDungeonMasterUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDynamaitetheLasVegasJapanRomDesc[] = {
	{ "Dynamaite the Las Vegas (Japan).sfc",          1048576, 0x1b644433, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDynamaitetheLasVegasJapan)
STD_ROM_FN(rDynamaitetheLasVegasJapan)

struct BurnDriver BurnDrvrDynamaitetheLasVegasJapan = {
	"Dynamaite the Las Vegas (Japan)", NULL, NULL, "1986",
	"Dynamaite the Las Vegas (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dynamaite the Las Vegas (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDynamaitetheLasVegasJapanRomInfo, rDynamaitetheLasVegasJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDynamiTracerJapanBSRomDesc[] = {
	{ "Dynami Tracer (Japan) (BS).sfc",          1048576, 0x41dae33c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDynamiTracerJapanBS)
STD_ROM_FN(rDynamiTracerJapanBS)

struct BurnDriver BurnDrvrDynamiTracerJapanBS = {
	"Dynami Tracer (Japan) (BS)", NULL, NULL, "1986",
	"Dynami Tracer (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dynami Tracer (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDynamiTracerJapanBSRomInfo, rDynamiTracerJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rDynamicStadiumJapanRomDesc[] = {
	{ "Dynamic Stadium (Japan).sfc",          1048576, 0xebcc121c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rDynamicStadiumJapan)
STD_ROM_FN(rDynamicStadiumJapan)

struct BurnDriver BurnDrvrDynamicStadiumJapan = {
	"Dynamic Stadium (Japan)", NULL, NULL, "1986",
	"Dynamic Stadium (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Dynamic Stadium (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rDynamicStadiumJapanRomInfo, rDynamicStadiumJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEVOSearchforEdenUSARomDesc[] = {
	{ "E.V.O. - Search for Eden (USA).sfc",          1572864, 0xdd49911e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEVOSearchforEdenUSA)
STD_ROM_FN(rEVOSearchforEdenUSA)

struct BurnDriver BurnDrvrEVOSearchforEdenUSA = {
	"E.V.O. - Search for Eden (USA)", NULL, NULL, "1986",
	"E.V.O. - Search for Eden (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"E.V.O. - Search for Eden (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEVOSearchforEdenUSARomInfo, rEVOSearchforEdenUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthDefenseForceEuropeRomDesc[] = {
	{ "Earth Defense Force (Europe).sfc",          1048576, 0x404bec17, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthDefenseForceEurope)
STD_ROM_FN(rEarthDefenseForceEurope)

struct BurnDriver BurnDrvrEarthDefenseForceEurope = {
	"Earth Defense Force (Europe)", NULL, NULL, "1986",
	"Earth Defense Force (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earth Defense Force (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthDefenseForceEuropeRomInfo, rEarthDefenseForceEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthDefenseForceUSARomDesc[] = {
	{ "Earth Defense Force (USA).sfc",          1048576, 0xca8ff946, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthDefenseForceUSA)
STD_ROM_FN(rEarthDefenseForceUSA)

struct BurnDriver BurnDrvrEarthDefenseForceUSA = {
	"Earth Defense Force (USA)", NULL, NULL, "1986",
	"Earth Defense Force (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earth Defense Force (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthDefenseForceUSARomInfo, rEarthDefenseForceUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthLightJapanRomDesc[] = {
	{ "Earth Light (Japan).sfc",          1048576, 0x727f1593, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthLightJapan)
STD_ROM_FN(rEarthLightJapan)

struct BurnDriver BurnDrvrEarthLightJapan = {
	"Earth Light (Japan)", NULL, NULL, "1986",
	"Earth Light (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earth Light (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthLightJapanRomInfo, rEarthLightJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthLightLunaStrikeJapanRomDesc[] = {
	{ "Earth Light - Luna Strike (Japan).sfc",          3145728, 0xeafd03c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthLightLunaStrikeJapan)
STD_ROM_FN(rEarthLightLunaStrikeJapan)

struct BurnDriver BurnDrvrEarthLightLunaStrikeJapan = {
	"Earth Light - Luna Strike (Japan)", NULL, NULL, "1986",
	"Earth Light - Luna Strike (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earth Light - Luna Strike (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthLightLunaStrikeJapanRomInfo, rEarthLightLunaStrikeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthBoundUSARomDesc[] = {
	{ "EarthBound (USA).sfc",          3145728, 0xdc9bb451, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthBoundUSA)
STD_ROM_FN(rEarthBoundUSA)

struct BurnDriver BurnDrvrEarthBoundUSA = {
	"EarthBound (USA)", NULL, NULL, "1986",
	"EarthBound (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"EarthBound (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthBoundUSARomInfo, rEarthBoundUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthwormJimEuropeRomDesc[] = {
	{ "Earthworm Jim (Europe).sfc",          3145728, 0x84ab251b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthwormJimEurope)
STD_ROM_FN(rEarthwormJimEurope)

struct BurnDriver BurnDrvrEarthwormJimEurope = {
	"Earthworm Jim (Europe)", NULL, NULL, "1986",
	"Earthworm Jim (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earthworm Jim (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthwormJimEuropeRomInfo, rEarthwormJimEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthwormJimJapanRomDesc[] = {
	{ "Earthworm Jim (Japan).sfc",          3145728, 0x6f8ed108, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthwormJimJapan)
STD_ROM_FN(rEarthwormJimJapan)

struct BurnDriver BurnDrvrEarthwormJimJapan = {
	"Earthworm Jim (Japan)", NULL, NULL, "1986",
	"Earthworm Jim (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earthworm Jim (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthwormJimJapanRomInfo, rEarthwormJimJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthwormJimUSAGamesMasterSpecialEditionRomDesc[] = {
	{ "Earthworm Jim (USA) (GamesMaster Special Edition).sfc",          3145728, 0xb1eaad9e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthwormJimUSAGamesMasterSpecialEdition)
STD_ROM_FN(rEarthwormJimUSAGamesMasterSpecialEdition)

struct BurnDriver BurnDrvrEarthwormJimUSAGamesMasterSpecialEdition = {
	"Earthworm Jim (USA) (GamesMaster Special Edition)", NULL, NULL, "1986",
	"Earthworm Jim (USA) (GamesMaster Special Edition)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earthworm Jim (USA) (GamesMaster Special Edition)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthwormJimUSAGamesMasterSpecialEditionRomInfo, rEarthwormJimUSAGamesMasterSpecialEditionRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthwormJimUSARomDesc[] = {
	{ "Earthworm Jim (USA).sfc",          3145728, 0x3a4a47eb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthwormJimUSA)
STD_ROM_FN(rEarthwormJimUSA)

struct BurnDriver BurnDrvrEarthwormJimUSA = {
	"Earthworm Jim (USA)", NULL, NULL, "1986",
	"Earthworm Jim (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earthworm Jim (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthwormJimUSARomInfo, rEarthwormJimUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthwormJim2EuropeRomDesc[] = {
	{ "Earthworm Jim 2 (Europe).sfc",          3145728, 0x4f961f70, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthwormJim2Europe)
STD_ROM_FN(rEarthwormJim2Europe)

struct BurnDriver BurnDrvrEarthwormJim2Europe = {
	"Earthworm Jim 2 (Europe)", NULL, NULL, "1986",
	"Earthworm Jim 2 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earthworm Jim 2 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthwormJim2EuropeRomInfo, rEarthwormJim2EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthwormJim2USABetaRomDesc[] = {
	{ "Earthworm Jim 2 (USA) (Beta).sfc",          3145728, 0xc110a23a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthwormJim2USABeta)
STD_ROM_FN(rEarthwormJim2USABeta)

struct BurnDriver BurnDrvrEarthwormJim2USABeta = {
	"Earthworm Jim 2 (USA) (Beta)", NULL, NULL, "1986",
	"Earthworm Jim 2 (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earthworm Jim 2 (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthwormJim2USABetaRomInfo, rEarthwormJim2USABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEarthwormJim2USARomDesc[] = {
	{ "Earthworm Jim 2 (USA).sfc",          3145728, 0x393de197, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEarthwormJim2USA)
STD_ROM_FN(rEarthwormJim2USA)

struct BurnDriver BurnDrvrEarthwormJim2USA = {
	"Earthworm Jim 2 (USA)", NULL, NULL, "1986",
	"Earthworm Jim 2 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Earthworm Jim 2 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEarthwormJim2USARomInfo, rEarthwormJim2USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEdonoKibaJapanRomDesc[] = {
	{ "Edono Kiba (Japan).sfc",          1048576, 0xeec5a5b1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEdonoKibaJapan)
STD_ROM_FN(rEdonoKibaJapan)

struct BurnDriver BurnDrvrEdonoKibaJapan = {
	"Edono Kiba (Japan)", NULL, NULL, "1986",
	"Edono Kiba (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Edono Kiba (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEdonoKibaJapanRomInfo, rEdonoKibaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEekTheCatEuropeRomDesc[] = {
	{ "Eek! The Cat (Europe).sfc",          1048576, 0x812555a3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEekTheCatEurope)
STD_ROM_FN(rEekTheCatEurope)

struct BurnDriver BurnDrvrEekTheCatEurope = {
	"Eek! The Cat (Europe)", NULL, NULL, "1986",
	"Eek! The Cat (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Eek! The Cat (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEekTheCatEuropeRomInfo, rEekTheCatEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEekTheCatUSARomDesc[] = {
	{ "Eek! The Cat (USA).sfc",          1048576, 0x216f2fc7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEekTheCatUSA)
STD_ROM_FN(rEekTheCatUSA)

struct BurnDriver BurnDrvrEekTheCatUSA = {
	"Eek! The Cat (USA)", NULL, NULL, "1986",
	"Eek! The Cat (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Eek! The Cat (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEekTheCatUSARomInfo, rEekTheCatUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEiennoFilernaJapanRomDesc[] = {
	{ "Eien no Filerna (Japan).sfc",          1572864, 0x41e9cd70, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEiennoFilernaJapan)
STD_ROM_FN(rEiennoFilernaJapan)

struct BurnDriver BurnDrvrEiennoFilernaJapan = {
	"Eien no Filerna (Japan)", NULL, NULL, "1986",
	"Eien no Filerna (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Eien no Filerna (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEiennoFilernaJapanRomInfo, rEiennoFilernaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rElfariaTheIsleoftheBlestJapanRomDesc[] = {
	{ "Elfaria - The Isle of the Blest (Japan).sfc",          1572864, 0x75993355, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rElfariaTheIsleoftheBlestJapan)
STD_ROM_FN(rElfariaTheIsleoftheBlestJapan)

struct BurnDriver BurnDrvrElfariaTheIsleoftheBlestJapan = {
	"Elfaria - The Isle of the Blest (Japan)", NULL, NULL, "1986",
	"Elfaria - The Isle of the Blest (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Elfaria - The Isle of the Blest (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rElfariaTheIsleoftheBlestJapanRomInfo, rElfariaTheIsleoftheBlestJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rElfariaIITheQuestoftheMeldJapanRomDesc[] = {
	{ "Elfaria II - The Quest of the Meld (Japan).sfc",          2097152, 0x4d5da64f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rElfariaIITheQuestoftheMeldJapan)
STD_ROM_FN(rElfariaIITheQuestoftheMeldJapan)

struct BurnDriver BurnDrvrElfariaIITheQuestoftheMeldJapan = {
	"Elfaria II - The Quest of the Meld (Japan)", NULL, NULL, "1986",
	"Elfaria II - The Quest of the Meld (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Elfaria II - The Quest of the Meld (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rElfariaIITheQuestoftheMeldJapanRomInfo, rElfariaIITheQuestoftheMeldJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEliteSoccerUSARomDesc[] = {
	{ "Elite Soccer (USA).sfc",          1048576, 0x62abaee1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEliteSoccerUSA)
STD_ROM_FN(rEliteSoccerUSA)

struct BurnDriver BurnDrvrEliteSoccerUSA = {
	"Elite Soccer (USA)", NULL, NULL, "1986",
	"Elite Soccer (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Elite Soccer (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEliteSoccerUSARomInfo, rEliteSoccerUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rElnardJapanRomDesc[] = {
	{ "Elnard (Japan).sfc",          1572864, 0x14320873, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rElnardJapan)
STD_ROM_FN(rElnardJapan)

struct BurnDriver BurnDrvrElnardJapan = {
	"Elnard (Japan)", NULL, NULL, "1986",
	"Elnard (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Elnard (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rElnardJapanRomInfo, rElnardJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEmeraldDragonJapanRomDesc[] = {
	{ "Emerald Dragon (Japan).sfc",          2097152, 0x9d0f5f98, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEmeraldDragonJapan)
STD_ROM_FN(rEmeraldDragonJapan)

struct BurnDriver BurnDrvrEmeraldDragonJapan = {
	"Emerald Dragon (Japan)", NULL, NULL, "1986",
	"Emerald Dragon (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Emerald Dragon (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEmeraldDragonJapanRomInfo, rEmeraldDragonJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEmitVol1TokinoMaigoJapanRomDesc[] = {
	{ "Emit Vol. 1 - Toki no Maigo (Japan).sfc",          3145728, 0xd1aacc2d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEmitVol1TokinoMaigoJapan)
STD_ROM_FN(rEmitVol1TokinoMaigoJapan)

struct BurnDriver BurnDrvrEmitVol1TokinoMaigoJapan = {
	"Emit Vol. 1 - Toki no Maigo (Japan)", NULL, NULL, "1986",
	"Emit Vol. 1 - Toki no Maigo (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Emit Vol. 1 - Toki no Maigo (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEmitVol1TokinoMaigoJapanRomInfo, rEmitVol1TokinoMaigoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEmitVol2InochigakenoTabiJapanRomDesc[] = {
	{ "Emit Vol. 2 - Inochigake no Tabi (Japan).sfc",          3145728, 0xad99d806, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEmitVol2InochigakenoTabiJapan)
STD_ROM_FN(rEmitVol2InochigakenoTabiJapan)

struct BurnDriver BurnDrvrEmitVol2InochigakenoTabiJapan = {
	"Emit Vol. 2 - Inochigake no Tabi (Japan)", NULL, NULL, "1986",
	"Emit Vol. 2 - Inochigake no Tabi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Emit Vol. 2 - Inochigake no Tabi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEmitVol2InochigakenoTabiJapanRomInfo, rEmitVol2InochigakenoTabiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEmitVol3WatashiniSayonaraoJapanRomDesc[] = {
	{ "Emit Vol. 3 - Watashi ni Sayonara o (Japan).sfc",          3145728, 0xcbc5da6d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEmitVol3WatashiniSayonaraoJapan)
STD_ROM_FN(rEmitVol3WatashiniSayonaraoJapan)

struct BurnDriver BurnDrvrEmitVol3WatashiniSayonaraoJapan = {
	"Emit Vol. 3 - Watashi ni Sayonara o (Japan)", NULL, NULL, "1986",
	"Emit Vol. 3 - Watashi ni Sayonara o (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Emit Vol. 3 - Watashi ni Sayonara o (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEmitVol3WatashiniSayonaraoJapanRomInfo, rEmitVol3WatashiniSayonaraoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEmmittSmithFootballUSARomDesc[] = {
	{ "Emmitt Smith Football (USA).sfc",          1048576, 0x9c3c0ef, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEmmittSmithFootballUSA)
STD_ROM_FN(rEmmittSmithFootballUSA)

struct BurnDriver BurnDrvrEmmittSmithFootballUSA = {
	"Emmitt Smith Football (USA)", NULL, NULL, "1986",
	"Emmitt Smith Football (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Emmitt Smith Football (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEmmittSmithFootballUSARomInfo, rEmmittSmithFootballUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEnergyBreakerJapanRomDesc[] = {
	{ "Energy Breaker (Japan).sfc",          3145728, 0xf70f2a95, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEnergyBreakerJapan)
STD_ROM_FN(rEnergyBreakerJapan)

struct BurnDriver BurnDrvrEnergyBreakerJapan = {
	"Energy Breaker (Japan)", NULL, NULL, "1986",
	"Energy Breaker (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Energy Breaker (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEnergyBreakerJapanRomInfo, rEnergyBreakerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEquinoxEuropeRomDesc[] = {
	{ "Equinox (Europe).sfc",          1048576, 0xa2b15ac4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEquinoxEurope)
STD_ROM_FN(rEquinoxEurope)

struct BurnDriver BurnDrvrEquinoxEurope = {
	"Equinox (Europe)", NULL, NULL, "1986",
	"Equinox (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Equinox (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEquinoxEuropeRomInfo, rEquinoxEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEquinoxUSABetaRomDesc[] = {
	{ "Equinox (USA) (Beta).sfc",          1048576, 0x61d22779, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEquinoxUSABeta)
STD_ROM_FN(rEquinoxUSABeta)

struct BurnDriver BurnDrvrEquinoxUSABeta = {
	"Equinox (USA) (Beta)", NULL, NULL, "1986",
	"Equinox (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Equinox (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEquinoxUSABetaRomInfo, rEquinoxUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEquinoxUSARomDesc[] = {
	{ "Equinox (USA).sfc",          1048576, 0x96a4d1c0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEquinoxUSA)
STD_ROM_FN(rEquinoxUSA)

struct BurnDriver BurnDrvrEquinoxUSA = {
	"Equinox (USA)", NULL, NULL, "1986",
	"Equinox (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Equinox (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEquinoxUSARomInfo, rEquinoxUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEricCantonaFootballChallengeFranceEnFrDeEsItNlSvRomDesc[] = {
	{ "Eric Cantona Football Challenge (France) (En,Fr,De,Es,It,Nl,Sv).sfc",          524288, 0xd190cf58, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEricCantonaFootballChallengeFranceEnFrDeEsItNlSv)
STD_ROM_FN(rEricCantonaFootballChallengeFranceEnFrDeEsItNlSv)

struct BurnDriver BurnDrvrEricCantonaFootballChallengeFranceEnFrDeEsItNlSv = {
	"Eric Cantona Football Challenge (France) (En,Fr,De,Es,It,Nl,Sv)", NULL, NULL, "1986",
	"Eric Cantona Football Challenge (France) (En,Fr,De,Es,It,Nl,Sv)\0", NULL, "Nintendo", "Miscellaneous",
	L"Eric Cantona Football Challenge (France) (En,Fr,De,Es,It,Nl,Sv)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEricCantonaFootballChallengeFranceEnFrDeEsItNlSvRomInfo, rEricCantonaFootballChallengeFranceEnFrDeEsItNlSvRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEsparksIjikuukaranoRaihoushaJapanRomDesc[] = {
	{ "Esparks - Ijikuu kara no Raihousha (Japan).sfc",          1572864, 0x634344a0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEsparksIjikuukaranoRaihoushaJapan)
STD_ROM_FN(rEsparksIjikuukaranoRaihoushaJapan)

struct BurnDriver BurnDrvrEsparksIjikuukaranoRaihoushaJapan = {
	"Esparks - Ijikuu kara no Raihousha (Japan)", NULL, NULL, "1986",
	"Esparks - Ijikuu kara no Raihousha (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Esparks - Ijikuu kara no Raihousha (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEsparksIjikuukaranoRaihoushaJapanRomInfo, rEsparksIjikuukaranoRaihoushaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rESPNBaseballTonightEuropeRomDesc[] = {
	{ "ESPN Baseball Tonight (Europe).sfc",          2097152, 0xa7a4be9b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rESPNBaseballTonightEurope)
STD_ROM_FN(rESPNBaseballTonightEurope)

struct BurnDriver BurnDrvrESPNBaseballTonightEurope = {
	"ESPN Baseball Tonight (Europe)", NULL, NULL, "1986",
	"ESPN Baseball Tonight (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"ESPN Baseball Tonight (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rESPNBaseballTonightEuropeRomInfo, rESPNBaseballTonightEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rESPNBaseballTonightUSABetaRomDesc[] = {
	{ "ESPN Baseball Tonight (USA) (Beta).sfc",          2097152, 0xd0117d67, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rESPNBaseballTonightUSABeta)
STD_ROM_FN(rESPNBaseballTonightUSABeta)

struct BurnDriver BurnDrvrESPNBaseballTonightUSABeta = {
	"ESPN Baseball Tonight (USA) (Beta)", NULL, NULL, "1986",
	"ESPN Baseball Tonight (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"ESPN Baseball Tonight (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rESPNBaseballTonightUSABetaRomInfo, rESPNBaseballTonightUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rESPNBaseballTonightUSARomDesc[] = {
	{ "ESPN Baseball Tonight (USA).sfc",          2097152, 0x8606d69b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rESPNBaseballTonightUSA)
STD_ROM_FN(rESPNBaseballTonightUSA)

struct BurnDriver BurnDrvrESPNBaseballTonightUSA = {
	"ESPN Baseball Tonight (USA)", NULL, NULL, "1986",
	"ESPN Baseball Tonight (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"ESPN Baseball Tonight (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rESPNBaseballTonightUSARomInfo, rESPNBaseballTonightUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rESPNNationalHockeyNightUSARomDesc[] = {
	{ "ESPN National Hockey Night (USA).sfc",          2097152, 0x75058ede, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rESPNNationalHockeyNightUSA)
STD_ROM_FN(rESPNNationalHockeyNightUSA)

struct BurnDriver BurnDrvrESPNNationalHockeyNightUSA = {
	"ESPN National Hockey Night (USA)", NULL, NULL, "1986",
	"ESPN National Hockey Night (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"ESPN National Hockey Night (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rESPNNationalHockeyNightUSARomInfo, rESPNNationalHockeyNightUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rESPNSpeedworldUSABetaRomDesc[] = {
	{ "ESPN Speedworld (USA) (Beta).sfc",          2097152, 0x2b0069c0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rESPNSpeedworldUSABeta)
STD_ROM_FN(rESPNSpeedworldUSABeta)

struct BurnDriver BurnDrvrESPNSpeedworldUSABeta = {
	"ESPN Speedworld (USA) (Beta)", NULL, NULL, "1986",
	"ESPN Speedworld (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"ESPN Speedworld (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rESPNSpeedworldUSABetaRomInfo, rESPNSpeedworldUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rESPNSpeedworldUSARomDesc[] = {
	{ "ESPN Speedworld (USA).sfc",          2097152, 0xc2cff05a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rESPNSpeedworldUSA)
STD_ROM_FN(rESPNSpeedworldUSA)

struct BurnDriver BurnDrvrESPNSpeedworldUSA = {
	"ESPN Speedworld (USA)", NULL, NULL, "1986",
	"ESPN Speedworld (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"ESPN Speedworld (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rESPNSpeedworldUSARomInfo, rESPNSpeedworldUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rESPNSundayNightNFLUSARomDesc[] = {
	{ "ESPN Sunday Night NFL (USA).sfc",          2097152, 0x26849f90, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rESPNSundayNightNFLUSA)
STD_ROM_FN(rESPNSundayNightNFLUSA)

struct BurnDriver BurnDrvrESPNSundayNightNFLUSA = {
	"ESPN Sunday Night NFL (USA)", NULL, NULL, "1986",
	"ESPN Sunday Night NFL (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"ESPN Sunday Night NFL (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rESPNSundayNightNFLUSARomInfo, rESPNSundayNightNFLUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEstpolisDenkiJapanRomDesc[] = {
	{ "Estpolis Denki (Japan).sfc",          1048576, 0x896b37fb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEstpolisDenkiJapan)
STD_ROM_FN(rEstpolisDenkiJapan)

struct BurnDriver BurnDrvrEstpolisDenkiJapan = {
	"Estpolis Denki (Japan)", NULL, NULL, "1986",
	"Estpolis Denki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Estpolis Denki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEstpolisDenkiJapanRomInfo, rEstpolisDenkiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEstpolisDenkiIIJapanRomDesc[] = {
	{ "Estpolis Denki II (Japan).sfc",          2621440, 0xd9665bbc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEstpolisDenkiIIJapan)
STD_ROM_FN(rEstpolisDenkiIIJapan)

struct BurnDriver BurnDrvrEstpolisDenkiIIJapan = {
	"Estpolis Denki II (Japan)", NULL, NULL, "1986",
	"Estpolis Denki II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Estpolis Denki II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEstpolisDenkiIIJapanRomInfo, rEstpolisDenkiIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEuritUSAProtoRomDesc[] = {
	{ "Eurit (USA) (Proto).sfc",          2097152, 0x78bcd558, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEuritUSAProto)
STD_ROM_FN(rEuritUSAProto)

struct BurnDriver BurnDrvrEuritUSAProto = {
	"Eurit (USA) (Proto)", NULL, NULL, "1986",
	"Eurit (USA) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Eurit (USA) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEuritUSAProtoRomInfo, rEuritUSAProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEuroFootballChampEuropeRomDesc[] = {
	{ "Euro Football Champ (Europe).sfc",          524288, 0x2c6eb470, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEuroFootballChampEurope)
STD_ROM_FN(rEuroFootballChampEurope)

struct BurnDriver BurnDrvrEuroFootballChampEurope = {
	"Euro Football Champ (Europe)", NULL, NULL, "1986",
	"Euro Football Champ (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Euro Football Champ (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEuroFootballChampEuropeRomInfo, rEuroFootballChampEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEuropeSensenJapanRomDesc[] = {
	{ "Europe Sensen (Japan).sfc",          1572864, 0xae066c31, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEuropeSensenJapan)
STD_ROM_FN(rEuropeSensenJapan)

struct BurnDriver BurnDrvrEuropeSensenJapan = {
	"Europe Sensen (Japan)", NULL, NULL, "1986",
	"Europe Sensen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Europe Sensen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEuropeSensenJapanRomInfo, rEuropeSensenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExcitebikeBunbunMarioBattleStadium1JapanBSRomDesc[] = {
	{ "Excitebike - Bunbun Mario Battle - Stadium 1 (Japan) (BS).sfc",          1048576, 0xcf37df6c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExcitebikeBunbunMarioBattleStadium1JapanBS)
STD_ROM_FN(rExcitebikeBunbunMarioBattleStadium1JapanBS)

struct BurnDriver BurnDrvrExcitebikeBunbunMarioBattleStadium1JapanBS = {
	"Excitebike - Bunbun Mario Battle - Stadium 1 (Japan) (BS)", NULL, NULL, "1986",
	"Excitebike - Bunbun Mario Battle - Stadium 1 (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Excitebike - Bunbun Mario Battle - Stadium 1 (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExcitebikeBunbunMarioBattleStadium1JapanBSRomInfo, rExcitebikeBunbunMarioBattleStadium1JapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExcitebikeBunbunMarioBattleStadium2JapanBSRomDesc[] = {
	{ "Excitebike - Bunbun Mario Battle - Stadium 2 (Japan) (BS).sfc",          1048576, 0x3576a0a9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExcitebikeBunbunMarioBattleStadium2JapanBS)
STD_ROM_FN(rExcitebikeBunbunMarioBattleStadium2JapanBS)

struct BurnDriver BurnDrvrExcitebikeBunbunMarioBattleStadium2JapanBS = {
	"Excitebike - Bunbun Mario Battle - Stadium 2 (Japan) (BS)", NULL, NULL, "1986",
	"Excitebike - Bunbun Mario Battle - Stadium 2 (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Excitebike - Bunbun Mario Battle - Stadium 2 (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExcitebikeBunbunMarioBattleStadium2JapanBSRomInfo, rExcitebikeBunbunMarioBattleStadium2JapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExcitebikeBunbunMarioBattleStadium3Japan1998011119980117BSRomDesc[] = {
	{ "Excitebike - Bunbun Mario Battle - Stadium 3 (Japan) (1998-01-11 - 1998-01-17) (BS).sfc",          1048576, 0x763c2ee4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExcitebikeBunbunMarioBattleStadium3Japan1998011119980117BS)
STD_ROM_FN(rExcitebikeBunbunMarioBattleStadium3Japan1998011119980117BS)

struct BurnDriver BurnDrvrExcitebikeBunbunMarioBattleStadium3Japan1998011119980117BS = {
	"Excitebike - Bunbun Mario Battle - Stadium 3 (Japan) (1998-01-11 - 1998-01-17) (BS)", NULL, NULL, "1986",
	"Excitebike - Bunbun Mario Battle - Stadium 3 (Japan) (1998-01-11 - 1998-01-17) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Excitebike - Bunbun Mario Battle - Stadium 3 (Japan) (1998-01-11 - 1998-01-17) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExcitebikeBunbunMarioBattleStadium3Japan1998011119980117BSRomInfo, rExcitebikeBunbunMarioBattleStadium3Japan1998011119980117BSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExcitebikeBunbunMarioBattleStadium3Japanxxxx0208BSRomDesc[] = {
	{ "Excitebike - Bunbun Mario Battle - Stadium 3 (Japan) (xxxx-02-08) (BS).sfc",          1048576, 0xe5206656, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExcitebikeBunbunMarioBattleStadium3Japanxxxx0208BS)
STD_ROM_FN(rExcitebikeBunbunMarioBattleStadium3Japanxxxx0208BS)

struct BurnDriver BurnDrvrExcitebikeBunbunMarioBattleStadium3Japanxxxx0208BS = {
	"Excitebike - Bunbun Mario Battle - Stadium 3 (Japan) (xxxx-02-08) (BS)", NULL, NULL, "1986",
	"Excitebike - Bunbun Mario Battle - Stadium 3 (Japan) (xxxx-02-08) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Excitebike - Bunbun Mario Battle - Stadium 3 (Japan) (xxxx-02-08) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExcitebikeBunbunMarioBattleStadium3Japanxxxx0208BSRomInfo, rExcitebikeBunbunMarioBattleStadium3Japanxxxx0208BSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExcitebikeBunbunMarioBattleStadium4JapanBSRomDesc[] = {
	{ "Excitebike - Bunbun Mario Battle - Stadium 4 (Japan) (BS).sfc",          1048576, 0xc9a77643, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExcitebikeBunbunMarioBattleStadium4JapanBS)
STD_ROM_FN(rExcitebikeBunbunMarioBattleStadium4JapanBS)

struct BurnDriver BurnDrvrExcitebikeBunbunMarioBattleStadium4JapanBS = {
	"Excitebike - Bunbun Mario Battle - Stadium 4 (Japan) (BS)", NULL, NULL, "1986",
	"Excitebike - Bunbun Mario Battle - Stadium 4 (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Excitebike - Bunbun Mario Battle - Stadium 4 (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExcitebikeBunbunMarioBattleStadium4JapanBSRomInfo, rExcitebikeBunbunMarioBattleStadium4JapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExertainmentMountainBikeRallySpeedRacerEuropeEnFrDeEsNlProtoRomDesc[] = {
	{ "Exertainment Mountain Bike Rally & Speed Racer (Europe) (En,Fr,De,Es,Nl) (Proto).sfc",          4194304, 0x811475b0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExertainmentMountainBikeRallySpeedRacerEuropeEnFrDeEsNlProto)
STD_ROM_FN(rExertainmentMountainBikeRallySpeedRacerEuropeEnFrDeEsNlProto)

struct BurnDriver BurnDrvrExertainmentMountainBikeRallySpeedRacerEuropeEnFrDeEsNlProto = {
	"Exertainment Mountain Bike Rally & Speed Racer (Europe) (En,Fr,De,Es,Nl) (Proto)", NULL, NULL, "1986",
	"Exertainment Mountain Bike Rally & Speed Racer (Europe) (En,Fr,De,Es,Nl) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Exertainment Mountain Bike Rally & Speed Racer (Europe) (En,Fr,De,Es,Nl) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExertainmentMountainBikeRallySpeedRacerEuropeEnFrDeEsNlProtoRomInfo, rExertainmentMountainBikeRallySpeedRacerEuropeEnFrDeEsNlProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExertainmentMountainBikeRallySpeedRacerUSARomDesc[] = {
	{ "Exertainment Mountain Bike Rally & Speed Racer (USA).sfc",          4194304, 0xee5e1906, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExertainmentMountainBikeRallySpeedRacerUSA)
STD_ROM_FN(rExertainmentMountainBikeRallySpeedRacerUSA)

struct BurnDriver BurnDrvrExertainmentMountainBikeRallySpeedRacerUSA = {
	"Exertainment Mountain Bike Rally & Speed Racer (USA)", NULL, NULL, "1986",
	"Exertainment Mountain Bike Rally & Speed Racer (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Exertainment Mountain Bike Rally & Speed Racer (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExertainmentMountainBikeRallySpeedRacerUSARomInfo, rExertainmentMountainBikeRallySpeedRacerUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExertainmentMountainBikeRallyUSARomDesc[] = {
	{ "Exertainment Mountain Bike Rally (USA).sfc",          2097152, 0xe6ede101, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExertainmentMountainBikeRallyUSA)
STD_ROM_FN(rExertainmentMountainBikeRallyUSA)

struct BurnDriver BurnDrvrExertainmentMountainBikeRallyUSA = {
	"Exertainment Mountain Bike Rally (USA)", NULL, NULL, "1986",
	"Exertainment Mountain Bike Rally (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Exertainment Mountain Bike Rally (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExertainmentMountainBikeRallyUSARomInfo, rExertainmentMountainBikeRallyUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExhaustHeatEuropeRomDesc[] = {
	{ "Exhaust Heat (Europe).sfc",          1048576, 0xaf5a3203, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExhaustHeatEurope)
STD_ROM_FN(rExhaustHeatEurope)

struct BurnDriver BurnDrvrExhaustHeatEurope = {
	"Exhaust Heat (Europe)", NULL, NULL, "1986",
	"Exhaust Heat (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Exhaust Heat (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExhaustHeatEuropeRomInfo, rExhaustHeatEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExhaustHeatJapanRomDesc[] = {
	{ "Exhaust Heat (Japan).sfc",          1048576, 0x5cb9bc35, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExhaustHeatJapan)
STD_ROM_FN(rExhaustHeatJapan)

struct BurnDriver BurnDrvrExhaustHeatJapan = {
	"Exhaust Heat (Japan)", NULL, NULL, "1986",
	"Exhaust Heat (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Exhaust Heat (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExhaustHeatJapanRomInfo, rExhaustHeatJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExhaustHeatIIF1DriverenoKisekiJapanRomDesc[] = {
	{ "Exhaust Heat II - F1 Driver e no Kiseki (Japan).sfc",          1048576, 0xe2c8e535, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExhaustHeatIIF1DriverenoKisekiJapan)
STD_ROM_FN(rExhaustHeatIIF1DriverenoKisekiJapan)

struct BurnDriver BurnDrvrExhaustHeatIIF1DriverenoKisekiJapan = {
	"Exhaust Heat II - F1 Driver e no Kiseki (Japan)", NULL, NULL, "1986",
	"Exhaust Heat II - F1 Driver e no Kiseki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Exhaust Heat II - F1 Driver e no Kiseki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExhaustHeatIIF1DriverenoKisekiJapanRomInfo, rExhaustHeatIIF1DriverenoKisekiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rExtraInningsUSARomDesc[] = {
	{ "Extra Innings (USA).sfc",          1048576, 0x440a4250, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rExtraInningsUSA)
STD_ROM_FN(rExtraInningsUSA)

struct BurnDriver BurnDrvrExtraInningsUSA = {
	"Extra Innings (USA)", NULL, NULL, "1986",
	"Extra Innings (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Extra Innings (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rExtraInningsUSARomInfo, rExtraInningsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEyeoftheBeholderJapanRomDesc[] = {
	{ "Eye of the Beholder (Japan).sfc",          1048576, 0xf6ad28a3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEyeoftheBeholderJapan)
STD_ROM_FN(rEyeoftheBeholderJapan)

struct BurnDriver BurnDrvrEyeoftheBeholderJapan = {
	"Eye of the Beholder (Japan)", NULL, NULL, "1986",
	"Eye of the Beholder (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Eye of the Beholder (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEyeoftheBeholderJapanRomInfo, rEyeoftheBeholderJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rEyeoftheBeholderUSARomDesc[] = {
	{ "Eye of the Beholder (USA).sfc",          1048576, 0x20143571, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rEyeoftheBeholderUSA)
STD_ROM_FN(rEyeoftheBeholderUSA)

struct BurnDriver BurnDrvrEyeoftheBeholderUSA = {
	"Eye of the Beholder (USA)", NULL, NULL, "1986",
	"Eye of the Beholder (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Eye of the Beholder (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rEyeoftheBeholderUSARomInfo, rEyeoftheBeholderUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF1GrandPrixJapanRomDesc[] = {
	{ "F-1 Grand Prix (Japan).sfc",          1048576, 0x1608ea1a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF1GrandPrixJapan)
STD_ROM_FN(rF1GrandPrixJapan)

struct BurnDriver BurnDrvrF1GrandPrixJapan = {
	"F-1 Grand Prix (Japan)", NULL, NULL, "1986",
	"F-1 Grand Prix (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"F-1 Grand Prix (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF1GrandPrixJapanRomInfo, rF1GrandPrixJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF1GrandPrixPartIIJapanRomDesc[] = {
	{ "F-1 Grand Prix - Part II (Japan).sfc",          1572864, 0x534ae12e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF1GrandPrixPartIIJapan)
STD_ROM_FN(rF1GrandPrixPartIIJapan)

struct BurnDriver BurnDrvrF1GrandPrixPartIIJapan = {
	"F-1 Grand Prix - Part II (Japan)", NULL, NULL, "1986",
	"F-1 Grand Prix - Part II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"F-1 Grand Prix - Part II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF1GrandPrixPartIIJapanRomInfo, rF1GrandPrixPartIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF1GrandPrixPartIIIJapanRomDesc[] = {
	{ "F-1 Grand Prix - Part III (Japan).sfc",          2097152, 0x9b68248e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF1GrandPrixPartIIIJapan)
STD_ROM_FN(rF1GrandPrixPartIIIJapan)

struct BurnDriver BurnDrvrF1GrandPrixPartIIIJapan = {
	"F-1 Grand Prix - Part III (Japan)", NULL, NULL, "1986",
	"F-1 Grand Prix - Part III (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"F-1 Grand Prix - Part III (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF1GrandPrixPartIIIJapanRomInfo, rF1GrandPrixPartIIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF15SuperStrikeEagleJapanRomDesc[] = {
	{ "F-15 Super Strike Eagle (Japan).sfc",          1048576, 0xf0202e26, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF15SuperStrikeEagleJapan)
STD_ROM_FN(rF15SuperStrikeEagleJapan)

struct BurnDriver BurnDrvrF15SuperStrikeEagleJapan = {
	"F-15 Super Strike Eagle (Japan)", NULL, NULL, "1986",
	"F-15 Super Strike Eagle (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"F-15 Super Strike Eagle (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF15SuperStrikeEagleJapanRomInfo, rF15SuperStrikeEagleJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFZeroEuropeRomDesc[] = {
	{ "F-Zero (Europe).sfc",          524288, 0xf1d8f5da, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFZeroEurope)
STD_ROM_FN(rFZeroEurope)

struct BurnDriver BurnDrvrFZeroEurope = {
	"F-Zero (Europe)", NULL, NULL, "1986",
	"F-Zero (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"F-Zero (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFZeroEuropeRomInfo, rFZeroEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFZeroJapanBSRomDesc[] = {
	{ "F-Zero (Japan) (BS).sfc",          524288, 0x6ff86710, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFZeroJapanBS)
STD_ROM_FN(rFZeroJapanBS)

struct BurnDriver BurnDrvrFZeroJapanBS = {
	"F-Zero (Japan) (BS)", NULL, NULL, "1986",
	"F-Zero (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"F-Zero (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFZeroJapanBSRomInfo, rFZeroJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFZeroJapanRomDesc[] = {
	{ "F-Zero (Japan).sfc",          524288, 0x7681efc1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFZeroJapan)
STD_ROM_FN(rFZeroJapan)

struct BurnDriver BurnDrvrFZeroJapan = {
	"F-Zero (Japan)", NULL, NULL, "1986",
	"F-Zero (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"F-Zero (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFZeroJapanRomInfo, rFZeroJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFZeroUSARomDesc[] = {
	{ "F-Zero (USA).sfc",          524288, 0xaa0e31de, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFZeroUSA)
STD_ROM_FN(rFZeroUSA)

struct BurnDriver BurnDrvrFZeroUSA = {
	"F-Zero (USA)", NULL, NULL, "1986",
	"F-Zero (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"F-Zero (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFZeroUSARomInfo, rFZeroUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF1PolePositionEuropeRomDesc[] = {
	{ "F1 Pole Position (Europe).sfc",          1048576, 0xe935886a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF1PolePositionEurope)
STD_ROM_FN(rF1PolePositionEurope)

struct BurnDriver BurnDrvrF1PolePositionEurope = {
	"F1 Pole Position (Europe)", NULL, NULL, "1986",
	"F1 Pole Position (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"F1 Pole Position (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF1PolePositionEuropeRomInfo, rF1PolePositionEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF1PolePositionUSABetaRomDesc[] = {
	{ "F1 Pole Position (USA) (Beta).sfc",          1048576, 0x7049aae8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF1PolePositionUSABeta)
STD_ROM_FN(rF1PolePositionUSABeta)

struct BurnDriver BurnDrvrF1PolePositionUSABeta = {
	"F1 Pole Position (USA) (Beta)", NULL, NULL, "1986",
	"F1 Pole Position (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"F1 Pole Position (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF1PolePositionUSABetaRomInfo, rF1PolePositionUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF1PolePositionUSARomDesc[] = {
	{ "F1 Pole Position (USA).sfc",          1048576, 0xb3da1b1d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF1PolePositionUSA)
STD_ROM_FN(rF1PolePositionUSA)

struct BurnDriver BurnDrvrF1PolePositionUSA = {
	"F1 Pole Position (USA)", NULL, NULL, "1986",
	"F1 Pole Position (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"F1 Pole Position (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF1PolePositionUSARomInfo, rF1PolePositionUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF1PolePosition2EuropeRomDesc[] = {
	{ "F1 Pole Position 2 (Europe).sfc",          1048576, 0x83fc0f0c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF1PolePosition2Europe)
STD_ROM_FN(rF1PolePosition2Europe)

struct BurnDriver BurnDrvrF1PolePosition2Europe = {
	"F1 Pole Position 2 (Europe)", NULL, NULL, "1986",
	"F1 Pole Position 2 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"F1 Pole Position 2 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF1PolePosition2EuropeRomInfo, rF1PolePosition2EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF1ROCRaceofChampionsUSARomDesc[] = {
	{ "F1 ROC - Race of Champions (USA).sfc",          1048576, 0x2a069989, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF1ROCRaceofChampionsUSA)
STD_ROM_FN(rF1ROCRaceofChampionsUSA)

struct BurnDriver BurnDrvrF1ROCRaceofChampionsUSA = {
	"F1 ROC - Race of Champions (USA)", NULL, NULL, "1986",
	"F1 ROC - Race of Champions (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"F1 ROC - Race of Champions (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF1ROCRaceofChampionsUSARomInfo, rF1ROCRaceofChampionsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF1ROCIIRaceofChampionsUSARomDesc[] = {
	{ "F1 ROC II - Race of Champions (USA).sfc",          1048576, 0x3447609e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF1ROCIIRaceofChampionsUSA)
STD_ROM_FN(rF1ROCIIRaceofChampionsUSA)

struct BurnDriver BurnDrvrF1ROCIIRaceofChampionsUSA = {
	"F1 ROC II - Race of Champions (USA)", NULL, NULL, "1986",
	"F1 ROC II - Race of Champions (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"F1 ROC II - Race of Champions (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF1ROCIIRaceofChampionsUSARomInfo, rF1ROCIIRaceofChampionsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rF1WorldChampionshipEditionEuropeRomDesc[] = {
	{ "F1 World Championship Edition (Europe).sfc",          2097152, 0x7ba8fc78, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rF1WorldChampionshipEditionEurope)
STD_ROM_FN(rF1WorldChampionshipEditionEurope)

struct BurnDriver BurnDrvrF1WorldChampionshipEditionEurope = {
	"F1 World Championship Edition (Europe)", NULL, NULL, "1986",
	"F1 World Championship Edition (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"F1 World Championship Edition (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rF1WorldChampionshipEditionEuropeRomInfo, rF1WorldChampionshipEditionEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFaceball2000USARomDesc[] = {
	{ "Faceball 2000 (USA).sfc",          524288, 0x8d4df815, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFaceball2000USA)
STD_ROM_FN(rFaceball2000USA)

struct BurnDriver BurnDrvrFaceball2000USA = {
	"Faceball 2000 (USA)", NULL, NULL, "1986",
	"Faceball 2000 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Faceball 2000 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFaceball2000USARomInfo, rFaceball2000USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFamicomBunkoHajimarinoMoriJapanNPRomDesc[] = {
	{ "Famicom Bunko - Hajimari no Mori (Japan) (NP).sfc",          4194304, 0x11dd3da9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFamicomBunkoHajimarinoMoriJapanNP)
STD_ROM_FN(rFamicomBunkoHajimarinoMoriJapanNP)

struct BurnDriver BurnDrvrFamicomBunkoHajimarinoMoriJapanNP = {
	"Famicom Bunko - Hajimari no Mori (Japan) (NP)", NULL, NULL, "1986",
	"Famicom Bunko - Hajimari no Mori (Japan) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Famicom Bunko - Hajimari no Mori (Japan) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFamicomBunkoHajimarinoMoriJapanNPRomInfo, rFamicomBunkoHajimarinoMoriJapanNPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFamicomTanteiClubPartIIUshironiTatsuShoujoJapanNPRomDesc[] = {
	{ "Famicom Tantei Club Part II - Ushiro ni Tatsu Shoujo (Japan) (NP).sfc",          3145728, 0x28f450ac, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFamicomTanteiClubPartIIUshironiTatsuShoujoJapanNP)
STD_ROM_FN(rFamicomTanteiClubPartIIUshironiTatsuShoujoJapanNP)

struct BurnDriver BurnDrvrFamicomTanteiClubPartIIUshironiTatsuShoujoJapanNP = {
	"Famicom Tantei Club Part II - Ushiro ni Tatsu Shoujo (Japan) (NP)", NULL, NULL, "1986",
	"Famicom Tantei Club Part II - Ushiro ni Tatsu Shoujo (Japan) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Famicom Tantei Club Part II - Ushiro ni Tatsu Shoujo (Japan) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFamicomTanteiClubPartIIUshironiTatsuShoujoJapanNPRomInfo, rFamicomTanteiClubPartIIUshironiTatsuShoujoJapanNPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFamicomTanteiClubPartIIUshironiTatsuShoujoJapanRev1NPRomDesc[] = {
	{ "Famicom Tantei Club Part II - Ushiro ni Tatsu Shoujo (Japan) (Rev 1) (NP).sfc",          3145728, 0x2ce70b92, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFamicomTanteiClubPartIIUshironiTatsuShoujoJapanRev1NP)
STD_ROM_FN(rFamicomTanteiClubPartIIUshironiTatsuShoujoJapanRev1NP)

struct BurnDriver BurnDrvrFamicomTanteiClubPartIIUshironiTatsuShoujoJapanRev1NP = {
	"Famicom Tantei Club Part II - Ushiro ni Tatsu Shoujo (Japan) (Rev 1) (NP)", NULL, NULL, "1986",
	"Famicom Tantei Club Part II - Ushiro ni Tatsu Shoujo (Japan) (Rev 1) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Famicom Tantei Club Part II - Ushiro ni Tatsu Shoujo (Japan) (Rev 1) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFamicomTanteiClubPartIIUshironiTatsuShoujoJapanRev1NPRomInfo, rFamicomTanteiClubPartIIUshironiTatsuShoujoJapanRev1NPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFamilyDogEuropeRomDesc[] = {
	{ "Family Dog (Europe).sfc",          1048576, 0xd95ca497, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFamilyDogEurope)
STD_ROM_FN(rFamilyDogEurope)

struct BurnDriver BurnDrvrFamilyDogEurope = {
	"Family Dog (Europe)", NULL, NULL, "1986",
	"Family Dog (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Family Dog (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFamilyDogEuropeRomInfo, rFamilyDogEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFamilyDogUSARomDesc[] = {
	{ "Family Dog (USA).sfc",          1048576, 0x1b53c15a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFamilyDogUSA)
STD_ROM_FN(rFamilyDogUSA)

struct BurnDriver BurnDrvrFamilyDogUSA = {
	"Family Dog (USA)", NULL, NULL, "1986",
	"Family Dog (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Family Dog (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFamilyDogUSARomInfo, rFamilyDogUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFamilyFeudUSARev1RomDesc[] = {
	{ "Family Feud (USA) (Rev 1).sfc",          524288, 0xc664b71, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFamilyFeudUSARev1)
STD_ROM_FN(rFamilyFeudUSARev1)

struct BurnDriver BurnDrvrFamilyFeudUSARev1 = {
	"Family Feud (USA) (Rev 1)", NULL, NULL, "1986",
	"Family Feud (USA) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Family Feud (USA) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFamilyFeudUSARev1RomInfo, rFamilyFeudUSARev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFamilyFeudUSARomDesc[] = {
	{ "Family Feud (USA).sfc",          524288, 0x4c716bb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFamilyFeudUSA)
STD_ROM_FN(rFamilyFeudUSA)

struct BurnDriver BurnDrvrFamilyFeudUSA = {
	"Family Feud (USA)", NULL, NULL, "1986",
	"Family Feud (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Family Feud (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFamilyFeudUSARomInfo, rFamilyFeudUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFarlandStoryJapanRomDesc[] = {
	{ "Farland Story (Japan).sfc",          2097152, 0xed3dcf2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFarlandStoryJapan)
STD_ROM_FN(rFarlandStoryJapan)

struct BurnDriver BurnDrvrFarlandStoryJapan = {
	"Farland Story (Japan)", NULL, NULL, "1986",
	"Farland Story (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Farland Story (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFarlandStoryJapanRomInfo, rFarlandStoryJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFarlandStory2JapanRomDesc[] = {
	{ "Farland Story 2 (Japan).sfc",          3145728, 0x1cf58de9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFarlandStory2Japan)
STD_ROM_FN(rFarlandStory2Japan)

struct BurnDriver BurnDrvrFarlandStory2Japan = {
	"Farland Story 2 (Japan)", NULL, NULL, "1986",
	"Farland Story 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Farland Story 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFarlandStory2JapanRomInfo, rFarlandStory2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFatalFuryEuropeRomDesc[] = {
	{ "Fatal Fury (Europe).sfc",          1572864, 0xf93611c6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFatalFuryEurope)
STD_ROM_FN(rFatalFuryEurope)

struct BurnDriver BurnDrvrFatalFuryEurope = {
	"Fatal Fury (Europe)", NULL, NULL, "1986",
	"Fatal Fury (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fatal Fury (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFatalFuryEuropeRomInfo, rFatalFuryEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFatalFuryUSARomDesc[] = {
	{ "Fatal Fury (USA).sfc",          1572864, 0xc67257d0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFatalFuryUSA)
STD_ROM_FN(rFatalFuryUSA)

struct BurnDriver BurnDrvrFatalFuryUSA = {
	"Fatal Fury (USA)", NULL, NULL, "1986",
	"Fatal Fury (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fatal Fury (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFatalFuryUSARomInfo, rFatalFuryUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFatalFury2EuropeRomDesc[] = {
	{ "Fatal Fury 2 (Europe).sfc",          2621440, 0x304b2610, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFatalFury2Europe)
STD_ROM_FN(rFatalFury2Europe)

struct BurnDriver BurnDrvrFatalFury2Europe = {
	"Fatal Fury 2 (Europe)", NULL, NULL, "1986",
	"Fatal Fury 2 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fatal Fury 2 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFatalFury2EuropeRomInfo, rFatalFury2EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFatalFury2USARomDesc[] = {
	{ "Fatal Fury 2 (USA).sfc",          2621440, 0xa26ebfef, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFatalFury2USA)
STD_ROM_FN(rFatalFury2USA)

struct BurnDriver BurnDrvrFatalFury2USA = {
	"Fatal Fury 2 (USA)", NULL, NULL, "1986",
	"Fatal Fury 2 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fatal Fury 2 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFatalFury2USARomInfo, rFatalFury2USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFatalFurySpecialEuropeBetaRomDesc[] = {
	{ "Fatal Fury Special (Europe) (Beta).sfc",          3145728, 0x3effa0f5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFatalFurySpecialEuropeBeta)
STD_ROM_FN(rFatalFurySpecialEuropeBeta)

struct BurnDriver BurnDrvrFatalFurySpecialEuropeBeta = {
	"Fatal Fury Special (Europe) (Beta)", NULL, NULL, "1986",
	"Fatal Fury Special (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fatal Fury Special (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFatalFurySpecialEuropeBetaRomInfo, rFatalFurySpecialEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFatalFurySpecialEuropeRomDesc[] = {
	{ "Fatal Fury Special (Europe).sfc",          3145728, 0xa7f8d832, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFatalFurySpecialEurope)
STD_ROM_FN(rFatalFurySpecialEurope)

struct BurnDriver BurnDrvrFatalFurySpecialEurope = {
	"Fatal Fury Special (Europe)", NULL, NULL, "1986",
	"Fatal Fury Special (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fatal Fury Special (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFatalFurySpecialEuropeRomInfo, rFatalFurySpecialEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFatalFurySpecialUSARomDesc[] = {
	{ "Fatal Fury Special (USA).sfc",          4194304, 0x93935bee, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFatalFurySpecialUSA)
STD_ROM_FN(rFatalFurySpecialUSA)

struct BurnDriver BurnDrvrFatalFurySpecialUSA = {
	"Fatal Fury Special (USA)", NULL, NULL, "1986",
	"Fatal Fury Special (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fatal Fury Special (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFatalFurySpecialUSARomInfo, rFatalFurySpecialUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFedaTheEmblemofJusticeJapanBetaRomDesc[] = {
	{ "Feda - The Emblem of Justice (Japan) (Beta).sfc",          2621440, 0x86013cf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFedaTheEmblemofJusticeJapanBeta)
STD_ROM_FN(rFedaTheEmblemofJusticeJapanBeta)

struct BurnDriver BurnDrvrFedaTheEmblemofJusticeJapanBeta = {
	"Feda - The Emblem of Justice (Japan) (Beta)", NULL, NULL, "1986",
	"Feda - The Emblem of Justice (Japan) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Feda - The Emblem of Justice (Japan) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFedaTheEmblemofJusticeJapanBetaRomInfo, rFedaTheEmblemofJusticeJapanBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFedaTheEmblemofJusticeJapanRomDesc[] = {
	{ "Feda - The Emblem of Justice (Japan).sfc",          2621440, 0xeda70f8a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFedaTheEmblemofJusticeJapan)
STD_ROM_FN(rFedaTheEmblemofJusticeJapan)

struct BurnDriver BurnDrvrFedaTheEmblemofJusticeJapan = {
	"Feda - The Emblem of Justice (Japan)", NULL, NULL, "1986",
	"Feda - The Emblem of Justice (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Feda - The Emblem of Justice (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFedaTheEmblemofJusticeJapanRomInfo, rFedaTheEmblemofJusticeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFenek6GatsugouJapanBSRomDesc[] = {
	{ "Fenek - 6 Gatsugou (Japan) (BS).sfc",          524288, 0x5c26c3b2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFenek6GatsugouJapanBS)
STD_ROM_FN(rFenek6GatsugouJapanBS)

struct BurnDriver BurnDrvrFenek6GatsugouJapanBS = {
	"Fenek - 6 Gatsugou (Japan) (BS)", NULL, NULL, "1986",
	"Fenek - 6 Gatsugou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fenek - 6 Gatsugou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFenek6GatsugouJapanBSRomInfo, rFenek6GatsugouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFeverPitchSoccerEuropeBetaRomDesc[] = {
	{ "Fever Pitch Soccer (Europe) (Beta).sfc",          2097152, 0x25c8f98a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFeverPitchSoccerEuropeBeta)
STD_ROM_FN(rFeverPitchSoccerEuropeBeta)

struct BurnDriver BurnDrvrFeverPitchSoccerEuropeBeta = {
	"Fever Pitch Soccer (Europe) (Beta)", NULL, NULL, "1986",
	"Fever Pitch Soccer (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fever Pitch Soccer (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFeverPitchSoccerEuropeBetaRomInfo, rFeverPitchSoccerEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFeverPitchSoccerEuropeEnFrDeEsItRomDesc[] = {
	{ "Fever Pitch Soccer (Europe) (En,Fr,De,Es,It).sfc",          2097152, 0x9b1ea779, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFeverPitchSoccerEuropeEnFrDeEsIt)
STD_ROM_FN(rFeverPitchSoccerEuropeEnFrDeEsIt)

struct BurnDriver BurnDrvrFeverPitchSoccerEuropeEnFrDeEsIt = {
	"Fever Pitch Soccer (Europe) (En,Fr,De,Es,It)", NULL, NULL, "1986",
	"Fever Pitch Soccer (Europe) (En,Fr,De,Es,It)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fever Pitch Soccer (Europe) (En,Fr,De,Es,It)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFeverPitchSoccerEuropeEnFrDeEsItRomInfo, rFeverPitchSoccerEuropeEnFrDeEsItRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFIFA97GoldEditionEuropeEnFrDeEsItSvRomDesc[] = {
	{ "FIFA 97 - Gold Edition (Europe) (En,Fr,De,Es,It,Sv).sfc",          2097152, 0x470eabe5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFIFA97GoldEditionEuropeEnFrDeEsItSv)
STD_ROM_FN(rFIFA97GoldEditionEuropeEnFrDeEsItSv)

struct BurnDriver BurnDrvrFIFA97GoldEditionEuropeEnFrDeEsItSv = {
	"FIFA 97 - Gold Edition (Europe) (En,Fr,De,Es,It,Sv)", NULL, NULL, "1986",
	"FIFA 97 - Gold Edition (Europe) (En,Fr,De,Es,It,Sv)\0", NULL, "Nintendo", "Miscellaneous",
	L"FIFA 97 - Gold Edition (Europe) (En,Fr,De,Es,It,Sv)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFIFA97GoldEditionEuropeEnFrDeEsItSvRomInfo, rFIFA97GoldEditionEuropeEnFrDeEsItSvRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFIFA98RoadtoWorldCupEuropeEnFrDeEsItSvRomDesc[] = {
	{ "FIFA 98 - Road to World Cup (Europe) (En,Fr,De,Es,It,Sv).sfc",          2097152, 0x5e4f4856, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFIFA98RoadtoWorldCupEuropeEnFrDeEsItSv)
STD_ROM_FN(rFIFA98RoadtoWorldCupEuropeEnFrDeEsItSv)

struct BurnDriver BurnDrvrFIFA98RoadtoWorldCupEuropeEnFrDeEsItSv = {
	"FIFA 98 - Road to World Cup (Europe) (En,Fr,De,Es,It,Sv)", NULL, NULL, "1986",
	"FIFA 98 - Road to World Cup (Europe) (En,Fr,De,Es,It,Sv)\0", NULL, "Nintendo", "Miscellaneous",
	L"FIFA 98 - Road to World Cup (Europe) (En,Fr,De,Es,It,Sv)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFIFA98RoadtoWorldCupEuropeEnFrDeEsItSvRomInfo, rFIFA98RoadtoWorldCupEuropeEnFrDeEsItSvRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFIFAInternationalSoccerEuropeRomDesc[] = {
	{ "FIFA International Soccer (Europe).sfc",          1048576, 0xa350821a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFIFAInternationalSoccerEurope)
STD_ROM_FN(rFIFAInternationalSoccerEurope)

struct BurnDriver BurnDrvrFIFAInternationalSoccerEurope = {
	"FIFA International Soccer (Europe)", NULL, NULL, "1986",
	"FIFA International Soccer (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"FIFA International Soccer (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFIFAInternationalSoccerEuropeRomInfo, rFIFAInternationalSoccerEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFIFAInternationalSoccerJapanRomDesc[] = {
	{ "FIFA International Soccer (Japan).sfc",          1048576, 0x4fa1d452, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFIFAInternationalSoccerJapan)
STD_ROM_FN(rFIFAInternationalSoccerJapan)

struct BurnDriver BurnDrvrFIFAInternationalSoccerJapan = {
	"FIFA International Soccer (Japan)", NULL, NULL, "1986",
	"FIFA International Soccer (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"FIFA International Soccer (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFIFAInternationalSoccerJapanRomInfo, rFIFAInternationalSoccerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFIFAInternationalSoccerUSARomDesc[] = {
	{ "FIFA International Soccer (USA).sfc",          1048576, 0x56296426, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFIFAInternationalSoccerUSA)
STD_ROM_FN(rFIFAInternationalSoccerUSA)

struct BurnDriver BurnDrvrFIFAInternationalSoccerUSA = {
	"FIFA International Soccer (USA)", NULL, NULL, "1986",
	"FIFA International Soccer (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"FIFA International Soccer (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFIFAInternationalSoccerUSARomInfo, rFIFAInternationalSoccerUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFIFASoccer96EuropeEnFrDeEsItSvRomDesc[] = {
	{ "FIFA Soccer 96 (Europe) (En,Fr,De,Es,It,Sv).sfc",          1572864, 0x8faf17e5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFIFASoccer96EuropeEnFrDeEsItSv)
STD_ROM_FN(rFIFASoccer96EuropeEnFrDeEsItSv)

struct BurnDriver BurnDrvrFIFASoccer96EuropeEnFrDeEsItSv = {
	"FIFA Soccer 96 (Europe) (En,Fr,De,Es,It,Sv)", NULL, NULL, "1986",
	"FIFA Soccer 96 (Europe) (En,Fr,De,Es,It,Sv)\0", NULL, "Nintendo", "Miscellaneous",
	L"FIFA Soccer 96 (Europe) (En,Fr,De,Es,It,Sv)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFIFASoccer96EuropeEnFrDeEsItSvRomInfo, rFIFASoccer96EuropeEnFrDeEsItSvRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFIFASoccer96USAEnFrDeEsItSvRomDesc[] = {
	{ "FIFA Soccer 96 (USA) (En,Fr,De,Es,It,Sv).sfc",          1572864, 0x7566347d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFIFASoccer96USAEnFrDeEsItSv)
STD_ROM_FN(rFIFASoccer96USAEnFrDeEsItSv)

struct BurnDriver BurnDrvrFIFASoccer96USAEnFrDeEsItSv = {
	"FIFA Soccer 96 (USA) (En,Fr,De,Es,It,Sv)", NULL, NULL, "1986",
	"FIFA Soccer 96 (USA) (En,Fr,De,Es,It,Sv)\0", NULL, "Nintendo", "Miscellaneous",
	L"FIFA Soccer 96 (USA) (En,Fr,De,Es,It,Sv)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFIFASoccer96USAEnFrDeEsItSvRomInfo, rFIFASoccer96USAEnFrDeEsItSvRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFIFASoccer97GoldEditionUSAEnFrDeEsItSvRomDesc[] = {
	{ "FIFA Soccer 97 - Gold Edition (USA) (En,Fr,De,Es,It,Sv).sfc",          2097152, 0x9cdbb2f8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFIFASoccer97GoldEditionUSAEnFrDeEsItSv)
STD_ROM_FN(rFIFASoccer97GoldEditionUSAEnFrDeEsItSv)

struct BurnDriver BurnDrvrFIFASoccer97GoldEditionUSAEnFrDeEsItSv = {
	"FIFA Soccer 97 - Gold Edition (USA) (En,Fr,De,Es,It,Sv)", NULL, NULL, "1986",
	"FIFA Soccer 97 - Gold Edition (USA) (En,Fr,De,Es,It,Sv)\0", NULL, "Nintendo", "Miscellaneous",
	L"FIFA Soccer 97 - Gold Edition (USA) (En,Fr,De,Es,It,Sv)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFIFASoccer97GoldEditionUSAEnFrDeEsItSvRomInfo, rFIFASoccer97GoldEditionUSAEnFrDeEsItSvRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFightersHistoryJapanRomDesc[] = {
	{ "Fighter's History (Japan).sfc",          2621440, 0x10751e4f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFightersHistoryJapan)
STD_ROM_FN(rFightersHistoryJapan)

struct BurnDriver BurnDrvrFightersHistoryJapan = {
	"Fighter's History (Japan)", NULL, NULL, "1986",
	"Fighter's History (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fighter's History (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFightersHistoryJapanRomInfo, rFightersHistoryJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFightersHistoryUSABetaRomDesc[] = {
	{ "Fighter's History (USA) (Beta).sfc",          2621440, 0x283a57aa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFightersHistoryUSABeta)
STD_ROM_FN(rFightersHistoryUSABeta)

struct BurnDriver BurnDrvrFightersHistoryUSABeta = {
	"Fighter's History (USA) (Beta)", NULL, NULL, "1986",
	"Fighter's History (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fighter's History (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFightersHistoryUSABetaRomInfo, rFightersHistoryUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFightersHistoryUSARev1RomDesc[] = {
	{ "Fighter's History (USA) (Rev 1).sfc",          2621440, 0x3d17f6ea, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFightersHistoryUSARev1)
STD_ROM_FN(rFightersHistoryUSARev1)

struct BurnDriver BurnDrvrFightersHistoryUSARev1 = {
	"Fighter's History (USA) (Rev 1)", NULL, NULL, "1986",
	"Fighter's History (USA) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fighter's History (USA) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFightersHistoryUSARev1RomInfo, rFightersHistoryUSARev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFightersHistoryMizoguchiKikiippatsuJapanRomDesc[] = {
	{ "Fighter's History - Mizoguchi Kikiippatsu!! (Japan).sfc",          3145728, 0x65bb5dc4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFightersHistoryMizoguchiKikiippatsuJapan)
STD_ROM_FN(rFightersHistoryMizoguchiKikiippatsuJapan)

struct BurnDriver BurnDrvrFightersHistoryMizoguchiKikiippatsuJapan = {
	"Fighter's History - Mizoguchi Kikiippatsu!! (Japan)", NULL, NULL, "1986",
	"Fighter's History - Mizoguchi Kikiippatsu!! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fighter's History - Mizoguchi Kikiippatsu!! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFightersHistoryMizoguchiKikiippatsuJapanRomInfo, rFightersHistoryMizoguchiKikiippatsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFightingBaseballJapanRomDesc[] = {
	{ "Fighting Baseball (Japan).sfc",          1048576, 0x7f3c1a95, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFightingBaseballJapan)
STD_ROM_FN(rFightingBaseballJapan)

struct BurnDriver BurnDrvrFightingBaseballJapan = {
	"Fighting Baseball (Japan)", NULL, NULL, "1986",
	"Fighting Baseball (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fighting Baseball (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFightingBaseballJapanRomInfo, rFightingBaseballJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyMysticQuestUSARev1RomDesc[] = {
	{ "Final Fantasy - Mystic Quest (USA) (Rev 1).sfc",          524288, 0x2c52c792, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyMysticQuestUSARev1)
STD_ROM_FN(rFinalFantasyMysticQuestUSARev1)

struct BurnDriver BurnDrvrFinalFantasyMysticQuestUSARev1 = {
	"Final Fantasy - Mystic Quest (USA) (Rev 1)", NULL, NULL, "1986",
	"Final Fantasy - Mystic Quest (USA) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy - Mystic Quest (USA) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyMysticQuestUSARev1RomInfo, rFinalFantasyMysticQuestUSARev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyMysticQuestUSARomDesc[] = {
	{ "Final Fantasy - Mystic Quest (USA).sfc",          524288, 0x6b19a2c6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyMysticQuestUSA)
STD_ROM_FN(rFinalFantasyMysticQuestUSA)

struct BurnDriver BurnDrvrFinalFantasyMysticQuestUSA = {
	"Final Fantasy - Mystic Quest (USA)", NULL, NULL, "1986",
	"Final Fantasy - Mystic Quest (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy - Mystic Quest (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyMysticQuestUSARomInfo, rFinalFantasyMysticQuestUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyIIUSARev1RomDesc[] = {
	{ "Final Fantasy II (USA) (Rev 1).sfc",          1048576, 0x23084fcd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyIIUSARev1)
STD_ROM_FN(rFinalFantasyIIUSARev1)

struct BurnDriver BurnDrvrFinalFantasyIIUSARev1 = {
	"Final Fantasy II (USA) (Rev 1)", NULL, NULL, "1986",
	"Final Fantasy II (USA) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy II (USA) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyIIUSARev1RomInfo, rFinalFantasyIIUSARev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyIIUSARomDesc[] = {
	{ "Final Fantasy II (USA).sfc",          1048576, 0x65d0a825, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyIIUSA)
STD_ROM_FN(rFinalFantasyIIUSA)

struct BurnDriver BurnDrvrFinalFantasyIIUSA = {
	"Final Fantasy II (USA)", NULL, NULL, "1986",
	"Final Fantasy II (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy II (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyIIUSARomInfo, rFinalFantasyIIUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyIIIUSARev1RomDesc[] = {
	{ "Final Fantasy III (USA) (Rev 1).sfc",          3145728, 0xc0fa0464, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyIIIUSARev1)
STD_ROM_FN(rFinalFantasyIIIUSARev1)

struct BurnDriver BurnDrvrFinalFantasyIIIUSARev1 = {
	"Final Fantasy III (USA) (Rev 1)", NULL, NULL, "1986",
	"Final Fantasy III (USA) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy III (USA) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyIIIUSARev1RomInfo, rFinalFantasyIIIUSARev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyIIIUSARomDesc[] = {
	{ "Final Fantasy III (USA).sfc",          3145728, 0xa27f1c7a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyIIIUSA)
STD_ROM_FN(rFinalFantasyIIIUSA)

struct BurnDriver BurnDrvrFinalFantasyIIIUSA = {
	"Final Fantasy III (USA)", NULL, NULL, "1986",
	"Final Fantasy III (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy III (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyIIIUSARomInfo, rFinalFantasyIIIUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyIVJapanRev1RomDesc[] = {
	{ "Final Fantasy IV (Japan) (Rev 1).sfc",          1048576, 0xcaa15e97, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyIVJapanRev1)
STD_ROM_FN(rFinalFantasyIVJapanRev1)

struct BurnDriver BurnDrvrFinalFantasyIVJapanRev1 = {
	"Final Fantasy IV (Japan) (Rev 1)", NULL, NULL, "1986",
	"Final Fantasy IV (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy IV (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyIVJapanRev1RomInfo, rFinalFantasyIVJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyIVJapanRomDesc[] = {
	{ "Final Fantasy IV (Japan).sfc",          1048576, 0x21027c5d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyIVJapan)
STD_ROM_FN(rFinalFantasyIVJapan)

struct BurnDriver BurnDrvrFinalFantasyIVJapan = {
	"Final Fantasy IV (Japan)", NULL, NULL, "1986",
	"Final Fantasy IV (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy IV (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyIVJapanRomInfo, rFinalFantasyIVJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyIVEasyTypeJapanRomDesc[] = {
	{ "Final Fantasy IV - Easy Type (Japan).sfc",          1048576, 0x6cda700c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyIVEasyTypeJapan)
STD_ROM_FN(rFinalFantasyIVEasyTypeJapan)

struct BurnDriver BurnDrvrFinalFantasyIVEasyTypeJapan = {
	"Final Fantasy IV - Easy Type (Japan)", NULL, NULL, "1986",
	"Final Fantasy IV - Easy Type (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy IV - Easy Type (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyIVEasyTypeJapanRomInfo, rFinalFantasyIVEasyTypeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyUSAMysticQuestJapanRomDesc[] = {
	{ "Final Fantasy USA - Mystic Quest (Japan).sfc",          524288, 0x1da17f0c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyUSAMysticQuestJapan)
STD_ROM_FN(rFinalFantasyUSAMysticQuestJapan)

struct BurnDriver BurnDrvrFinalFantasyUSAMysticQuestJapan = {
	"Final Fantasy USA - Mystic Quest (Japan)", NULL, NULL, "1986",
	"Final Fantasy USA - Mystic Quest (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy USA - Mystic Quest (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyUSAMysticQuestJapanRomInfo, rFinalFantasyUSAMysticQuestJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyVJapanRomDesc[] = {
	{ "Final Fantasy V (Japan).sfc",          2097152, 0xc1bc267d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyVJapan)
STD_ROM_FN(rFinalFantasyVJapan)

struct BurnDriver BurnDrvrFinalFantasyVJapan = {
	"Final Fantasy V (Japan)", NULL, NULL, "1986",
	"Final Fantasy V (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy V (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyVJapanRomInfo, rFinalFantasyVJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFantasyVIJapanRomDesc[] = {
	{ "Final Fantasy VI (Japan).sfc",          3145728, 0x45ef5ac8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFantasyVIJapan)
STD_ROM_FN(rFinalFantasyVIJapan)

struct BurnDriver BurnDrvrFinalFantasyVIJapan = {
	"Final Fantasy VI (Japan)", NULL, NULL, "1986",
	"Final Fantasy VI (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fantasy VI (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFantasyVIJapanRomInfo, rFinalFantasyVIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFightEuropeRomDesc[] = {
	{ "Final Fight (Europe).sfc",          1048576, 0xa4437629, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFightEurope)
STD_ROM_FN(rFinalFightEurope)

struct BurnDriver BurnDrvrFinalFightEurope = {
	"Final Fight (Europe)", NULL, NULL, "1986",
	"Final Fight (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFightEuropeRomInfo, rFinalFightEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFightJapanRomDesc[] = {
	{ "Final Fight (Japan).sfc",          1048576, 0xa425a202, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFightJapan)
STD_ROM_FN(rFinalFightJapan)

struct BurnDriver BurnDrvrFinalFightJapan = {
	"Final Fight (Japan)", NULL, NULL, "1986",
	"Final Fight (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFightJapanRomInfo, rFinalFightJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFightUSARomDesc[] = {
	{ "Final Fight (USA).sfc",          1048576, 0x4cab21db, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFightUSA)
STD_ROM_FN(rFinalFightUSA)

struct BurnDriver BurnDrvrFinalFightUSA = {
	"Final Fight (USA)", NULL, NULL, "1986",
	"Final Fight (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFightUSARomInfo, rFinalFightUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFight2EuropeRomDesc[] = {
	{ "Final Fight 2 (Europe).sfc",          1310720, 0x7b94ca96, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFight2Europe)
STD_ROM_FN(rFinalFight2Europe)

struct BurnDriver BurnDrvrFinalFight2Europe = {
	"Final Fight 2 (Europe)", NULL, NULL, "1986",
	"Final Fight 2 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight 2 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFight2EuropeRomInfo, rFinalFight2EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFight2JapanRomDesc[] = {
	{ "Final Fight 2 (Japan).sfc",          1310720, 0xf41e1a5a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFight2Japan)
STD_ROM_FN(rFinalFight2Japan)

struct BurnDriver BurnDrvrFinalFight2Japan = {
	"Final Fight 2 (Japan)", NULL, NULL, "1986",
	"Final Fight 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFight2JapanRomInfo, rFinalFight2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFight2USARomDesc[] = {
	{ "Final Fight 2 (USA).sfc",          1310720, 0x8c37ff55, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFight2USA)
STD_ROM_FN(rFinalFight2USA)

struct BurnDriver BurnDrvrFinalFight2USA = {
	"Final Fight 2 (USA)", NULL, NULL, "1986",
	"Final Fight 2 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight 2 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFight2USARomInfo, rFinalFight2USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFight3EuropeRomDesc[] = {
	{ "Final Fight 3 (Europe).sfc",          3145728, 0xaa58a166, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFight3Europe)
STD_ROM_FN(rFinalFight3Europe)

struct BurnDriver BurnDrvrFinalFight3Europe = {
	"Final Fight 3 (Europe)", NULL, NULL, "1986",
	"Final Fight 3 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight 3 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFight3EuropeRomInfo, rFinalFight3EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFight3USABetaRomDesc[] = {
	{ "Final Fight 3 (USA) (Beta).sfc",          3145728, 0xfb764d87, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFight3USABeta)
STD_ROM_FN(rFinalFight3USABeta)

struct BurnDriver BurnDrvrFinalFight3USABeta = {
	"Final Fight 3 (USA) (Beta)", NULL, NULL, "1986",
	"Final Fight 3 (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight 3 (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFight3USABetaRomInfo, rFinalFight3USABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFight3USARomDesc[] = {
	{ "Final Fight 3 (USA).sfc",          3145728, 0xa916e708, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFight3USA)
STD_ROM_FN(rFinalFight3USA)

struct BurnDriver BurnDrvrFinalFight3USA = {
	"Final Fight 3 (USA)", NULL, NULL, "1986",
	"Final Fight 3 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight 3 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFight3USARomInfo, rFinalFight3USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFightGuyJapanRomDesc[] = {
	{ "Final Fight Guy (Japan).sfc",          1048576, 0xde144411, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFightGuyJapan)
STD_ROM_FN(rFinalFightGuyJapan)

struct BurnDriver BurnDrvrFinalFightGuyJapan = {
	"Final Fight Guy (Japan)", NULL, NULL, "1986",
	"Final Fight Guy (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight Guy (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFightGuyJapanRomInfo, rFinalFightGuyJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFightGuyUSARomDesc[] = {
	{ "Final Fight Guy (USA).sfc",          1048576, 0xbc1ae3c2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFightGuyUSA)
STD_ROM_FN(rFinalFightGuyUSA)

struct BurnDriver BurnDrvrFinalFightGuyUSA = {
	"Final Fight Guy (USA)", NULL, NULL, "1986",
	"Final Fight Guy (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight Guy (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFightGuyUSARomInfo, rFinalFightGuyUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalFightToughJapanRomDesc[] = {
	{ "Final Fight Tough (Japan).sfc",          3145728, 0xe3ee9b3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalFightToughJapan)
STD_ROM_FN(rFinalFightToughJapan)

struct BurnDriver BurnDrvrFinalFightToughJapan = {
	"Final Fight Tough (Japan)", NULL, NULL, "1986",
	"Final Fight Tough (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Fight Tough (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalFightToughJapanRomInfo, rFinalFightToughJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalKnockoutJapanRomDesc[] = {
	{ "Final Knockout (Japan).sfc",          1048576, 0xcc1dbc9b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalKnockoutJapan)
STD_ROM_FN(rFinalKnockoutJapan)

struct BurnDriver BurnDrvrFinalKnockoutJapan = {
	"Final Knockout (Japan)", NULL, NULL, "1986",
	"Final Knockout (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Knockout (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalKnockoutJapanRomInfo, rFinalKnockoutJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalStretchJapanRomDesc[] = {
	{ "Final Stretch (Japan).sfc",          1572864, 0x8d29f41f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalStretchJapan)
STD_ROM_FN(rFinalStretchJapan)

struct BurnDriver BurnDrvrFinalStretchJapan = {
	"Final Stretch (Japan)", NULL, NULL, "1986",
	"Final Stretch (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Final Stretch (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalStretchJapanRomInfo, rFinalStretchJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFinalsetJapanRomDesc[] = {
	{ "Finalset (Japan).sfc",          1048576, 0xe06fae58, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFinalsetJapan)
STD_ROM_FN(rFinalsetJapan)

struct BurnDriver BurnDrvrFinalsetJapan = {
	"Finalset (Japan)", NULL, NULL, "1986",
	"Finalset (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Finalset (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFinalsetJapanRomInfo, rFinalsetJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireEmblemMonshounoNazoJapanRev1RomDesc[] = {
	{ "Fire Emblem - Monshou no Nazo (Japan) (Rev 1).sfc",          3145728, 0xa427b7e6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireEmblemMonshounoNazoJapanRev1)
STD_ROM_FN(rFireEmblemMonshounoNazoJapanRev1)

struct BurnDriver BurnDrvrFireEmblemMonshounoNazoJapanRev1 = {
	"Fire Emblem - Monshou no Nazo (Japan) (Rev 1)", NULL, NULL, "1986",
	"Fire Emblem - Monshou no Nazo (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fire Emblem - Monshou no Nazo (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireEmblemMonshounoNazoJapanRev1RomInfo, rFireEmblemMonshounoNazoJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireEmblemMonshounoNazoJapanRomDesc[] = {
	{ "Fire Emblem - Monshou no Nazo (Japan).sfc",          3145728, 0x25d214f4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireEmblemMonshounoNazoJapan)
STD_ROM_FN(rFireEmblemMonshounoNazoJapan)

struct BurnDriver BurnDrvrFireEmblemMonshounoNazoJapan = {
	"Fire Emblem - Monshou no Nazo (Japan)", NULL, NULL, "1986",
	"Fire Emblem - Monshou no Nazo (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fire Emblem - Monshou no Nazo (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireEmblemMonshounoNazoJapanRomInfo, rFireEmblemMonshounoNazoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireEmblemSeisennoKeifuJapanRomDesc[] = {
	{ "Fire Emblem - Seisen no Keifu (Japan).sfc",          4194304, 0xdc0d8cf9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireEmblemSeisennoKeifuJapan)
STD_ROM_FN(rFireEmblemSeisennoKeifuJapan)

struct BurnDriver BurnDrvrFireEmblemSeisennoKeifuJapan = {
	"Fire Emblem - Seisen no Keifu (Japan)", NULL, NULL, "1986",
	"Fire Emblem - Seisen no Keifu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fire Emblem - Seisen no Keifu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireEmblemSeisennoKeifuJapanRomInfo, rFireEmblemSeisennoKeifuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireEmblemThracia776JapanNPRomDesc[] = {
	{ "Fire Emblem - Thracia 776 (Japan) (NP).sfc",          4194304, 0xbc6162ae, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireEmblemThracia776JapanNP)
STD_ROM_FN(rFireEmblemThracia776JapanNP)

struct BurnDriver BurnDrvrFireEmblemThracia776JapanNP = {
	"Fire Emblem - Thracia 776 (Japan) (NP)", NULL, NULL, "1986",
	"Fire Emblem - Thracia 776 (Japan) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fire Emblem - Thracia 776 (Japan) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireEmblemThracia776JapanNPRomInfo, rFireEmblemThracia776JapanNPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireEmblemThracia776JapanRev1NPRomDesc[] = {
	{ "Fire Emblem - Thracia 776 (Japan) (Rev 1) (NP).sfc",          4194304, 0xeaaa2c53, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireEmblemThracia776JapanRev1NP)
STD_ROM_FN(rFireEmblemThracia776JapanRev1NP)

struct BurnDriver BurnDrvrFireEmblemThracia776JapanRev1NP = {
	"Fire Emblem - Thracia 776 (Japan) (Rev 1) (NP)", NULL, NULL, "1986",
	"Fire Emblem - Thracia 776 (Japan) (Rev 1) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fire Emblem - Thracia 776 (Japan) (Rev 1) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireEmblemThracia776JapanRev1NPRomInfo, rFireEmblemThracia776JapanRev1NPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireEmblemThracia776JapanRomDesc[] = {
	{ "Fire Emblem - Thracia 776 (Japan).sfc",          4194304, 0xfc519952, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireEmblemThracia776Japan)
STD_ROM_FN(rFireEmblemThracia776Japan)

struct BurnDriver BurnDrvrFireEmblemThracia776Japan = {
	"Fire Emblem - Thracia 776 (Japan)", NULL, NULL, "1986",
	"Fire Emblem - Thracia 776 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fire Emblem - Thracia 776 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireEmblemThracia776JapanRomInfo, rFireEmblemThracia776JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireFightingJapanRomDesc[] = {
	{ "Fire Fighting (Japan).sfc",          1048576, 0x554fc152, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireFightingJapan)
STD_ROM_FN(rFireFightingJapan)

struct BurnDriver BurnDrvrFireFightingJapan = {
	"Fire Fighting (Japan)", NULL, NULL, "1986",
	"Fire Fighting (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fire Fighting (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireFightingJapanRomInfo, rFireFightingJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireProJoshiAllStarDreamSlamJapanRomDesc[] = {
	{ "Fire Pro Joshi - All Star Dream Slam (Japan).sfc",          2097152, 0xec8e8a05, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireProJoshiAllStarDreamSlamJapan)
STD_ROM_FN(rFireProJoshiAllStarDreamSlamJapan)

struct BurnDriver BurnDrvrFireProJoshiAllStarDreamSlamJapan = {
	"Fire Pro Joshi - All Star Dream Slam (Japan)", NULL, NULL, "1986",
	"Fire Pro Joshi - All Star Dream Slam (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fire Pro Joshi - All Star Dream Slam (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireProJoshiAllStarDreamSlamJapanRomInfo, rFireProJoshiAllStarDreamSlamJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireStrikerUSABetaRomDesc[] = {
	{ "Fire Striker (USA) (Beta).sfc",          1048576, 0xbbbbabb6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireStrikerUSABeta)
STD_ROM_FN(rFireStrikerUSABeta)

struct BurnDriver BurnDrvrFireStrikerUSABeta = {
	"Fire Striker (USA) (Beta)", NULL, NULL, "1986",
	"Fire Striker (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fire Striker (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireStrikerUSABetaRomInfo, rFireStrikerUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireStrikerUSARomDesc[] = {
	{ "Fire Striker (USA).sfc",          1048576, 0xe500c7ba, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireStrikerUSA)
STD_ROM_FN(rFireStrikerUSA)

struct BurnDriver BurnDrvrFireStrikerUSA = {
	"Fire Striker (USA)", NULL, NULL, "1986",
	"Fire Striker (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fire Striker (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireStrikerUSARomInfo, rFireStrikerUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFiremenTheEuropeEnFrDeRomDesc[] = {
	{ "Firemen, The (Europe) (En,Fr,De).sfc",          1048576, 0xdef665af, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFiremenTheEuropeEnFrDe)
STD_ROM_FN(rFiremenTheEuropeEnFrDe)

struct BurnDriver BurnDrvrFiremenTheEuropeEnFrDe = {
	"Firemen, The (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Firemen, The (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Firemen, The (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFiremenTheEuropeEnFrDeRomInfo, rFiremenTheEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFiremenTheJapanBSRomDesc[] = {
	{ "Firemen, The (Japan) (BS).sfc",          1048576, 0x927ba7c2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFiremenTheJapanBS)
STD_ROM_FN(rFiremenTheJapanBS)

struct BurnDriver BurnDrvrFiremenTheJapanBS = {
	"Firemen, The (Japan) (BS)", NULL, NULL, "1986",
	"Firemen, The (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Firemen, The (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFiremenTheJapanBSRomInfo, rFiremenTheJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFiremenTheJapanRomDesc[] = {
	{ "Firemen, The (Japan).sfc",          1048576, 0x15f2271d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFiremenTheJapan)
STD_ROM_FN(rFiremenTheJapan)

struct BurnDriver BurnDrvrFiremenTheJapan = {
	"Firemen, The (Japan)", NULL, NULL, "1986",
	"Firemen, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Firemen, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFiremenTheJapanRomInfo, rFiremenTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFiremenTheUSAProtoRomDesc[] = {
	{ "Firemen, The (USA) (Proto).sfc",          1048576, 0xb9c82442, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFiremenTheUSAProto)
STD_ROM_FN(rFiremenTheUSAProto)

struct BurnDriver BurnDrvrFiremenTheUSAProto = {
	"Firemen, The (USA) (Proto)", NULL, NULL, "1986",
	"Firemen, The (USA) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Firemen, The (USA) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFiremenTheUSAProtoRomInfo, rFiremenTheUSAProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFirepower2000USARomDesc[] = {
	{ "Firepower 2000 (USA).sfc",          1048576, 0x327416d4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFirepower2000USA)
STD_ROM_FN(rFirepower2000USA)

struct BurnDriver BurnDrvrFirepower2000USA = {
	"Firepower 2000 (USA)", NULL, NULL, "1986",
	"Firepower 2000 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Firepower 2000 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFirepower2000USARomInfo, rFirepower2000USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFireteamRogueUSAProtoRomDesc[] = {
	{ "Fireteam Rogue (USA) (Proto).sfc",          2097152, 0xf67ba2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFireteamRogueUSAProto)
STD_ROM_FN(rFireteamRogueUSAProto)

struct BurnDriver BurnDrvrFireteamRogueUSAProto = {
	"Fireteam Rogue (USA) (Proto)", NULL, NULL, "1986",
	"Fireteam Rogue (USA) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fireteam Rogue (USA) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFireteamRogueUSAProtoRomInfo, rFireteamRogueUSAProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFirstQueenOrnicSenkiJapanRomDesc[] = {
	{ "First Queen - Ornic Senki (Japan).sfc",          1048576, 0xbe3de834, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFirstQueenOrnicSenkiJapan)
STD_ROM_FN(rFirstQueenOrnicSenkiJapan)

struct BurnDriver BurnDrvrFirstQueenOrnicSenkiJapan = {
	"First Queen - Ornic Senki (Japan)", NULL, NULL, "1986",
	"First Queen - Ornic Senki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"First Queen - Ornic Senki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFirstQueenOrnicSenkiJapanRomInfo, rFirstQueenOrnicSenkiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFirstSamuraiEuropeBetaRomDesc[] = {
	{ "First Samurai (Europe) (Beta).sfc",          524288, 0x9b855ed0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFirstSamuraiEuropeBeta)
STD_ROM_FN(rFirstSamuraiEuropeBeta)

struct BurnDriver BurnDrvrFirstSamuraiEuropeBeta = {
	"First Samurai (Europe) (Beta)", NULL, NULL, "1986",
	"First Samurai (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"First Samurai (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFirstSamuraiEuropeBetaRomInfo, rFirstSamuraiEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFirstSamuraiEuropeRomDesc[] = {
	{ "First Samurai (Europe).sfc",          524288, 0x5685773a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFirstSamuraiEurope)
STD_ROM_FN(rFirstSamuraiEurope)

struct BurnDriver BurnDrvrFirstSamuraiEurope = {
	"First Samurai (Europe)", NULL, NULL, "1986",
	"First Samurai (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"First Samurai (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFirstSamuraiEuropeRomInfo, rFirstSamuraiEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFirstSamuraiJapanRomDesc[] = {
	{ "First Samurai (Japan).sfc",          524288, 0xb249401b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFirstSamuraiJapan)
STD_ROM_FN(rFirstSamuraiJapan)

struct BurnDriver BurnDrvrFirstSamuraiJapan = {
	"First Samurai (Japan)", NULL, NULL, "1986",
	"First Samurai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"First Samurai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFirstSamuraiJapanRomInfo, rFirstSamuraiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFirstSamuraiUSARomDesc[] = {
	{ "First Samurai (USA).sfc",          524288, 0x4f0a1e2a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFirstSamuraiUSA)
STD_ROM_FN(rFirstSamuraiUSA)

struct BurnDriver BurnDrvrFirstSamuraiUSA = {
	"First Samurai (USA)", NULL, NULL, "1986",
	"First Samurai (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"First Samurai (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFirstSamuraiUSARomInfo, rFirstSamuraiUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFishingKoushienJapanRomDesc[] = {
	{ "Fishing Koushien (Japan).sfc",          2097152, 0xdcfe0b6b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFishingKoushienJapan)
STD_ROM_FN(rFishingKoushienJapan)

struct BurnDriver BurnDrvrFishingKoushienJapan = {
	"Fishing Koushien (Japan)", NULL, NULL, "1986",
	"Fishing Koushien (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fishing Koushien (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFishingKoushienJapanRomInfo, rFishingKoushienJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlashbackEuropeEnFrRomDesc[] = {
	{ "Flashback (Europe) (En,Fr).sfc",          2097152, 0x5dafac3e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlashbackEuropeEnFr)
STD_ROM_FN(rFlashbackEuropeEnFr)

struct BurnDriver BurnDrvrFlashbackEuropeEnFr = {
	"Flashback (Europe) (En,Fr)", NULL, NULL, "1986",
	"Flashback (Europe) (En,Fr)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flashback (Europe) (En,Fr)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlashbackEuropeEnFrRomInfo, rFlashbackEuropeEnFrRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlashbackEuropeEnFrDeRomDesc[] = {
	{ "Flashback (Europe) (En,Fr,De).sfc",          2097152, 0xa0525b9c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlashbackEuropeEnFrDe)
STD_ROM_FN(rFlashbackEuropeEnFrDe)

struct BurnDriver BurnDrvrFlashbackEuropeEnFrDe = {
	"Flashback (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Flashback (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flashback (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlashbackEuropeEnFrDeRomInfo, rFlashbackEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlashbackJapanRomDesc[] = {
	{ "Flashback (Japan).sfc",          2097152, 0xcd09a892, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlashbackJapan)
STD_ROM_FN(rFlashbackJapan)

struct BurnDriver BurnDrvrFlashbackJapan = {
	"Flashback (Japan)", NULL, NULL, "1986",
	"Flashback (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flashback (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlashbackJapanRomInfo, rFlashbackJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlashbackTheQuestforIdentityUSAEnFrDeRomDesc[] = {
	{ "Flashback - The Quest for Identity (USA) (En,Fr,De).sfc",          2097152, 0x1e6aceba, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlashbackTheQuestforIdentityUSAEnFrDe)
STD_ROM_FN(rFlashbackTheQuestforIdentityUSAEnFrDe)

struct BurnDriver BurnDrvrFlashbackTheQuestforIdentityUSAEnFrDe = {
	"Flashback - The Quest for Identity (USA) (En,Fr,De)", NULL, NULL, "1986",
	"Flashback - The Quest for Identity (USA) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flashback - The Quest for Identity (USA) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlashbackTheQuestforIdentityUSAEnFrDeRomInfo, rFlashbackTheQuestforIdentityUSAEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlintstonesTheEuropeEnFrDeEsItBetaRomDesc[] = {
	{ "Flintstones, The (Europe) (En,Fr,De,Es,It) (Beta).sfc",          2097152, 0x15143605, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlintstonesTheEuropeEnFrDeEsItBeta)
STD_ROM_FN(rFlintstonesTheEuropeEnFrDeEsItBeta)

struct BurnDriver BurnDrvrFlintstonesTheEuropeEnFrDeEsItBeta = {
	"Flintstones, The (Europe) (En,Fr,De,Es,It) (Beta)", NULL, NULL, "1986",
	"Flintstones, The (Europe) (En,Fr,De,Es,It) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flintstones, The (Europe) (En,Fr,De,Es,It) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlintstonesTheEuropeEnFrDeEsItBetaRomInfo, rFlintstonesTheEuropeEnFrDeEsItBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlintstonesTheEuropeEnFrDeEsItRomDesc[] = {
	{ "Flintstones, The (Europe) (En,Fr,De,Es,It).sfc",          2097152, 0x85a8b156, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlintstonesTheEuropeEnFrDeEsIt)
STD_ROM_FN(rFlintstonesTheEuropeEnFrDeEsIt)

struct BurnDriver BurnDrvrFlintstonesTheEuropeEnFrDeEsIt = {
	"Flintstones, The (Europe) (En,Fr,De,Es,It)", NULL, NULL, "1986",
	"Flintstones, The (Europe) (En,Fr,De,Es,It)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flintstones, The (Europe) (En,Fr,De,Es,It)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlintstonesTheEuropeEnFrDeEsItRomInfo, rFlintstonesTheEuropeEnFrDeEsItRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlintstonesTheUSABetaRomDesc[] = {
	{ "Flintstones, The (USA) (Beta).sfc",          1048576, 0xcc3e9c19, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlintstonesTheUSABeta)
STD_ROM_FN(rFlintstonesTheUSABeta)

struct BurnDriver BurnDrvrFlintstonesTheUSABeta = {
	"Flintstones, The (USA) (Beta)", NULL, NULL, "1986",
	"Flintstones, The (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flintstones, The (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlintstonesTheUSABetaRomInfo, rFlintstonesTheUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlintstonesTheUSAEnFrDeEsItRomDesc[] = {
	{ "Flintstones, The (USA) (En,Fr,De,Es,It).sfc",          2097152, 0x3e7b51e0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlintstonesTheUSAEnFrDeEsIt)
STD_ROM_FN(rFlintstonesTheUSAEnFrDeEsIt)

struct BurnDriver BurnDrvrFlintstonesTheUSAEnFrDeEsIt = {
	"Flintstones, The (USA) (En,Fr,De,Es,It)", NULL, NULL, "1986",
	"Flintstones, The (USA) (En,Fr,De,Es,It)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flintstones, The (USA) (En,Fr,De,Es,It)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlintstonesTheUSAEnFrDeEsItRomInfo, rFlintstonesTheUSAEnFrDeEsItRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlintstonesTheTheTreasureofSierraMadrockEuropeRomDesc[] = {
	{ "Flintstones, The - The Treasure of Sierra Madrock (Europe).sfc",          1048576, 0xcc846dc4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlintstonesTheTheTreasureofSierraMadrockEurope)
STD_ROM_FN(rFlintstonesTheTheTreasureofSierraMadrockEurope)

struct BurnDriver BurnDrvrFlintstonesTheTheTreasureofSierraMadrockEurope = {
	"Flintstones, The - The Treasure of Sierra Madrock (Europe)", NULL, NULL, "1986",
	"Flintstones, The - The Treasure of Sierra Madrock (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flintstones, The - The Treasure of Sierra Madrock (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlintstonesTheTheTreasureofSierraMadrockEuropeRomInfo, rFlintstonesTheTheTreasureofSierraMadrockEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlintstonesTheTheTreasureofSierraMadrockJapanRomDesc[] = {
	{ "Flintstones, The - The Treasure of Sierra Madrock (Japan).sfc",          1048576, 0x53d29a71, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlintstonesTheTheTreasureofSierraMadrockJapan)
STD_ROM_FN(rFlintstonesTheTheTreasureofSierraMadrockJapan)

struct BurnDriver BurnDrvrFlintstonesTheTheTreasureofSierraMadrockJapan = {
	"Flintstones, The - The Treasure of Sierra Madrock (Japan)", NULL, NULL, "1986",
	"Flintstones, The - The Treasure of Sierra Madrock (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flintstones, The - The Treasure of Sierra Madrock (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlintstonesTheTheTreasureofSierraMadrockJapanRomInfo, rFlintstonesTheTheTreasureofSierraMadrockJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlintstonesTheTheTreasureofSierraMadrockUSARomDesc[] = {
	{ "Flintstones, The - The Treasure of Sierra Madrock (USA).sfc",          1048576, 0x594f5cc6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlintstonesTheTheTreasureofSierraMadrockUSA)
STD_ROM_FN(rFlintstonesTheTheTreasureofSierraMadrockUSA)

struct BurnDriver BurnDrvrFlintstonesTheTheTreasureofSierraMadrockUSA = {
	"Flintstones, The - The Treasure of Sierra Madrock (USA)", NULL, NULL, "1986",
	"Flintstones, The - The Treasure of Sierra Madrock (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flintstones, The - The Treasure of Sierra Madrock (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlintstonesTheTheTreasureofSierraMadrockUSARomInfo, rFlintstonesTheTheTreasureofSierraMadrockUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFlyingHeroBugyurunoDaiboukenJapanRomDesc[] = {
	{ "Flying Hero - Bugyuru no Daibouken (Japan).sfc",          1048576, 0x1a19fc3a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFlyingHeroBugyurunoDaiboukenJapan)
STD_ROM_FN(rFlyingHeroBugyurunoDaiboukenJapan)

struct BurnDriver BurnDrvrFlyingHeroBugyurunoDaiboukenJapan = {
	"Flying Hero - Bugyuru no Daibouken (Japan)", NULL, NULL, "1986",
	"Flying Hero - Bugyuru no Daibouken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Flying Hero - Bugyuru no Daibouken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFlyingHeroBugyurunoDaiboukenJapanRomInfo, rFlyingHeroBugyurunoDaiboukenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFootballFuryUSARomDesc[] = {
	{ "Football Fury (USA).sfc",          1048576, 0x729a5524, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFootballFuryUSA)
STD_ROM_FN(rFootballFuryUSA)

struct BurnDriver BurnDrvrFootballFuryUSA = {
	"Football Fury (USA)", NULL, NULL, "1986",
	"Football Fury (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Football Fury (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFootballFuryUSARomInfo, rFootballFuryUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rForemanForRealEuropeRomDesc[] = {
	{ "Foreman For Real (Europe).sfc",          3145728, 0x8c1b9f50, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rForemanForRealEurope)
STD_ROM_FN(rForemanForRealEurope)

struct BurnDriver BurnDrvrForemanForRealEurope = {
	"Foreman For Real (Europe)", NULL, NULL, "1986",
	"Foreman For Real (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Foreman For Real (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rForemanForRealEuropeRomInfo, rForemanForRealEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rForemanForRealJapanRomDesc[] = {
	{ "Foreman For Real (Japan).sfc",          3145728, 0xd7576775, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rForemanForRealJapan)
STD_ROM_FN(rForemanForRealJapan)

struct BurnDriver BurnDrvrForemanForRealJapan = {
	"Foreman For Real (Japan)", NULL, NULL, "1986",
	"Foreman For Real (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Foreman For Real (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rForemanForRealJapanRomInfo, rForemanForRealJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rForemanForRealUSARomDesc[] = {
	{ "Foreman For Real (USA).sfc",          3145728, 0x5fa4d051, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rForemanForRealUSA)
STD_ROM_FN(rForemanForRealUSA)

struct BurnDriver BurnDrvrForemanForRealUSA = {
	"Foreman For Real (USA)", NULL, NULL, "1986",
	"Foreman For Real (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Foreman For Real (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rForemanForRealUSARomInfo, rForemanForRealUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFortuneQuestDiceoKorogaseJapanRomDesc[] = {
	{ "Fortune Quest - Dice o Korogase (Japan).sfc",          1048576, 0x448e3712, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFortuneQuestDiceoKorogaseJapan)
STD_ROM_FN(rFortuneQuestDiceoKorogaseJapan)

struct BurnDriver BurnDrvrFortuneQuestDiceoKorogaseJapan = {
	"Fortune Quest - Dice o Korogase (Japan)", NULL, NULL, "1986",
	"Fortune Quest - Dice o Korogase (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fortune Quest - Dice o Korogase (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFortuneQuestDiceoKorogaseJapanRomInfo, rFortuneQuestDiceoKorogaseJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFrankThomasBigHurtBaseballEuropeRomDesc[] = {
	{ "Frank Thomas Big Hurt Baseball (Europe).sfc",          3145728, 0x50300f58, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFrankThomasBigHurtBaseballEurope)
STD_ROM_FN(rFrankThomasBigHurtBaseballEurope)

struct BurnDriver BurnDrvrFrankThomasBigHurtBaseballEurope = {
	"Frank Thomas Big Hurt Baseball (Europe)", NULL, NULL, "1986",
	"Frank Thomas Big Hurt Baseball (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Frank Thomas Big Hurt Baseball (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFrankThomasBigHurtBaseballEuropeRomInfo, rFrankThomasBigHurtBaseballEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFrankThomasBigHurtBaseballJapanRomDesc[] = {
	{ "Frank Thomas Big Hurt Baseball (Japan).sfc",          3145728, 0x1a895b24, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFrankThomasBigHurtBaseballJapan)
STD_ROM_FN(rFrankThomasBigHurtBaseballJapan)

struct BurnDriver BurnDrvrFrankThomasBigHurtBaseballJapan = {
	"Frank Thomas Big Hurt Baseball (Japan)", NULL, NULL, "1986",
	"Frank Thomas Big Hurt Baseball (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Frank Thomas Big Hurt Baseball (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFrankThomasBigHurtBaseballJapanRomInfo, rFrankThomasBigHurtBaseballJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFrankThomasBigHurtBaseballUSARomDesc[] = {
	{ "Frank Thomas Big Hurt Baseball (USA).sfc",          3145728, 0x21239dda, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFrankThomasBigHurtBaseballUSA)
STD_ROM_FN(rFrankThomasBigHurtBaseballUSA)

struct BurnDriver BurnDrvrFrankThomasBigHurtBaseballUSA = {
	"Frank Thomas Big Hurt Baseball (USA)", NULL, NULL, "1986",
	"Frank Thomas Big Hurt Baseball (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Frank Thomas Big Hurt Baseball (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFrankThomasBigHurtBaseballUSARomInfo, rFrankThomasBigHurtBaseballUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFranticFleaEuropeBetaRomDesc[] = {
	{ "Frantic Flea (Europe) (Beta).sfc",          2097152, 0x4da05714, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFranticFleaEuropeBeta)
STD_ROM_FN(rFranticFleaEuropeBeta)

struct BurnDriver BurnDrvrFranticFleaEuropeBeta = {
	"Frantic Flea (Europe) (Beta)", NULL, NULL, "1986",
	"Frantic Flea (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Frantic Flea (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFranticFleaEuropeBetaRomInfo, rFranticFleaEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFranticFleaEuropeRomDesc[] = {
	{ "Frantic Flea (Europe).sfc",          2097152, 0xce5c3af9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFranticFleaEurope)
STD_ROM_FN(rFranticFleaEurope)

struct BurnDriver BurnDrvrFranticFleaEurope = {
	"Frantic Flea (Europe)", NULL, NULL, "1986",
	"Frantic Flea (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Frantic Flea (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFranticFleaEuropeRomInfo, rFranticFleaEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFranticFleaUSARomDesc[] = {
	{ "Frantic Flea (USA).sfc",          2097152, 0xffa8d1ff, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFranticFleaUSA)
STD_ROM_FN(rFranticFleaUSA)

struct BurnDriver BurnDrvrFranticFleaUSA = {
	"Frantic Flea (USA)", NULL, NULL, "1986",
	"Frantic Flea (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Frantic Flea (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFranticFleaUSARomInfo, rFranticFleaUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFreudnoChousenjouDai1gouJapanBSRomDesc[] = {
	{ "Freud no Chousenjou - Dai-1-gou (Japan) (BS).sfc",          1048576, 0x8d78d0d7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFreudnoChousenjouDai1gouJapanBS)
STD_ROM_FN(rFreudnoChousenjouDai1gouJapanBS)

struct BurnDriver BurnDrvrFreudnoChousenjouDai1gouJapanBS = {
	"Freud no Chousenjou - Dai-1-gou (Japan) (BS)", NULL, NULL, "1986",
	"Freud no Chousenjou - Dai-1-gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Freud no Chousenjou - Dai-1-gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFreudnoChousenjouDai1gouJapanBSRomInfo, rFreudnoChousenjouDai1gouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFreudnoChousenjouDai2gouJapanBSRomDesc[] = {
	{ "Freud no Chousenjou - Dai-2-gou (Japan) (BS).sfc",          1048576, 0xc99282d6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFreudnoChousenjouDai2gouJapanBS)
STD_ROM_FN(rFreudnoChousenjouDai2gouJapanBS)

struct BurnDriver BurnDrvrFreudnoChousenjouDai2gouJapanBS = {
	"Freud no Chousenjou - Dai-2-gou (Japan) (BS)", NULL, NULL, "1986",
	"Freud no Chousenjou - Dai-2-gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Freud no Chousenjou - Dai-2-gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFreudnoChousenjouDai2gouJapanBSRomInfo, rFreudnoChousenjouDai2gouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFreudnoChousenjouDai3gouJapanBSRomDesc[] = {
	{ "Freud no Chousenjou - Dai-3-gou (Japan) (BS).sfc",          1048576, 0xf938ebc3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFreudnoChousenjouDai3gouJapanBS)
STD_ROM_FN(rFreudnoChousenjouDai3gouJapanBS)

struct BurnDriver BurnDrvrFreudnoChousenjouDai3gouJapanBS = {
	"Freud no Chousenjou - Dai-3-gou (Japan) (BS)", NULL, NULL, "1986",
	"Freud no Chousenjou - Dai-3-gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Freud no Chousenjou - Dai-3-gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFreudnoChousenjouDai3gouJapanBSRomInfo, rFreudnoChousenjouDai3gouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFreudnoChousenjouDai4gouJapanBSRomDesc[] = {
	{ "Freud no Chousenjou - Dai-4-gou (Japan) (BS).sfc",          1048576, 0x12e3a8ee, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFreudnoChousenjouDai4gouJapanBS)
STD_ROM_FN(rFreudnoChousenjouDai4gouJapanBS)

struct BurnDriver BurnDrvrFreudnoChousenjouDai4gouJapanBS = {
	"Freud no Chousenjou - Dai-4-gou (Japan) (BS)", NULL, NULL, "1986",
	"Freud no Chousenjou - Dai-4-gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Freud no Chousenjou - Dai-4-gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFreudnoChousenjouDai4gouJapanBSRomInfo, rFreudnoChousenjouDai4gouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFreudnoChousenjouDai5gouJapanBSRomDesc[] = {
	{ "Freud no Chousenjou - Dai-5-gou (Japan) (BS).sfc",          1048576, 0x4d0af6f3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFreudnoChousenjouDai5gouJapanBS)
STD_ROM_FN(rFreudnoChousenjouDai5gouJapanBS)

struct BurnDriver BurnDrvrFreudnoChousenjouDai5gouJapanBS = {
	"Freud no Chousenjou - Dai-5-gou (Japan) (BS)", NULL, NULL, "1986",
	"Freud no Chousenjou - Dai-5-gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Freud no Chousenjou - Dai-5-gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFreudnoChousenjouDai5gouJapanBSRomInfo, rFreudnoChousenjouDai5gouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFreudnoChousenjouDai6gouJapanBSRomDesc[] = {
	{ "Freud no Chousenjou - Dai-6-gou (Japan) (BS).sfc",          1048576, 0x167f3ab1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFreudnoChousenjouDai6gouJapanBS)
STD_ROM_FN(rFreudnoChousenjouDai6gouJapanBS)

struct BurnDriver BurnDrvrFreudnoChousenjouDai6gouJapanBS = {
	"Freud no Chousenjou - Dai-6-gou (Japan) (BS)", NULL, NULL, "1986",
	"Freud no Chousenjou - Dai-6-gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Freud no Chousenjou - Dai-6-gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFreudnoChousenjouDai6gouJapanBSRomInfo, rFreudnoChousenjouDai6gouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFroggerUSARomDesc[] = {
	{ "Frogger (USA).sfc",          524288, 0x2488b8f2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFroggerUSA)
STD_ROM_FN(rFroggerUSA)

struct BurnDriver BurnDrvrFroggerUSA = {
	"Frogger (USA)", NULL, NULL, "1986",
	"Frogger (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Frogger (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFroggerUSARomInfo, rFroggerUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFromTVAnimationSlamDunkDreamTeamShuueishaLimitedJapanRomDesc[] = {
	{ "From TV Animation Slam Dunk - Dream Team - Shuueisha Limited (Japan).sfc",          1572864, 0x99276eaa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFromTVAnimationSlamDunkDreamTeamShuueishaLimitedJapan)
STD_ROM_FN(rFromTVAnimationSlamDunkDreamTeamShuueishaLimitedJapan)

struct BurnDriver BurnDrvrFromTVAnimationSlamDunkDreamTeamShuueishaLimitedJapan = {
	"From TV Animation Slam Dunk - Dream Team - Shuueisha Limited (Japan)", NULL, NULL, "1986",
	"From TV Animation Slam Dunk - Dream Team - Shuueisha Limited (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"From TV Animation Slam Dunk - Dream Team - Shuueisha Limited (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFromTVAnimationSlamDunkDreamTeamShuueishaLimitedJapanRomInfo, rFromTVAnimationSlamDunkDreamTeamShuueishaLimitedJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFromTVAnimationSlamDunkSDHeatUpJapanRomDesc[] = {
	{ "From TV Animation Slam Dunk - SD Heat Up!! (Japan).sfc",          1572864, 0xd05114c0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFromTVAnimationSlamDunkSDHeatUpJapan)
STD_ROM_FN(rFromTVAnimationSlamDunkSDHeatUpJapan)

struct BurnDriver BurnDrvrFromTVAnimationSlamDunkSDHeatUpJapan = {
	"From TV Animation Slam Dunk - SD Heat Up!! (Japan)", NULL, NULL, "1986",
	"From TV Animation Slam Dunk - SD Heat Up!! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"From TV Animation Slam Dunk - SD Heat Up!! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFromTVAnimationSlamDunkSDHeatUpJapanRomInfo, rFromTVAnimationSlamDunkSDHeatUpJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFromTVAnimationSlamDunkYonkyouGekitotsuJapanRomDesc[] = {
	{ "From TV Animation Slam Dunk - Yonkyou Gekitotsu!! (Japan).sfc",          1572864, 0x35b21bba, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFromTVAnimationSlamDunkYonkyouGekitotsuJapan)
STD_ROM_FN(rFromTVAnimationSlamDunkYonkyouGekitotsuJapan)

struct BurnDriver BurnDrvrFromTVAnimationSlamDunkYonkyouGekitotsuJapan = {
	"From TV Animation Slam Dunk - Yonkyou Gekitotsu!! (Japan)", NULL, NULL, "1986",
	"From TV Animation Slam Dunk - Yonkyou Gekitotsu!! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"From TV Animation Slam Dunk - Yonkyou Gekitotsu!! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFromTVAnimationSlamDunkYonkyouGekitotsuJapanRomInfo, rFromTVAnimationSlamDunkYonkyouGekitotsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFromTVAnimationSlamDunk2IHYosenKanzenBanJapanRomDesc[] = {
	{ "From TV Animation Slam Dunk 2 - IH Yosen Kanzen Ban!! (Japan).sfc",          3145728, 0xaa2b7692, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFromTVAnimationSlamDunk2IHYosenKanzenBanJapan)
STD_ROM_FN(rFromTVAnimationSlamDunk2IHYosenKanzenBanJapan)

struct BurnDriver BurnDrvrFromTVAnimationSlamDunk2IHYosenKanzenBanJapan = {
	"From TV Animation Slam Dunk 2 - IH Yosen Kanzen Ban!! (Japan)", NULL, NULL, "1986",
	"From TV Animation Slam Dunk 2 - IH Yosen Kanzen Ban!! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"From TV Animation Slam Dunk 2 - IH Yosen Kanzen Ban!! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFromTVAnimationSlamDunk2IHYosenKanzenBanJapanRomInfo, rFromTVAnimationSlamDunk2IHYosenKanzenBanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFrontMissionJapanRev1RomDesc[] = {
	{ "Front Mission (Japan) (Rev 1).sfc",          3145728, 0x50278b21, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFrontMissionJapanRev1)
STD_ROM_FN(rFrontMissionJapanRev1)

struct BurnDriver BurnDrvrFrontMissionJapanRev1 = {
	"Front Mission (Japan) (Rev 1)", NULL, NULL, "1986",
	"Front Mission (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Front Mission (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFrontMissionJapanRev1RomInfo, rFrontMissionJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFrontMissionJapanRomDesc[] = {
	{ "Front Mission (Japan).sfc",          3145728, 0xfe27e061, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFrontMissionJapan)
STD_ROM_FN(rFrontMissionJapan)

struct BurnDriver BurnDrvrFrontMissionJapan = {
	"Front Mission (Japan)", NULL, NULL, "1986",
	"Front Mission (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Front Mission (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFrontMissionJapanRomInfo, rFrontMissionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFrontMissionSeriesGunHazardJapanRomDesc[] = {
	{ "Front Mission Series - Gun Hazard (Japan).sfc",          3145728, 0xfd3fdbac, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFrontMissionSeriesGunHazardJapan)
STD_ROM_FN(rFrontMissionSeriesGunHazardJapan)

struct BurnDriver BurnDrvrFrontMissionSeriesGunHazardJapan = {
	"Front Mission Series - Gun Hazard (Japan)", NULL, NULL, "1986",
	"Front Mission Series - Gun Hazard (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Front Mission Series - Gun Hazard (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFrontMissionSeriesGunHazardJapanRomInfo, rFrontMissionSeriesGunHazardJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFullPowerJapanRomDesc[] = {
	{ "Full Power (Japan).sfc",          2097152, 0x66c04587, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFullPowerJapan)
STD_ROM_FN(rFullPowerJapan)

struct BurnDriver BurnDrvrFullPowerJapan = {
	"Full Power (Japan)", NULL, NULL, "1986",
	"Full Power (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Full Power (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFullPowerJapanRomInfo, rFullPowerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFullThrottleAllAmericanRacingEuropeRomDesc[] = {
	{ "Full Throttle - All-American Racing (Europe).sfc",          2097152, 0x861f2e42, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFullThrottleAllAmericanRacingEurope)
STD_ROM_FN(rFullThrottleAllAmericanRacingEurope)

struct BurnDriver BurnDrvrFullThrottleAllAmericanRacingEurope = {
	"Full Throttle - All-American Racing (Europe)", NULL, NULL, "1986",
	"Full Throttle - All-American Racing (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Full Throttle - All-American Racing (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFullThrottleAllAmericanRacingEuropeRomInfo, rFullThrottleAllAmericanRacingEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFullThrottleAllAmericanRacingUSABetaRomDesc[] = {
	{ "Full Throttle - All-American Racing (USA) (Beta).sfc",          2097152, 0xe96e463c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFullThrottleAllAmericanRacingUSABeta)
STD_ROM_FN(rFullThrottleAllAmericanRacingUSABeta)

struct BurnDriver BurnDrvrFullThrottleAllAmericanRacingUSABeta = {
	"Full Throttle - All-American Racing (USA) (Beta)", NULL, NULL, "1986",
	"Full Throttle - All-American Racing (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Full Throttle - All-American Racing (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFullThrottleAllAmericanRacingUSABetaRomInfo, rFullThrottleAllAmericanRacingUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFullThrottleAllAmericanRacingUSARomDesc[] = {
	{ "Full Throttle - All-American Racing (USA).sfc",          2097152, 0x2a4a53ca, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFullThrottleAllAmericanRacingUSA)
STD_ROM_FN(rFullThrottleAllAmericanRacingUSA)

struct BurnDriver BurnDrvrFullThrottleAllAmericanRacingUSA = {
	"Full Throttle - All-American Racing (USA)", NULL, NULL, "1986",
	"Full Throttle - All-American Racing (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Full Throttle - All-American Racing (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFullThrottleAllAmericanRacingUSARomInfo, rFullThrottleAllAmericanRacingUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFunnGamesEuropeRomDesc[] = {
	{ "Fun 'n Games (Europe).sfc",          1048576, 0x9ff2dfe, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFunnGamesEurope)
STD_ROM_FN(rFunnGamesEurope)

struct BurnDriver BurnDrvrFunnGamesEurope = {
	"Fun 'n Games (Europe)", NULL, NULL, "1986",
	"Fun 'n Games (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fun 'n Games (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFunnGamesEuropeRomInfo, rFunnGamesEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFunnGamesUSARomDesc[] = {
	{ "Fun 'n Games (USA).sfc",          1048576, 0x5d6deac7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFunnGamesUSA)
STD_ROM_FN(rFunnGamesUSA)

struct BurnDriver BurnDrvrFunnGamesUSA = {
	"Fun 'n Games (USA)", NULL, NULL, "1986",
	"Fun 'n Games (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fun 'n Games (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFunnGamesUSARomInfo, rFunnGamesUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFunakiMasakatsuHybridWrestlerTougiDenshouJapanRomDesc[] = {
	{ "Funaki Masakatsu Hybrid Wrestler - Tougi Denshou (Japan).sfc",          2097152, 0xd1909ffb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFunakiMasakatsuHybridWrestlerTougiDenshouJapan)
STD_ROM_FN(rFunakiMasakatsuHybridWrestlerTougiDenshouJapan)

struct BurnDriver BurnDrvrFunakiMasakatsuHybridWrestlerTougiDenshouJapan = {
	"Funaki Masakatsu Hybrid Wrestler - Tougi Denshou (Japan)", NULL, NULL, "1986",
	"Funaki Masakatsu Hybrid Wrestler - Tougi Denshou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Funaki Masakatsu Hybrid Wrestler - Tougi Denshou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFunakiMasakatsuHybridWrestlerTougiDenshouJapanRomInfo, rFunakiMasakatsuHybridWrestlerTougiDenshouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFuneTarouJapanRomDesc[] = {
	{ "Fune Tarou (Japan).sfc",          2097152, 0x5d6ba598, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFuneTarouJapan)
STD_ROM_FN(rFuneTarouJapan)

struct BurnDriver BurnDrvrFuneTarouJapan = {
	"Fune Tarou (Japan)", NULL, NULL, "1986",
	"Fune Tarou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fune Tarou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFuneTarouJapanRomInfo, rFuneTarouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFurutaAtsuyanoSimulationProYakyuu2JapanRomDesc[] = {
	{ "Furuta Atsuya no Simulation Pro Yakyuu 2 (Japan).sfc",          2097152, 0x566176fa, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFurutaAtsuyanoSimulationProYakyuu2Japan)
STD_ROM_FN(rFurutaAtsuyanoSimulationProYakyuu2Japan)

struct BurnDriver BurnDrvrFurutaAtsuyanoSimulationProYakyuu2Japan = {
	"Furuta Atsuya no Simulation Pro Yakyuu 2 (Japan)", NULL, NULL, "1986",
	"Furuta Atsuya no Simulation Pro Yakyuu 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Furuta Atsuya no Simulation Pro Yakyuu 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFurutaAtsuyanoSimulationProYakyuu2JapanRomInfo, rFurutaAtsuyanoSimulationProYakyuu2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFushiginoDungeon2FuurainoShirenJapanRev1NPRomDesc[] = {
	{ "Fushigi no Dungeon 2 - Fuurai no Shiren (Japan) (Rev 1) (NP).sfc",          4194304, 0x824aa6b5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFushiginoDungeon2FuurainoShirenJapanRev1NP)
STD_ROM_FN(rFushiginoDungeon2FuurainoShirenJapanRev1NP)

struct BurnDriver BurnDrvrFushiginoDungeon2FuurainoShirenJapanRev1NP = {
	"Fushigi no Dungeon 2 - Fuurai no Shiren (Japan) (Rev 1) (NP)", NULL, NULL, "1986",
	"Fushigi no Dungeon 2 - Fuurai no Shiren (Japan) (Rev 1) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fushigi no Dungeon 2 - Fuurai no Shiren (Japan) (Rev 1) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFushiginoDungeon2FuurainoShirenJapanRev1NPRomInfo, rFushiginoDungeon2FuurainoShirenJapanRev1NPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rFushiginoDungeon2FuurainoShirenJapanRomDesc[] = {
	{ "Fushigi no Dungeon 2 - Fuurai no Shiren (Japan).sfc",          4194304, 0xaf5703ee, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rFushiginoDungeon2FuurainoShirenJapan)
STD_ROM_FN(rFushiginoDungeon2FuurainoShirenJapan)

struct BurnDriver BurnDrvrFushiginoDungeon2FuurainoShirenJapan = {
	"Fushigi no Dungeon 2 - Fuurai no Shiren (Japan)", NULL, NULL, "1986",
	"Fushigi no Dungeon 2 - Fuurai no Shiren (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Fushigi no Dungeon 2 - Fuurai no Shiren (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rFushiginoDungeon2FuurainoShirenJapanRomInfo, rFushiginoDungeon2FuurainoShirenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGODMezameyotoYobuKoegaKikoeJapanRomDesc[] = {
	{ "G.O.D - Mezame yo to Yobu Koe ga Kikoe (Japan).sfc",          3145728, 0x4d2ce16f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGODMezameyotoYobuKoegaKikoeJapan)
STD_ROM_FN(rGODMezameyotoYobuKoegaKikoeJapan)

struct BurnDriver BurnDrvrGODMezameyotoYobuKoegaKikoeJapan = {
	"G.O.D - Mezame yo to Yobu Koe ga Kikoe (Japan)", NULL, NULL, "1986",
	"G.O.D - Mezame yo to Yobu Koe ga Kikoe (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"G.O.D - Mezame yo to Yobu Koe ga Kikoe (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGODMezameyotoYobuKoegaKikoeJapanRomInfo, rGODMezameyotoYobuKoegaKikoeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGaiaGensoukiJapanRomDesc[] = {
	{ "Gaia Gensouki (Japan).sfc",          2097152, 0xb344e9a0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGaiaGensoukiJapan)
STD_ROM_FN(rGaiaGensoukiJapan)

struct BurnDriver BurnDrvrGaiaGensoukiJapan = {
	"Gaia Gensouki (Japan)", NULL, NULL, "1986",
	"Gaia Gensouki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gaia Gensouki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGaiaGensoukiJapanRomInfo, rGaiaGensoukiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGaiaSaverHeroSaidainoSakusenJapanRomDesc[] = {
	{ "Gaia Saver - Hero Saidai no Sakusen (Japan).sfc",          1572864, 0xee6534b5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGaiaSaverHeroSaidainoSakusenJapan)
STD_ROM_FN(rGaiaSaverHeroSaidainoSakusenJapan)

struct BurnDriver BurnDrvrGaiaSaverHeroSaidainoSakusenJapan = {
	"Gaia Saver - Hero Saidai no Sakusen (Japan)", NULL, NULL, "1986",
	"Gaia Saver - Hero Saidai no Sakusen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gaia Saver - Hero Saidai no Sakusen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGaiaSaverHeroSaidainoSakusenJapanRomInfo, rGaiaSaverHeroSaidainoSakusenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGakkoudeAttaKowaiHanashiJapanRomDesc[] = {
	{ "Gakkou de Atta Kowai Hanashi (Japan).sfc",          3145728, 0x94b93b25, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGakkoudeAttaKowaiHanashiJapan)
STD_ROM_FN(rGakkoudeAttaKowaiHanashiJapan)

struct BurnDriver BurnDrvrGakkoudeAttaKowaiHanashiJapan = {
	"Gakkou de Atta Kowai Hanashi (Japan)", NULL, NULL, "1986",
	"Gakkou de Atta Kowai Hanashi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gakkou de Atta Kowai Hanashi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGakkoudeAttaKowaiHanashiJapanRomInfo, rGakkoudeAttaKowaiHanashiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGalaxyRoboJapanRomDesc[] = {
	{ "Galaxy Robo (Japan).sfc",          1572864, 0xbee62812, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGalaxyRoboJapan)
STD_ROM_FN(rGalaxyRoboJapan)

struct BurnDriver BurnDrvrGalaxyRoboJapan = {
	"Galaxy Robo (Japan)", NULL, NULL, "1986",
	"Galaxy Robo (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Galaxy Robo (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGalaxyRoboJapanRomInfo, rGalaxyRoboJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGalaxyWarsJapanRomDesc[] = {
	{ "Galaxy Wars (Japan).sfc",          262144, 0xf159ca70, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGalaxyWarsJapan)
STD_ROM_FN(rGalaxyWarsJapan)

struct BurnDriver BurnDrvrGalaxyWarsJapan = {
	"Galaxy Wars (Japan)", NULL, NULL, "1986",
	"Galaxy Wars (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Galaxy Wars (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGalaxyWarsJapanRomInfo, rGalaxyWarsJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGamblerJikochuushinhaMahjongKouisenJapanRomDesc[] = {
	{ "Gambler Jikochuushinha - Mahjong Kouisen (Japan).sfc",          524288, 0x8ebd1223, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGamblerJikochuushinhaMahjongKouisenJapan)
STD_ROM_FN(rGamblerJikochuushinhaMahjongKouisenJapan)

struct BurnDriver BurnDrvrGamblerJikochuushinhaMahjongKouisenJapan = {
	"Gambler Jikochuushinha - Mahjong Kouisen (Japan)", NULL, NULL, "1986",
	"Gambler Jikochuushinha - Mahjong Kouisen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gambler Jikochuushinha - Mahjong Kouisen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGamblerJikochuushinhaMahjongKouisenJapanRomInfo, rGamblerJikochuushinhaMahjongKouisenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGamblerJikochuushinha2DoraponQuestJapanRomDesc[] = {
	{ "Gambler Jikochuushinha 2 - Dorapon Quest (Japan).sfc",          1048576, 0x4d098c5c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGamblerJikochuushinha2DoraponQuestJapan)
STD_ROM_FN(rGamblerJikochuushinha2DoraponQuestJapan)

struct BurnDriver BurnDrvrGamblerJikochuushinha2DoraponQuestJapan = {
	"Gambler Jikochuushinha 2 - Dorapon Quest (Japan)", NULL, NULL, "1986",
	"Gambler Jikochuushinha 2 - Dorapon Quest (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gambler Jikochuushinha 2 - Dorapon Quest (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGamblerJikochuushinha2DoraponQuestJapanRomInfo, rGamblerJikochuushinha2DoraponQuestJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGamblingHouroukiJapanRomDesc[] = {
	{ "Gambling Hourouki (Japan).sfc",          1048576, 0x43b2590d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGamblingHouroukiJapan)
STD_ROM_FN(rGamblingHouroukiJapan)

struct BurnDriver BurnDrvrGamblingHouroukiJapan = {
	"Gambling Hourouki (Japan)", NULL, NULL, "1986",
	"Gambling Hourouki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gambling Hourouki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGamblingHouroukiJapanRomInfo, rGamblingHouroukiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGameGenieUSAAlt1UnlbRomDesc[] = {
	{ "Game Genie (USA) (Alt 1) (Unl) [b].sfc",          65536, 0x58cbf2fe, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGameGenieUSAAlt1Unlb)
STD_ROM_FN(rGameGenieUSAAlt1Unlb)

struct BurnDriver BurnDrvrGameGenieUSAAlt1Unlb = {
	"Game Genie (USA) (Alt 1) (Unl) [b]", NULL, NULL, "1986",
	"Game Genie (USA) (Alt 1) (Unl) [b]\0", NULL, "Nintendo", "Miscellaneous",
	L"Game Genie (USA) (Alt 1) (Unl) [b]", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGameGenieUSAAlt1UnlbRomInfo, rGameGenieUSAAlt1UnlbRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGameGenieUSAUnlbRomDesc[] = {
	{ "Game Genie (USA) (Unl) [b].sfc",          32768, 0xf8d4c303, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGameGenieUSAUnlb)
STD_ROM_FN(rGameGenieUSAUnlb)

struct BurnDriver BurnDrvrGameGenieUSAUnlb = {
	"Game Genie (USA) (Unl) [b]", NULL, NULL, "1986",
	"Game Genie (USA) (Unl) [b]\0", NULL, "Nintendo", "Miscellaneous",
	L"Game Genie (USA) (Unl) [b]", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGameGenieUSAUnlbRomInfo, rGameGenieUSAUnlbRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGameGenieUSAv20UnlRomDesc[] = {
	{ "Game Genie (USA) (v2.0) (Unl).sfc",          32768, 0xac94f94a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGameGenieUSAv20Unl)
STD_ROM_FN(rGameGenieUSAv20Unl)

struct BurnDriver BurnDrvrGameGenieUSAv20Unl = {
	"Game Genie (USA) (v2.0) (Unl)", NULL, NULL, "1986",
	"Game Genie (USA) (v2.0) (Unl)\0", NULL, "Nintendo", "Miscellaneous",
	L"Game Genie (USA) (v2.0) (Unl)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGameGenieUSAv20UnlRomInfo, rGameGenieUSAv20UnlRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGamenoTatsujinJapanRomDesc[] = {
	{ "Game no Tatsujin (Japan).sfc",          2097152, 0xa3203356, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGamenoTatsujinJapan)
STD_ROM_FN(rGamenoTatsujinJapan)

struct BurnDriver BurnDrvrGamenoTatsujinJapan = {
	"Game no Tatsujin (Japan)", NULL, NULL, "1986",
	"Game no Tatsujin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Game no Tatsujin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGamenoTatsujinJapanRomInfo, rGamenoTatsujinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGamenoTetsujinTheShanghaiJapanRomDesc[] = {
	{ "Game no Tetsujin - The Shanghai (Japan).sfc",          2097152, 0xe50bbfb7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGamenoTetsujinTheShanghaiJapan)
STD_ROM_FN(rGamenoTetsujinTheShanghaiJapan)

struct BurnDriver BurnDrvrGamenoTetsujinTheShanghaiJapan = {
	"Game no Tetsujin - The Shanghai (Japan)", NULL, NULL, "1986",
	"Game no Tetsujin - The Shanghai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Game no Tetsujin - The Shanghai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGamenoTetsujinTheShanghaiJapanRomInfo, rGamenoTetsujinTheShanghaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGameSaverEuropev16UnlRomDesc[] = {
	{ "Game Saver (Europe) (v1.6) (Unl).sfc",          32768, 0x9da23b4a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGameSaverEuropev16Unl)
STD_ROM_FN(rGameSaverEuropev16Unl)

struct BurnDriver BurnDrvrGameSaverEuropev16Unl = {
	"Game Saver (Europe) (v1.6) (Unl)", NULL, NULL, "1986",
	"Game Saver (Europe) (v1.6) (Unl)\0", NULL, "Nintendo", "Miscellaneous",
	L"Game Saver (Europe) (v1.6) (Unl)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGameSaverEuropev16UnlRomInfo, rGameSaverEuropev16UnlRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGameSaverEuropev17UnlRomDesc[] = {
	{ "Game Saver (Europe) (v1.7) (Unl).sfc",          32768, 0xf2225203, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGameSaverEuropev17Unl)
STD_ROM_FN(rGameSaverEuropev17Unl)

struct BurnDriver BurnDrvrGameSaverEuropev17Unl = {
	"Game Saver (Europe) (v1.7) (Unl)", NULL, NULL, "1986",
	"Game Saver (Europe) (v1.7) (Unl)\0", NULL, "Nintendo", "Miscellaneous",
	L"Game Saver (Europe) (v1.7) (Unl)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGameSaverEuropev17UnlRomInfo, rGameSaverEuropev17UnlRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGameToranoTaikoban517GouJapanBSRomDesc[] = {
	{ "Game Tora no Taikoban - 5-17 Gou (Japan) (BS).sfc",          524288, 0x4cf3e14f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGameToranoTaikoban517GouJapanBS)
STD_ROM_FN(rGameToranoTaikoban517GouJapanBS)

struct BurnDriver BurnDrvrGameToranoTaikoban517GouJapanBS = {
	"Game Tora no Taikoban - 5-17 Gou (Japan) (BS)", NULL, NULL, "1986",
	"Game Tora no Taikoban - 5-17 Gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Game Tora no Taikoban - 5-17 Gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGameToranoTaikoban517GouJapanBSRomInfo, rGameToranoTaikoban517GouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGameToranoTaikoban531GouJapanBSRomDesc[] = {
	{ "Game Tora no Taikoban - 5-31 Gou (Japan) (BS).sfc",          524288, 0x393e9715, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGameToranoTaikoban531GouJapanBS)
STD_ROM_FN(rGameToranoTaikoban531GouJapanBS)

struct BurnDriver BurnDrvrGameToranoTaikoban531GouJapanBS = {
	"Game Tora no Taikoban - 5-31 Gou (Japan) (BS)", NULL, NULL, "1986",
	"Game Tora no Taikoban - 5-31 Gou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Game Tora no Taikoban - 5-31 Gou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGameToranoTaikoban531GouJapanBSRomInfo, rGameToranoTaikoban531GouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGameraGyaosGekimetsuSakusenJapanRomDesc[] = {
	{ "Gamera - Gyaos Gekimetsu Sakusen (Japan).sfc",          1572864, 0xbdb4dd84, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGameraGyaosGekimetsuSakusenJapan)
STD_ROM_FN(rGameraGyaosGekimetsuSakusenJapan)

struct BurnDriver BurnDrvrGameraGyaosGekimetsuSakusenJapan = {
	"Gamera - Gyaos Gekimetsu Sakusen (Japan)", NULL, NULL, "1986",
	"Gamera - Gyaos Gekimetsu Sakusen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gamera - Gyaos Gekimetsu Sakusen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGameraGyaosGekimetsuSakusenJapanRomInfo, rGameraGyaosGekimetsuSakusenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGanbareGoemonYukiHimeKyuushutsuEmakiJapanRev2RomDesc[] = {
	{ "Ganbare Goemon - Yuki Hime Kyuushutsu Emaki (Japan) (Rev 2).sfc",          1048576, 0x6cd62399, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGanbareGoemonYukiHimeKyuushutsuEmakiJapanRev2)
STD_ROM_FN(rGanbareGoemonYukiHimeKyuushutsuEmakiJapanRev2)

struct BurnDriver BurnDrvrGanbareGoemonYukiHimeKyuushutsuEmakiJapanRev2 = {
	"Ganbare Goemon - Yuki Hime Kyuushutsu Emaki (Japan) (Rev 2)", NULL, NULL, "1986",
	"Ganbare Goemon - Yuki Hime Kyuushutsu Emaki (Japan) (Rev 2)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ganbare Goemon - Yuki Hime Kyuushutsu Emaki (Japan) (Rev 2)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGanbareGoemonYukiHimeKyuushutsuEmakiJapanRev2RomInfo, rGanbareGoemonYukiHimeKyuushutsuEmakiJapanRev2RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGanbareGoemonYukiHimeKyuushutsuEmakiJapanRomDesc[] = {
	{ "Ganbare Goemon - Yuki Hime Kyuushutsu Emaki (Japan).sfc",          1048576, 0xadde8d79, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGanbareGoemonYukiHimeKyuushutsuEmakiJapan)
STD_ROM_FN(rGanbareGoemonYukiHimeKyuushutsuEmakiJapan)

struct BurnDriver BurnDrvrGanbareGoemonYukiHimeKyuushutsuEmakiJapan = {
	"Ganbare Goemon - Yuki Hime Kyuushutsu Emaki (Japan)", NULL, NULL, "1986",
	"Ganbare Goemon - Yuki Hime Kyuushutsu Emaki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ganbare Goemon - Yuki Hime Kyuushutsu Emaki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGanbareGoemonYukiHimeKyuushutsuEmakiJapanRomInfo, rGanbareGoemonYukiHimeKyuushutsuEmakiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGanbareGoemon2KiteretsuShougunMagginesuJapanRomDesc[] = {
	{ "Ganbare Goemon 2 - Kiteretsu Shougun Magginesu (Japan).sfc",          2097152, 0xca4c0219, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGanbareGoemon2KiteretsuShougunMagginesuJapan)
STD_ROM_FN(rGanbareGoemon2KiteretsuShougunMagginesuJapan)

struct BurnDriver BurnDrvrGanbareGoemon2KiteretsuShougunMagginesuJapan = {
	"Ganbare Goemon 2 - Kiteretsu Shougun Magginesu (Japan)", NULL, NULL, "1986",
	"Ganbare Goemon 2 - Kiteretsu Shougun Magginesu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ganbare Goemon 2 - Kiteretsu Shougun Magginesu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGanbareGoemon2KiteretsuShougunMagginesuJapanRomInfo, rGanbareGoemon2KiteretsuShougunMagginesuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGanbareGoemon3ShishiJuurokubeenoKarakuriManjigatameJapanRomDesc[] = {
	{ "Ganbare Goemon 3 - Shishi Juurokubee no Karakuri Manjigatame (Japan).sfc",          2097152, 0x7e5929e8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGanbareGoemon3ShishiJuurokubeenoKarakuriManjigatameJapan)
STD_ROM_FN(rGanbareGoemon3ShishiJuurokubeenoKarakuriManjigatameJapan)

struct BurnDriver BurnDrvrGanbareGoemon3ShishiJuurokubeenoKarakuriManjigatameJapan = {
	"Ganbare Goemon 3 - Shishi Juurokubee no Karakuri Manjigatame (Japan)", NULL, NULL, "1986",
	"Ganbare Goemon 3 - Shishi Juurokubee no Karakuri Manjigatame (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ganbare Goemon 3 - Shishi Juurokubee no Karakuri Manjigatame (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGanbareGoemon3ShishiJuurokubeenoKarakuriManjigatameJapanRomInfo, rGanbareGoemon3ShishiJuurokubeenoKarakuriManjigatameJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapanRev2NPRomDesc[] = {
	{ "Ganbare Goemon Kirakira Douchuu - Boku ga Dancer ni Natta Wake (Japan) (Rev 2) (NP).sfc",          3145728, 0xc20720c2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapanRev2NP)
STD_ROM_FN(rGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapanRev2NP)

struct BurnDriver BurnDrvrGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapanRev2NP = {
	"Ganbare Goemon Kirakira Douchuu - Boku ga Dancer ni Natta Wake (Japan) (Rev 2) (NP)", NULL, NULL, "1986",
	"Ganbare Goemon Kirakira Douchuu - Boku ga Dancer ni Natta Wake (Japan) (Rev 2) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ganbare Goemon Kirakira Douchuu - Boku ga Dancer ni Natta Wake (Japan) (Rev 2) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapanRev2NPRomInfo, rGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapanRev2NPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapanRomDesc[] = {
	{ "Ganbare Goemon Kirakira Douchuu - Boku ga Dancer ni Natta Wake (Japan).sfc",          3145728, 0xbb9d8e56, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapan)
STD_ROM_FN(rGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapan)

struct BurnDriver BurnDrvrGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapan = {
	"Ganbare Goemon Kirakira Douchuu - Boku ga Dancer ni Natta Wake (Japan)", NULL, NULL, "1986",
	"Ganbare Goemon Kirakira Douchuu - Boku ga Dancer ni Natta Wake (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ganbare Goemon Kirakira Douchuu - Boku ga Dancer ni Natta Wake (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapanRomInfo, rGanbareGoemonKirakiraDouchuuBokugaDancerniNattaWakeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGanbareDaikunoGensanJapanRomDesc[] = {
	{ "Ganbare! Daiku no Gen-san (Japan).sfc",          1048576, 0x206bd866, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGanbareDaikunoGensanJapan)
STD_ROM_FN(rGanbareDaikunoGensanJapan)

struct BurnDriver BurnDrvrGanbareDaikunoGensanJapan = {
	"Ganbare! Daiku no Gen-san (Japan)", NULL, NULL, "1986",
	"Ganbare! Daiku no Gen-san (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ganbare! Daiku no Gen-san (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGanbareDaikunoGensanJapanRomInfo, rGanbareDaikunoGensanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGanganGanchanJapanRomDesc[] = {
	{ "Gangan Gan-chan (Japan).sfc",          1048576, 0xa220c6d5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGanganGanchanJapan)
STD_ROM_FN(rGanganGanchanJapan)

struct BurnDriver BurnDrvrGanganGanchanJapan = {
	"Gangan Gan-chan (Japan)", NULL, NULL, "1986",
	"Gangan Gan-chan (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gangan Gan-chan (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGanganGanchanJapanRomInfo, rGanganGanchanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGanpuruGunmansProofJapanRomDesc[] = {
	{ "Ganpuru - Gunman's Proof (Japan).sfc",          3145728, 0xaf415c24, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGanpuruGunmansProofJapan)
STD_ROM_FN(rGanpuruGunmansProofJapan)

struct BurnDriver BurnDrvrGanpuruGunmansProofJapan = {
	"Ganpuru - Gunman's Proof (Japan)", NULL, NULL, "1986",
	"Ganpuru - Gunman's Proof (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ganpuru - Gunman's Proof (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGanpuruGunmansProofJapanRomInfo, rGanpuruGunmansProofJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGansoPachiSlotNihonichiJapanRomDesc[] = {
	{ "Ganso Pachi-Slot Nihonichi (Japan).sfc",          1048576, 0x18bbad5c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGansoPachiSlotNihonichiJapan)
STD_ROM_FN(rGansoPachiSlotNihonichiJapan)

struct BurnDriver BurnDrvrGansoPachiSlotNihonichiJapan = {
	"Ganso Pachi-Slot Nihonichi (Japan)", NULL, NULL, "1986",
	"Ganso Pachi-Slot Nihonichi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ganso Pachi-Slot Nihonichi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGansoPachiSlotNihonichiJapanRomInfo, rGansoPachiSlotNihonichiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGansoPachinkoOuJapanRomDesc[] = {
	{ "Ganso Pachinko Ou (Japan).sfc",          1048576, 0x73453c46, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGansoPachinkoOuJapan)
STD_ROM_FN(rGansoPachinkoOuJapan)

struct BurnDriver BurnDrvrGansoPachinkoOuJapan = {
	"Ganso Pachinko Ou (Japan)", NULL, NULL, "1986",
	"Ganso Pachinko Ou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ganso Pachinko Ou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGansoPachinkoOuJapanRomInfo, rGansoPachinkoOuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGarouDensetsuShukumeinoTatakaiJapanRev1RomDesc[] = {
	{ "Garou Densetsu - Shukumei no Tatakai (Japan) (Rev 1).sfc",          1572864, 0xae4dfed0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGarouDensetsuShukumeinoTatakaiJapanRev1)
STD_ROM_FN(rGarouDensetsuShukumeinoTatakaiJapanRev1)

struct BurnDriver BurnDrvrGarouDensetsuShukumeinoTatakaiJapanRev1 = {
	"Garou Densetsu - Shukumei no Tatakai (Japan) (Rev 1)", NULL, NULL, "1986",
	"Garou Densetsu - Shukumei no Tatakai (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Garou Densetsu - Shukumei no Tatakai (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGarouDensetsuShukumeinoTatakaiJapanRev1RomInfo, rGarouDensetsuShukumeinoTatakaiJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGarouDensetsuShukumeinoTatakaiJapanRomDesc[] = {
	{ "Garou Densetsu - Shukumei no Tatakai (Japan).sfc",          1572864, 0xd549e3e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGarouDensetsuShukumeinoTatakaiJapan)
STD_ROM_FN(rGarouDensetsuShukumeinoTatakaiJapan)

struct BurnDriver BurnDrvrGarouDensetsuShukumeinoTatakaiJapan = {
	"Garou Densetsu - Shukumei no Tatakai (Japan)", NULL, NULL, "1986",
	"Garou Densetsu - Shukumei no Tatakai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Garou Densetsu - Shukumei no Tatakai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGarouDensetsuShukumeinoTatakaiJapanRomInfo, rGarouDensetsuShukumeinoTatakaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGarouDensetsu2AratanaruTatakaiJapanRev1RomDesc[] = {
	{ "Garou Densetsu 2 - Aratanaru Tatakai (Japan) (Rev 1).sfc",          2621440, 0x3ee1b2d2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGarouDensetsu2AratanaruTatakaiJapanRev1)
STD_ROM_FN(rGarouDensetsu2AratanaruTatakaiJapanRev1)

struct BurnDriver BurnDrvrGarouDensetsu2AratanaruTatakaiJapanRev1 = {
	"Garou Densetsu 2 - Aratanaru Tatakai (Japan) (Rev 1)", NULL, NULL, "1986",
	"Garou Densetsu 2 - Aratanaru Tatakai (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Garou Densetsu 2 - Aratanaru Tatakai (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGarouDensetsu2AratanaruTatakaiJapanRev1RomInfo, rGarouDensetsu2AratanaruTatakaiJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGarouDensetsu2AratanaruTatakaiJapanRomDesc[] = {
	{ "Garou Densetsu 2 - Aratanaru Tatakai (Japan).sfc",          2621440, 0xfbf3abdf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGarouDensetsu2AratanaruTatakaiJapan)
STD_ROM_FN(rGarouDensetsu2AratanaruTatakaiJapan)

struct BurnDriver BurnDrvrGarouDensetsu2AratanaruTatakaiJapan = {
	"Garou Densetsu 2 - Aratanaru Tatakai (Japan)", NULL, NULL, "1986",
	"Garou Densetsu 2 - Aratanaru Tatakai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Garou Densetsu 2 - Aratanaru Tatakai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGarouDensetsu2AratanaruTatakaiJapanRomInfo, rGarouDensetsu2AratanaruTatakaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGarouDensetsuSpecialJapanRomDesc[] = {
	{ "Garou Densetsu Special (Japan).sfc",          4194304, 0xc1f68c7a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGarouDensetsuSpecialJapan)
STD_ROM_FN(rGarouDensetsuSpecialJapan)

struct BurnDriver BurnDrvrGarouDensetsuSpecialJapan = {
	"Garou Densetsu Special (Japan)", NULL, NULL, "1986",
	"Garou Densetsu Special (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Garou Densetsu Special (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGarouDensetsuSpecialJapanRomInfo, rGarouDensetsuSpecialJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGdleenJapanRev1RomDesc[] = {
	{ "Gdleen (Japan) (Rev 1).sfc",          1048576, 0x9692c77, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGdleenJapanRev1)
STD_ROM_FN(rGdleenJapanRev1)

struct BurnDriver BurnDrvrGdleenJapanRev1 = {
	"Gdleen (Japan) (Rev 1)", NULL, NULL, "1986",
	"Gdleen (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gdleen (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGdleenJapanRev1RomInfo, rGdleenJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGdleenJapanRomDesc[] = {
	{ "Gdleen (Japan).sfc",          1048576, 0xf0205fed, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGdleenJapan)
STD_ROM_FN(rGdleenJapan)

struct BurnDriver BurnDrvrGdleenJapan = {
	"Gdleen (Japan)", NULL, NULL, "1986",
	"Gdleen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gdleen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGdleenJapanRomInfo, rGdleenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGegegenoKitarouFukkatsuTenmaDaiouJapanRomDesc[] = {
	{ "Gegege no Kitarou - Fukkatsu! Tenma Daiou (Japan).sfc",          1048576, 0xe51fb6f8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGegegenoKitarouFukkatsuTenmaDaiouJapan)
STD_ROM_FN(rGegegenoKitarouFukkatsuTenmaDaiouJapan)

struct BurnDriver BurnDrvrGegegenoKitarouFukkatsuTenmaDaiouJapan = {
	"Gegege no Kitarou - Fukkatsu! Tenma Daiou (Japan)", NULL, NULL, "1986",
	"Gegege no Kitarou - Fukkatsu! Tenma Daiou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gegege no Kitarou - Fukkatsu! Tenma Daiou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGegegenoKitarouFukkatsuTenmaDaiouJapanRomInfo, rGegegenoKitarouFukkatsuTenmaDaiouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGegegenoKitarouYoukaiDonjaraJapanSTRomDesc[] = {
	{ "Gegege no Kitarou - Youkai Donjara (Japan) (ST).sfc",          524288, 0x4296500d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGegegenoKitarouYoukaiDonjaraJapanST)
STD_ROM_FN(rGegegenoKitarouYoukaiDonjaraJapanST)

struct BurnDriver BurnDrvrGegegenoKitarouYoukaiDonjaraJapanST = {
	"Gegege no Kitarou - Youkai Donjara (Japan) (ST)", NULL, NULL, "1986",
	"Gegege no Kitarou - Youkai Donjara (Japan) (ST)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gegege no Kitarou - Youkai Donjara (Japan) (ST)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGegegenoKitarouYoukaiDonjaraJapanSTRomInfo, rGegegenoKitarouYoukaiDonjaraJapanSTRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGekisouSentaiCarrangerZenkaiRacerSenshiJapanSTRomDesc[] = {
	{ "Gekisou Sentai Carranger - Zenkai! Racer Senshi (Japan) (ST).sfc",          524288, 0x14c66fca, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGekisouSentaiCarrangerZenkaiRacerSenshiJapanST)
STD_ROM_FN(rGekisouSentaiCarrangerZenkaiRacerSenshiJapanST)

struct BurnDriver BurnDrvrGekisouSentaiCarrangerZenkaiRacerSenshiJapanST = {
	"Gekisou Sentai Carranger - Zenkai! Racer Senshi (Japan) (ST)", NULL, NULL, "1986",
	"Gekisou Sentai Carranger - Zenkai! Racer Senshi (Japan) (ST)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gekisou Sentai Carranger - Zenkai! Racer Senshi (Japan) (ST)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGekisouSentaiCarrangerZenkaiRacerSenshiJapanSTRomInfo, rGekisouSentaiCarrangerZenkaiRacerSenshiJapanSTRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGekitotsuDanganJidoushaKessenBattleMobileJapanRomDesc[] = {
	{ "Gekitotsu Dangan Jidousha Kessen - Battle Mobile (Japan).sfc",          1048576, 0x3e88e883, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGekitotsuDanganJidoushaKessenBattleMobileJapan)
STD_ROM_FN(rGekitotsuDanganJidoushaKessenBattleMobileJapan)

struct BurnDriver BurnDrvrGekitotsuDanganJidoushaKessenBattleMobileJapan = {
	"Gekitotsu Dangan Jidousha Kessen - Battle Mobile (Japan)", NULL, NULL, "1986",
	"Gekitotsu Dangan Jidousha Kessen - Battle Mobile (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gekitotsu Dangan Jidousha Kessen - Battle Mobile (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGekitotsuDanganJidoushaKessenBattleMobileJapanRomInfo, rGekitotsuDanganJidoushaKessenBattleMobileJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGekitouBurningProWrestlingJapanRomDesc[] = {
	{ "Gekitou Burning Pro Wrestling (Japan).sfc",          2621440, 0xb2e7fc76, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGekitouBurningProWrestlingJapan)
STD_ROM_FN(rGekitouBurningProWrestlingJapan)

struct BurnDriver BurnDrvrGekitouBurningProWrestlingJapan = {
	"Gekitou Burning Pro Wrestling (Japan)", NULL, NULL, "1986",
	"Gekitou Burning Pro Wrestling (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gekitou Burning Pro Wrestling (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGekitouBurningProWrestlingJapanRomInfo, rGekitouBurningProWrestlingJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGekkanCoinTossDeck1JapanBSRomDesc[] = {
	{ "Gekkan Coin Toss - Deck 1 (Japan) (BS).sfc",          1048576, 0xd2d7c3e5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGekkanCoinTossDeck1JapanBS)
STD_ROM_FN(rGekkanCoinTossDeck1JapanBS)

struct BurnDriver BurnDrvrGekkanCoinTossDeck1JapanBS = {
	"Gekkan Coin Toss - Deck 1 (Japan) (BS)", NULL, NULL, "1986",
	"Gekkan Coin Toss - Deck 1 (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gekkan Coin Toss - Deck 1 (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGekkanCoinTossDeck1JapanBSRomInfo, rGekkanCoinTossDeck1JapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGemfireUSARomDesc[] = {
	{ "Gemfire (USA).sfc",          1048576, 0xee801a54, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGemfireUSA)
STD_ROM_FN(rGemfireUSA)

struct BurnDriver BurnDrvrGemfireUSA = {
	"Gemfire (USA)", NULL, NULL, "1986",
	"Gemfire (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gemfire (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGemfireUSARomInfo, rGemfireUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGenghisKhanIIClanoftheGrayWolfUSARomDesc[] = {
	{ "Genghis Khan II - Clan of the Gray Wolf (USA).sfc",          1048576, 0xd7875512, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGenghisKhanIIClanoftheGrayWolfUSA)
STD_ROM_FN(rGenghisKhanIIClanoftheGrayWolfUSA)

struct BurnDriver BurnDrvrGenghisKhanIIClanoftheGrayWolfUSA = {
	"Genghis Khan II - Clan of the Gray Wolf (USA)", NULL, NULL, "1986",
	"Genghis Khan II - Clan of the Gray Wolf (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Genghis Khan II - Clan of the Gray Wolf (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGenghisKhanIIClanoftheGrayWolfUSARomInfo, rGenghisKhanIIClanoftheGrayWolfUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGenjuuRyodanJapanNPRomDesc[] = {
	{ "Genjuu Ryodan (Japan) (NP).sfc",          4194304, 0x8d9bffc8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGenjuuRyodanJapanNP)
STD_ROM_FN(rGenjuuRyodanJapanNP)

struct BurnDriver BurnDrvrGenjuuRyodanJapanNP = {
	"Genjuu Ryodan (Japan) (NP)", NULL, NULL, "1986",
	"Genjuu Ryodan (Japan) (NP)\0", NULL, "Nintendo", "Miscellaneous",
	L"Genjuu Ryodan (Japan) (NP)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGenjuuRyodanJapanNPRomInfo, rGenjuuRyodanJapanNPRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGenocide2JapanBetaRomDesc[] = {
	{ "Genocide 2 (Japan) (Beta).sfc",          262144, 0xf8876331, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGenocide2JapanBeta)
STD_ROM_FN(rGenocide2JapanBeta)

struct BurnDriver BurnDrvrGenocide2JapanBeta = {
	"Genocide 2 (Japan) (Beta)", NULL, NULL, "1986",
	"Genocide 2 (Japan) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Genocide 2 (Japan) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGenocide2JapanBetaRomInfo, rGenocide2JapanBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGenocide2JapanRomDesc[] = {
	{ "Genocide 2 (Japan).sfc",          2097152, 0xde40aa12, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGenocide2Japan)
STD_ROM_FN(rGenocide2Japan)

struct BurnDriver BurnDrvrGenocide2Japan = {
	"Genocide 2 (Japan)", NULL, NULL, "1986",
	"Genocide 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Genocide 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGenocide2JapanRomInfo, rGenocide2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGeorgeForemansKOBoxingEuropeRomDesc[] = {
	{ "George Foreman's KO Boxing (Europe).sfc",          1048576, 0x9fe6ec1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGeorgeForemansKOBoxingEurope)
STD_ROM_FN(rGeorgeForemansKOBoxingEurope)

struct BurnDriver BurnDrvrGeorgeForemansKOBoxingEurope = {
	"George Foreman's KO Boxing (Europe)", NULL, NULL, "1986",
	"George Foreman's KO Boxing (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"George Foreman's KO Boxing (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGeorgeForemansKOBoxingEuropeRomInfo, rGeorgeForemansKOBoxingEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGeorgeForemansKOBoxingUSADoritosPromoRomDesc[] = {
	{ "George Foreman's KO Boxing (USA) (Doritos Promo).sfc",          1048576, 0x71056bf3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGeorgeForemansKOBoxingUSADoritosPromo)
STD_ROM_FN(rGeorgeForemansKOBoxingUSADoritosPromo)

struct BurnDriver BurnDrvrGeorgeForemansKOBoxingUSADoritosPromo = {
	"George Foreman's KO Boxing (USA) (Doritos Promo)", NULL, NULL, "1986",
	"George Foreman's KO Boxing (USA) (Doritos Promo)\0", NULL, "Nintendo", "Miscellaneous",
	L"George Foreman's KO Boxing (USA) (Doritos Promo)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGeorgeForemansKOBoxingUSADoritosPromoRomInfo, rGeorgeForemansKOBoxingUSADoritosPromoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGeorgeForemansKOBoxingUSARev1RomDesc[] = {
	{ "George Foreman's KO Boxing (USA) (Rev 1).sfc",          1048576, 0x15194fc9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGeorgeForemansKOBoxingUSARev1)
STD_ROM_FN(rGeorgeForemansKOBoxingUSARev1)

struct BurnDriver BurnDrvrGeorgeForemansKOBoxingUSARev1 = {
	"George Foreman's KO Boxing (USA) (Rev 1)", NULL, NULL, "1986",
	"George Foreman's KO Boxing (USA) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"George Foreman's KO Boxing (USA) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGeorgeForemansKOBoxingUSARev1RomInfo, rGeorgeForemansKOBoxingUSARev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGeorgeForemansKOBoxingUSARomDesc[] = {
	{ "George Foreman's KO Boxing (USA).sfc",          1048576, 0xaf571267, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGeorgeForemansKOBoxingUSA)
STD_ROM_FN(rGeorgeForemansKOBoxingUSA)

struct BurnDriver BurnDrvrGeorgeForemansKOBoxingUSA = {
	"George Foreman's KO Boxing (USA)", NULL, NULL, "1986",
	"George Foreman's KO Boxing (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"George Foreman's KO Boxing (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGeorgeForemansKOBoxingUSARomInfo, rGeorgeForemansKOBoxingUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGetintheHoleJapanRomDesc[] = {
	{ "Get in the Hole (Japan).sfc",          1572864, 0x7f0d601d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGetintheHoleJapan)
STD_ROM_FN(rGetintheHoleJapan)

struct BurnDriver BurnDrvrGetintheHoleJapan = {
	"Get in the Hole (Japan)", NULL, NULL, "1986",
	"Get in the Hole (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Get in the Hole (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGetintheHoleJapanRomInfo, rGetintheHoleJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGetsumennoAnubisJapanRomDesc[] = {
	{ "Getsumen no Anubis (Japan).sfc",          3145728, 0x78432ddc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGetsumennoAnubisJapan)
STD_ROM_FN(rGetsumennoAnubisJapan)

struct BurnDriver BurnDrvrGetsumennoAnubisJapan = {
	"Getsumen no Anubis (Japan)", NULL, NULL, "1986",
	"Getsumen no Anubis (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Getsumen no Anubis (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGetsumennoAnubisJapanRomInfo, rGetsumennoAnubisJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGhostChaserDenseiJapanRomDesc[] = {
	{ "Ghost Chaser Densei (Japan).sfc",          2097152, 0xdfd6385d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGhostChaserDenseiJapan)
STD_ROM_FN(rGhostChaserDenseiJapan)

struct BurnDriver BurnDrvrGhostChaserDenseiJapan = {
	"Ghost Chaser Densei (Japan)", NULL, NULL, "1986",
	"Ghost Chaser Densei (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ghost Chaser Densei (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGhostChaserDenseiJapanRomInfo, rGhostChaserDenseiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGhoulPatrolEuropeRomDesc[] = {
	{ "Ghoul Patrol (Europe).sfc",          1048576, 0x2c6cefe7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGhoulPatrolEurope)
STD_ROM_FN(rGhoulPatrolEurope)

struct BurnDriver BurnDrvrGhoulPatrolEurope = {
	"Ghoul Patrol (Europe)", NULL, NULL, "1986",
	"Ghoul Patrol (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ghoul Patrol (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGhoulPatrolEuropeRomInfo, rGhoulPatrolEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGhoulPatrolJapanRomDesc[] = {
	{ "Ghoul Patrol (Japan).sfc",          1048576, 0x5519af34, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGhoulPatrolJapan)
STD_ROM_FN(rGhoulPatrolJapan)

struct BurnDriver BurnDrvrGhoulPatrolJapan = {
	"Ghoul Patrol (Japan)", NULL, NULL, "1986",
	"Ghoul Patrol (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ghoul Patrol (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGhoulPatrolJapanRomInfo, rGhoulPatrolJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGhoulPatrolUSARomDesc[] = {
	{ "Ghoul Patrol (USA).sfc",          1048576, 0xea16b5a2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGhoulPatrolUSA)
STD_ROM_FN(rGhoulPatrolUSA)

struct BurnDriver BurnDrvrGhoulPatrolUSA = {
	"Ghoul Patrol (USA)", NULL, NULL, "1986",
	"Ghoul Patrol (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ghoul Patrol (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGhoulPatrolUSARomInfo, rGhoulPatrolUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGindamaOyakatanoPachinkoHisshouhouJapanRev1RomDesc[] = {
	{ "Gindama Oyakata no Pachinko Hisshouhou (Japan) (Rev 1).sfc",          1572864, 0xb8c7a417, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGindamaOyakatanoPachinkoHisshouhouJapanRev1)
STD_ROM_FN(rGindamaOyakatanoPachinkoHisshouhouJapanRev1)

struct BurnDriver BurnDrvrGindamaOyakatanoPachinkoHisshouhouJapanRev1 = {
	"Gindama Oyakata no Pachinko Hisshouhou (Japan) (Rev 1)", NULL, NULL, "1986",
	"Gindama Oyakata no Pachinko Hisshouhou (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gindama Oyakata no Pachinko Hisshouhou (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGindamaOyakatanoPachinkoHisshouhouJapanRev1RomInfo, rGindamaOyakatanoPachinkoHisshouhouJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGindamaOyakatanoPachinkoHisshouhouJapanRomDesc[] = {
	{ "Gindama Oyakata no Pachinko Hisshouhou (Japan).sfc",          1572864, 0x7adacc49, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGindamaOyakatanoPachinkoHisshouhouJapan)
STD_ROM_FN(rGindamaOyakatanoPachinkoHisshouhouJapan)

struct BurnDriver BurnDrvrGindamaOyakatanoPachinkoHisshouhouJapan = {
	"Gindama Oyakata no Pachinko Hisshouhou (Japan)", NULL, NULL, "1986",
	"Gindama Oyakata no Pachinko Hisshouhou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gindama Oyakata no Pachinko Hisshouhou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGindamaOyakatanoPachinkoHisshouhouJapanRomInfo, rGindamaOyakatanoPachinkoHisshouhouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGingaEiyuuDensetsuJapanRomDesc[] = {
	{ "Ginga Eiyuu Densetsu (Japan).sfc",          1048576, 0x2e480eef, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGingaEiyuuDensetsuJapan)
STD_ROM_FN(rGingaEiyuuDensetsuJapan)

struct BurnDriver BurnDrvrGingaEiyuuDensetsuJapan = {
	"Ginga Eiyuu Densetsu (Japan)", NULL, NULL, "1986",
	"Ginga Eiyuu Densetsu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ginga Eiyuu Densetsu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGingaEiyuuDensetsuJapanRomInfo, rGingaEiyuuDensetsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGingaSengokuGunyuudenRaiJapanRomDesc[] = {
	{ "Ginga Sengoku Gunyuuden Rai (Japan).sfc",          2097152, 0x98f76260, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGingaSengokuGunyuudenRaiJapan)
STD_ROM_FN(rGingaSengokuGunyuudenRaiJapan)

struct BurnDriver BurnDrvrGingaSengokuGunyuudenRaiJapan = {
	"Ginga Sengoku Gunyuuden Rai (Japan)", NULL, NULL, "1986",
	"Ginga Sengoku Gunyuuden Rai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ginga Sengoku Gunyuuden Rai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGingaSengokuGunyuudenRaiJapanRomInfo, rGingaSengokuGunyuudenRaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGionbanaJapanRomDesc[] = {
	{ "Gionbana (Japan).sfc",          1048576, 0x19309a2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGionbanaJapan)
STD_ROM_FN(rGionbanaJapan)

struct BurnDriver BurnDrvrGionbanaJapan = {
	"Gionbana (Japan)", NULL, NULL, "1986",
	"Gionbana (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gionbana (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGionbanaJapanRomInfo, rGionbanaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoGoAckmanJapanRomDesc[] = {
	{ "Go Go Ackman (Japan).sfc",          1310720, 0x26fb2d11, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoGoAckmanJapan)
STD_ROM_FN(rGoGoAckmanJapan)

struct BurnDriver BurnDrvrGoGoAckmanJapan = {
	"Go Go Ackman (Japan)", NULL, NULL, "1986",
	"Go Go Ackman (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Go Go Ackman (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoGoAckmanJapanRomInfo, rGoGoAckmanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoGoAckman2JapanRomDesc[] = {
	{ "Go Go Ackman 2 (Japan).sfc",          1572864, 0x76c7aa37, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoGoAckman2Japan)
STD_ROM_FN(rGoGoAckman2Japan)

struct BurnDriver BurnDrvrGoGoAckman2Japan = {
	"Go Go Ackman 2 (Japan)", NULL, NULL, "1986",
	"Go Go Ackman 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Go Go Ackman 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoGoAckman2JapanRomInfo, rGoGoAckman2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoGoAckman3JapanRomDesc[] = {
	{ "Go Go Ackman 3 (Japan).sfc",          2097152, 0x9a18290c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoGoAckman3Japan)
STD_ROM_FN(rGoGoAckman3Japan)

struct BurnDriver BurnDrvrGoGoAckman3Japan = {
	"Go Go Ackman 3 (Japan)", NULL, NULL, "1986",
	"Go Go Ackman 3 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Go Go Ackman 3 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoGoAckman3JapanRomInfo, rGoGoAckman3JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoGoDodgeLeagueJapanRev1RomDesc[] = {
	{ "Go! Go! Dodge League (Japan) (Rev 1).sfc",          524288, 0x6e6e66d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoGoDodgeLeagueJapanRev1)
STD_ROM_FN(rGoGoDodgeLeagueJapanRev1)

struct BurnDriver BurnDrvrGoGoDodgeLeagueJapanRev1 = {
	"Go! Go! Dodge League (Japan) (Rev 1)", NULL, NULL, "1986",
	"Go! Go! Dodge League (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Go! Go! Dodge League (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoGoDodgeLeagueJapanRev1RomInfo, rGoGoDodgeLeagueJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoGoDodgeLeagueJapanRomDesc[] = {
	{ "Go! Go! Dodge League (Japan).sfc",          524288, 0x184b07dc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoGoDodgeLeagueJapan)
STD_ROM_FN(rGoGoDodgeLeagueJapan)

struct BurnDriver BurnDrvrGoGoDodgeLeagueJapan = {
	"Go! Go! Dodge League (Japan)", NULL, NULL, "1986",
	"Go! Go! Dodge League (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Go! Go! Dodge League (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoGoDodgeLeagueJapanRomInfo, rGoGoDodgeLeagueJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoalUSARomDesc[] = {
	{ "Goal! (USA).sfc",          1048576, 0x935ea22c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoalUSA)
STD_ROM_FN(rGoalUSA)

struct BurnDriver BurnDrvrGoalUSA = {
	"Goal! (USA)", NULL, NULL, "1986",
	"Goal! (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Goal! (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoalUSARomInfo, rGoalUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGodsEuropeRomDesc[] = {
	{ "Gods (Europe).sfc",          1048576, 0x16416bb5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGodsEurope)
STD_ROM_FN(rGodsEurope)

struct BurnDriver BurnDrvrGodsEurope = {
	"Gods (Europe)", NULL, NULL, "1986",
	"Gods (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gods (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGodsEuropeRomInfo, rGodsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGodsUSARomDesc[] = {
	{ "Gods (USA).sfc",          1048576, 0x6779970f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGodsUSA)
STD_ROM_FN(rGodsUSA)

struct BurnDriver BurnDrvrGodsUSA = {
	"Gods (USA)", NULL, NULL, "1986",
	"Gods (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gods (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGodsUSARomInfo, rGodsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGodzillaKaijuuDaikessenJapanRomDesc[] = {
	{ "Godzilla - Kaijuu Daikessen (Japan).sfc",          2621440, 0x29ce8e57, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGodzillaKaijuuDaikessenJapan)
STD_ROM_FN(rGodzillaKaijuuDaikessenJapan)

struct BurnDriver BurnDrvrGodzillaKaijuuDaikessenJapan = {
	"Godzilla - Kaijuu Daikessen (Japan)", NULL, NULL, "1986",
	"Godzilla - Kaijuu Daikessen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Godzilla - Kaijuu Daikessen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGodzillaKaijuuDaikessenJapanRomInfo, rGodzillaKaijuuDaikessenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGokinjoBoukentaiJapanRomDesc[] = {
	{ "Gokinjo Boukentai (Japan).sfc",          2621440, 0x33374f65, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGokinjoBoukentaiJapan)
STD_ROM_FN(rGokinjoBoukentaiJapan)

struct BurnDriver BurnDrvrGokinjoBoukentaiJapan = {
	"Gokinjo Boukentai (Japan)", NULL, NULL, "1986",
	"Gokinjo Boukentai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gokinjo Boukentai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGokinjoBoukentaiJapanRomInfo, rGokinjoBoukentaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGokujouParodiusJapanBetaRomDesc[] = {
	{ "Gokujou Parodius (Japan) (Beta).sfc",          2097152, 0x56fe0a74, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGokujouParodiusJapanBeta)
STD_ROM_FN(rGokujouParodiusJapanBeta)

struct BurnDriver BurnDrvrGokujouParodiusJapanBeta = {
	"Gokujou Parodius (Japan) (Beta)", NULL, NULL, "1986",
	"Gokujou Parodius (Japan) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gokujou Parodius (Japan) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGokujouParodiusJapanBetaRomInfo, rGokujouParodiusJapanBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGokujouParodiusJapanRomDesc[] = {
	{ "Gokujou Parodius (Japan).sfc",          2097152, 0x4ee98ed, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGokujouParodiusJapan)
STD_ROM_FN(rGokujouParodiusJapan)

struct BurnDriver BurnDrvrGokujouParodiusJapan = {
	"Gokujou Parodius (Japan)", NULL, NULL, "1986",
	"Gokujou Parodius (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gokujou Parodius (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGokujouParodiusJapanRomInfo, rGokujouParodiusJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGolfDaisukiOBClubJapanBSRomDesc[] = {
	{ "Golf Daisuki! O.B. Club (Japan) (BS).sfc",          1048576, 0xdc00efeb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGolfDaisukiOBClubJapanBS)
STD_ROM_FN(rGolfDaisukiOBClubJapanBS)

struct BurnDriver BurnDrvrGolfDaisukiOBClubJapanBS = {
	"Golf Daisuki! O.B. Club (Japan) (BS)", NULL, NULL, "1986",
	"Golf Daisuki! O.B. Club (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Golf Daisuki! O.B. Club (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGolfDaisukiOBClubJapanBSRomInfo, rGolfDaisukiOBClubJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGonJapanRomDesc[] = {
	{ "Gon (Japan).sfc",          1048576, 0x426881a3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGonJapan)
STD_ROM_FN(rGonJapan)

struct BurnDriver BurnDrvrGonJapan = {
	"Gon (Japan)", NULL, NULL, "1986",
	"Gon (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gon (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGonJapanRomInfo, rGonJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoodsPress3GatsugouJapanBSRomDesc[] = {
	{ "GoodsPress - 3 Gatsugou (Japan) (BS).sfc",          1048576, 0xe328adee, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoodsPress3GatsugouJapanBS)
STD_ROM_FN(rGoodsPress3GatsugouJapanBS)

struct BurnDriver BurnDrvrGoodsPress3GatsugouJapanBS = {
	"GoodsPress - 3 Gatsugou (Japan) (BS)", NULL, NULL, "1986",
	"GoodsPress - 3 Gatsugou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"GoodsPress - 3 Gatsugou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoodsPress3GatsugouJapanBSRomInfo, rGoodsPress3GatsugouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoodsPress6GatsugouJapanBSRomDesc[] = {
	{ "GoodsPress - 6 Gatsugou (Japan) (BS).sfc",          524288, 0xfba1273b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoodsPress6GatsugouJapanBS)
STD_ROM_FN(rGoodsPress6GatsugouJapanBS)

struct BurnDriver BurnDrvrGoodsPress6GatsugouJapanBS = {
	"GoodsPress - 6 Gatsugou (Japan) (BS)", NULL, NULL, "1986",
	"GoodsPress - 6 Gatsugou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"GoodsPress - 6 Gatsugou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoodsPress6GatsugouJapanBSRomInfo, rGoodsPress6GatsugouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoodsPress7GatsugouJapanBSRomDesc[] = {
	{ "GoodsPress - 7 Gatsugou (Japan) (BS).sfc",          1048576, 0x83611a0c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoodsPress7GatsugouJapanBS)
STD_ROM_FN(rGoodsPress7GatsugouJapanBS)

struct BurnDriver BurnDrvrGoodsPress7GatsugouJapanBS = {
	"GoodsPress - 7 Gatsugou (Japan) (BS)", NULL, NULL, "1986",
	"GoodsPress - 7 Gatsugou (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"GoodsPress - 7 Gatsugou (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoodsPress7GatsugouJapanBSRomInfo, rGoodsPress7GatsugouJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoofTroopEuropeRomDesc[] = {
	{ "Goof Troop (Europe).sfc",          524288, 0x61e8f56a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoofTroopEurope)
STD_ROM_FN(rGoofTroopEurope)

struct BurnDriver BurnDrvrGoofTroopEurope = {
	"Goof Troop (Europe)", NULL, NULL, "1986",
	"Goof Troop (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Goof Troop (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoofTroopEuropeRomInfo, rGoofTroopEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoofTroopFranceRomDesc[] = {
	{ "Goof Troop (France).sfc",          524288, 0x4fe6077a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoofTroopFrance)
STD_ROM_FN(rGoofTroopFrance)

struct BurnDriver BurnDrvrGoofTroopFrance = {
	"Goof Troop (France)", NULL, NULL, "1986",
	"Goof Troop (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"Goof Troop (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoofTroopFranceRomInfo, rGoofTroopFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoofTroopGermanyRomDesc[] = {
	{ "Goof Troop (Germany).sfc",          524288, 0xaa69ef05, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoofTroopGermany)
STD_ROM_FN(rGoofTroopGermany)

struct BurnDriver BurnDrvrGoofTroopGermany = {
	"Goof Troop (Germany)", NULL, NULL, "1986",
	"Goof Troop (Germany)\0", NULL, "Nintendo", "Miscellaneous",
	L"Goof Troop (Germany)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoofTroopGermanyRomInfo, rGoofTroopGermanyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoofTroopUSARomDesc[] = {
	{ "Goof Troop (USA).sfc",          524288, 0x4aafa462, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoofTroopUSA)
STD_ROM_FN(rGoofTroopUSA)

struct BurnDriver BurnDrvrGoofTroopUSA = {
	"Goof Troop (USA)", NULL, NULL, "1986",
	"Goof Troop (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Goof Troop (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoofTroopUSARomInfo, rGoofTroopUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGoofytoMaxKaizokujimanoDaiboukenJapanRomDesc[] = {
	{ "Goofy to Max - Kaizoku-jima no Daibouken (Japan).sfc",          524288, 0xd3279aac, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGoofytoMaxKaizokujimanoDaiboukenJapan)
STD_ROM_FN(rGoofytoMaxKaizokujimanoDaiboukenJapan)

struct BurnDriver BurnDrvrGoofytoMaxKaizokujimanoDaiboukenJapan = {
	"Goofy to Max - Kaizoku-jima no Daibouken (Japan)", NULL, NULL, "1986",
	"Goofy to Max - Kaizoku-jima no Daibouken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Goofy to Max - Kaizoku-jima no Daibouken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGoofytoMaxKaizokujimanoDaiboukenJapanRomInfo, rGoofytoMaxKaizokujimanoDaiboukenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGouketsujiIchizokuJapanRomDesc[] = {
	{ "Gouketsuji Ichizoku (Japan).sfc",          3145728, 0xbaf084ee, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGouketsujiIchizokuJapan)
STD_ROM_FN(rGouketsujiIchizokuJapan)

struct BurnDriver BurnDrvrGouketsujiIchizokuJapan = {
	"Gouketsuji Ichizoku (Japan)", NULL, NULL, "1986",
	"Gouketsuji Ichizoku (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gouketsuji Ichizoku (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGouketsujiIchizokuJapanRomInfo, rGouketsujiIchizokuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGourmetSentaiBarayarouJapanRomDesc[] = {
	{ "Gourmet Sentai Barayarou (Japan).sfc",          2097152, 0x9f717d76, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGourmetSentaiBarayarouJapan)
STD_ROM_FN(rGourmetSentaiBarayarouJapan)

struct BurnDriver BurnDrvrGourmetSentaiBarayarouJapan = {
	"Gourmet Sentai Barayarou (Japan)", NULL, NULL, "1986",
	"Gourmet Sentai Barayarou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gourmet Sentai Barayarou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGourmetSentaiBarayarouJapanRomInfo, rGourmetSentaiBarayarouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGousouJinraiDensetsuMushaJapanRomDesc[] = {
	{ "Gousou Jinrai Densetsu - Musha (Japan).sfc",          1048576, 0x342f1c02, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGousouJinraiDensetsuMushaJapan)
STD_ROM_FN(rGousouJinraiDensetsuMushaJapan)

struct BurnDriver BurnDrvrGousouJinraiDensetsuMushaJapan = {
	"Gousou Jinrai Densetsu - Musha (Japan)", NULL, NULL, "1986",
	"Gousou Jinrai Densetsu - Musha (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gousou Jinrai Densetsu - Musha (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGousouJinraiDensetsuMushaJapanRomInfo, rGousouJinraiDensetsuMushaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGP1EuropeRomDesc[] = {
	{ "GP-1 (Europe).sfc",          1048576, 0xd013316b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGP1Europe)
STD_ROM_FN(rGP1Europe)

struct BurnDriver BurnDrvrGP1Europe = {
	"GP-1 (Europe)", NULL, NULL, "1986",
	"GP-1 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"GP-1 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGP1EuropeRomInfo, rGP1EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGP1JapanRomDesc[] = {
	{ "GP-1 (Japan).sfc",          1048576, 0x1895299c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGP1Japan)
STD_ROM_FN(rGP1Japan)

struct BurnDriver BurnDrvrGP1Japan = {
	"GP-1 (Japan)", NULL, NULL, "1986",
	"GP-1 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"GP-1 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGP1JapanRomInfo, rGP1JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGP1USARomDesc[] = {
	{ "GP-1 (USA).sfc",          1048576, 0x14bbc357, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGP1USA)
STD_ROM_FN(rGP1USA)

struct BurnDriver BurnDrvrGP1USA = {
	"GP-1 (USA)", NULL, NULL, "1986",
	"GP-1 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"GP-1 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGP1USARomInfo, rGP1USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGP1PartIIUSARomDesc[] = {
	{ "GP-1 - Part II (USA).sfc",          1572864, 0xa9014e12, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGP1PartIIUSA)
STD_ROM_FN(rGP1PartIIUSA)

struct BurnDriver BurnDrvrGP1PartIIUSA = {
	"GP-1 - Part II (USA)", NULL, NULL, "1986",
	"GP-1 - Part II (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"GP-1 - Part II (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGP1PartIIUSARomInfo, rGP1PartIIUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGP1RSRapidStreamJapanRomDesc[] = {
	{ "GP-1 RS - Rapid Stream (Japan).sfc",          1572864, 0xd4488768, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGP1RSRapidStreamJapan)
STD_ROM_FN(rGP1RSRapidStreamJapan)

struct BurnDriver BurnDrvrGP1RSRapidStreamJapan = {
	"GP-1 RS - Rapid Stream (Japan)", NULL, NULL, "1986",
	"GP-1 RS - Rapid Stream (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"GP-1 RS - Rapid Stream (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGP1RSRapidStreamJapanRomInfo, rGP1RSRapidStreamJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGradiusIIIJapanRomDesc[] = {
	{ "Gradius III (Japan).sfc",          524288, 0xbca9ab02, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGradiusIIIJapan)
STD_ROM_FN(rGradiusIIIJapan)

struct BurnDriver BurnDrvrGradiusIIIJapan = {
	"Gradius III (Japan)", NULL, NULL, "1986",
	"Gradius III (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gradius III (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGradiusIIIJapanRomInfo, rGradiusIIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGradiusIIIUSARomDesc[] = {
	{ "Gradius III (USA).sfc",          524288, 0xcd973979, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGradiusIIIUSA)
STD_ROM_FN(rGradiusIIIUSA)

struct BurnDriver BurnDrvrGradiusIIIUSA = {
	"Gradius III (USA)", NULL, NULL, "1986",
	"Gradius III (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Gradius III (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGradiusIIIUSARomInfo, rGradiusIIIUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGranhistoriaGenshiSekaikiJapanRomDesc[] = {
	{ "Granhistoria - Genshi Sekaiki (Japan).sfc",          2097152, 0x4aa7f384, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGranhistoriaGenshiSekaikiJapan)
STD_ROM_FN(rGranhistoriaGenshiSekaikiJapan)

struct BurnDriver BurnDrvrGranhistoriaGenshiSekaikiJapan = {
	"Granhistoria - Genshi Sekaiki (Japan)", NULL, NULL, "1986",
	"Granhistoria - Genshi Sekaiki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Granhistoria - Genshi Sekaiki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGranhistoriaGenshiSekaikiJapanRomInfo, rGranhistoriaGenshiSekaikiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGreatBattleGaiden2TheMatsuridaWasshoiJapanRomDesc[] = {
	{ "Great Battle Gaiden 2, The - Matsuri da Wasshoi (Japan).sfc",          1310720, 0x83806e38, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGreatBattleGaiden2TheMatsuridaWasshoiJapan)
STD_ROM_FN(rGreatBattleGaiden2TheMatsuridaWasshoiJapan)

struct BurnDriver BurnDrvrGreatBattleGaiden2TheMatsuridaWasshoiJapan = {
	"Great Battle Gaiden 2, The - Matsuri da Wasshoi (Japan)", NULL, NULL, "1986",
	"Great Battle Gaiden 2, The - Matsuri da Wasshoi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Great Battle Gaiden 2, The - Matsuri da Wasshoi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGreatBattleGaiden2TheMatsuridaWasshoiJapanRomInfo, rGreatBattleGaiden2TheMatsuridaWasshoiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGreatBattleIITheLastFighterTwinJapanRomDesc[] = {
	{ "Great Battle II, The - Last Fighter Twin (Japan).sfc",          1048576, 0x8254a32e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGreatBattleIITheLastFighterTwinJapan)
STD_ROM_FN(rGreatBattleIITheLastFighterTwinJapan)

struct BurnDriver BurnDrvrGreatBattleIITheLastFighterTwinJapan = {
	"Great Battle II, The - Last Fighter Twin (Japan)", NULL, NULL, "1986",
	"Great Battle II, The - Last Fighter Twin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Great Battle II, The - Last Fighter Twin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGreatBattleIITheLastFighterTwinJapanRomInfo, rGreatBattleIITheLastFighterTwinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGreatBattleIIITheJapanRomDesc[] = {
	{ "Great Battle III, The (Japan).sfc",          1310720, 0xb311df48, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGreatBattleIIITheJapan)
STD_ROM_FN(rGreatBattleIIITheJapan)

struct BurnDriver BurnDrvrGreatBattleIIITheJapan = {
	"Great Battle III, The (Japan)", NULL, NULL, "1986",
	"Great Battle III, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Great Battle III, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGreatBattleIIITheJapanRomInfo, rGreatBattleIIITheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGreatBattleIVTheJapanSampleRomDesc[] = {
	{ "Great Battle IV, The (Japan) (Sample).sfc",          1572864, 0x615c4aa7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGreatBattleIVTheJapanSample)
STD_ROM_FN(rGreatBattleIVTheJapanSample)

struct BurnDriver BurnDrvrGreatBattleIVTheJapanSample = {
	"Great Battle IV, The (Japan) (Sample)", NULL, NULL, "1986",
	"Great Battle IV, The (Japan) (Sample)\0", NULL, "Nintendo", "Miscellaneous",
	L"Great Battle IV, The (Japan) (Sample)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGreatBattleIVTheJapanSampleRomInfo, rGreatBattleIVTheJapanSampleRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGreatBattleIVTheJapanRomDesc[] = {
	{ "Great Battle IV, The (Japan).sfc",          1572864, 0xfb165a32, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGreatBattleIVTheJapan)
STD_ROM_FN(rGreatBattleIVTheJapan)

struct BurnDriver BurnDrvrGreatBattleIVTheJapan = {
	"Great Battle IV, The (Japan)", NULL, NULL, "1986",
	"Great Battle IV, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Great Battle IV, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGreatBattleIVTheJapanRomInfo, rGreatBattleIVTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGreatBattleVTheJapanRomDesc[] = {
	{ "Great Battle V, The (Japan).sfc",          1572864, 0xbf3c9314, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGreatBattleVTheJapan)
STD_ROM_FN(rGreatBattleVTheJapan)

struct BurnDriver BurnDrvrGreatBattleVTheJapan = {
	"Great Battle V, The (Japan)", NULL, NULL, "1986",
	"Great Battle V, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Great Battle V, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGreatBattleVTheJapanRomInfo, rGreatBattleVTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGreatCircusMysteryStarringMickeyMinnieTheEuropeRomDesc[] = {
	{ "Great Circus Mystery Starring Mickey & Minnie, The (Europe).sfc",          1572864, 0x7de42137, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGreatCircusMysteryStarringMickeyMinnieTheEurope)
STD_ROM_FN(rGreatCircusMysteryStarringMickeyMinnieTheEurope)

struct BurnDriver BurnDrvrGreatCircusMysteryStarringMickeyMinnieTheEurope = {
	"Great Circus Mystery Starring Mickey & Minnie, The (Europe)", NULL, NULL, "1986",
	"Great Circus Mystery Starring Mickey & Minnie, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Great Circus Mystery Starring Mickey & Minnie, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGreatCircusMysteryStarringMickeyMinnieTheEuropeRomInfo, rGreatCircusMysteryStarringMickeyMinnieTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGreatCircusMysteryStarringMickeyMinnieTheUSARomDesc[] = {
	{ "Great Circus Mystery Starring Mickey & Minnie, The (USA).sfc",          1572864, 0x1903ea89, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGreatCircusMysteryStarringMickeyMinnieTheUSA)
STD_ROM_FN(rGreatCircusMysteryStarringMickeyMinnieTheUSA)

struct BurnDriver BurnDrvrGreatCircusMysteryStarringMickeyMinnieTheUSA = {
	"Great Circus Mystery Starring Mickey & Minnie, The (USA)", NULL, NULL, "1986",
	"Great Circus Mystery Starring Mickey & Minnie, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Great Circus Mystery Starring Mickey & Minnie, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGreatCircusMysteryStarringMickeyMinnieTheUSARomInfo, rGreatCircusMysteryStarringMickeyMinnieTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGreatWaldoSearchTheUSARomDesc[] = {
	{ "Great Waldo Search, The (USA).sfc",          524288, 0xeb49f246, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGreatWaldoSearchTheUSA)
STD_ROM_FN(rGreatWaldoSearchTheUSA)

struct BurnDriver BurnDrvrGreatWaldoSearchTheUSA = {
	"Great Waldo Search, The (USA)", NULL, NULL, "1986",
	"Great Waldo Search, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Great Waldo Search, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGreatWaldoSearchTheUSARomInfo, rGreatWaldoSearchTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGSMikamiJoreishiwaNiceBodyJapanRomDesc[] = {
	{ "GS Mikami - Joreishi wa Nice Body (Japan).sfc",          1048576, 0x444c9962, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGSMikamiJoreishiwaNiceBodyJapan)
STD_ROM_FN(rGSMikamiJoreishiwaNiceBodyJapan)

struct BurnDriver BurnDrvrGSMikamiJoreishiwaNiceBodyJapan = {
	"GS Mikami - Joreishi wa Nice Body (Japan)", NULL, NULL, "1986",
	"GS Mikami - Joreishi wa Nice Body (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"GS Mikami - Joreishi wa Nice Body (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGSMikamiJoreishiwaNiceBodyJapanRomInfo, rGSMikamiJoreishiwaNiceBodyJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGTRacingJapanRomDesc[] = {
	{ "GT Racing (Japan).sfc",          2097152, 0x1f73c832, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGTRacingJapan)
STD_ROM_FN(rGTRacingJapan)

struct BurnDriver BurnDrvrGTRacingJapan = {
	"GT Racing (Japan)", NULL, NULL, "1986",
	"GT Racing (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"GT Racing (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGTRacingJapanRomInfo, rGTRacingJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGunForceBattleFireEngulfedTerrorIslandEuropeProtoRomDesc[] = {
	{ "GunForce - Battle Fire Engulfed Terror Island (Europe) (Proto).sfc",          524288, 0x11af8992, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGunForceBattleFireEngulfedTerrorIslandEuropeProto)
STD_ROM_FN(rGunForceBattleFireEngulfedTerrorIslandEuropeProto)

struct BurnDriver BurnDrvrGunForceBattleFireEngulfedTerrorIslandEuropeProto = {
	"GunForce - Battle Fire Engulfed Terror Island (Europe) (Proto)", NULL, NULL, "1986",
	"GunForce - Battle Fire Engulfed Terror Island (Europe) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"GunForce - Battle Fire Engulfed Terror Island (Europe) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGunForceBattleFireEngulfedTerrorIslandEuropeProtoRomInfo, rGunForceBattleFireEngulfedTerrorIslandEuropeProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGunForceBattleFireEngulfedTerrorIslandJapanRomDesc[] = {
	{ "GunForce - Battle Fire Engulfed Terror Island (Japan).sfc",          524288, 0xeeafd816, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGunForceBattleFireEngulfedTerrorIslandJapan)
STD_ROM_FN(rGunForceBattleFireEngulfedTerrorIslandJapan)

struct BurnDriver BurnDrvrGunForceBattleFireEngulfedTerrorIslandJapan = {
	"GunForce - Battle Fire Engulfed Terror Island (Japan)", NULL, NULL, "1986",
	"GunForce - Battle Fire Engulfed Terror Island (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"GunForce - Battle Fire Engulfed Terror Island (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGunForceBattleFireEngulfedTerrorIslandJapanRomInfo, rGunForceBattleFireEngulfedTerrorIslandJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rGunForceBattleFireEngulfedTerrorIslandUSARomDesc[] = {
	{ "GunForce - Battle Fire Engulfed Terror Island (USA).sfc",          524288, 0x6f5c5dc0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rGunForceBattleFireEngulfedTerrorIslandUSA)
STD_ROM_FN(rGunForceBattleFireEngulfedTerrorIslandUSA)

struct BurnDriver BurnDrvrGunForceBattleFireEngulfedTerrorIslandUSA = {
	"GunForce - Battle Fire Engulfed Terror Island (USA)", NULL, NULL, "1986",
	"GunForce - Battle Fire Engulfed Terror Island (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"GunForce - Battle Fire Engulfed Terror Island (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rGunForceBattleFireEngulfedTerrorIslandUSARomInfo, rGunForceBattleFireEngulfedTerrorIslandUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHabuMeijinnoOmoshiroShougiJapanRomDesc[] = {
	{ "Habu Meijin no Omoshiro Shougi (Japan).sfc",          1048576, 0x4c1b8801, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHabuMeijinnoOmoshiroShougiJapan)
STD_ROM_FN(rHabuMeijinnoOmoshiroShougiJapan)

struct BurnDriver BurnDrvrHabuMeijinnoOmoshiroShougiJapan = {
	"Habu Meijin no Omoshiro Shougi (Japan)", NULL, NULL, "1986",
	"Habu Meijin no Omoshiro Shougi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Habu Meijin no Omoshiro Shougi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHabuMeijinnoOmoshiroShougiJapanRomInfo, rHabuMeijinnoOmoshiroShougiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHaganeJapanBetaRomDesc[] = {
	{ "Hagane (Japan) (Beta).sfc",          2097152, 0xf0bc3837, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHaganeJapanBeta)
STD_ROM_FN(rHaganeJapanBeta)

struct BurnDriver BurnDrvrHaganeJapanBeta = {
	"Hagane (Japan) (Beta)", NULL, NULL, "1986",
	"Hagane (Japan) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hagane (Japan) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHaganeJapanBetaRomInfo, rHaganeJapanBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHaganeJapanRomDesc[] = {
	{ "Hagane (Japan).sfc",          2097152, 0x63245cac, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHaganeJapan)
STD_ROM_FN(rHaganeJapan)

struct BurnDriver BurnDrvrHaganeJapan = {
	"Hagane (Japan)", NULL, NULL, "1986",
	"Hagane (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hagane (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHaganeJapanRomInfo, rHaganeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHaganeTheFinalConflictEuropeRomDesc[] = {
	{ "Hagane - The Final Conflict (Europe).sfc",          2097152, 0x7f6ccf00, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHaganeTheFinalConflictEurope)
STD_ROM_FN(rHaganeTheFinalConflictEurope)

struct BurnDriver BurnDrvrHaganeTheFinalConflictEurope = {
	"Hagane - The Final Conflict (Europe)", NULL, NULL, "1986",
	"Hagane - The Final Conflict (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hagane - The Final Conflict (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHaganeTheFinalConflictEuropeRomInfo, rHaganeTheFinalConflictEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHaganeTheFinalConflictUSARomDesc[] = {
	{ "Hagane - The Final Conflict (USA).sfc",          2097152, 0x8e0a7034, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHaganeTheFinalConflictUSA)
STD_ROM_FN(rHaganeTheFinalConflictUSA)

struct BurnDriver BurnDrvrHaganeTheFinalConflictUSA = {
	"Hagane - The Final Conflict (USA)", NULL, NULL, "1986",
	"Hagane - The Final Conflict (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hagane - The Final Conflict (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHaganeTheFinalConflictUSARomInfo, rHaganeTheFinalConflictUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHaiseiMahjongRyougaJapanRomDesc[] = {
	{ "Haisei Mahjong - Ryouga (Japan).sfc",          1048576, 0xcf7b57e0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHaiseiMahjongRyougaJapan)
STD_ROM_FN(rHaiseiMahjongRyougaJapan)

struct BurnDriver BurnDrvrHaiseiMahjongRyougaJapan = {
	"Haisei Mahjong - Ryouga (Japan)", NULL, NULL, "1986",
	"Haisei Mahjong - Ryouga (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Haisei Mahjong - Ryouga (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHaiseiMahjongRyougaJapanRomInfo, rHaiseiMahjongRyougaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHakunetsuProYakyuu93GanbaLeagueJapanRomDesc[] = {
	{ "Hakunetsu Pro Yakyuu '93 - Ganba League (Japan).sfc",          1572864, 0xa539cbc8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHakunetsuProYakyuu93GanbaLeagueJapan)
STD_ROM_FN(rHakunetsuProYakyuu93GanbaLeagueJapan)

struct BurnDriver BurnDrvrHakunetsuProYakyuu93GanbaLeagueJapan = {
	"Hakunetsu Pro Yakyuu '93 - Ganba League (Japan)", NULL, NULL, "1986",
	"Hakunetsu Pro Yakyuu '93 - Ganba League (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hakunetsu Pro Yakyuu '93 - Ganba League (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHakunetsuProYakyuu93GanbaLeagueJapanRomInfo, rHakunetsuProYakyuu93GanbaLeagueJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHakunetsuProYakyuu94GanbaLeague3JapanRomDesc[] = {
	{ "Hakunetsu Pro Yakyuu '94 - Ganba League 3 (Japan).sfc",          1048576, 0x1b33d93c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHakunetsuProYakyuu94GanbaLeague3Japan)
STD_ROM_FN(rHakunetsuProYakyuu94GanbaLeague3Japan)

struct BurnDriver BurnDrvrHakunetsuProYakyuu94GanbaLeague3Japan = {
	"Hakunetsu Pro Yakyuu '94 - Ganba League 3 (Japan)", NULL, NULL, "1986",
	"Hakunetsu Pro Yakyuu '94 - Ganba League 3 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hakunetsu Pro Yakyuu '94 - Ganba League 3 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHakunetsuProYakyuu94GanbaLeague3JapanRomInfo, rHakunetsuProYakyuu94GanbaLeague3JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHakunetsuProYakyuuGanbaLeagueJapanRev1RomDesc[] = {
	{ "Hakunetsu Pro Yakyuu - Ganba League (Japan) (Rev 1).sfc",          1048576, 0x702446b7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHakunetsuProYakyuuGanbaLeagueJapanRev1)
STD_ROM_FN(rHakunetsuProYakyuuGanbaLeagueJapanRev1)

struct BurnDriver BurnDrvrHakunetsuProYakyuuGanbaLeagueJapanRev1 = {
	"Hakunetsu Pro Yakyuu - Ganba League (Japan) (Rev 1)", NULL, NULL, "1986",
	"Hakunetsu Pro Yakyuu - Ganba League (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hakunetsu Pro Yakyuu - Ganba League (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHakunetsuProYakyuuGanbaLeagueJapanRev1RomInfo, rHakunetsuProYakyuuGanbaLeagueJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHakunetsuProYakyuuGanbaLeagueJapanRomDesc[] = {
	{ "Hakunetsu Pro Yakyuu - Ganba League (Japan).sfc",          1048576, 0xc7168fcb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHakunetsuProYakyuuGanbaLeagueJapan)
STD_ROM_FN(rHakunetsuProYakyuuGanbaLeagueJapan)

struct BurnDriver BurnDrvrHakunetsuProYakyuuGanbaLeagueJapan = {
	"Hakunetsu Pro Yakyuu - Ganba League (Japan)", NULL, NULL, "1986",
	"Hakunetsu Pro Yakyuu - Ganba League (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hakunetsu Pro Yakyuu - Ganba League (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHakunetsuProYakyuuGanbaLeagueJapanRomInfo, rHakunetsuProYakyuuGanbaLeagueJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHALsHoleinOneGolfEuropeRomDesc[] = {
	{ "HAL's Hole in One Golf (Europe).sfc",          1048576, 0x27c87d04, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHALsHoleinOneGolfEurope)
STD_ROM_FN(rHALsHoleinOneGolfEurope)

struct BurnDriver BurnDrvrHALsHoleinOneGolfEurope = {
	"HAL's Hole in One Golf (Europe)", NULL, NULL, "1986",
	"HAL's Hole in One Golf (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"HAL's Hole in One Golf (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHALsHoleinOneGolfEuropeRomInfo, rHALsHoleinOneGolfEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHALsHoleinOneGolfUSARomDesc[] = {
	{ "HAL's Hole in One Golf (USA).sfc",          1048576, 0x58752baf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHALsHoleinOneGolfUSA)
STD_ROM_FN(rHALsHoleinOneGolfUSA)

struct BurnDriver BurnDrvrHALsHoleinOneGolfUSA = {
	"HAL's Hole in One Golf (USA)", NULL, NULL, "1986",
	"HAL's Hole in One Golf (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"HAL's Hole in One Golf (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHALsHoleinOneGolfUSARomInfo, rHALsHoleinOneGolfUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHamelnnoViolinHikiJapanRomDesc[] = {
	{ "Hameln no Violin Hiki (Japan).sfc",          1572864, 0xfb500926, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHamelnnoViolinHikiJapan)
STD_ROM_FN(rHamelnnoViolinHikiJapan)

struct BurnDriver BurnDrvrHamelnnoViolinHikiJapan = {
	"Hameln no Violin Hiki (Japan)", NULL, NULL, "1986",
	"Hameln no Violin Hiki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hameln no Violin Hiki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHamelnnoViolinHikiJapanRomInfo, rHamelnnoViolinHikiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHammerlockWrestlingUSARomDesc[] = {
	{ "Hammerlock Wrestling (USA).sfc",          2097152, 0x3d2352ea, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHammerlockWrestlingUSA)
STD_ROM_FN(rHammerlockWrestlingUSA)

struct BurnDriver BurnDrvrHammerlockWrestlingUSA = {
	"Hammerlock Wrestling (USA)", NULL, NULL, "1986",
	"Hammerlock Wrestling (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hammerlock Wrestling (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHammerlockWrestlingUSARomInfo, rHammerlockWrestlingUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHananoKeijiKumonoKanataniJapanRomDesc[] = {
	{ "Hana no Keiji - Kumo no Kanata ni (Japan).sfc",          2097152, 0xdc2b90f2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHananoKeijiKumonoKanataniJapan)
STD_ROM_FN(rHananoKeijiKumonoKanataniJapan)

struct BurnDriver BurnDrvrHananoKeijiKumonoKanataniJapan = {
	"Hana no Keiji - Kumo no Kanata ni (Japan)", NULL, NULL, "1986",
	"Hana no Keiji - Kumo no Kanata ni (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hana no Keiji - Kumo no Kanata ni (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHananoKeijiKumonoKanataniJapanRomInfo, rHananoKeijiKumonoKanataniJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHanafudaOuJapanRomDesc[] = {
	{ "Hanafuda Ou (Japan).sfc",          524288, 0x4f453a21, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHanafudaOuJapan)
STD_ROM_FN(rHanafudaOuJapan)

struct BurnDriver BurnDrvrHanafudaOuJapan = {
	"Hanafuda Ou (Japan)", NULL, NULL, "1986",
	"Hanafuda Ou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hanafuda Ou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHanafudaOuJapanRomInfo, rHanafudaOuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHangukProYaguKoreaRomDesc[] = {
	{ "Hanguk Pro Yagu (Korea).sfc",          1572864, 0xa21fb1d5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHangukProYaguKorea)
STD_ROM_FN(rHangukProYaguKorea)

struct BurnDriver BurnDrvrHangukProYaguKorea = {
	"Hanguk Pro Yagu (Korea)", NULL, NULL, "1986",
	"Hanguk Pro Yagu (Korea)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hanguk Pro Yagu (Korea)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHangukProYaguKoreaRomInfo, rHangukProYaguKoreaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHanjukuHeroAhSekaiyoHanjukuNareJapanRomDesc[] = {
	{ "Hanjuku Hero - Ah, Sekai yo Hanjuku Nare...!! (Japan).sfc",          1048576, 0xd191ad46, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHanjukuHeroAhSekaiyoHanjukuNareJapan)
STD_ROM_FN(rHanjukuHeroAhSekaiyoHanjukuNareJapan)

struct BurnDriver BurnDrvrHanjukuHeroAhSekaiyoHanjukuNareJapan = {
	"Hanjuku Hero - Ah, Sekai yo Hanjuku Nare...!! (Japan)", NULL, NULL, "1986",
	"Hanjuku Hero - Ah, Sekai yo Hanjuku Nare...!! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hanjuku Hero - Ah, Sekai yo Hanjuku Nare...!! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHanjukuHeroAhSekaiyoHanjukuNareJapanRomInfo, rHanjukuHeroAhSekaiyoHanjukuNareJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHanseiZaruJirokunnoDaiboukenJapanRomDesc[] = {
	{ "Hansei Zaru Jiro-kun no Daibouken (Japan).sfc",          524288, 0xa7dc25d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHanseiZaruJirokunnoDaiboukenJapan)
STD_ROM_FN(rHanseiZaruJirokunnoDaiboukenJapan)

struct BurnDriver BurnDrvrHanseiZaruJirokunnoDaiboukenJapan = {
	"Hansei Zaru Jiro-kun no Daibouken (Japan)", NULL, NULL, "1986",
	"Hansei Zaru Jiro-kun no Daibouken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hansei Zaru Jiro-kun no Daibouken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHanseiZaruJirokunnoDaiboukenJapanRomInfo, rHanseiZaruJirokunnoDaiboukenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHaouTaikeiRyuuKnightLordofPaladinJapanRev1RomDesc[] = {
	{ "Haou Taikei Ryuu Knight - Lord of Paladin (Japan) (Rev 1).sfc",          1572864, 0x2740560b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHaouTaikeiRyuuKnightLordofPaladinJapanRev1)
STD_ROM_FN(rHaouTaikeiRyuuKnightLordofPaladinJapanRev1)

struct BurnDriver BurnDrvrHaouTaikeiRyuuKnightLordofPaladinJapanRev1 = {
	"Haou Taikei Ryuu Knight - Lord of Paladin (Japan) (Rev 1)", NULL, NULL, "1986",
	"Haou Taikei Ryuu Knight - Lord of Paladin (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Haou Taikei Ryuu Knight - Lord of Paladin (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHaouTaikeiRyuuKnightLordofPaladinJapanRev1RomInfo, rHaouTaikeiRyuuKnightLordofPaladinJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHaouTaikeiRyuuKnightLordofPaladinJapanRomDesc[] = {
	{ "Haou Taikei Ryuu Knight - Lord of Paladin (Japan).sfc",          1572864, 0xb7b6bef7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHaouTaikeiRyuuKnightLordofPaladinJapan)
STD_ROM_FN(rHaouTaikeiRyuuKnightLordofPaladinJapan)

struct BurnDriver BurnDrvrHaouTaikeiRyuuKnightLordofPaladinJapan = {
	"Haou Taikei Ryuu Knight - Lord of Paladin (Japan)", NULL, NULL, "1986",
	"Haou Taikei Ryuu Knight - Lord of Paladin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Haou Taikei Ryuu Knight - Lord of Paladin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHaouTaikeiRyuuKnightLordofPaladinJapanRomInfo, rHaouTaikeiRyuuKnightLordofPaladinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHarapekoBakkaJapanRomDesc[] = {
	{ "Harapeko Bakka (Japan).sfc",          262144, 0x7abdb576, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHarapekoBakkaJapan)
STD_ROM_FN(rHarapekoBakkaJapan)

struct BurnDriver BurnDrvrHarapekoBakkaJapan = {
	"Harapeko Bakka (Japan)", NULL, NULL, "1986",
	"Harapeko Bakka (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Harapeko Bakka (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHarapekoBakkaJapanRomInfo, rHarapekoBakkaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHardBallIIIUSARomDesc[] = {
	{ "HardBall III (USA).sfc",          2097152, 0xf3589b15, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHardBallIIIUSA)
STD_ROM_FN(rHardBallIIIUSA)

struct BurnDriver BurnDrvrHardBallIIIUSA = {
	"HardBall III (USA)", NULL, NULL, "1986",
	"HardBall III (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"HardBall III (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHardBallIIIUSARomInfo, rHardBallIIIUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHarleysHumongousAdventureEuropeRomDesc[] = {
	{ "Harley's Humongous Adventure (Europe).sfc",          524288, 0x7715303, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHarleysHumongousAdventureEurope)
STD_ROM_FN(rHarleysHumongousAdventureEurope)

struct BurnDriver BurnDrvrHarleysHumongousAdventureEurope = {
	"Harley's Humongous Adventure (Europe)", NULL, NULL, "1986",
	"Harley's Humongous Adventure (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Harley's Humongous Adventure (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHarleysHumongousAdventureEuropeRomInfo, rHarleysHumongousAdventureEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHarleysHumongousAdventureUSABetaRomDesc[] = {
	{ "Harley's Humongous Adventure (USA) (Beta).sfc",          524288, 0xf52eacd1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHarleysHumongousAdventureUSABeta)
STD_ROM_FN(rHarleysHumongousAdventureUSABeta)

struct BurnDriver BurnDrvrHarleysHumongousAdventureUSABeta = {
	"Harley's Humongous Adventure (USA) (Beta)", NULL, NULL, "1986",
	"Harley's Humongous Adventure (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Harley's Humongous Adventure (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHarleysHumongousAdventureUSABetaRomInfo, rHarleysHumongousAdventureUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHarleysHumongousAdventureUSARomDesc[] = {
	{ "Harley's Humongous Adventure (USA).sfc",          524288, 0x91e0c960, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHarleysHumongousAdventureUSA)
STD_ROM_FN(rHarleysHumongousAdventureUSA)

struct BurnDriver BurnDrvrHarleysHumongousAdventureUSA = {
	"Harley's Humongous Adventure (USA)", NULL, NULL, "1986",
	"Harley's Humongous Adventure (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Harley's Humongous Adventure (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHarleysHumongousAdventureUSARomInfo, rHarleysHumongousAdventureUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHarvestMoonEuropeRomDesc[] = {
	{ "Harvest Moon (Europe).sfc",          2097152, 0xd54e1452, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHarvestMoonEurope)
STD_ROM_FN(rHarvestMoonEurope)

struct BurnDriver BurnDrvrHarvestMoonEurope = {
	"Harvest Moon (Europe)", NULL, NULL, "1986",
	"Harvest Moon (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Harvest Moon (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHarvestMoonEuropeRomInfo, rHarvestMoonEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHarvestMoonGermanyRomDesc[] = {
	{ "Harvest Moon (Germany).sfc",          2097152, 0x3c1037c1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHarvestMoonGermany)
STD_ROM_FN(rHarvestMoonGermany)

struct BurnDriver BurnDrvrHarvestMoonGermany = {
	"Harvest Moon (Germany)", NULL, NULL, "1986",
	"Harvest Moon (Germany)\0", NULL, "Nintendo", "Miscellaneous",
	L"Harvest Moon (Germany)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHarvestMoonGermanyRomInfo, rHarvestMoonGermanyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHarvestMoonUSARomDesc[] = {
	{ "Harvest Moon (USA).sfc",          2097152, 0xf829129e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHarvestMoonUSA)
STD_ROM_FN(rHarvestMoonUSA)

struct BurnDriver BurnDrvrHarvestMoonUSA = {
	"Harvest Moon (USA)", NULL, NULL, "1986",
	"Harvest Moon (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Harvest Moon (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHarvestMoonUSARomInfo, rHarvestMoonUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHashireHeberekeJapanRomDesc[] = {
	{ "Hashire Hebereke (Japan).sfc",          1310720, 0xdd792499, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHashireHeberekeJapan)
STD_ROM_FN(rHashireHeberekeJapan)

struct BurnDriver BurnDrvrHashireHeberekeJapan = {
	"Hashire Hebereke (Japan)", NULL, NULL, "1986",
	"Hashire Hebereke (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hashire Hebereke (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHashireHeberekeJapanRomInfo, rHashireHeberekeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHatTrickHeroJapanRomDesc[] = {
	{ "Hat Trick Hero (Japan).sfc",          524288, 0xfce8a74d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHatTrickHeroJapan)
STD_ROM_FN(rHatTrickHeroJapan)

struct BurnDriver BurnDrvrHatTrickHeroJapan = {
	"Hat Trick Hero (Japan)", NULL, NULL, "1986",
	"Hat Trick Hero (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hat Trick Hero (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHatTrickHeroJapanRomInfo, rHatTrickHeroJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHatTrickHero2JapanRomDesc[] = {
	{ "Hat Trick Hero 2 (Japan).sfc",          1048576, 0x19e67dff, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHatTrickHero2Japan)
STD_ROM_FN(rHatTrickHero2Japan)

struct BurnDriver BurnDrvrHatTrickHero2Japan = {
	"Hat Trick Hero 2 (Japan)", NULL, NULL, "1986",
	"Hat Trick Hero 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hat Trick Hero 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHatTrickHero2JapanRomInfo, rHatTrickHero2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHatayamaHatchnoProYakyuuNewsJitsumeiBanJapanRomDesc[] = {
	{ "Hatayama Hatch no Pro Yakyuu News! - Jitsumei Ban (Japan).sfc",          1048576, 0x7a585763, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHatayamaHatchnoProYakyuuNewsJitsumeiBanJapan)
STD_ROM_FN(rHatayamaHatchnoProYakyuuNewsJitsumeiBanJapan)

struct BurnDriver BurnDrvrHatayamaHatchnoProYakyuuNewsJitsumeiBanJapan = {
	"Hatayama Hatch no Pro Yakyuu News! - Jitsumei Ban (Japan)", NULL, NULL, "1986",
	"Hatayama Hatch no Pro Yakyuu News! - Jitsumei Ban (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hatayama Hatch no Pro Yakyuu News! - Jitsumei Ban (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHatayamaHatchnoProYakyuuNewsJitsumeiBanJapanRomInfo, rHatayamaHatchnoProYakyuuNewsJitsumeiBanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHayazashiNidanMoritaShougiJapanRomDesc[] = {
	{ "Hayazashi Nidan Morita Shougi (Japan).sfc",          524288, 0x81e822ad, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHayazashiNidanMoritaShougiJapan)
STD_ROM_FN(rHayazashiNidanMoritaShougiJapan)

struct BurnDriver BurnDrvrHayazashiNidanMoritaShougiJapan = {
	"Hayazashi Nidan Morita Shougi (Japan)", NULL, NULL, "1986",
	"Hayazashi Nidan Morita Shougi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hayazashi Nidan Morita Shougi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHayazashiNidanMoritaShougiJapanRomInfo, rHayazashiNidanMoritaShougiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHayazashiNidanMoritaShougi2JapanRomDesc[] = {
	{ "Hayazashi Nidan Morita Shougi 2 (Japan).sfc",          524288, 0xdd852671, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHayazashiNidanMoritaShougi2Japan)
STD_ROM_FN(rHayazashiNidanMoritaShougi2Japan)

struct BurnDriver BurnDrvrHayazashiNidanMoritaShougi2Japan = {
	"Hayazashi Nidan Morita Shougi 2 (Japan)", NULL, NULL, "1986",
	"Hayazashi Nidan Morita Shougi 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hayazashi Nidan Morita Shougi 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHayazashiNidanMoritaShougi2JapanRomInfo, rHayazashiNidanMoritaShougi2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeadOnSoccerUSARomDesc[] = {
	{ "Head-On Soccer (USA).sfc",          2097152, 0x60dc3634, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeadOnSoccerUSA)
STD_ROM_FN(rHeadOnSoccerUSA)

struct BurnDriver BurnDrvrHeadOnSoccerUSA = {
	"Head-On Soccer (USA)", NULL, NULL, "1986",
	"Head-On Soccer (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Head-On Soccer (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeadOnSoccerUSARomInfo, rHeadOnSoccerUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeberekenoOishiiPuzzlewaIrimasenkaJapanRomDesc[] = {
	{ "Hebereke no Oishii Puzzle wa Irimasenka (Japan).sfc",          1310720, 0xb94ccd4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeberekenoOishiiPuzzlewaIrimasenkaJapan)
STD_ROM_FN(rHeberekenoOishiiPuzzlewaIrimasenkaJapan)

struct BurnDriver BurnDrvrHeberekenoOishiiPuzzlewaIrimasenkaJapan = {
	"Hebereke no Oishii Puzzle wa Irimasenka (Japan)", NULL, NULL, "1986",
	"Hebereke no Oishii Puzzle wa Irimasenka (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hebereke no Oishii Puzzle wa Irimasenka (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeberekenoOishiiPuzzlewaIrimasenkaJapanRomInfo, rHeberekenoOishiiPuzzlewaIrimasenkaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeberekenoPopoonJapanRomDesc[] = {
	{ "Hebereke no Popoon (Japan).sfc",          1048576, 0x890d9c9e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeberekenoPopoonJapan)
STD_ROM_FN(rHeberekenoPopoonJapan)

struct BurnDriver BurnDrvrHeberekenoPopoonJapan = {
	"Hebereke no Popoon (Japan)", NULL, NULL, "1986",
	"Hebereke no Popoon (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hebereke no Popoon (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeberekenoPopoonJapanRomInfo, rHeberekenoPopoonJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeberekesPopoittoEuropeRomDesc[] = {
	{ "Hebereke's Popoitto (Europe).sfc",          524288, 0xce626ba, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeberekesPopoittoEurope)
STD_ROM_FN(rHeberekesPopoittoEurope)

struct BurnDriver BurnDrvrHeberekesPopoittoEurope = {
	"Hebereke's Popoitto (Europe)", NULL, NULL, "1986",
	"Hebereke's Popoitto (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hebereke's Popoitto (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeberekesPopoittoEuropeRomInfo, rHeberekesPopoittoEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeberekesPopoonEuropeRomDesc[] = {
	{ "Hebereke's Popoon (Europe).sfc",          1048576, 0x7a313722, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeberekesPopoonEurope)
STD_ROM_FN(rHeberekesPopoonEurope)

struct BurnDriver BurnDrvrHeberekesPopoonEurope = {
	"Hebereke's Popoon (Europe)", NULL, NULL, "1986",
	"Hebereke's Popoon (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hebereke's Popoon (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeberekesPopoonEuropeRomInfo, rHeberekesPopoonEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeianFuuundenJapanRomDesc[] = {
	{ "Heian Fuuunden (Japan).sfc",          1572864, 0x4640d1a2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeianFuuundenJapan)
STD_ROM_FN(rHeianFuuundenJapan)

struct BurnDriver BurnDrvrHeianFuuundenJapan = {
	"Heian Fuuunden (Japan)", NULL, NULL, "1986",
	"Heian Fuuunden (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heian Fuuunden (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeianFuuundenJapanRomInfo, rHeianFuuundenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeiseiGunjinShougiJapanBSRomDesc[] = {
	{ "Heisei Gunjin Shougi (Japan) (BS).sfc",          524288, 0x63f948db, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeiseiGunjinShougiJapanBS)
STD_ROM_FN(rHeiseiGunjinShougiJapanBS)

struct BurnDriver BurnDrvrHeiseiGunjinShougiJapanBS = {
	"Heisei Gunjin Shougi (Japan) (BS)", NULL, NULL, "1986",
	"Heisei Gunjin Shougi (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heisei Gunjin Shougi (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeiseiGunjinShougiJapanBSRomInfo, rHeiseiGunjinShougiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeiseiGunjinShougiJapanRomDesc[] = {
	{ "Heisei Gunjin Shougi (Japan).sfc",          524288, 0x10bca5e1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeiseiGunjinShougiJapan)
STD_ROM_FN(rHeiseiGunjinShougiJapan)

struct BurnDriver BurnDrvrHeiseiGunjinShougiJapan = {
	"Heisei Gunjin Shougi (Japan)", NULL, NULL, "1986",
	"Heisei Gunjin Shougi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heisei Gunjin Shougi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeiseiGunjinShougiJapanRomInfo, rHeiseiGunjinShougiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeiseiInuMonogatariBowPopnSmashJapanRomDesc[] = {
	{ "Heisei Inu Monogatari Bow - Pop'n Smash!! (Japan).sfc",          524288, 0xfe4a2622, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeiseiInuMonogatariBowPopnSmashJapan)
STD_ROM_FN(rHeiseiInuMonogatariBowPopnSmashJapan)

struct BurnDriver BurnDrvrHeiseiInuMonogatariBowPopnSmashJapan = {
	"Heisei Inu Monogatari Bow - Pop'n Smash!! (Japan)", NULL, NULL, "1986",
	"Heisei Inu Monogatari Bow - Pop'n Smash!! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heisei Inu Monogatari Bow - Pop'n Smash!! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeiseiInuMonogatariBowPopnSmashJapanRomInfo, rHeiseiInuMonogatariBowPopnSmashJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeiseiShinOnigashimaKouhenJapanRomDesc[] = {
	{ "Heisei Shin Onigashima - Kouhen (Japan).sfc",          3145728, 0xe4c28fe, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeiseiShinOnigashimaKouhenJapan)
STD_ROM_FN(rHeiseiShinOnigashimaKouhenJapan)

struct BurnDriver BurnDrvrHeiseiShinOnigashimaKouhenJapan = {
	"Heisei Shin Onigashima - Kouhen (Japan)", NULL, NULL, "1986",
	"Heisei Shin Onigashima - Kouhen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heisei Shin Onigashima - Kouhen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeiseiShinOnigashimaKouhenJapanRomInfo, rHeiseiShinOnigashimaKouhenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeiseiShinOnigashimaZenpenJapanRomDesc[] = {
	{ "Heisei Shin Onigashima - Zenpen (Japan).sfc",          3145728, 0x1725e556, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeiseiShinOnigashimaZenpenJapan)
STD_ROM_FN(rHeiseiShinOnigashimaZenpenJapan)

struct BurnDriver BurnDrvrHeiseiShinOnigashimaZenpenJapan = {
	"Heisei Shin Onigashima - Zenpen (Japan)", NULL, NULL, "1986",
	"Heisei Shin Onigashima - Zenpen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heisei Shin Onigashima - Zenpen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeiseiShinOnigashimaZenpenJapanRomInfo, rHeiseiShinOnigashimaZenpenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeiwaPachinkoWorldJapanRomDesc[] = {
	{ "Heiwa Pachinko World (Japan).sfc",          1572864, 0xb2a081d2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeiwaPachinkoWorldJapan)
STD_ROM_FN(rHeiwaPachinkoWorldJapan)

struct BurnDriver BurnDrvrHeiwaPachinkoWorldJapan = {
	"Heiwa Pachinko World (Japan)", NULL, NULL, "1986",
	"Heiwa Pachinko World (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heiwa Pachinko World (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeiwaPachinkoWorldJapanRomInfo, rHeiwaPachinkoWorldJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeiwaPachinkoWorld2JapanRomDesc[] = {
	{ "Heiwa Pachinko World 2 (Japan).sfc",          2621440, 0x975766d5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeiwaPachinkoWorld2Japan)
STD_ROM_FN(rHeiwaPachinkoWorld2Japan)

struct BurnDriver BurnDrvrHeiwaPachinkoWorld2Japan = {
	"Heiwa Pachinko World 2 (Japan)", NULL, NULL, "1986",
	"Heiwa Pachinko World 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heiwa Pachinko World 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeiwaPachinkoWorld2JapanRomInfo, rHeiwaPachinkoWorld2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeiwaPachinkoWorld3JapanRomDesc[] = {
	{ "Heiwa Pachinko World 3 (Japan).sfc",          3145728, 0x37ff1fdf, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeiwaPachinkoWorld3Japan)
STD_ROM_FN(rHeiwaPachinkoWorld3Japan)

struct BurnDriver BurnDrvrHeiwaPachinkoWorld3Japan = {
	"Heiwa Pachinko World 3 (Japan)", NULL, NULL, "1986",
	"Heiwa Pachinko World 3 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heiwa Pachinko World 3 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeiwaPachinkoWorld3JapanRomInfo, rHeiwaPachinkoWorld3JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeiwaParlorMini8PachinkoJikkiSimulationGameJapanRomDesc[] = {
	{ "Heiwa Parlor! Mini 8 - Pachinko Jikki Simulation Game (Japan).sfc",          1048576, 0xaaf45e59, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeiwaParlorMini8PachinkoJikkiSimulationGameJapan)
STD_ROM_FN(rHeiwaParlorMini8PachinkoJikkiSimulationGameJapan)

struct BurnDriver BurnDrvrHeiwaParlorMini8PachinkoJikkiSimulationGameJapan = {
	"Heiwa Parlor! Mini 8 - Pachinko Jikki Simulation Game (Japan)", NULL, NULL, "1986",
	"Heiwa Parlor! Mini 8 - Pachinko Jikki Simulation Game (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heiwa Parlor! Mini 8 - Pachinko Jikki Simulation Game (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeiwaParlorMini8PachinkoJikkiSimulationGameJapanRomInfo, rHeiwaParlorMini8PachinkoJikkiSimulationGameJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHelloPacManJapanRomDesc[] = {
	{ "Hello! Pac-Man (Japan).sfc",          1572864, 0x318fd8c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHelloPacManJapan)
STD_ROM_FN(rHelloPacManJapan)

struct BurnDriver BurnDrvrHelloPacManJapan = {
	"Hello! Pac-Man (Japan)", NULL, NULL, "1986",
	"Hello! Pac-Man (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hello! Pac-Man (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHelloPacManJapanRomInfo, rHelloPacManJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeraclesnoEikouIIIKamigaminoChinmokuJapanRomDesc[] = {
	{ "Heracles no Eikou III - Kamigami no Chinmoku (Japan).sfc",          1048576, 0x61939546, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeraclesnoEikouIIIKamigaminoChinmokuJapan)
STD_ROM_FN(rHeraclesnoEikouIIIKamigaminoChinmokuJapan)

struct BurnDriver BurnDrvrHeraclesnoEikouIIIKamigaminoChinmokuJapan = {
	"Heracles no Eikou III - Kamigami no Chinmoku (Japan)", NULL, NULL, "1986",
	"Heracles no Eikou III - Kamigami no Chinmoku (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heracles no Eikou III - Kamigami no Chinmoku (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeraclesnoEikouIIIKamigaminoChinmokuJapanRomInfo, rHeraclesnoEikouIIIKamigaminoChinmokuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeraclesnoEikouIVKamigamikaranoOkurimonoJapanRomDesc[] = {
	{ "Heracles no Eikou IV - Kamigami kara no Okurimono (Japan).sfc",          2097152, 0x920a738e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeraclesnoEikouIVKamigamikaranoOkurimonoJapan)
STD_ROM_FN(rHeraclesnoEikouIVKamigamikaranoOkurimonoJapan)

struct BurnDriver BurnDrvrHeraclesnoEikouIVKamigamikaranoOkurimonoJapan = {
	"Heracles no Eikou IV - Kamigami kara no Okurimono (Japan)", NULL, NULL, "1986",
	"Heracles no Eikou IV - Kamigami kara no Okurimono (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Heracles no Eikou IV - Kamigami kara no Okurimono (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeraclesnoEikouIVKamigamikaranoOkurimonoJapanRomInfo, rHeraclesnoEikouIVKamigamikaranoOkurimonoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHeroSenkiProjectOlympusJapanRomDesc[] = {
	{ "Hero Senki - Project Olympus (Japan).sfc",          1572864, 0x789da99c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHeroSenkiProjectOlympusJapan)
STD_ROM_FN(rHeroSenkiProjectOlympusJapan)

struct BurnDriver BurnDrvrHeroSenkiProjectOlympusJapan = {
	"Hero Senki - Project Olympus (Japan)", NULL, NULL, "1986",
	"Hero Senki - Project Olympus (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hero Senki - Project Olympus (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHeroSenkiProjectOlympusJapanRomInfo, rHeroSenkiProjectOlympusJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHinoOujiYamatoTakeruJapanRomDesc[] = {
	{ "Hi no Ouji - Yamato Takeru (Japan).sfc",          3145728, 0x2fc4c8a2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHinoOujiYamatoTakeruJapan)
STD_ROM_FN(rHinoOujiYamatoTakeruJapan)

struct BurnDriver BurnDrvrHinoOujiYamatoTakeruJapan = {
	"Hi no Ouji - Yamato Takeru (Japan)", NULL, NULL, "1986",
	"Hi no Ouji - Yamato Takeru (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hi no Ouji - Yamato Takeru (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHinoOujiYamatoTakeruJapanRomInfo, rHinoOujiYamatoTakeruJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHigashioOsamuKanshuuSuperProYakyuuStadiumJapanRomDesc[] = {
	{ "Higashio Osamu Kanshuu Super Pro Yakyuu Stadium (Japan).sfc",          524288, 0x4d6b6c80, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHigashioOsamuKanshuuSuperProYakyuuStadiumJapan)
STD_ROM_FN(rHigashioOsamuKanshuuSuperProYakyuuStadiumJapan)

struct BurnDriver BurnDrvrHigashioOsamuKanshuuSuperProYakyuuStadiumJapan = {
	"Higashio Osamu Kanshuu Super Pro Yakyuu Stadium (Japan)", NULL, NULL, "1986",
	"Higashio Osamu Kanshuu Super Pro Yakyuu Stadium (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Higashio Osamu Kanshuu Super Pro Yakyuu Stadium (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHigashioOsamuKanshuuSuperProYakyuuStadiumJapanRomInfo, rHigashioOsamuKanshuuSuperProYakyuuStadiumJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHioudenMamonotachitonoChikaiJapanRomDesc[] = {
	{ "Hiouden - Mamono-tachi to no Chikai (Japan).sfc",          1572864, 0x1d4ae6ab, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHioudenMamonotachitonoChikaiJapan)
STD_ROM_FN(rHioudenMamonotachitonoChikaiJapan)

struct BurnDriver BurnDrvrHioudenMamonotachitonoChikaiJapan = {
	"Hiouden - Mamono-tachi to no Chikai (Japan)", NULL, NULL, "1986",
	"Hiouden - Mamono-tachi to no Chikai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hiouden - Mamono-tachi to no Chikai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHioudenMamonotachitonoChikaiJapanRomInfo, rHioudenMamonotachitonoChikaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHiryuunoKenSGoldenFighterJapanRomDesc[] = {
	{ "Hiryuu no Ken S - Golden Fighter (Japan).sfc",          1572864, 0x1b113c99, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHiryuunoKenSGoldenFighterJapan)
STD_ROM_FN(rHiryuunoKenSGoldenFighterJapan)

struct BurnDriver BurnDrvrHiryuunoKenSGoldenFighterJapan = {
	"Hiryuu no Ken S - Golden Fighter (Japan)", NULL, NULL, "1986",
	"Hiryuu no Ken S - Golden Fighter (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hiryuu no Ken S - Golden Fighter (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHiryuunoKenSGoldenFighterJapanRomInfo, rHiryuunoKenSGoldenFighterJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHiryuunoKenSHyperVersionJapanRomDesc[] = {
	{ "Hiryuu no Ken S - Hyper Version (Japan).sfc",          1572864, 0xb035ec54, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHiryuunoKenSHyperVersionJapan)
STD_ROM_FN(rHiryuunoKenSHyperVersionJapan)

struct BurnDriver BurnDrvrHiryuunoKenSHyperVersionJapan = {
	"Hiryuu no Ken S - Hyper Version (Japan)", NULL, NULL, "1986",
	"Hiryuu no Ken S - Hyper Version (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hiryuu no Ken S - Hyper Version (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHiryuunoKenSHyperVersionJapanRomInfo, rHiryuunoKenSHyperVersionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHissatsuPachinkoCollectionJapanRomDesc[] = {
	{ "Hissatsu Pachinko Collection (Japan).sfc",          1048576, 0xa1bf047b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHissatsuPachinkoCollectionJapan)
STD_ROM_FN(rHissatsuPachinkoCollectionJapan)

struct BurnDriver BurnDrvrHissatsuPachinkoCollectionJapan = {
	"Hissatsu Pachinko Collection (Japan)", NULL, NULL, "1986",
	"Hissatsu Pachinko Collection (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hissatsu Pachinko Collection (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHissatsuPachinkoCollectionJapanRomInfo, rHissatsuPachinkoCollectionJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHissatsuPachinkoCollection2JapanRomDesc[] = {
	{ "Hissatsu Pachinko Collection 2 (Japan).sfc",          2097152, 0x4a5b12ce, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHissatsuPachinkoCollection2Japan)
STD_ROM_FN(rHissatsuPachinkoCollection2Japan)

struct BurnDriver BurnDrvrHissatsuPachinkoCollection2Japan = {
	"Hissatsu Pachinko Collection 2 (Japan)", NULL, NULL, "1986",
	"Hissatsu Pachinko Collection 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hissatsu Pachinko Collection 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHissatsuPachinkoCollection2JapanRomInfo, rHissatsuPachinkoCollection2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHissatsuPachinkoCollection3JapanRomDesc[] = {
	{ "Hissatsu Pachinko Collection 3 (Japan).sfc",          2097152, 0xc3dd6d9f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHissatsuPachinkoCollection3Japan)
STD_ROM_FN(rHissatsuPachinkoCollection3Japan)

struct BurnDriver BurnDrvrHissatsuPachinkoCollection3Japan = {
	"Hissatsu Pachinko Collection 3 (Japan)", NULL, NULL, "1986",
	"Hissatsu Pachinko Collection 3 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hissatsu Pachinko Collection 3 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHissatsuPachinkoCollection3JapanRomInfo, rHissatsuPachinkoCollection3JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHissatsuPachinkoCollection4JapanRomDesc[] = {
	{ "Hissatsu Pachinko Collection 4 (Japan).sfc",          2097152, 0xb6f34c7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHissatsuPachinkoCollection4Japan)
STD_ROM_FN(rHissatsuPachinkoCollection4Japan)

struct BurnDriver BurnDrvrHissatsuPachinkoCollection4Japan = {
	"Hissatsu Pachinko Collection 4 (Japan)", NULL, NULL, "1986",
	"Hissatsu Pachinko Collection 4 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hissatsu Pachinko Collection 4 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHissatsuPachinkoCollection4JapanRomInfo, rHissatsuPachinkoCollection4JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHisshou777FighterPachiSlotRyuuguuDensetsuJapanRomDesc[] = {
	{ "Hisshou 777 Fighter - Pachi-Slot Ryuuguu Densetsu (Japan).sfc",          524288, 0xef85eb96, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHisshou777FighterPachiSlotRyuuguuDensetsuJapan)
STD_ROM_FN(rHisshou777FighterPachiSlotRyuuguuDensetsuJapan)

struct BurnDriver BurnDrvrHisshou777FighterPachiSlotRyuuguuDensetsuJapan = {
	"Hisshou 777 Fighter - Pachi-Slot Ryuuguu Densetsu (Japan)", NULL, NULL, "1986",
	"Hisshou 777 Fighter - Pachi-Slot Ryuuguu Densetsu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hisshou 777 Fighter - Pachi-Slot Ryuuguu Densetsu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHisshou777FighterPachiSlotRyuuguuDensetsuJapanRomInfo, rHisshou777FighterPachiSlotRyuuguuDensetsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHisshou777FighterIIPachiSlotMaruhiJouhouJapanRomDesc[] = {
	{ "Hisshou 777 Fighter II - Pachi-Slot Maruhi Jouhou (Japan).sfc",          524288, 0x26c8072e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHisshou777FighterIIPachiSlotMaruhiJouhouJapan)
STD_ROM_FN(rHisshou777FighterIIPachiSlotMaruhiJouhouJapan)

struct BurnDriver BurnDrvrHisshou777FighterIIPachiSlotMaruhiJouhouJapan = {
	"Hisshou 777 Fighter II - Pachi-Slot Maruhi Jouhou (Japan)", NULL, NULL, "1986",
	"Hisshou 777 Fighter II - Pachi-Slot Maruhi Jouhou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hisshou 777 Fighter II - Pachi-Slot Maruhi Jouhou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHisshou777FighterIIPachiSlotMaruhiJouhouJapanRomInfo, rHisshou777FighterIIPachiSlotMaruhiJouhouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHisshou777FighterIIIKokuryuuOunoFukkatsuJapanRomDesc[] = {
	{ "Hisshou 777 Fighter III - Kokuryuu Ou no Fukkatsu (Japan).sfc",          1048576, 0xc386fc22, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHisshou777FighterIIIKokuryuuOunoFukkatsuJapan)
STD_ROM_FN(rHisshou777FighterIIIKokuryuuOunoFukkatsuJapan)

struct BurnDriver BurnDrvrHisshou777FighterIIIKokuryuuOunoFukkatsuJapan = {
	"Hisshou 777 Fighter III - Kokuryuu Ou no Fukkatsu (Japan)", NULL, NULL, "1986",
	"Hisshou 777 Fighter III - Kokuryuu Ou no Fukkatsu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hisshou 777 Fighter III - Kokuryuu Ou no Fukkatsu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHisshou777FighterIIIKokuryuuOunoFukkatsuJapanRomInfo, rHisshou777FighterIIIKokuryuuOunoFukkatsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHisshouPachiSlotFunJapanRomDesc[] = {
	{ "Hisshou Pachi-Slot Fun (Japan).sfc",          1048576, 0xb37bbd38, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHisshouPachiSlotFunJapan)
STD_ROM_FN(rHisshouPachiSlotFunJapan)

struct BurnDriver BurnDrvrHisshouPachiSlotFunJapan = {
	"Hisshou Pachi-Slot Fun (Japan)", NULL, NULL, "1986",
	"Hisshou Pachi-Slot Fun (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hisshou Pachi-Slot Fun (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHisshouPachiSlotFunJapanRomInfo, rHisshouPachiSlotFunJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHittheIceUSARomDesc[] = {
	{ "Hit the Ice (USA).sfc",          524288, 0xec13477e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHittheIceUSA)
STD_ROM_FN(rHittheIceUSA)

struct BurnDriver BurnDrvrHittheIceUSA = {
	"Hit the Ice (USA)", NULL, NULL, "1986",
	"Hit the Ice (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hit the Ice (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHittheIceUSARomInfo, rHittheIceUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHokutonoKen5TenmaRyuuseidenAiZetsuShouJapanRomDesc[] = {
	{ "Hokuto no Ken 5 - Tenma Ryuuseiden Ai Zetsu Shou (Japan).sfc",          1048576, 0x68bdcbd7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHokutonoKen5TenmaRyuuseidenAiZetsuShouJapan)
STD_ROM_FN(rHokutonoKen5TenmaRyuuseidenAiZetsuShouJapan)

struct BurnDriver BurnDrvrHokutonoKen5TenmaRyuuseidenAiZetsuShouJapan = {
	"Hokuto no Ken 5 - Tenma Ryuuseiden Ai Zetsu Shou (Japan)", NULL, NULL, "1986",
	"Hokuto no Ken 5 - Tenma Ryuuseiden Ai Zetsu Shou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hokuto no Ken 5 - Tenma Ryuuseiden Ai Zetsu Shou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHokutonoKen5TenmaRyuuseidenAiZetsuShouJapanRomInfo, rHokutonoKen5TenmaRyuuseidenAiZetsuShouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHokutonoKen6GekitouDenshoukenHaouenoMichiJapanRomDesc[] = {
	{ "Hokuto no Ken 6 - Gekitou Denshouken Haou e no Michi (Japan).sfc",          1572864, 0xe51cd206, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHokutonoKen6GekitouDenshoukenHaouenoMichiJapan)
STD_ROM_FN(rHokutonoKen6GekitouDenshoukenHaouenoMichiJapan)

struct BurnDriver BurnDrvrHokutonoKen6GekitouDenshoukenHaouenoMichiJapan = {
	"Hokuto no Ken 6 - Gekitou Denshouken Haou e no Michi (Japan)", NULL, NULL, "1986",
	"Hokuto no Ken 6 - Gekitou Denshouken Haou e no Michi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hokuto no Ken 6 - Gekitou Denshouken Haou e no Michi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHokutonoKen6GekitouDenshoukenHaouenoMichiJapanRomInfo, rHokutonoKen6GekitouDenshoukenHaouenoMichiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHokutonoKen7SeikenRetsudenDenshoushaenoMichiJapanRomDesc[] = {
	{ "Hokuto no Ken 7 - Seiken Retsuden Denshousha e no Michi (Japan).sfc",          2621440, 0x143e5a7d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHokutonoKen7SeikenRetsudenDenshoushaenoMichiJapan)
STD_ROM_FN(rHokutonoKen7SeikenRetsudenDenshoushaenoMichiJapan)

struct BurnDriver BurnDrvrHokutonoKen7SeikenRetsudenDenshoushaenoMichiJapan = {
	"Hokuto no Ken 7 - Seiken Retsuden Denshousha e no Michi (Japan)", NULL, NULL, "1986",
	"Hokuto no Ken 7 - Seiken Retsuden Denshousha e no Michi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hokuto no Ken 7 - Seiken Retsuden Denshousha e no Michi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHokutonoKen7SeikenRetsudenDenshoushaenoMichiJapanRomInfo, rHokutonoKen7SeikenRetsudenDenshoushaenoMichiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHolyStrikerJapanRomDesc[] = {
	{ "Holy Striker (Japan).sfc",          1048576, 0x46acfc84, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHolyStrikerJapan)
STD_ROM_FN(rHolyStrikerJapan)

struct BurnDriver BurnDrvrHolyStrikerJapan = {
	"Holy Striker (Japan)", NULL, NULL, "1986",
	"Holy Striker (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Holy Striker (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHolyStrikerJapanRomInfo, rHolyStrikerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHolyUmbrellaDonderanoMubouJapanRomDesc[] = {
	{ "Holy Umbrella - Dondera no Mubou!! (Japan).sfc",          2621440, 0xf0a9dead, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHolyUmbrellaDonderanoMubouJapan)
STD_ROM_FN(rHolyUmbrellaDonderanoMubouJapan)

struct BurnDriver BurnDrvrHolyUmbrellaDonderanoMubouJapan = {
	"Holy Umbrella - Dondera no Mubou!! (Japan)", NULL, NULL, "1986",
	"Holy Umbrella - Dondera no Mubou!! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Holy Umbrella - Dondera no Mubou!! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHolyUmbrellaDonderanoMubouJapanRomInfo, rHolyUmbrellaDonderanoMubouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHomeAloneEuropeRomDesc[] = {
	{ "Home Alone (Europe).sfc",          524288, 0x3eeea766, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHomeAloneEurope)
STD_ROM_FN(rHomeAloneEurope)

struct BurnDriver BurnDrvrHomeAloneEurope = {
	"Home Alone (Europe)", NULL, NULL, "1986",
	"Home Alone (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Home Alone (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHomeAloneEuropeRomInfo, rHomeAloneEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHomeAloneJapanRomDesc[] = {
	{ "Home Alone (Japan).sfc",          524288, 0x6278bca1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHomeAloneJapan)
STD_ROM_FN(rHomeAloneJapan)

struct BurnDriver BurnDrvrHomeAloneJapan = {
	"Home Alone (Japan)", NULL, NULL, "1986",
	"Home Alone (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Home Alone (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHomeAloneJapanRomInfo, rHomeAloneJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHomeAloneUSARomDesc[] = {
	{ "Home Alone (USA).sfc",          524288, 0x7c494b1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHomeAloneUSA)
STD_ROM_FN(rHomeAloneUSA)

struct BurnDriver BurnDrvrHomeAloneUSA = {
	"Home Alone (USA)", NULL, NULL, "1986",
	"Home Alone (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Home Alone (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHomeAloneUSARomInfo, rHomeAloneUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHomeAlone2LostinNewYorkEuropeRomDesc[] = {
	{ "Home Alone 2 - Lost in New York (Europe).sfc",          524288, 0x226998d6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHomeAlone2LostinNewYorkEurope)
STD_ROM_FN(rHomeAlone2LostinNewYorkEurope)

struct BurnDriver BurnDrvrHomeAlone2LostinNewYorkEurope = {
	"Home Alone 2 - Lost in New York (Europe)", NULL, NULL, "1986",
	"Home Alone 2 - Lost in New York (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Home Alone 2 - Lost in New York (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHomeAlone2LostinNewYorkEuropeRomInfo, rHomeAlone2LostinNewYorkEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHomeAlone2LostinNewYorkUSARomDesc[] = {
	{ "Home Alone 2 - Lost in New York (USA).sfc",          524288, 0xd19165d9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHomeAlone2LostinNewYorkUSA)
STD_ROM_FN(rHomeAlone2LostinNewYorkUSA)

struct BurnDriver BurnDrvrHomeAlone2LostinNewYorkUSA = {
	"Home Alone 2 - Lost in New York (USA)", NULL, NULL, "1986",
	"Home Alone 2 - Lost in New York (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Home Alone 2 - Lost in New York (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHomeAlone2LostinNewYorkUSARomInfo, rHomeAlone2LostinNewYorkUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHomeImprovementUSARomDesc[] = {
	{ "Home Improvement (USA).sfc",          1572864, 0xfa698c31, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHomeImprovementUSA)
STD_ROM_FN(rHomeImprovementUSA)

struct BurnDriver BurnDrvrHomeImprovementUSA = {
	"Home Improvement (USA)", NULL, NULL, "1986",
	"Home Improvement (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Home Improvement (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHomeImprovementUSARomInfo, rHomeImprovementUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHonkakuMahjongTetsumanJapanRomDesc[] = {
	{ "Honkaku Mahjong - Tetsuman (Japan).sfc",          524288, 0x53f03db9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHonkakuMahjongTetsumanJapan)
STD_ROM_FN(rHonkakuMahjongTetsumanJapan)

struct BurnDriver BurnDrvrHonkakuMahjongTetsumanJapan = {
	"Honkaku Mahjong - Tetsuman (Japan)", NULL, NULL, "1986",
	"Honkaku Mahjong - Tetsuman (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Honkaku Mahjong - Tetsuman (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHonkakuMahjongTetsumanJapanRomInfo, rHonkakuMahjongTetsumanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHonkakuMahjongTetsumanIIJapanRomDesc[] = {
	{ "Honkaku Mahjong - Tetsuman II (Japan).sfc",          524288, 0xa43c5a39, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHonkakuMahjongTetsumanIIJapan)
STD_ROM_FN(rHonkakuMahjongTetsumanIIJapan)

struct BurnDriver BurnDrvrHonkakuMahjongTetsumanIIJapan = {
	"Honkaku Mahjong - Tetsuman II (Japan)", NULL, NULL, "1986",
	"Honkaku Mahjong - Tetsuman II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Honkaku Mahjong - Tetsuman II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHonkakuMahjongTetsumanIIJapanRomInfo, rHonkakuMahjongTetsumanIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHonkakuShougiFuuunjiRyuuouJapanRomDesc[] = {
	{ "Honkaku Shougi - Fuuunji Ryuuou (Japan).sfc",          1048576, 0xb8be82c2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHonkakuShougiFuuunjiRyuuouJapan)
STD_ROM_FN(rHonkakuShougiFuuunjiRyuuouJapan)

struct BurnDriver BurnDrvrHonkakuShougiFuuunjiRyuuouJapan = {
	"Honkaku Shougi - Fuuunji Ryuuou (Japan)", NULL, NULL, "1986",
	"Honkaku Shougi - Fuuunji Ryuuou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Honkaku Shougi - Fuuunji Ryuuou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHonkakuShougiFuuunjiRyuuouJapanRomInfo, rHonkakuShougiFuuunjiRyuuouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHonkakuhaIgoGoseiJapanRomDesc[] = {
	{ "Honkakuha Igo - Gosei (Japan).sfc",          1048576, 0x8f322c56, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHonkakuhaIgoGoseiJapan)
STD_ROM_FN(rHonkakuhaIgoGoseiJapan)

struct BurnDriver BurnDrvrHonkakuhaIgoGoseiJapan = {
	"Honkakuha Igo - Gosei (Japan)", NULL, NULL, "1986",
	"Honkakuha Igo - Gosei (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Honkakuha Igo - Gosei (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHonkakuhaIgoGoseiJapanRomInfo, rHonkakuhaIgoGoseiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHonkeHanafudaJapanRomDesc[] = {
	{ "Honke Hanafuda (Japan).sfc",          1048576, 0x53206326, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHonkeHanafudaJapan)
STD_ROM_FN(rHonkeHanafudaJapan)

struct BurnDriver BurnDrvrHonkeHanafudaJapan = {
	"Honke Hanafuda (Japan)", NULL, NULL, "1986",
	"Honke Hanafuda (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Honke Hanafuda (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHonkeHanafudaJapanRomInfo, rHonkeHanafudaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHonkeSankyoFeverJikkiSimulationJapanRomDesc[] = {
	{ "Honke Sankyo Fever - Jikki Simulation (Japan).sfc",          1572864, 0x3bbdf518, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHonkeSankyoFeverJikkiSimulationJapan)
STD_ROM_FN(rHonkeSankyoFeverJikkiSimulationJapan)

struct BurnDriver BurnDrvrHonkeSankyoFeverJikkiSimulationJapan = {
	"Honke Sankyo Fever - Jikki Simulation (Japan)", NULL, NULL, "1986",
	"Honke Sankyo Fever - Jikki Simulation (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Honke Sankyo Fever - Jikki Simulation (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHonkeSankyoFeverJikkiSimulationJapanRomInfo, rHonkeSankyoFeverJikkiSimulationJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHonkeSankyoFever2JikkiSimulationJapanRomDesc[] = {
	{ "Honke Sankyo Fever 2 - Jikki Simulation (Japan).sfc",          1572864, 0x57ff6d4c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHonkeSankyoFever2JikkiSimulationJapan)
STD_ROM_FN(rHonkeSankyoFever2JikkiSimulationJapan)

struct BurnDriver BurnDrvrHonkeSankyoFever2JikkiSimulationJapan = {
	"Honke Sankyo Fever 2 - Jikki Simulation (Japan)", NULL, NULL, "1986",
	"Honke Sankyo Fever 2 - Jikki Simulation (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Honke Sankyo Fever 2 - Jikki Simulation (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHonkeSankyoFever2JikkiSimulationJapanRomInfo, rHonkeSankyoFever2JikkiSimulationJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHonkeSankyoFever3JikkiSimulationJapanRomDesc[] = {
	{ "Honke Sankyo Fever 3 - Jikki Simulation (Japan).sfc",          1048576, 0x759a4585, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHonkeSankyoFever3JikkiSimulationJapan)
STD_ROM_FN(rHonkeSankyoFever3JikkiSimulationJapan)

struct BurnDriver BurnDrvrHonkeSankyoFever3JikkiSimulationJapan = {
	"Honke Sankyo Fever 3 - Jikki Simulation (Japan)", NULL, NULL, "1986",
	"Honke Sankyo Fever 3 - Jikki Simulation (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Honke Sankyo Fever 3 - Jikki Simulation (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHonkeSankyoFever3JikkiSimulationJapanRomInfo, rHonkeSankyoFever3JikkiSimulationJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHonoonoToukyuujiDodgeDanpeiJapanRomDesc[] = {
	{ "Honoo no Toukyuuji - Dodge Danpei (Japan).sfc",          1048576, 0x5947a7a4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHonoonoToukyuujiDodgeDanpeiJapan)
STD_ROM_FN(rHonoonoToukyuujiDodgeDanpeiJapan)

struct BurnDriver BurnDrvrHonoonoToukyuujiDodgeDanpeiJapan = {
	"Honoo no Toukyuuji - Dodge Danpei (Japan)", NULL, NULL, "1986",
	"Honoo no Toukyuuji - Dodge Danpei (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Honoo no Toukyuuji - Dodge Danpei (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHonoonoToukyuujiDodgeDanpeiJapanRomInfo, rHonoonoToukyuujiDodgeDanpeiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHookEuropeRomDesc[] = {
	{ "Hook (Europe).sfc",          1048576, 0x6679a772, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHookEurope)
STD_ROM_FN(rHookEurope)

struct BurnDriver BurnDrvrHookEurope = {
	"Hook (Europe)", NULL, NULL, "1986",
	"Hook (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hook (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHookEuropeRomInfo, rHookEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHookJapanRomDesc[] = {
	{ "Hook (Japan).sfc",          1048576, 0x6f91883e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHookJapan)
STD_ROM_FN(rHookJapan)

struct BurnDriver BurnDrvrHookJapan = {
	"Hook (Japan)", NULL, NULL, "1986",
	"Hook (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hook (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHookJapanRomInfo, rHookJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHookUSABetaRomDesc[] = {
	{ "Hook (USA) (Beta).sfc",          1048576, 0x82ff23bc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHookUSABeta)
STD_ROM_FN(rHookUSABeta)

struct BurnDriver BurnDrvrHookUSABeta = {
	"Hook (USA) (Beta)", NULL, NULL, "1986",
	"Hook (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hook (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHookUSABetaRomInfo, rHookUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHookUSARomDesc[] = {
	{ "Hook (USA).sfc",          1048576, 0xc572ef0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHookUSA)
STD_ROM_FN(rHookUSA)

struct BurnDriver BurnDrvrHookUSA = {
	"Hook (USA)", NULL, NULL, "1986",
	"Hook (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hook (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHookUSARomInfo, rHookUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHoshinoKirbySuperDeluxeJapanRev1RomDesc[] = {
	{ "Hoshi no Kirby - Super Deluxe (Japan) (Rev 1).sfc",          4194304, 0xdbbcd010, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHoshinoKirbySuperDeluxeJapanRev1)
STD_ROM_FN(rHoshinoKirbySuperDeluxeJapanRev1)

struct BurnDriver BurnDrvrHoshinoKirbySuperDeluxeJapanRev1 = {
	"Hoshi no Kirby - Super Deluxe (Japan) (Rev 1)", NULL, NULL, "1986",
	"Hoshi no Kirby - Super Deluxe (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hoshi no Kirby - Super Deluxe (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHoshinoKirbySuperDeluxeJapanRev1RomInfo, rHoshinoKirbySuperDeluxeJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHoshinoKirbySuperDeluxeJapanRev2RomDesc[] = {
	{ "Hoshi no Kirby - Super Deluxe (Japan) (Rev 2).sfc",          4194304, 0x1f35f230, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHoshinoKirbySuperDeluxeJapanRev2)
STD_ROM_FN(rHoshinoKirbySuperDeluxeJapanRev2)

struct BurnDriver BurnDrvrHoshinoKirbySuperDeluxeJapanRev2 = {
	"Hoshi no Kirby - Super Deluxe (Japan) (Rev 2)", NULL, NULL, "1986",
	"Hoshi no Kirby - Super Deluxe (Japan) (Rev 2)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hoshi no Kirby - Super Deluxe (Japan) (Rev 2)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHoshinoKirbySuperDeluxeJapanRev2RomInfo, rHoshinoKirbySuperDeluxeJapanRev2RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHoshinoKirbySuperDeluxeJapanRomDesc[] = {
	{ "Hoshi no Kirby - Super Deluxe (Japan).sfc",          4194304, 0x151bd470, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHoshinoKirbySuperDeluxeJapan)
STD_ROM_FN(rHoshinoKirbySuperDeluxeJapan)

struct BurnDriver BurnDrvrHoshinoKirbySuperDeluxeJapan = {
	"Hoshi no Kirby - Super Deluxe (Japan)", NULL, NULL, "1986",
	"Hoshi no Kirby - Super Deluxe (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hoshi no Kirby - Super Deluxe (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHoshinoKirbySuperDeluxeJapanRomInfo, rHoshinoKirbySuperDeluxeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHoshinoKirby3JapanRomDesc[] = {
	{ "Hoshi no Kirby 3 (Japan).sfc",          4194304, 0x43373aee, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHoshinoKirby3Japan)
STD_ROM_FN(rHoshinoKirby3Japan)

struct BurnDriver BurnDrvrHoshinoKirby3Japan = {
	"Hoshi no Kirby 3 (Japan)", NULL, NULL, "1986",
	"Hoshi no Kirby 3 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hoshi no Kirby 3 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHoshinoKirby3JapanRomInfo, rHoshinoKirby3JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHoukagoinBeppinJogakuinJapanRomDesc[] = {
	{ "Houkago in Beppin Jogakuin (Japan).sfc",          1572864, 0xd3871866, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHoukagoinBeppinJogakuinJapan)
STD_ROM_FN(rHoukagoinBeppinJogakuinJapan)

struct BurnDriver BurnDrvrHoukagoinBeppinJogakuinJapan = {
	"Houkago in Beppin Jogakuin (Japan)", NULL, NULL, "1986",
	"Houkago in Beppin Jogakuin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Houkago in Beppin Jogakuin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHoukagoinBeppinJogakuinJapanRomInfo, rHoukagoinBeppinJogakuinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHouraiGakuennoBoukenTenkouseiScrambleJapanRomDesc[] = {
	{ "Hourai Gakuen no Bouken! - Tenkousei Scramble (Japan).sfc",          2097152, 0x6299fb1c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHouraiGakuennoBoukenTenkouseiScrambleJapan)
STD_ROM_FN(rHouraiGakuennoBoukenTenkouseiScrambleJapan)

struct BurnDriver BurnDrvrHouraiGakuennoBoukenTenkouseiScrambleJapan = {
	"Hourai Gakuen no Bouken! - Tenkousei Scramble (Japan)", NULL, NULL, "1986",
	"Hourai Gakuen no Bouken! - Tenkousei Scramble (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hourai Gakuen no Bouken! - Tenkousei Scramble (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHouraiGakuennoBoukenTenkouseiScrambleJapanRomInfo, rHouraiGakuennoBoukenTenkouseiScrambleJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHumanBaseballJapanRomDesc[] = {
	{ "Human Baseball (Japan).sfc",          1048576, 0x10e3dab, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHumanBaseballJapan)
STD_ROM_FN(rHumanBaseballJapan)

struct BurnDriver BurnDrvrHumanBaseballJapan = {
	"Human Baseball (Japan)", NULL, NULL, "1986",
	"Human Baseball (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Human Baseball (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHumanBaseballJapanRomInfo, rHumanBaseballJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHumanGrandPrixJapanRomDesc[] = {
	{ "Human Grand Prix (Japan).sfc",          1048576, 0x823019ca, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHumanGrandPrixJapan)
STD_ROM_FN(rHumanGrandPrixJapan)

struct BurnDriver BurnDrvrHumanGrandPrixJapan = {
	"Human Grand Prix (Japan)", NULL, NULL, "1986",
	"Human Grand Prix (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Human Grand Prix (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHumanGrandPrixJapanRomInfo, rHumanGrandPrixJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHumanGrandPrixIIJapanRomDesc[] = {
	{ "Human Grand Prix II (Japan).sfc",          1048576, 0xa5351db4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHumanGrandPrixIIJapan)
STD_ROM_FN(rHumanGrandPrixIIJapan)

struct BurnDriver BurnDrvrHumanGrandPrixIIJapan = {
	"Human Grand Prix II (Japan)", NULL, NULL, "1986",
	"Human Grand Prix II (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Human Grand Prix II (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHumanGrandPrixIIJapanRomInfo, rHumanGrandPrixIIJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHumanGrandPrixIIIF1TripleBattleJapanRomDesc[] = {
	{ "Human Grand Prix III - F1 Triple Battle (Japan).sfc",          2097152, 0x9f6d0228, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHumanGrandPrixIIIF1TripleBattleJapan)
STD_ROM_FN(rHumanGrandPrixIIIF1TripleBattleJapan)

struct BurnDriver BurnDrvrHumanGrandPrixIIIF1TripleBattleJapan = {
	"Human Grand Prix III - F1 Triple Battle (Japan)", NULL, NULL, "1986",
	"Human Grand Prix III - F1 Triple Battle (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Human Grand Prix III - F1 Triple Battle (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHumanGrandPrixIIIF1TripleBattleJapanRomInfo, rHumanGrandPrixIIIF1TripleBattleJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHumanGrandPrixIVF1DreamBattleJapanRomDesc[] = {
	{ "Human Grand Prix IV - F1 Dream Battle (Japan).sfc",          2097152, 0x47453477, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHumanGrandPrixIVF1DreamBattleJapan)
STD_ROM_FN(rHumanGrandPrixIVF1DreamBattleJapan)

struct BurnDriver BurnDrvrHumanGrandPrixIVF1DreamBattleJapan = {
	"Human Grand Prix IV - F1 Dream Battle (Japan)", NULL, NULL, "1986",
	"Human Grand Prix IV - F1 Dream Battle (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Human Grand Prix IV - F1 Dream Battle (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHumanGrandPrixIVF1DreamBattleJapanRomInfo, rHumanGrandPrixIVF1DreamBattleJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHumansTheEuropeRomDesc[] = {
	{ "Humans, The (Europe).sfc",          1048576, 0xd2af01d4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHumansTheEurope)
STD_ROM_FN(rHumansTheEurope)

struct BurnDriver BurnDrvrHumansTheEurope = {
	"Humans, The (Europe)", NULL, NULL, "1986",
	"Humans, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Humans, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHumansTheEuropeRomInfo, rHumansTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHumansTheGermanyRomDesc[] = {
	{ "Humans, The (Germany).sfc",          1048576, 0xe83a092b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHumansTheGermany)
STD_ROM_FN(rHumansTheGermany)

struct BurnDriver BurnDrvrHumansTheGermany = {
	"Humans, The (Germany)", NULL, NULL, "1986",
	"Humans, The (Germany)\0", NULL, "Nintendo", "Miscellaneous",
	L"Humans, The (Germany)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHumansTheGermanyRomInfo, rHumansTheGermanyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHungryDinosaursEuropeRomDesc[] = {
	{ "Hungry Dinosaurs (Europe).sfc",          262144, 0x5c4b2544, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHungryDinosaursEurope)
STD_ROM_FN(rHungryDinosaursEurope)

struct BurnDriver BurnDrvrHungryDinosaursEurope = {
	"Hungry Dinosaurs (Europe)", NULL, NULL, "1986",
	"Hungry Dinosaurs (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hungry Dinosaurs (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHungryDinosaursEuropeRomInfo, rHungryDinosaursEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHuntforRedOctoberTheEuropeBetaRomDesc[] = {
	{ "Hunt for Red October, The (Europe) (Beta).sfc",          524288, 0x66ed877a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHuntforRedOctoberTheEuropeBeta)
STD_ROM_FN(rHuntforRedOctoberTheEuropeBeta)

struct BurnDriver BurnDrvrHuntforRedOctoberTheEuropeBeta = {
	"Hunt for Red October, The (Europe) (Beta)", NULL, NULL, "1986",
	"Hunt for Red October, The (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hunt for Red October, The (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHuntforRedOctoberTheEuropeBetaRomInfo, rHuntforRedOctoberTheEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHuntforRedOctoberTheEuropeRomDesc[] = {
	{ "Hunt for Red October, The (Europe).sfc",          524288, 0x346e153f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHuntforRedOctoberTheEurope)
STD_ROM_FN(rHuntforRedOctoberTheEurope)

struct BurnDriver BurnDrvrHuntforRedOctoberTheEurope = {
	"Hunt for Red October, The (Europe)", NULL, NULL, "1986",
	"Hunt for Red October, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hunt for Red October, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHuntforRedOctoberTheEuropeRomInfo, rHuntforRedOctoberTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHuntforRedOctoberTheJapanRomDesc[] = {
	{ "Hunt for Red October, The (Japan).sfc",          524288, 0x76065e37, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHuntforRedOctoberTheJapan)
STD_ROM_FN(rHuntforRedOctoberTheJapan)

struct BurnDriver BurnDrvrHuntforRedOctoberTheJapan = {
	"Hunt for Red October, The (Japan)", NULL, NULL, "1986",
	"Hunt for Red October, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hunt for Red October, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHuntforRedOctoberTheJapanRomInfo, rHuntforRedOctoberTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHuntforRedOctoberTheUSARomDesc[] = {
	{ "Hunt for Red October, The (USA).sfc",          524288, 0xc796e830, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHuntforRedOctoberTheUSA)
STD_ROM_FN(rHuntforRedOctoberTheUSA)

struct BurnDriver BurnDrvrHuntforRedOctoberTheUSA = {
	"Hunt for Red October, The (USA)", NULL, NULL, "1986",
	"Hunt for Red October, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hunt for Red October, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHuntforRedOctoberTheUSARomInfo, rHuntforRedOctoberTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHurricanesEuropeBetaRomDesc[] = {
	{ "Hurricanes (Europe) (Beta).sfc",          1048576, 0xe6767848, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHurricanesEuropeBeta)
STD_ROM_FN(rHurricanesEuropeBeta)

struct BurnDriver BurnDrvrHurricanesEuropeBeta = {
	"Hurricanes (Europe) (Beta)", NULL, NULL, "1986",
	"Hurricanes (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hurricanes (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHurricanesEuropeBetaRomInfo, rHurricanesEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHurricanesEuropeRomDesc[] = {
	{ "Hurricanes (Europe).sfc",          1048576, 0xde5f9d73, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHurricanesEurope)
STD_ROM_FN(rHurricanesEurope)

struct BurnDriver BurnDrvrHurricanesEurope = {
	"Hurricanes (Europe)", NULL, NULL, "1986",
	"Hurricanes (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hurricanes (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHurricanesEuropeRomInfo, rHurricanesEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHurricanesUSARomDesc[] = {
	{ "Hurricanes (USA).sfc",          1048576, 0x42ff4f08, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHurricanesUSA)
STD_ROM_FN(rHurricanesUSA)

struct BurnDriver BurnDrvrHurricanesUSA = {
	"Hurricanes (USA)", NULL, NULL, "1986",
	"Hurricanes (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hurricanes (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHurricanesUSARomInfo, rHurricanesUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHyperIriaJapanRomDesc[] = {
	{ "Hyper Iria (Japan).sfc",          1572864, 0xae7f2b0d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHyperIriaJapan)
STD_ROM_FN(rHyperIriaJapan)

struct BurnDriver BurnDrvrHyperIriaJapan = {
	"Hyper Iria (Japan)", NULL, NULL, "1986",
	"Hyper Iria (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hyper Iria (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHyperIriaJapanRomInfo, rHyperIriaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHyperVBallEuropeRomDesc[] = {
	{ "Hyper V-Ball (Europe).sfc",          1048576, 0x94012ea, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHyperVBallEurope)
STD_ROM_FN(rHyperVBallEurope)

struct BurnDriver BurnDrvrHyperVBallEurope = {
	"Hyper V-Ball (Europe)", NULL, NULL, "1986",
	"Hyper V-Ball (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hyper V-Ball (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHyperVBallEuropeRomInfo, rHyperVBallEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHyperVBallUSARomDesc[] = {
	{ "Hyper V-Ball (USA).sfc",          1048576, 0x7d179e21, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHyperVBallUSA)
STD_ROM_FN(rHyperVBallUSA)

struct BurnDriver BurnDrvrHyperVBallUSA = {
	"Hyper V-Ball (USA)", NULL, NULL, "1986",
	"Hyper V-Ball (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Hyper V-Ball (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHyperVBallUSARomInfo, rHyperVBallUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHyperZoneEuropeRomDesc[] = {
	{ "HyperZone (Europe).sfc",          524288, 0xfa15d068, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHyperZoneEurope)
STD_ROM_FN(rHyperZoneEurope)

struct BurnDriver BurnDrvrHyperZoneEurope = {
	"HyperZone (Europe)", NULL, NULL, "1986",
	"HyperZone (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"HyperZone (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHyperZoneEuropeRomInfo, rHyperZoneEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHyperZoneJapanRomDesc[] = {
	{ "HyperZone (Japan).sfc",          1048576, 0x613c62b7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHyperZoneJapan)
STD_ROM_FN(rHyperZoneJapan)

struct BurnDriver BurnDrvrHyperZoneJapan = {
	"HyperZone (Japan)", NULL, NULL, "1986",
	"HyperZone (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"HyperZone (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHyperZoneJapanRomInfo, rHyperZoneJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rHyperZoneUSARomDesc[] = {
	{ "HyperZone (USA).sfc",          524288, 0xc95b4129, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rHyperZoneUSA)
STD_ROM_FN(rHyperZoneUSA)

struct BurnDriver BurnDrvrHyperZoneUSA = {
	"HyperZone (USA)", NULL, NULL, "1986",
	"HyperZone (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"HyperZone (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rHyperZoneUSARomInfo, rHyperZoneUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIdeanoHiJapanRomDesc[] = {
	{ "Idea no Hi (Japan).sfc",          2097152, 0x2796523e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIdeanoHiJapan)
STD_ROM_FN(rIdeanoHiJapan)

struct BurnDriver BurnDrvrIdeanoHiJapan = {
	"Idea no Hi (Japan)", NULL, NULL, "1986",
	"Idea no Hi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Idea no Hi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIdeanoHiJapanRomInfo, rIdeanoHiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIgnitionFactorTheUSARomDesc[] = {
	{ "Ignition Factor, The (USA).sfc",          1048576, 0xee441564, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIgnitionFactorTheUSA)
STD_ROM_FN(rIgnitionFactorTheUSA)

struct BurnDriver BurnDrvrIgnitionFactorTheUSA = {
	"Ignition Factor, The (USA)", NULL, NULL, "1986",
	"Ignition Factor, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ignition Factor, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIgnitionFactorTheUSARomInfo, rIgnitionFactorTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIgoClubJapanRomDesc[] = {
	{ "Igo Club (Japan).sfc",          1048576, 0x1e23f3d6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIgoClubJapan)
STD_ROM_FN(rIgoClubJapan)

struct BurnDriver BurnDrvrIgoClubJapan = {
	"Igo Club (Japan)", NULL, NULL, "1986",
	"Igo Club (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Igo Club (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIgoClubJapanRomInfo, rIgoClubJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIhatovMonogatariJapanRomDesc[] = {
	{ "Ihatov Monogatari (Japan).sfc",          1048576, 0xc588cd17, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIhatovMonogatariJapan)
STD_ROM_FN(rIhatovMonogatariJapan)

struct BurnDriver BurnDrvrIhatovMonogatariJapan = {
	"Ihatov Monogatari (Japan)", NULL, NULL, "1986",
	"Ihatov Monogatari (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ihatov Monogatari (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIhatovMonogatariJapanRomInfo, rIhatovMonogatariJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIkarinoYousaiJapanBSRomDesc[] = {
	{ "Ikari no Yousai (Japan) (BS).sfc",          1048576, 0xc69a81ea, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIkarinoYousaiJapanBS)
STD_ROM_FN(rIkarinoYousaiJapanBS)

struct BurnDriver BurnDrvrIkarinoYousaiJapanBS = {
	"Ikari no Yousai (Japan) (BS)", NULL, NULL, "1986",
	"Ikari no Yousai (Japan) (BS)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ikari no Yousai (Japan) (BS)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIkarinoYousaiJapanBSRomInfo, rIkarinoYousaiJapanBSRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIkarinoYousaiJapanRomDesc[] = {
	{ "Ikari no Yousai (Japan).sfc",          1048576, 0x4d5329f2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIkarinoYousaiJapan)
STD_ROM_FN(rIkarinoYousaiJapan)

struct BurnDriver BurnDrvrIkarinoYousaiJapan = {
	"Ikari no Yousai (Japan)", NULL, NULL, "1986",
	"Ikari no Yousai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ikari no Yousai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIkarinoYousaiJapanRomInfo, rIkarinoYousaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIllusionofGaiaUSABetaRomDesc[] = {
	{ "Illusion of Gaia (USA) (Beta).sfc",          2097152, 0xce90286b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIllusionofGaiaUSABeta)
STD_ROM_FN(rIllusionofGaiaUSABeta)

struct BurnDriver BurnDrvrIllusionofGaiaUSABeta = {
	"Illusion of Gaia (USA) (Beta)", NULL, NULL, "1986",
	"Illusion of Gaia (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Illusion of Gaia (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIllusionofGaiaUSABetaRomInfo, rIllusionofGaiaUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIllusionofGaiaUSARomDesc[] = {
	{ "Illusion of Gaia (USA).sfc",          2097152, 0x1c3848c0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIllusionofGaiaUSA)
STD_ROM_FN(rIllusionofGaiaUSA)

struct BurnDriver BurnDrvrIllusionofGaiaUSA = {
	"Illusion of Gaia (USA)", NULL, NULL, "1986",
	"Illusion of Gaia (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Illusion of Gaia (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIllusionofGaiaUSARomInfo, rIllusionofGaiaUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIllusionofTimeEuropeRomDesc[] = {
	{ "Illusion of Time (Europe).sfc",          2097152, 0xf9ae28db, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIllusionofTimeEurope)
STD_ROM_FN(rIllusionofTimeEurope)

struct BurnDriver BurnDrvrIllusionofTimeEurope = {
	"Illusion of Time (Europe)", NULL, NULL, "1986",
	"Illusion of Time (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Illusion of Time (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIllusionofTimeEuropeRomInfo, rIllusionofTimeEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIllusionofTimeFranceRomDesc[] = {
	{ "Illusion of Time (France).sfc",          2097152, 0x63f6f934, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIllusionofTimeFrance)
STD_ROM_FN(rIllusionofTimeFrance)

struct BurnDriver BurnDrvrIllusionofTimeFrance = {
	"Illusion of Time (France)", NULL, NULL, "1986",
	"Illusion of Time (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"Illusion of Time (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIllusionofTimeFranceRomInfo, rIllusionofTimeFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIllusionofTimeGermanyRev1RomDesc[] = {
	{ "Illusion of Time (Germany) (Rev 1).sfc",          2097152, 0x4bd8e60b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIllusionofTimeGermanyRev1)
STD_ROM_FN(rIllusionofTimeGermanyRev1)

struct BurnDriver BurnDrvrIllusionofTimeGermanyRev1 = {
	"Illusion of Time (Germany) (Rev 1)", NULL, NULL, "1986",
	"Illusion of Time (Germany) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Illusion of Time (Germany) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIllusionofTimeGermanyRev1RomInfo, rIllusionofTimeGermanyRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIllusionofTimeGermanyRomDesc[] = {
	{ "Illusion of Time (Germany).sfc",          2097152, 0x1a7c8541, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIllusionofTimeGermany)
STD_ROM_FN(rIllusionofTimeGermany)

struct BurnDriver BurnDrvrIllusionofTimeGermany = {
	"Illusion of Time (Germany)", NULL, NULL, "1986",
	"Illusion of Time (Germany)\0", NULL, "Nintendo", "Miscellaneous",
	L"Illusion of Time (Germany)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIllusionofTimeGermanyRomInfo, rIllusionofTimeGermanyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIllusionofTimeSpainRomDesc[] = {
	{ "Illusion of Time (Spain).sfc",          2097152, 0x7c305dc8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIllusionofTimeSpain)
STD_ROM_FN(rIllusionofTimeSpain)

struct BurnDriver BurnDrvrIllusionofTimeSpain = {
	"Illusion of Time (Spain)", NULL, NULL, "1986",
	"Illusion of Time (Spain)\0", NULL, "Nintendo", "Miscellaneous",
	L"Illusion of Time (Spain)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIllusionofTimeSpainRomInfo, rIllusionofTimeSpainRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIllvaniannoShiroJapanRomDesc[] = {
	{ "Illvanian no Shiro (Japan).sfc",          2097152, 0xf568579f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIllvaniannoShiroJapan)
STD_ROM_FN(rIllvaniannoShiroJapan)

struct BurnDriver BurnDrvrIllvaniannoShiroJapan = {
	"Illvanian no Shiro (Japan)", NULL, NULL, "1986",
	"Illvanian no Shiro (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Illvanian no Shiro (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIllvaniannoShiroJapanRomInfo, rIllvaniannoShiroJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rImperiumUSARomDesc[] = {
	{ "Imperium (USA).sfc",          1048576, 0x2624f8bd, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rImperiumUSA)
STD_ROM_FN(rImperiumUSA)

struct BurnDriver BurnDrvrImperiumUSA = {
	"Imperium (USA)", NULL, NULL, "1986",
	"Imperium (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Imperium (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rImperiumUSARomInfo, rImperiumUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInazumaServedaSuperBeachVolleyJapanRomDesc[] = {
	{ "Inazuma Serve da! Super Beach Volley (Japan).sfc",          1048576, 0x879edee8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInazumaServedaSuperBeachVolleyJapan)
STD_ROM_FN(rInazumaServedaSuperBeachVolleyJapan)

struct BurnDriver BurnDrvrInazumaServedaSuperBeachVolleyJapan = {
	"Inazuma Serve da! Super Beach Volley (Japan)", NULL, NULL, "1986",
	"Inazuma Serve da! Super Beach Volley (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Inazuma Serve da! Super Beach Volley (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInazumaServedaSuperBeachVolleyJapanRomInfo, rInazumaServedaSuperBeachVolleyJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIncantationEuropeRomDesc[] = {
	{ "Incantation (Europe).sfc",          524288, 0x34fad701, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIncantationEurope)
STD_ROM_FN(rIncantationEurope)

struct BurnDriver BurnDrvrIncantationEurope = {
	"Incantation (Europe)", NULL, NULL, "1986",
	"Incantation (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Incantation (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIncantationEuropeRomInfo, rIncantationEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIncantationUSARomDesc[] = {
	{ "Incantation (USA).sfc",          524288, 0xd0ff7e9f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIncantationUSA)
STD_ROM_FN(rIncantationUSA)

struct BurnDriver BurnDrvrIncantationUSA = {
	"Incantation (USA)", NULL, NULL, "1986",
	"Incantation (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Incantation (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIncantationUSARomInfo, rIncantationUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIncredibleCrashDummiesTheEuropeRomDesc[] = {
	{ "Incredible Crash Dummies, The (Europe).sfc",          1048576, 0x3ee9b136, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIncredibleCrashDummiesTheEurope)
STD_ROM_FN(rIncredibleCrashDummiesTheEurope)

struct BurnDriver BurnDrvrIncredibleCrashDummiesTheEurope = {
	"Incredible Crash Dummies, The (Europe)", NULL, NULL, "1986",
	"Incredible Crash Dummies, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Incredible Crash Dummies, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIncredibleCrashDummiesTheEuropeRomInfo, rIncredibleCrashDummiesTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIncredibleCrashDummiesTheUSABetaRomDesc[] = {
	{ "Incredible Crash Dummies, The (USA) (Beta).sfc",          1048576, 0x42ebe9c1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIncredibleCrashDummiesTheUSABeta)
STD_ROM_FN(rIncredibleCrashDummiesTheUSABeta)

struct BurnDriver BurnDrvrIncredibleCrashDummiesTheUSABeta = {
	"Incredible Crash Dummies, The (USA) (Beta)", NULL, NULL, "1986",
	"Incredible Crash Dummies, The (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Incredible Crash Dummies, The (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIncredibleCrashDummiesTheUSABetaRomInfo, rIncredibleCrashDummiesTheUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIncredibleCrashDummiesTheUSARomDesc[] = {
	{ "Incredible Crash Dummies, The (USA).sfc",          1048576, 0xb6209ba, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIncredibleCrashDummiesTheUSA)
STD_ROM_FN(rIncredibleCrashDummiesTheUSA)

struct BurnDriver BurnDrvrIncredibleCrashDummiesTheUSA = {
	"Incredible Crash Dummies, The (USA)", NULL, NULL, "1986",
	"Incredible Crash Dummies, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Incredible Crash Dummies, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIncredibleCrashDummiesTheUSARomInfo, rIncredibleCrashDummiesTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIncredibleCrashDummiesTheDrZabuoSukuidaseJapanRomDesc[] = {
	{ "Incredible Crash Dummies, The - Dr. Zabu o Sukuidase (Japan).sfc",          1048576, 0xc3bc16d5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIncredibleCrashDummiesTheDrZabuoSukuidaseJapan)
STD_ROM_FN(rIncredibleCrashDummiesTheDrZabuoSukuidaseJapan)

struct BurnDriver BurnDrvrIncredibleCrashDummiesTheDrZabuoSukuidaseJapan = {
	"Incredible Crash Dummies, The - Dr. Zabu o Sukuidase (Japan)", NULL, NULL, "1986",
	"Incredible Crash Dummies, The - Dr. Zabu o Sukuidase (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Incredible Crash Dummies, The - Dr. Zabu o Sukuidase (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIncredibleCrashDummiesTheDrZabuoSukuidaseJapanRomInfo, rIncredibleCrashDummiesTheDrZabuoSukuidaseJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIncredibleHulkTheEuropeRomDesc[] = {
	{ "Incredible Hulk, The (Europe).sfc",          2097152, 0x9df29605, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIncredibleHulkTheEurope)
STD_ROM_FN(rIncredibleHulkTheEurope)

struct BurnDriver BurnDrvrIncredibleHulkTheEurope = {
	"Incredible Hulk, The (Europe)", NULL, NULL, "1986",
	"Incredible Hulk, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Incredible Hulk, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIncredibleHulkTheEuropeRomInfo, rIncredibleHulkTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIncredibleHulkTheUSARomDesc[] = {
	{ "Incredible Hulk, The (USA).sfc",          2097152, 0x36b5a429, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIncredibleHulkTheUSA)
STD_ROM_FN(rIncredibleHulkTheUSA)

struct BurnDriver BurnDrvrIncredibleHulkTheUSA = {
	"Incredible Hulk, The (USA)", NULL, NULL, "1986",
	"Incredible Hulk, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Incredible Hulk, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIncredibleHulkTheUSARomInfo, rIncredibleHulkTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIndianaJonesGreatestAdventuresEuropeRomDesc[] = {
	{ "Indiana Jones' Greatest Adventures (Europe).sfc",          2097152, 0xfa4560c3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIndianaJonesGreatestAdventuresEurope)
STD_ROM_FN(rIndianaJonesGreatestAdventuresEurope)

struct BurnDriver BurnDrvrIndianaJonesGreatestAdventuresEurope = {
	"Indiana Jones' Greatest Adventures (Europe)", NULL, NULL, "1986",
	"Indiana Jones' Greatest Adventures (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Indiana Jones' Greatest Adventures (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIndianaJonesGreatestAdventuresEuropeRomInfo, rIndianaJonesGreatestAdventuresEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIndianaJonesGreatestAdventuresJapanRomDesc[] = {
	{ "Indiana Jones' Greatest Adventures (Japan).sfc",          2097152, 0x79b9996, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIndianaJonesGreatestAdventuresJapan)
STD_ROM_FN(rIndianaJonesGreatestAdventuresJapan)

struct BurnDriver BurnDrvrIndianaJonesGreatestAdventuresJapan = {
	"Indiana Jones' Greatest Adventures (Japan)", NULL, NULL, "1986",
	"Indiana Jones' Greatest Adventures (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Indiana Jones' Greatest Adventures (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIndianaJonesGreatestAdventuresJapanRomInfo, rIndianaJonesGreatestAdventuresJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIndianaJonesGreatestAdventuresUSARomDesc[] = {
	{ "Indiana Jones' Greatest Adventures (USA).sfc",          2097152, 0x70da6bb8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIndianaJonesGreatestAdventuresUSA)
STD_ROM_FN(rIndianaJonesGreatestAdventuresUSA)

struct BurnDriver BurnDrvrIndianaJonesGreatestAdventuresUSA = {
	"Indiana Jones' Greatest Adventures (USA)", NULL, NULL, "1986",
	"Indiana Jones' Greatest Adventures (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Indiana Jones' Greatest Adventures (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIndianaJonesGreatestAdventuresUSARomInfo, rIndianaJonesGreatestAdventuresUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInindoWayoftheNinjaUSARomDesc[] = {
	{ "Inindo - Way of the Ninja (USA).sfc",          1048576, 0x543f3327, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInindoWayoftheNinjaUSA)
STD_ROM_FN(rInindoWayoftheNinjaUSA)

struct BurnDriver BurnDrvrInindoWayoftheNinjaUSA = {
	"Inindo - Way of the Ninja (USA)", NULL, NULL, "1986",
	"Inindo - Way of the Ninja (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Inindo - Way of the Ninja (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInindoWayoftheNinjaUSARomInfo, rInindoWayoftheNinjaUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInspectorGadgetUSARomDesc[] = {
	{ "Inspector Gadget (USA).sfc",          1048576, 0x4ce2b818, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInspectorGadgetUSA)
STD_ROM_FN(rInspectorGadgetUSA)

struct BurnDriver BurnDrvrInspectorGadgetUSA = {
	"Inspector Gadget (USA)", NULL, NULL, "1986",
	"Inspector Gadget (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Inspector Gadget (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInspectorGadgetUSARomInfo, rInspectorGadgetUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInternationalSensibleSoccerWorldChampionsLimitedEditionEuropeEnFrDeItRev1RomDesc[] = {
	{ "International Sensible Soccer - World Champions Limited Edition (Europe) (En,Fr,De,It) (Rev 1).sfc",          524288, 0x6ff2d97e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInternationalSensibleSoccerWorldChampionsLimitedEditionEuropeEnFrDeItRev1)
STD_ROM_FN(rInternationalSensibleSoccerWorldChampionsLimitedEditionEuropeEnFrDeItRev1)

struct BurnDriver BurnDrvrInternationalSensibleSoccerWorldChampionsLimitedEditionEuropeEnFrDeItRev1 = {
	"International Sensible Soccer - World Champions Limited Edition (Europe) (En,Fr,De,It) (Rev 1)", NULL, NULL, "1986",
	"International Sensible Soccer - World Champions Limited Edition (Europe) (En,Fr,De,It) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"International Sensible Soccer - World Champions Limited Edition (Europe) (En,Fr,De,It) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInternationalSensibleSoccerWorldChampionsLimitedEditionEuropeEnFrDeItRev1RomInfo, rInternationalSensibleSoccerWorldChampionsLimitedEditionEuropeEnFrDeItRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInternationalSuperstarSoccerEuropeRomDesc[] = {
	{ "International Superstar Soccer (Europe).sfc",          1048576, 0x6cd568a9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInternationalSuperstarSoccerEurope)
STD_ROM_FN(rInternationalSuperstarSoccerEurope)

struct BurnDriver BurnDrvrInternationalSuperstarSoccerEurope = {
	"International Superstar Soccer (Europe)", NULL, NULL, "1986",
	"International Superstar Soccer (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"International Superstar Soccer (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInternationalSuperstarSoccerEuropeRomInfo, rInternationalSuperstarSoccerEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInternationalSuperstarSoccerUSARomDesc[] = {
	{ "International Superstar Soccer (USA).sfc",          1048576, 0x49627238, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInternationalSuperstarSoccerUSA)
STD_ROM_FN(rInternationalSuperstarSoccerUSA)

struct BurnDriver BurnDrvrInternationalSuperstarSoccerUSA = {
	"International Superstar Soccer (USA)", NULL, NULL, "1986",
	"International Superstar Soccer (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"International Superstar Soccer (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInternationalSuperstarSoccerUSARomInfo, rInternationalSuperstarSoccerUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInternationalSuperstarSoccerDeluxeEuropeRomDesc[] = {
	{ "International Superstar Soccer Deluxe (Europe).sfc",          2097152, 0xcba724ba, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInternationalSuperstarSoccerDeluxeEurope)
STD_ROM_FN(rInternationalSuperstarSoccerDeluxeEurope)

struct BurnDriver BurnDrvrInternationalSuperstarSoccerDeluxeEurope = {
	"International Superstar Soccer Deluxe (Europe)", NULL, NULL, "1986",
	"International Superstar Soccer Deluxe (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"International Superstar Soccer Deluxe (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInternationalSuperstarSoccerDeluxeEuropeRomInfo, rInternationalSuperstarSoccerDeluxeEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInternationalSuperstarSoccerDeluxeUSARomDesc[] = {
	{ "International Superstar Soccer Deluxe (USA).sfc",          2097152, 0xa20e602, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInternationalSuperstarSoccerDeluxeUSA)
STD_ROM_FN(rInternationalSuperstarSoccerDeluxeUSA)

struct BurnDriver BurnDrvrInternationalSuperstarSoccerDeluxeUSA = {
	"International Superstar Soccer Deluxe (USA)", NULL, NULL, "1986",
	"International Superstar Soccer Deluxe (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"International Superstar Soccer Deluxe (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInternationalSuperstarSoccerDeluxeUSARomInfo, rInternationalSuperstarSoccerDeluxeUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInternationalTennisTourEuropeRomDesc[] = {
	{ "International Tennis Tour (Europe).sfc",          1048576, 0x6bbcea4f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInternationalTennisTourEurope)
STD_ROM_FN(rInternationalTennisTourEurope)

struct BurnDriver BurnDrvrInternationalTennisTourEurope = {
	"International Tennis Tour (Europe)", NULL, NULL, "1986",
	"International Tennis Tour (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"International Tennis Tour (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInternationalTennisTourEuropeRomInfo, rInternationalTennisTourEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInternationalTennisTourJapanRomDesc[] = {
	{ "International Tennis Tour (Japan).sfc",          1048576, 0x45f2dab9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInternationalTennisTourJapan)
STD_ROM_FN(rInternationalTennisTourJapan)

struct BurnDriver BurnDrvrInternationalTennisTourJapan = {
	"International Tennis Tour (Japan)", NULL, NULL, "1986",
	"International Tennis Tour (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"International Tennis Tour (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInternationalTennisTourJapanRomInfo, rInternationalTennisTourJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rInternationalTennisTourUSARomDesc[] = {
	{ "International Tennis Tour (USA).sfc",          1048576, 0xad3cd5e6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rInternationalTennisTourUSA)
STD_ROM_FN(rInternationalTennisTourUSA)

struct BurnDriver BurnDrvrInternationalTennisTourUSA = {
	"International Tennis Tour (USA)", NULL, NULL, "1986",
	"International Tennis Tour (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"International Tennis Tour (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rInternationalTennisTourUSARomInfo, rInternationalTennisTourUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIppatsuGyakutenJapanRomDesc[] = {
	{ "Ippatsu Gyakuten (Japan).sfc",          1048576, 0x5a9fde8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIppatsuGyakutenJapan)
STD_ROM_FN(rIppatsuGyakutenJapan)

struct BurnDriver BurnDrvrIppatsuGyakutenJapan = {
	"Ippatsu Gyakuten (Japan)", NULL, NULL, "1986",
	"Ippatsu Gyakuten (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Ippatsu Gyakuten (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIppatsuGyakutenJapanRomInfo, rIppatsuGyakutenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIremMajorTitleTheEuropeRomDesc[] = {
	{ "Irem Major Title, The (Europe).sfc",          1048576, 0x3075cb04, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIremMajorTitleTheEurope)
STD_ROM_FN(rIremMajorTitleTheEurope)

struct BurnDriver BurnDrvrIremMajorTitleTheEurope = {
	"Irem Major Title, The (Europe)", NULL, NULL, "1986",
	"Irem Major Title, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Irem Major Title, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIremMajorTitleTheEuropeRomInfo, rIremMajorTitleTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIremMajorTitleTheJapanRomDesc[] = {
	{ "Irem Major Title, The (Japan).sfc",          1048576, 0xe98f71d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIremMajorTitleTheJapan)
STD_ROM_FN(rIremMajorTitleTheJapan)

struct BurnDriver BurnDrvrIremMajorTitleTheJapan = {
	"Irem Major Title, The (Japan)", NULL, NULL, "1986",
	"Irem Major Title, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Irem Major Title, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIremMajorTitleTheJapanRomInfo, rIremMajorTitleTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIremSkinsGameTheUSARomDesc[] = {
	{ "Irem Skins Game, The (USA).sfc",          1048576, 0xb95ddc44, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIremSkinsGameTheUSA)
STD_ROM_FN(rIremSkinsGameTheUSA)

struct BurnDriver BurnDrvrIremSkinsGameTheUSA = {
	"Irem Skins Game, The (USA)", NULL, NULL, "1986",
	"Irem Skins Game, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Irem Skins Game, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIremSkinsGameTheUSARomInfo, rIremSkinsGameTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIronCommandoEuropeProtoRomDesc[] = {
	{ "Iron Commando (Europe) (Proto).sfc",          1310720, 0xd967299d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIronCommandoEuropeProto)
STD_ROM_FN(rIronCommandoEuropeProto)

struct BurnDriver BurnDrvrIronCommandoEuropeProto = {
	"Iron Commando (Europe) (Proto)", NULL, NULL, "1986",
	"Iron Commando (Europe) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Iron Commando (Europe) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIronCommandoEuropeProtoRomInfo, rIronCommandoEuropeProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIronCommandoKoutetsunoSenshiJapanRomDesc[] = {
	{ "Iron Commando - Koutetsu no Senshi (Japan).sfc",          1310720, 0x828b5f07, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIronCommandoKoutetsunoSenshiJapan)
STD_ROM_FN(rIronCommandoKoutetsunoSenshiJapan)

struct BurnDriver BurnDrvrIronCommandoKoutetsunoSenshiJapan = {
	"Iron Commando - Koutetsu no Senshi (Japan)", NULL, NULL, "1986",
	"Iron Commando - Koutetsu no Senshi (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Iron Commando - Koutetsu no Senshi (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIronCommandoKoutetsunoSenshiJapanRomInfo, rIronCommandoKoutetsunoSenshiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIsozuriRitouHenJapanRomDesc[] = {
	{ "Isozuri - Ritou Hen (Japan).sfc",          2097152, 0x3d35d085, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIsozuriRitouHenJapan)
STD_ROM_FN(rIsozuriRitouHenJapan)

struct BurnDriver BurnDrvrIsozuriRitouHenJapan = {
	"Isozuri - Ritou Hen (Japan)", NULL, NULL, "1986",
	"Isozuri - Ritou Hen (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Isozuri - Ritou Hen (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIsozuriRitouHenJapanRomInfo, rIsozuriRitouHenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rItadakiStreet2NeonSignwaBaraironiJapanRomDesc[] = {
	{ "Itadaki Street 2 - Neon Sign wa Barairo ni (Japan).sfc",          1572864, 0x95310032, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rItadakiStreet2NeonSignwaBaraironiJapan)
STD_ROM_FN(rItadakiStreet2NeonSignwaBaraironiJapan)

struct BurnDriver BurnDrvrItadakiStreet2NeonSignwaBaraironiJapan = {
	"Itadaki Street 2 - Neon Sign wa Barairo ni (Japan)", NULL, NULL, "1986",
	"Itadaki Street 2 - Neon Sign wa Barairo ni (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Itadaki Street 2 - Neon Sign wa Barairo ni (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rItadakiStreet2NeonSignwaBaraironiJapanRomInfo, rItadakiStreet2NeonSignwaBaraironiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rItchyScratchyGameTheEuropeRomDesc[] = {
	{ "Itchy & Scratchy Game, The (Europe).sfc",          1048576, 0xc402347a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rItchyScratchyGameTheEurope)
STD_ROM_FN(rItchyScratchyGameTheEurope)

struct BurnDriver BurnDrvrItchyScratchyGameTheEurope = {
	"Itchy & Scratchy Game, The (Europe)", NULL, NULL, "1986",
	"Itchy & Scratchy Game, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Itchy & Scratchy Game, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rItchyScratchyGameTheEuropeRomInfo, rItchyScratchyGameTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rItchyScratchyGameTheUSARomDesc[] = {
	{ "Itchy & Scratchy Game, The (USA).sfc",          1048576, 0x95b65dfe, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rItchyScratchyGameTheUSA)
STD_ROM_FN(rItchyScratchyGameTheUSA)

struct BurnDriver BurnDrvrItchyScratchyGameTheUSA = {
	"Itchy & Scratchy Game, The (USA)", NULL, NULL, "1986",
	"Itchy & Scratchy Game, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Itchy & Scratchy Game, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rItchyScratchyGameTheUSARomInfo, rItchyScratchyGameTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rItoiShigesatonoBassTsuriNo1JapanRomDesc[] = {
	{ "Itoi Shigesato no Bass Tsuri No. 1 (Japan).sfc",          4194304, 0xb9ba8544, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rItoiShigesatonoBassTsuriNo1Japan)
STD_ROM_FN(rItoiShigesatonoBassTsuriNo1Japan)

struct BurnDriver BurnDrvrItoiShigesatonoBassTsuriNo1Japan = {
	"Itoi Shigesato no Bass Tsuri No. 1 (Japan)", NULL, NULL, "1986",
	"Itoi Shigesato no Bass Tsuri No. 1 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Itoi Shigesato no Bass Tsuri No. 1 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rItoiShigesatonoBassTsuriNo1JapanRomInfo, rItoiShigesatonoBassTsuriNo1JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rItouHatasuRokudannoShougiDoujouJapanRev1RomDesc[] = {
	{ "Itou Hatasu Rokudan no Shougi Doujou (Japan) (Rev 1).sfc",          1048576, 0x7ee270da, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rItouHatasuRokudannoShougiDoujouJapanRev1)
STD_ROM_FN(rItouHatasuRokudannoShougiDoujouJapanRev1)

struct BurnDriver BurnDrvrItouHatasuRokudannoShougiDoujouJapanRev1 = {
	"Itou Hatasu Rokudan no Shougi Doujou (Japan) (Rev 1)", NULL, NULL, "1986",
	"Itou Hatasu Rokudan no Shougi Doujou (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Itou Hatasu Rokudan no Shougi Doujou (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rItouHatasuRokudannoShougiDoujouJapanRev1RomInfo, rItouHatasuRokudannoShougiDoujouJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rItouHatasuRokudannoShougiDoujouJapanRomDesc[] = {
	{ "Itou Hatasu Rokudan no Shougi Doujou (Japan).sfc",          1048576, 0xbffce7c6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rItouHatasuRokudannoShougiDoujouJapan)
STD_ROM_FN(rItouHatasuRokudannoShougiDoujouJapan)

struct BurnDriver BurnDrvrItouHatasuRokudannoShougiDoujouJapan = {
	"Itou Hatasu Rokudan no Shougi Doujou (Japan)", NULL, NULL, "1986",
	"Itou Hatasu Rokudan no Shougi Doujou (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Itou Hatasu Rokudan no Shougi Doujou (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rItouHatasuRokudannoShougiDoujouJapanRomInfo, rItouHatasuRokudannoShougiDoujouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIzzysQuestfortheOlympicRingsEuropeRomDesc[] = {
	{ "Izzy's Quest for the Olympic Rings (Europe).sfc",          2097152, 0xb096e82e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIzzysQuestfortheOlympicRingsEurope)
STD_ROM_FN(rIzzysQuestfortheOlympicRingsEurope)

struct BurnDriver BurnDrvrIzzysQuestfortheOlympicRingsEurope = {
	"Izzy's Quest for the Olympic Rings (Europe)", NULL, NULL, "1986",
	"Izzy's Quest for the Olympic Rings (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Izzy's Quest for the Olympic Rings (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIzzysQuestfortheOlympicRingsEuropeRomInfo, rIzzysQuestfortheOlympicRingsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIzzysQuestfortheOlympicRingsUSABetaRomDesc[] = {
	{ "Izzy's Quest for the Olympic Rings (USA) (Beta).sfc",          2097152, 0x53ce0546, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIzzysQuestfortheOlympicRingsUSABeta)
STD_ROM_FN(rIzzysQuestfortheOlympicRingsUSABeta)

struct BurnDriver BurnDrvrIzzysQuestfortheOlympicRingsUSABeta = {
	"Izzy's Quest for the Olympic Rings (USA) (Beta)", NULL, NULL, "1986",
	"Izzy's Quest for the Olympic Rings (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Izzy's Quest for the Olympic Rings (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIzzysQuestfortheOlympicRingsUSABetaRomInfo, rIzzysQuestfortheOlympicRingsUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rIzzysQuestfortheOlympicRingsUSARomDesc[] = {
	{ "Izzy's Quest for the Olympic Rings (USA).sfc",          2097152, 0xe9bb68c7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rIzzysQuestfortheOlympicRingsUSA)
STD_ROM_FN(rIzzysQuestfortheOlympicRingsUSA)

struct BurnDriver BurnDrvrIzzysQuestfortheOlympicRingsUSA = {
	"Izzy's Quest for the Olympic Rings (USA)", NULL, NULL, "1986",
	"Izzy's Quest for the Olympic Rings (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Izzy's Quest for the Olympic Rings (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rIzzysQuestfortheOlympicRingsUSARomInfo, rIzzysQuestfortheOlympicRingsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeague96DreamStadiumJapanRomDesc[] = {
	{ "J.League '96 Dream Stadium (Japan).sfc",          2621440, 0x93a0a25c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeague96DreamStadiumJapan)
STD_ROM_FN(rJLeague96DreamStadiumJapan)

struct BurnDriver BurnDrvrJLeague96DreamStadiumJapan = {
	"J.League '96 Dream Stadium (Japan)", NULL, NULL, "1986",
	"J.League '96 Dream Stadium (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League '96 Dream Stadium (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeague96DreamStadiumJapanRomInfo, rJLeague96DreamStadiumJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueExciteStage94JapanRev1RomDesc[] = {
	{ "J.League Excite Stage '94 (Japan) (Rev 1).sfc",          1572864, 0xc9e33615, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueExciteStage94JapanRev1)
STD_ROM_FN(rJLeagueExciteStage94JapanRev1)

struct BurnDriver BurnDrvrJLeagueExciteStage94JapanRev1 = {
	"J.League Excite Stage '94 (Japan) (Rev 1)", NULL, NULL, "1986",
	"J.League Excite Stage '94 (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Excite Stage '94 (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueExciteStage94JapanRev1RomInfo, rJLeagueExciteStage94JapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueExciteStage94JapanRomDesc[] = {
	{ "J.League Excite Stage '94 (Japan).sfc",          1572864, 0xd96b3936, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueExciteStage94Japan)
STD_ROM_FN(rJLeagueExciteStage94Japan)

struct BurnDriver BurnDrvrJLeagueExciteStage94Japan = {
	"J.League Excite Stage '94 (Japan)", NULL, NULL, "1986",
	"J.League Excite Stage '94 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Excite Stage '94 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueExciteStage94JapanRomInfo, rJLeagueExciteStage94JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueExciteStage95JapanRomDesc[] = {
	{ "J.League Excite Stage '95 (Japan).sfc",          1572864, 0xdd871511, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueExciteStage95Japan)
STD_ROM_FN(rJLeagueExciteStage95Japan)

struct BurnDriver BurnDrvrJLeagueExciteStage95Japan = {
	"J.League Excite Stage '95 (Japan)", NULL, NULL, "1986",
	"J.League Excite Stage '95 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Excite Stage '95 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueExciteStage95JapanRomInfo, rJLeagueExciteStage95JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueExciteStage96JapanRev1RomDesc[] = {
	{ "J.League Excite Stage '96 (Japan) (Rev 1).sfc",          2097152, 0x857bbfab, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueExciteStage96JapanRev1)
STD_ROM_FN(rJLeagueExciteStage96JapanRev1)

struct BurnDriver BurnDrvrJLeagueExciteStage96JapanRev1 = {
	"J.League Excite Stage '96 (Japan) (Rev 1)", NULL, NULL, "1986",
	"J.League Excite Stage '96 (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Excite Stage '96 (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueExciteStage96JapanRev1RomInfo, rJLeagueExciteStage96JapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueExciteStage96JapanRomDesc[] = {
	{ "J.League Excite Stage '96 (Japan).sfc",          2097152, 0xe044e0f1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueExciteStage96Japan)
STD_ROM_FN(rJLeagueExciteStage96Japan)

struct BurnDriver BurnDrvrJLeagueExciteStage96Japan = {
	"J.League Excite Stage '96 (Japan)", NULL, NULL, "1986",
	"J.League Excite Stage '96 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Excite Stage '96 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueExciteStage96JapanRomInfo, rJLeagueExciteStage96JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueSoccerPrimeGoalJapanRev1RomDesc[] = {
	{ "J.League Soccer Prime Goal (Japan) (Rev 1).sfc",          1048576, 0x7538f598, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueSoccerPrimeGoalJapanRev1)
STD_ROM_FN(rJLeagueSoccerPrimeGoalJapanRev1)

struct BurnDriver BurnDrvrJLeagueSoccerPrimeGoalJapanRev1 = {
	"J.League Soccer Prime Goal (Japan) (Rev 1)", NULL, NULL, "1986",
	"J.League Soccer Prime Goal (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Soccer Prime Goal (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueSoccerPrimeGoalJapanRev1RomInfo, rJLeagueSoccerPrimeGoalJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueSoccerPrimeGoalJapanRomDesc[] = {
	{ "J.League Soccer Prime Goal (Japan).sfc",          1048576, 0xb81828ec, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueSoccerPrimeGoalJapan)
STD_ROM_FN(rJLeagueSoccerPrimeGoalJapan)

struct BurnDriver BurnDrvrJLeagueSoccerPrimeGoalJapan = {
	"J.League Soccer Prime Goal (Japan)", NULL, NULL, "1986",
	"J.League Soccer Prime Goal (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Soccer Prime Goal (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueSoccerPrimeGoalJapanRomInfo, rJLeagueSoccerPrimeGoalJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueSoccerPrimeGoal2JapanRomDesc[] = {
	{ "J.League Soccer Prime Goal 2 (Japan).sfc",          1572864, 0x569db79d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueSoccerPrimeGoal2Japan)
STD_ROM_FN(rJLeagueSoccerPrimeGoal2Japan)

struct BurnDriver BurnDrvrJLeagueSoccerPrimeGoal2Japan = {
	"J.League Soccer Prime Goal 2 (Japan)", NULL, NULL, "1986",
	"J.League Soccer Prime Goal 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Soccer Prime Goal 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueSoccerPrimeGoal2JapanRomInfo, rJLeagueSoccerPrimeGoal2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueSoccerPrimeGoal3JapanRomDesc[] = {
	{ "J.League Soccer Prime Goal 3 (Japan).sfc",          2097152, 0x1499b746, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueSoccerPrimeGoal3Japan)
STD_ROM_FN(rJLeagueSoccerPrimeGoal3Japan)

struct BurnDriver BurnDrvrJLeagueSoccerPrimeGoal3Japan = {
	"J.League Soccer Prime Goal 3 (Japan)", NULL, NULL, "1986",
	"J.League Soccer Prime Goal 3 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Soccer Prime Goal 3 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueSoccerPrimeGoal3JapanRomInfo, rJLeagueSoccerPrimeGoal3JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueSuperSoccer95JikkyouStadiumJapanRomDesc[] = {
	{ "J.League Super Soccer '95 - Jikkyou Stadium (Japan).sfc",          2097152, 0x26664bb4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueSuperSoccer95JikkyouStadiumJapan)
STD_ROM_FN(rJLeagueSuperSoccer95JikkyouStadiumJapan)

struct BurnDriver BurnDrvrJLeagueSuperSoccer95JikkyouStadiumJapan = {
	"J.League Super Soccer '95 - Jikkyou Stadium (Japan)", NULL, NULL, "1986",
	"J.League Super Soccer '95 - Jikkyou Stadium (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Super Soccer '95 - Jikkyou Stadium (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueSuperSoccer95JikkyouStadiumJapanRomInfo, rJLeagueSuperSoccer95JikkyouStadiumJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJLeagueSuperSoccerJapanRomDesc[] = {
	{ "J.League Super Soccer (Japan).sfc",          1572864, 0x1d20cac2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJLeagueSuperSoccerJapan)
STD_ROM_FN(rJLeagueSuperSoccerJapan)

struct BurnDriver BurnDrvrJLeagueSuperSoccerJapan = {
	"J.League Super Soccer (Japan)", NULL, NULL, "1986",
	"J.League Super Soccer (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.League Super Soccer (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJLeagueSuperSoccerJapanRomInfo, rJLeagueSuperSoccerJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJRRTolkiensTheLordoftheRingsVolume1USARomDesc[] = {
	{ "J.R.R. Tolkien's The Lord of the Rings - Volume 1 (USA).sfc",          1048576, 0xcd2150c8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJRRTolkiensTheLordoftheRingsVolume1USA)
STD_ROM_FN(rJRRTolkiensTheLordoftheRingsVolume1USA)

struct BurnDriver BurnDrvrJRRTolkiensTheLordoftheRingsVolume1USA = {
	"J.R.R. Tolkien's The Lord of the Rings - Volume 1 (USA)", NULL, NULL, "1986",
	"J.R.R. Tolkien's The Lord of the Rings - Volume 1 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.R.R. Tolkien's The Lord of the Rings - Volume 1 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJRRTolkiensTheLordoftheRingsVolume1USARomInfo, rJRRTolkiensTheLordoftheRingsVolume1USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJRRTolkiensTheLordoftheRingsVolumeOneEuropeRomDesc[] = {
	{ "J.R.R. Tolkien's The Lord of the Rings - Volume One (Europe).sfc",          1048576, 0x247c17d3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJRRTolkiensTheLordoftheRingsVolumeOneEurope)
STD_ROM_FN(rJRRTolkiensTheLordoftheRingsVolumeOneEurope)

struct BurnDriver BurnDrvrJRRTolkiensTheLordoftheRingsVolumeOneEurope = {
	"J.R.R. Tolkien's The Lord of the Rings - Volume One (Europe)", NULL, NULL, "1986",
	"J.R.R. Tolkien's The Lord of the Rings - Volume One (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.R.R. Tolkien's The Lord of the Rings - Volume One (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJRRTolkiensTheLordoftheRingsVolumeOneEuropeRomInfo, rJRRTolkiensTheLordoftheRingsVolumeOneEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJRRTolkiensTheLordoftheRingsVolumeOneGermanyRomDesc[] = {
	{ "J.R.R. Tolkien's The Lord of the Rings - Volume One (Germany).sfc",          1048576, 0x8b172b4e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJRRTolkiensTheLordoftheRingsVolumeOneGermany)
STD_ROM_FN(rJRRTolkiensTheLordoftheRingsVolumeOneGermany)

struct BurnDriver BurnDrvrJRRTolkiensTheLordoftheRingsVolumeOneGermany = {
	"J.R.R. Tolkien's The Lord of the Rings - Volume One (Germany)", NULL, NULL, "1986",
	"J.R.R. Tolkien's The Lord of the Rings - Volume One (Germany)\0", NULL, "Nintendo", "Miscellaneous",
	L"J.R.R. Tolkien's The Lord of the Rings - Volume One (Germany)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJRRTolkiensTheLordoftheRingsVolumeOneGermanyRomInfo, rJRRTolkiensTheLordoftheRingsVolumeOneGermanyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJackNicklausGolfEuropeRomDesc[] = {
	{ "Jack Nicklaus Golf (Europe).sfc",          524288, 0xa7f0652f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJackNicklausGolfEurope)
STD_ROM_FN(rJackNicklausGolfEurope)

struct BurnDriver BurnDrvrJackNicklausGolfEurope = {
	"Jack Nicklaus Golf (Europe)", NULL, NULL, "1986",
	"Jack Nicklaus Golf (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jack Nicklaus Golf (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJackNicklausGolfEuropeRomInfo, rJackNicklausGolfEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJackNicklausGolfFranceRomDesc[] = {
	{ "Jack Nicklaus Golf (France).sfc",          524288, 0x4c545a02, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJackNicklausGolfFrance)
STD_ROM_FN(rJackNicklausGolfFrance)

struct BurnDriver BurnDrvrJackNicklausGolfFrance = {
	"Jack Nicklaus Golf (France)", NULL, NULL, "1986",
	"Jack Nicklaus Golf (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jack Nicklaus Golf (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJackNicklausGolfFranceRomInfo, rJackNicklausGolfFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJackNicklausGolfUSARomDesc[] = {
	{ "Jack Nicklaus Golf (USA).sfc",          524288, 0x9abc58e2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJackNicklausGolfUSA)
STD_ROM_FN(rJackNicklausGolfUSA)

struct BurnDriver BurnDrvrJackNicklausGolfUSA = {
	"Jack Nicklaus Golf (USA)", NULL, NULL, "1986",
	"Jack Nicklaus Golf (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jack Nicklaus Golf (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJackNicklausGolfUSARomInfo, rJackNicklausGolfUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJakiCrushJapanRomDesc[] = {
	{ "Jaki Crush (Japan).sfc",          1048576, 0xf696d5a9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJakiCrushJapan)
STD_ROM_FN(rJakiCrushJapan)

struct BurnDriver BurnDrvrJakiCrushJapan = {
	"Jaki Crush (Japan)", NULL, NULL, "1986",
	"Jaki Crush (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jaki Crush (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJakiCrushJapanRomInfo, rJakiCrushJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJalecoRallyBigRunTheSupreme4WDChallengeJapanRomDesc[] = {
	{ "Jaleco Rally Big Run - The Supreme 4WD Challenge (Japan).sfc",          1048576, 0xc157978c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJalecoRallyBigRunTheSupreme4WDChallengeJapan)
STD_ROM_FN(rJalecoRallyBigRunTheSupreme4WDChallengeJapan)

struct BurnDriver BurnDrvrJalecoRallyBigRunTheSupreme4WDChallengeJapan = {
	"Jaleco Rally Big Run - The Supreme 4WD Challenge (Japan)", NULL, NULL, "1986",
	"Jaleco Rally Big Run - The Supreme 4WD Challenge (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jaleco Rally Big Run - The Supreme 4WD Challenge (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJalecoRallyBigRunTheSupreme4WDChallengeJapanRomInfo, rJalecoRallyBigRunTheSupreme4WDChallengeJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJamesBondJrEuropeRomDesc[] = {
	{ "James Bond Jr (Europe).sfc",          524288, 0x7414a4c2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJamesBondJrEurope)
STD_ROM_FN(rJamesBondJrEurope)

struct BurnDriver BurnDrvrJamesBondJrEurope = {
	"James Bond Jr (Europe)", NULL, NULL, "1986",
	"James Bond Jr (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"James Bond Jr (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJamesBondJrEuropeRomInfo, rJamesBondJrEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJamesBondJrUSARomDesc[] = {
	{ "James Bond Jr (USA).sfc",          524288, 0x69c2f850, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJamesBondJrUSA)
STD_ROM_FN(rJamesBondJrUSA)

struct BurnDriver BurnDrvrJamesBondJrUSA = {
	"James Bond Jr (USA)", NULL, NULL, "1986",
	"James Bond Jr (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"James Bond Jr (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJamesBondJrUSARomInfo, rJamesBondJrUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJamesPondsCrazySportsEuropeRomDesc[] = {
	{ "James Pond's Crazy Sports (Europe).sfc",          524288, 0x66f00725, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJamesPondsCrazySportsEurope)
STD_ROM_FN(rJamesPondsCrazySportsEurope)

struct BurnDriver BurnDrvrJamesPondsCrazySportsEurope = {
	"James Pond's Crazy Sports (Europe)", NULL, NULL, "1986",
	"James Pond's Crazy Sports (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"James Pond's Crazy Sports (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJamesPondsCrazySportsEuropeRomInfo, rJamesPondsCrazySportsEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJammesJapanRomDesc[] = {
	{ "Jammes (Japan).sfc",          524288, 0x9bb76902, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJammesJapan)
STD_ROM_FN(rJammesJapan)

struct BurnDriver BurnDrvrJammesJapan = {
	"Jammes (Japan)", NULL, NULL, "1986",
	"Jammes (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jammes (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJammesJapanRomInfo, rJammesJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJammitUSARomDesc[] = {
	{ "Jammit (USA).sfc",          2097152, 0x7bddd73f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJammitUSA)
STD_ROM_FN(rJammitUSA)

struct BurnDriver BurnDrvrJammitUSA = {
	"Jammit (USA)", NULL, NULL, "1986",
	"Jammit (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jammit (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJammitUSARomInfo, rJammitUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJanyuukiGokuuRandaJapanRomDesc[] = {
	{ "Janyuuki - Gokuu Randa (Japan).sfc",          1048576, 0x10978b2d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJanyuukiGokuuRandaJapan)
STD_ROM_FN(rJanyuukiGokuuRandaJapan)

struct BurnDriver BurnDrvrJanyuukiGokuuRandaJapan = {
	"Janyuuki - Gokuu Randa (Japan)", NULL, NULL, "1986",
	"Janyuuki - Gokuu Randa (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Janyuuki - Gokuu Randa (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJanyuukiGokuuRandaJapanRomInfo, rJanyuukiGokuuRandaJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJBTheSuperBassJapanRomDesc[] = {
	{ "JB The Super Bass (Japan).sfc",          2621440, 0xd85c1c8f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJBTheSuperBassJapan)
STD_ROM_FN(rJBTheSuperBassJapan)

struct BurnDriver BurnDrvrJBTheSuperBassJapan = {
	"JB The Super Bass (Japan)", NULL, NULL, "1986",
	"JB The Super Bass (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"JB The Super Bass (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJBTheSuperBassJapanRomInfo, rJBTheSuperBassJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJellyBoyEuropeRomDesc[] = {
	{ "Jelly Boy (Europe).sfc",          1048576, 0xf8c72a24, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJellyBoyEurope)
STD_ROM_FN(rJellyBoyEurope)

struct BurnDriver BurnDrvrJellyBoyEurope = {
	"Jelly Boy (Europe)", NULL, NULL, "1986",
	"Jelly Boy (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jelly Boy (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJellyBoyEuropeRomInfo, rJellyBoyEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJellyBoy2JapanProtoRomDesc[] = {
	{ "Jelly Boy 2 (Japan) (Proto).sfc",          1572864, 0xf3a6c574, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJellyBoy2JapanProto)
STD_ROM_FN(rJellyBoy2JapanProto)

struct BurnDriver BurnDrvrJellyBoy2JapanProto = {
	"Jelly Boy 2 (Japan) (Proto)", NULL, NULL, "1986",
	"Jelly Boy 2 (Japan) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jelly Boy 2 (Japan) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJellyBoy2JapanProtoRomInfo, rJellyBoy2JapanProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJeopardyUSARomDesc[] = {
	{ "Jeopardy! (USA).sfc",          524288, 0x65bf3a7e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJeopardyUSA)
STD_ROM_FN(rJeopardyUSA)

struct BurnDriver BurnDrvrJeopardyUSA = {
	"Jeopardy! (USA)", NULL, NULL, "1986",
	"Jeopardy! (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jeopardy! (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJeopardyUSARomInfo, rJeopardyUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJeopardyDeluxeEditionUSARomDesc[] = {
	{ "Jeopardy! - Deluxe Edition (USA).sfc",          524288, 0x6301060c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJeopardyDeluxeEditionUSA)
STD_ROM_FN(rJeopardyDeluxeEditionUSA)

struct BurnDriver BurnDrvrJeopardyDeluxeEditionUSA = {
	"Jeopardy! - Deluxe Edition (USA)", NULL, NULL, "1986",
	"Jeopardy! - Deluxe Edition (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jeopardy! - Deluxe Edition (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJeopardyDeluxeEditionUSARomInfo, rJeopardyDeluxeEditionUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJeopardySportsEditionUSARomDesc[] = {
	{ "Jeopardy! - Sports Edition (USA).sfc",          524288, 0xbda7de29, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJeopardySportsEditionUSA)
STD_ROM_FN(rJeopardySportsEditionUSA)

struct BurnDriver BurnDrvrJeopardySportsEditionUSA = {
	"Jeopardy! - Sports Edition (USA)", NULL, NULL, "1986",
	"Jeopardy! - Sports Edition (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jeopardy! - Sports Edition (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJeopardySportsEditionUSARomInfo, rJeopardySportsEditionUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJerryBoyJapanRomDesc[] = {
	{ "Jerry Boy (Japan).sfc",          1048576, 0x4ef452f6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJerryBoyJapan)
STD_ROM_FN(rJerryBoyJapan)

struct BurnDriver BurnDrvrJerryBoyJapan = {
	"Jerry Boy (Japan)", NULL, NULL, "1986",
	"Jerry Boy (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jerry Boy (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJerryBoyJapanRomInfo, rJerryBoyJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJetsonsTheInvasionofthePlanetPiratesUSARomDesc[] = {
	{ "Jetsons, The - Invasion of the Planet Pirates (USA).sfc",          1048576, 0x3e3073ce, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJetsonsTheInvasionofthePlanetPiratesUSA)
STD_ROM_FN(rJetsonsTheInvasionofthePlanetPiratesUSA)

struct BurnDriver BurnDrvrJetsonsTheInvasionofthePlanetPiratesUSA = {
	"Jetsons, The - Invasion of the Planet Pirates (USA)", NULL, NULL, "1986",
	"Jetsons, The - Invasion of the Planet Pirates (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jetsons, The - Invasion of the Planet Pirates (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJetsonsTheInvasionofthePlanetPiratesUSARomInfo, rJetsonsTheInvasionofthePlanetPiratesUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJigsawPartyJapanRomDesc[] = {
	{ "Jigsaw Party (Japan).sfc",          1048576, 0x78f229dc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJigsawPartyJapan)
STD_ROM_FN(rJigsawPartyJapan)

struct BurnDriver BurnDrvrJigsawPartyJapan = {
	"Jigsaw Party (Japan)", NULL, NULL, "1986",
	"Jigsaw Party (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jigsaw Party (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJigsawPartyJapanRomInfo, rJigsawPartyJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouOshaberiParodiusJapanRomDesc[] = {
	{ "Jikkyou Oshaberi Parodius (Japan).sfc",          3145728, 0x177937ab, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouOshaberiParodiusJapan)
STD_ROM_FN(rJikkyouOshaberiParodiusJapan)

struct BurnDriver BurnDrvrJikkyouOshaberiParodiusJapan = {
	"Jikkyou Oshaberi Parodius (Japan)", NULL, NULL, "1986",
	"Jikkyou Oshaberi Parodius (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Oshaberi Parodius (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouOshaberiParodiusJapanRomInfo, rJikkyouOshaberiParodiusJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouPowerProWrestling96MaxVoltageJapanRomDesc[] = {
	{ "Jikkyou Power Pro Wrestling '96 - Max Voltage (Japan).sfc",          4194304, 0x94c1d85c, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouPowerProWrestling96MaxVoltageJapan)
STD_ROM_FN(rJikkyouPowerProWrestling96MaxVoltageJapan)

struct BurnDriver BurnDrvrJikkyouPowerProWrestling96MaxVoltageJapan = {
	"Jikkyou Power Pro Wrestling '96 - Max Voltage (Japan)", NULL, NULL, "1986",
	"Jikkyou Power Pro Wrestling '96 - Max Voltage (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Power Pro Wrestling '96 - Max Voltage (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouPowerProWrestling96MaxVoltageJapanRomInfo, rJikkyouPowerProWrestling96MaxVoltageJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouPowerfulProYakyuu94JapanRomDesc[] = {
	{ "Jikkyou Powerful Pro Yakyuu '94 (Japan).sfc",          2097152, 0xa4374771, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouPowerfulProYakyuu94Japan)
STD_ROM_FN(rJikkyouPowerfulProYakyuu94Japan)

struct BurnDriver BurnDrvrJikkyouPowerfulProYakyuu94Japan = {
	"Jikkyou Powerful Pro Yakyuu '94 (Japan)", NULL, NULL, "1986",
	"Jikkyou Powerful Pro Yakyuu '94 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Powerful Pro Yakyuu '94 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouPowerfulProYakyuu94JapanRomInfo, rJikkyouPowerfulProYakyuu94JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouPowerfulProYakyuu96KaimakuBanJapanRev1RomDesc[] = {
	{ "Jikkyou Powerful Pro Yakyuu '96 - Kaimaku Ban (Japan) (Rev 1).sfc",          3145728, 0xfb487712, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouPowerfulProYakyuu96KaimakuBanJapanRev1)
STD_ROM_FN(rJikkyouPowerfulProYakyuu96KaimakuBanJapanRev1)

struct BurnDriver BurnDrvrJikkyouPowerfulProYakyuu96KaimakuBanJapanRev1 = {
	"Jikkyou Powerful Pro Yakyuu '96 - Kaimaku Ban (Japan) (Rev 1)", NULL, NULL, "1986",
	"Jikkyou Powerful Pro Yakyuu '96 - Kaimaku Ban (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Powerful Pro Yakyuu '96 - Kaimaku Ban (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouPowerfulProYakyuu96KaimakuBanJapanRev1RomInfo, rJikkyouPowerfulProYakyuu96KaimakuBanJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouPowerfulProYakyuu96KaimakuBanJapanRomDesc[] = {
	{ "Jikkyou Powerful Pro Yakyuu '96 - Kaimaku Ban (Japan).sfc",          3145728, 0xbc9b4391, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouPowerfulProYakyuu96KaimakuBanJapan)
STD_ROM_FN(rJikkyouPowerfulProYakyuu96KaimakuBanJapan)

struct BurnDriver BurnDrvrJikkyouPowerfulProYakyuu96KaimakuBanJapan = {
	"Jikkyou Powerful Pro Yakyuu '96 - Kaimaku Ban (Japan)", NULL, NULL, "1986",
	"Jikkyou Powerful Pro Yakyuu '96 - Kaimaku Ban (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Powerful Pro Yakyuu '96 - Kaimaku Ban (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouPowerfulProYakyuu96KaimakuBanJapanRomInfo, rJikkyouPowerfulProYakyuu96KaimakuBanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouPowerfulProYakyuuBasicBan98JapanRomDesc[] = {
	{ "Jikkyou Powerful Pro Yakyuu - Basic Ban '98 (Japan).sfc",          3145728, 0xe17c5c97, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouPowerfulProYakyuuBasicBan98Japan)
STD_ROM_FN(rJikkyouPowerfulProYakyuuBasicBan98Japan)

struct BurnDriver BurnDrvrJikkyouPowerfulProYakyuuBasicBan98Japan = {
	"Jikkyou Powerful Pro Yakyuu - Basic Ban '98 (Japan)", NULL, NULL, "1986",
	"Jikkyou Powerful Pro Yakyuu - Basic Ban '98 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Powerful Pro Yakyuu - Basic Ban '98 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouPowerfulProYakyuuBasicBan98JapanRomInfo, rJikkyouPowerfulProYakyuuBasicBan98JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouPowerfulProYakyuu2JapanRev1RomDesc[] = {
	{ "Jikkyou Powerful Pro Yakyuu 2 (Japan) (Rev 1).sfc",          2621440, 0xee0c54b5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouPowerfulProYakyuu2JapanRev1)
STD_ROM_FN(rJikkyouPowerfulProYakyuu2JapanRev1)

struct BurnDriver BurnDrvrJikkyouPowerfulProYakyuu2JapanRev1 = {
	"Jikkyou Powerful Pro Yakyuu 2 (Japan) (Rev 1)", NULL, NULL, "1986",
	"Jikkyou Powerful Pro Yakyuu 2 (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Powerful Pro Yakyuu 2 (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouPowerfulProYakyuu2JapanRev1RomInfo, rJikkyouPowerfulProYakyuu2JapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouPowerfulProYakyuu2JapanRomDesc[] = {
	{ "Jikkyou Powerful Pro Yakyuu 2 (Japan).sfc",          2621440, 0x5d7cd9c8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouPowerfulProYakyuu2Japan)
STD_ROM_FN(rJikkyouPowerfulProYakyuu2Japan)

struct BurnDriver BurnDrvrJikkyouPowerfulProYakyuu2Japan = {
	"Jikkyou Powerful Pro Yakyuu 2 (Japan)", NULL, NULL, "1986",
	"Jikkyou Powerful Pro Yakyuu 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Powerful Pro Yakyuu 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouPowerfulProYakyuu2JapanRomInfo, rJikkyouPowerfulProYakyuu2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouPowerfulProYakyuu3JapanRomDesc[] = {
	{ "Jikkyou Powerful Pro Yakyuu 3 (Japan).sfc",          3145728, 0xf7c3a222, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouPowerfulProYakyuu3Japan)
STD_ROM_FN(rJikkyouPowerfulProYakyuu3Japan)

struct BurnDriver BurnDrvrJikkyouPowerfulProYakyuu3Japan = {
	"Jikkyou Powerful Pro Yakyuu 3 (Japan)", NULL, NULL, "1986",
	"Jikkyou Powerful Pro Yakyuu 3 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Powerful Pro Yakyuu 3 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouPowerfulProYakyuu3JapanRomInfo, rJikkyouPowerfulProYakyuu3JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouPowerfulProYakyuu397HaruJapanRev1RomDesc[] = {
	{ "Jikkyou Powerful Pro Yakyuu 3 - '97 Haru (Japan) (Rev 1).sfc",          3145728, 0x5e75a0e0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouPowerfulProYakyuu397HaruJapanRev1)
STD_ROM_FN(rJikkyouPowerfulProYakyuu397HaruJapanRev1)

struct BurnDriver BurnDrvrJikkyouPowerfulProYakyuu397HaruJapanRev1 = {
	"Jikkyou Powerful Pro Yakyuu 3 - '97 Haru (Japan) (Rev 1)", NULL, NULL, "1986",
	"Jikkyou Powerful Pro Yakyuu 3 - '97 Haru (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Powerful Pro Yakyuu 3 - '97 Haru (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouPowerfulProYakyuu397HaruJapanRev1RomInfo, rJikkyouPowerfulProYakyuu397HaruJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouPowerfulProYakyuu397HaruJapanRomDesc[] = {
	{ "Jikkyou Powerful Pro Yakyuu 3 - '97 Haru (Japan).sfc",          3145728, 0xad5b0417, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouPowerfulProYakyuu397HaruJapan)
STD_ROM_FN(rJikkyouPowerfulProYakyuu397HaruJapan)

struct BurnDriver BurnDrvrJikkyouPowerfulProYakyuu397HaruJapan = {
	"Jikkyou Powerful Pro Yakyuu 3 - '97 Haru (Japan)", NULL, NULL, "1986",
	"Jikkyou Powerful Pro Yakyuu 3 - '97 Haru (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou Powerful Pro Yakyuu 3 - '97 Haru (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouPowerfulProYakyuu397HaruJapanRomInfo, rJikkyouPowerfulProYakyuu397HaruJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouWorldSoccerPerfectElevenJapanRev1RomDesc[] = {
	{ "Jikkyou World Soccer - Perfect Eleven (Japan) (Rev 1).sfc",          2097152, 0x16d71685, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouWorldSoccerPerfectElevenJapanRev1)
STD_ROM_FN(rJikkyouWorldSoccerPerfectElevenJapanRev1)

struct BurnDriver BurnDrvrJikkyouWorldSoccerPerfectElevenJapanRev1 = {
	"Jikkyou World Soccer - Perfect Eleven (Japan) (Rev 1)", NULL, NULL, "1986",
	"Jikkyou World Soccer - Perfect Eleven (Japan) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou World Soccer - Perfect Eleven (Japan) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouWorldSoccerPerfectElevenJapanRev1RomInfo, rJikkyouWorldSoccerPerfectElevenJapanRev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouWorldSoccerPerfectElevenJapanRomDesc[] = {
	{ "Jikkyou World Soccer - Perfect Eleven (Japan).sfc",          2097152, 0x37c36fdc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouWorldSoccerPerfectElevenJapan)
STD_ROM_FN(rJikkyouWorldSoccerPerfectElevenJapan)

struct BurnDriver BurnDrvrJikkyouWorldSoccerPerfectElevenJapan = {
	"Jikkyou World Soccer - Perfect Eleven (Japan)", NULL, NULL, "1986",
	"Jikkyou World Soccer - Perfect Eleven (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou World Soccer - Perfect Eleven (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouWorldSoccerPerfectElevenJapanRomInfo, rJikkyouWorldSoccerPerfectElevenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouWorldSoccer2FightingElevenJapanBetaRomDesc[] = {
	{ "Jikkyou World Soccer 2 - Fighting Eleven (Japan) (Beta).sfc",          3145728, 0x261e0ea1, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouWorldSoccer2FightingElevenJapanBeta)
STD_ROM_FN(rJikkyouWorldSoccer2FightingElevenJapanBeta)

struct BurnDriver BurnDrvrJikkyouWorldSoccer2FightingElevenJapanBeta = {
	"Jikkyou World Soccer 2 - Fighting Eleven (Japan) (Beta)", NULL, NULL, "1986",
	"Jikkyou World Soccer 2 - Fighting Eleven (Japan) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou World Soccer 2 - Fighting Eleven (Japan) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouWorldSoccer2FightingElevenJapanBetaRomInfo, rJikkyouWorldSoccer2FightingElevenJapanBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJikkyouWorldSoccer2FightingElevenJapanRomDesc[] = {
	{ "Jikkyou World Soccer 2 - Fighting Eleven (Japan).sfc",          3145728, 0xe7559d73, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJikkyouWorldSoccer2FightingElevenJapan)
STD_ROM_FN(rJikkyouWorldSoccer2FightingElevenJapan)

struct BurnDriver BurnDrvrJikkyouWorldSoccer2FightingElevenJapan = {
	"Jikkyou World Soccer 2 - Fighting Eleven (Japan)", NULL, NULL, "1986",
	"Jikkyou World Soccer 2 - Fighting Eleven (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jikkyou World Soccer 2 - Fighting Eleven (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJikkyouWorldSoccer2FightingElevenJapanRomInfo, rJikkyouWorldSoccer2FightingElevenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJimLeesWildCATSCovertActionTeamsUSARomDesc[] = {
	{ "Jim Lee's WildC.A.T.S - Covert Action Teams (USA).sfc",          2097152, 0x10c6f5ad, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJimLeesWildCATSCovertActionTeamsUSA)
STD_ROM_FN(rJimLeesWildCATSCovertActionTeamsUSA)

struct BurnDriver BurnDrvrJimLeesWildCATSCovertActionTeamsUSA = {
	"Jim Lee's WildC.A.T.S - Covert Action Teams (USA)", NULL, NULL, "1986",
	"Jim Lee's WildC.A.T.S - Covert Action Teams (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jim Lee's WildC.A.T.S - Covert Action Teams (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJimLeesWildCATSCovertActionTeamsUSARomInfo, rJimLeesWildCATSCovertActionTeamsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJimPowerTheLostDimensionin3DEuropeProtoRomDesc[] = {
	{ "Jim Power - The Lost Dimension in 3D (Europe) (Proto).sfc",          1048576, 0x35aae4eb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJimPowerTheLostDimensionin3DEuropeProto)
STD_ROM_FN(rJimPowerTheLostDimensionin3DEuropeProto)

struct BurnDriver BurnDrvrJimPowerTheLostDimensionin3DEuropeProto = {
	"Jim Power - The Lost Dimension in 3D (Europe) (Proto)", NULL, NULL, "1986",
	"Jim Power - The Lost Dimension in 3D (Europe) (Proto)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jim Power - The Lost Dimension in 3D (Europe) (Proto)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJimPowerTheLostDimensionin3DEuropeProtoRomInfo, rJimPowerTheLostDimensionin3DEuropeProtoRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJimPowerTheLostDimensionin3DUSARomDesc[] = {
	{ "Jim Power - The Lost Dimension in 3D (USA).sfc",          1048576, 0xc469f8f0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJimPowerTheLostDimensionin3DUSA)
STD_ROM_FN(rJimPowerTheLostDimensionin3DUSA)

struct BurnDriver BurnDrvrJimPowerTheLostDimensionin3DUSA = {
	"Jim Power - The Lost Dimension in 3D (USA)", NULL, NULL, "1986",
	"Jim Power - The Lost Dimension in 3D (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jim Power - The Lost Dimension in 3D (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJimPowerTheLostDimensionin3DUSARomInfo, rJimPowerTheLostDimensionin3DUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJimmyConnorsProTennisTourEuropeRomDesc[] = {
	{ "Jimmy Connors Pro Tennis Tour (Europe).sfc",          524288, 0xbba55bec, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJimmyConnorsProTennisTourEurope)
STD_ROM_FN(rJimmyConnorsProTennisTourEurope)

struct BurnDriver BurnDrvrJimmyConnorsProTennisTourEurope = {
	"Jimmy Connors Pro Tennis Tour (Europe)", NULL, NULL, "1986",
	"Jimmy Connors Pro Tennis Tour (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jimmy Connors Pro Tennis Tour (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJimmyConnorsProTennisTourEuropeRomInfo, rJimmyConnorsProTennisTourEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJimmyConnorsProTennisTourFranceRomDesc[] = {
	{ "Jimmy Connors Pro Tennis Tour (France).sfc",          524288, 0xbea289fc, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJimmyConnorsProTennisTourFrance)
STD_ROM_FN(rJimmyConnorsProTennisTourFrance)

struct BurnDriver BurnDrvrJimmyConnorsProTennisTourFrance = {
	"Jimmy Connors Pro Tennis Tour (France)", NULL, NULL, "1986",
	"Jimmy Connors Pro Tennis Tour (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jimmy Connors Pro Tennis Tour (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJimmyConnorsProTennisTourFranceRomInfo, rJimmyConnorsProTennisTourFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJimmyConnorsProTennisTourGermanyRomDesc[] = {
	{ "Jimmy Connors Pro Tennis Tour (Germany).sfc",          524288, 0xe2294a8e, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJimmyConnorsProTennisTourGermany)
STD_ROM_FN(rJimmyConnorsProTennisTourGermany)

struct BurnDriver BurnDrvrJimmyConnorsProTennisTourGermany = {
	"Jimmy Connors Pro Tennis Tour (Germany)", NULL, NULL, "1986",
	"Jimmy Connors Pro Tennis Tour (Germany)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jimmy Connors Pro Tennis Tour (Germany)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJimmyConnorsProTennisTourGermanyRomInfo, rJimmyConnorsProTennisTourGermanyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJimmyConnorsProTennisTourJapanRomDesc[] = {
	{ "Jimmy Connors Pro Tennis Tour (Japan).sfc",          524288, 0xa95bef02, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJimmyConnorsProTennisTourJapan)
STD_ROM_FN(rJimmyConnorsProTennisTourJapan)

struct BurnDriver BurnDrvrJimmyConnorsProTennisTourJapan = {
	"Jimmy Connors Pro Tennis Tour (Japan)", NULL, NULL, "1986",
	"Jimmy Connors Pro Tennis Tour (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jimmy Connors Pro Tennis Tour (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJimmyConnorsProTennisTourJapanRomInfo, rJimmyConnorsProTennisTourJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJimmyConnorsProTennisTourUSARomDesc[] = {
	{ "Jimmy Connors Pro Tennis Tour (USA).sfc",          524288, 0x913f1555, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJimmyConnorsProTennisTourUSA)
STD_ROM_FN(rJimmyConnorsProTennisTourUSA)

struct BurnDriver BurnDrvrJimmyConnorsProTennisTourUSA = {
	"Jimmy Connors Pro Tennis Tour (USA)", NULL, NULL, "1986",
	"Jimmy Connors Pro Tennis Tour (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jimmy Connors Pro Tennis Tour (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJimmyConnorsProTennisTourUSARomInfo, rJimmyConnorsProTennisTourUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJimmyHoustonsBassTournamentUSAUSARomDesc[] = {
	{ "Jimmy Houston's Bass Tournament U.S.A. (USA).sfc",          1572864, 0xe7e488d5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJimmyHoustonsBassTournamentUSAUSA)
STD_ROM_FN(rJimmyHoustonsBassTournamentUSAUSA)

struct BurnDriver BurnDrvrJimmyHoustonsBassTournamentUSAUSA = {
	"Jimmy Houston's Bass Tournament U.S.A. (USA)", NULL, NULL, "1986",
	"Jimmy Houston's Bass Tournament U.S.A. (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jimmy Houston's Bass Tournament U.S.A. (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJimmyHoustonsBassTournamentUSAUSARomInfo, rJimmyHoustonsBassTournamentUSAUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJissenBassFishingHisshouhouinUSAJapanRomDesc[] = {
	{ "Jissen Bass Fishing Hisshouhou in USA (Japan).sfc",          1572864, 0x82ba9020, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJissenBassFishingHisshouhouinUSAJapan)
STD_ROM_FN(rJissenBassFishingHisshouhouinUSAJapan)

struct BurnDriver BurnDrvrJissenBassFishingHisshouhouinUSAJapan = {
	"Jissen Bass Fishing Hisshouhou in USA (Japan)", NULL, NULL, "1986",
	"Jissen Bass Fishing Hisshouhou in USA (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jissen Bass Fishing Hisshouhou in USA (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJissenBassFishingHisshouhouinUSAJapanRomInfo, rJissenBassFishingHisshouhouinUSAJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJissenKyouteiJapanRomDesc[] = {
	{ "Jissen Kyoutei (Japan).sfc",          1572864, 0x65815455, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJissenKyouteiJapan)
STD_ROM_FN(rJissenKyouteiJapan)

struct BurnDriver BurnDrvrJissenKyouteiJapan = {
	"Jissen Kyoutei (Japan)", NULL, NULL, "1986",
	"Jissen Kyoutei (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jissen Kyoutei (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJissenKyouteiJapanRomInfo, rJissenKyouteiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJissenPachiSlotHisshouhouTwinJapanRomDesc[] = {
	{ "Jissen Pachi-Slot Hisshouhou! Twin (Japan).sfc",          524288, 0xacbef43d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJissenPachiSlotHisshouhouTwinJapan)
STD_ROM_FN(rJissenPachiSlotHisshouhouTwinJapan)

struct BurnDriver BurnDrvrJissenPachiSlotHisshouhouTwinJapan = {
	"Jissen Pachi-Slot Hisshouhou! Twin (Japan)", NULL, NULL, "1986",
	"Jissen Pachi-Slot Hisshouhou! Twin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jissen Pachi-Slot Hisshouhou! Twin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJissenPachiSlotHisshouhouTwinJapanRomInfo, rJissenPachiSlotHisshouhouTwinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJissenPachiSlotHisshouhouTwinVol2JapanRomDesc[] = {
	{ "Jissen Pachi-Slot Hisshouhou! Twin Vol. 2 (Japan).sfc",          524288, 0x1013bcf3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJissenPachiSlotHisshouhouTwinVol2Japan)
STD_ROM_FN(rJissenPachiSlotHisshouhouTwinVol2Japan)

struct BurnDriver BurnDrvrJissenPachiSlotHisshouhouTwinVol2Japan = {
	"Jissen Pachi-Slot Hisshouhou! Twin Vol. 2 (Japan)", NULL, NULL, "1986",
	"Jissen Pachi-Slot Hisshouhou! Twin Vol. 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jissen Pachi-Slot Hisshouhou! Twin Vol. 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJissenPachiSlotHisshouhouTwinVol2JapanRomInfo, rJissenPachiSlotHisshouhouTwinVol2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJissenPachinkoHisshouhou2JapanRomDesc[] = {
	{ "Jissen Pachinko Hisshouhou! 2 (Japan).sfc",          1572864, 0x59884df2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJissenPachinkoHisshouhou2Japan)
STD_ROM_FN(rJissenPachinkoHisshouhou2Japan)

struct BurnDriver BurnDrvrJissenPachinkoHisshouhou2Japan = {
	"Jissen Pachinko Hisshouhou! 2 (Japan)", NULL, NULL, "1986",
	"Jissen Pachinko Hisshouhou! 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jissen Pachinko Hisshouhou! 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJissenPachinkoHisshouhou2JapanRomInfo, rJissenPachinkoHisshouhou2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJissenMahjongShinanJapanRomDesc[] = {
	{ "Jissen! Mahjong Shinan (Japan).sfc",          1048576, 0x457f3020, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJissenMahjongShinanJapan)
STD_ROM_FN(rJissenMahjongShinanJapan)

struct BurnDriver BurnDrvrJissenMahjongShinanJapan = {
	"Jissen! Mahjong Shinan (Japan)", NULL, NULL, "1986",
	"Jissen! Mahjong Shinan (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jissen! Mahjong Shinan (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJissenMahjongShinanJapanRomInfo, rJissenMahjongShinanJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJissenPachiSlotHisshouhouJapanRomDesc[] = {
	{ "Jissen! Pachi-Slot Hisshouhou! (Japan).sfc",          524288, 0x4664ff26, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJissenPachiSlotHisshouhouJapan)
STD_ROM_FN(rJissenPachiSlotHisshouhouJapan)

struct BurnDriver BurnDrvrJissenPachiSlotHisshouhouJapan = {
	"Jissen! Pachi-Slot Hisshouhou! (Japan)", NULL, NULL, "1986",
	"Jissen! Pachi-Slot Hisshouhou! (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jissen! Pachi-Slot Hisshouhou! (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJissenPachiSlotHisshouhouJapanRomInfo, rJissenPachiSlotHisshouhouJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJissenPachiSlotHisshouhou2JapanRomDesc[] = {
	{ "Jissen! Pachi-Slot Hisshouhou! 2 (Japan).sfc",          1048576, 0x9bfa7045, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJissenPachiSlotHisshouhou2Japan)
STD_ROM_FN(rJissenPachiSlotHisshouhou2Japan)

struct BurnDriver BurnDrvrJissenPachiSlotHisshouhou2Japan = {
	"Jissen! Pachi-Slot Hisshouhou! 2 (Japan)", NULL, NULL, "1986",
	"Jissen! Pachi-Slot Hisshouhou! 2 (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jissen! Pachi-Slot Hisshouhou! 2 (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJissenPachiSlotHisshouhou2JapanRomInfo, rJissenPachiSlotHisshouhou2JapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJissenPachiSlotHisshouhouClassicJapanRomDesc[] = {
	{ "Jissen! Pachi-Slot Hisshouhou! Classic (Japan).sfc",          1048576, 0xf28358c0, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJissenPachiSlotHisshouhouClassicJapan)
STD_ROM_FN(rJissenPachiSlotHisshouhouClassicJapan)

struct BurnDriver BurnDrvrJissenPachiSlotHisshouhouClassicJapan = {
	"Jissen! Pachi-Slot Hisshouhou! Classic (Japan)", NULL, NULL, "1986",
	"Jissen! Pachi-Slot Hisshouhou! Classic (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jissen! Pachi-Slot Hisshouhou! Classic (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJissenPachiSlotHisshouhouClassicJapanRomInfo, rJissenPachiSlotHisshouhouClassicJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJissenPachiSlotHisshouhouYamasaDensetsuJapanRomDesc[] = {
	{ "Jissen! Pachi-Slot Hisshouhou! Yamasa Densetsu (Japan).sfc",          1048576, 0x8fb6a868, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJissenPachiSlotHisshouhouYamasaDensetsuJapan)
STD_ROM_FN(rJissenPachiSlotHisshouhouYamasaDensetsuJapan)

struct BurnDriver BurnDrvrJissenPachiSlotHisshouhouYamasaDensetsuJapan = {
	"Jissen! Pachi-Slot Hisshouhou! Yamasa Densetsu (Japan)", NULL, NULL, "1986",
	"Jissen! Pachi-Slot Hisshouhou! Yamasa Densetsu (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jissen! Pachi-Slot Hisshouhou! Yamasa Densetsu (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJissenPachiSlotHisshouhouYamasaDensetsuJapanRomInfo, rJissenPachiSlotHisshouhouYamasaDensetsuJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJoeMacUSARomDesc[] = {
	{ "Joe & Mac (USA).sfc",          1048576, 0x3a2b6167, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJoeMacUSA)
STD_ROM_FN(rJoeMacUSA)

struct BurnDriver BurnDrvrJoeMacUSA = {
	"Joe & Mac (USA)", NULL, NULL, "1986",
	"Joe & Mac (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Joe & Mac (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJoeMacUSARomInfo, rJoeMacUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJoeMacCavemanNinjaEuropeEnFrDeEsItNlBetaRomDesc[] = {
	{ "Joe & Mac - Caveman Ninja (Europe) (En,Fr,De,Es,It,Nl) (Beta).sfc",          1048576, 0xdb8447eb, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJoeMacCavemanNinjaEuropeEnFrDeEsItNlBeta)
STD_ROM_FN(rJoeMacCavemanNinjaEuropeEnFrDeEsItNlBeta)

struct BurnDriver BurnDrvrJoeMacCavemanNinjaEuropeEnFrDeEsItNlBeta = {
	"Joe & Mac - Caveman Ninja (Europe) (En,Fr,De,Es,It,Nl) (Beta)", NULL, NULL, "1986",
	"Joe & Mac - Caveman Ninja (Europe) (En,Fr,De,Es,It,Nl) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Joe & Mac - Caveman Ninja (Europe) (En,Fr,De,Es,It,Nl) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJoeMacCavemanNinjaEuropeEnFrDeEsItNlBetaRomInfo, rJoeMacCavemanNinjaEuropeEnFrDeEsItNlBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJoeMacCavemanNinjaEuropeEnFrDeEsItNlRomDesc[] = {
	{ "Joe & Mac - Caveman Ninja (Europe) (En,Fr,De,Es,It,Nl).sfc",          1048576, 0xa423a9d8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJoeMacCavemanNinjaEuropeEnFrDeEsItNl)
STD_ROM_FN(rJoeMacCavemanNinjaEuropeEnFrDeEsItNl)

struct BurnDriver BurnDrvrJoeMacCavemanNinjaEuropeEnFrDeEsItNl = {
	"Joe & Mac - Caveman Ninja (Europe) (En,Fr,De,Es,It,Nl)", NULL, NULL, "1986",
	"Joe & Mac - Caveman Ninja (Europe) (En,Fr,De,Es,It,Nl)\0", NULL, "Nintendo", "Miscellaneous",
	L"Joe & Mac - Caveman Ninja (Europe) (En,Fr,De,Es,It,Nl)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJoeMacCavemanNinjaEuropeEnFrDeEsItNlRomInfo, rJoeMacCavemanNinjaEuropeEnFrDeEsItNlRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJoeMacTatakaeGenshijinJapanRomDesc[] = {
	{ "Joe & Mac - Tatakae Genshijin (Japan).sfc",          1048576, 0xfb9f19ba, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJoeMacTatakaeGenshijinJapan)
STD_ROM_FN(rJoeMacTatakaeGenshijinJapan)

struct BurnDriver BurnDrvrJoeMacTatakaeGenshijinJapan = {
	"Joe & Mac - Tatakae Genshijin (Japan)", NULL, NULL, "1986",
	"Joe & Mac - Tatakae Genshijin (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Joe & Mac - Tatakae Genshijin (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJoeMacTatakaeGenshijinJapanRomInfo, rJoeMacTatakaeGenshijinJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJoeMac2LostintheTropicsUSABetaRomDesc[] = {
	{ "Joe & Mac 2 - Lost in the Tropics (USA) (Beta).sfc",          1048576, 0xec7a2ed3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJoeMac2LostintheTropicsUSABeta)
STD_ROM_FN(rJoeMac2LostintheTropicsUSABeta)

struct BurnDriver BurnDrvrJoeMac2LostintheTropicsUSABeta = {
	"Joe & Mac 2 - Lost in the Tropics (USA) (Beta)", NULL, NULL, "1986",
	"Joe & Mac 2 - Lost in the Tropics (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Joe & Mac 2 - Lost in the Tropics (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJoeMac2LostintheTropicsUSABetaRomInfo, rJoeMac2LostintheTropicsUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJoeMac2LostintheTropicsUSARomDesc[] = {
	{ "Joe & Mac 2 - Lost in the Tropics (USA).sfc",          1048576, 0xc3b4201, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJoeMac2LostintheTropicsUSA)
STD_ROM_FN(rJoeMac2LostintheTropicsUSA)

struct BurnDriver BurnDrvrJoeMac2LostintheTropicsUSA = {
	"Joe & Mac 2 - Lost in the Tropics (USA)", NULL, NULL, "1986",
	"Joe & Mac 2 - Lost in the Tropics (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Joe & Mac 2 - Lost in the Tropics (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJoeMac2LostintheTropicsUSARomInfo, rJoeMac2LostintheTropicsUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJoeMac3LostintheTropicsEuropeEnFrDeBetaRomDesc[] = {
	{ "Joe & Mac 3 - Lost in the Tropics (Europe) (En,Fr,De) (Beta).sfc",          1048576, 0x5970fb74, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJoeMac3LostintheTropicsEuropeEnFrDeBeta)
STD_ROM_FN(rJoeMac3LostintheTropicsEuropeEnFrDeBeta)

struct BurnDriver BurnDrvrJoeMac3LostintheTropicsEuropeEnFrDeBeta = {
	"Joe & Mac 3 - Lost in the Tropics (Europe) (En,Fr,De) (Beta)", NULL, NULL, "1986",
	"Joe & Mac 3 - Lost in the Tropics (Europe) (En,Fr,De) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Joe & Mac 3 - Lost in the Tropics (Europe) (En,Fr,De) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJoeMac3LostintheTropicsEuropeEnFrDeBetaRomInfo, rJoeMac3LostintheTropicsEuropeEnFrDeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJoeMac3LostintheTropicsEuropeEnFrDeRomDesc[] = {
	{ "Joe & Mac 3 - Lost in the Tropics (Europe) (En,Fr,De).sfc",          1048576, 0xb9d6269d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJoeMac3LostintheTropicsEuropeEnFrDe)
STD_ROM_FN(rJoeMac3LostintheTropicsEuropeEnFrDe)

struct BurnDriver BurnDrvrJoeMac3LostintheTropicsEuropeEnFrDe = {
	"Joe & Mac 3 - Lost in the Tropics (Europe) (En,Fr,De)", NULL, NULL, "1986",
	"Joe & Mac 3 - Lost in the Tropics (Europe) (En,Fr,De)\0", NULL, "Nintendo", "Miscellaneous",
	L"Joe & Mac 3 - Lost in the Tropics (Europe) (En,Fr,De)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJoeMac3LostintheTropicsEuropeEnFrDeRomInfo, rJoeMac3LostintheTropicsEuropeEnFrDeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJohnMaddenFootball93EuropeRomDesc[] = {
	{ "John Madden Football '93 (Europe).sfc",          1048576, 0xb07b2a60, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJohnMaddenFootball93Europe)
STD_ROM_FN(rJohnMaddenFootball93Europe)

struct BurnDriver BurnDrvrJohnMaddenFootball93Europe = {
	"John Madden Football '93 (Europe)", NULL, NULL, "1986",
	"John Madden Football '93 (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"John Madden Football '93 (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJohnMaddenFootball93EuropeRomInfo, rJohnMaddenFootball93EuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJohnMaddenFootball93USARev1RomDesc[] = {
	{ "John Madden Football '93 (USA) (Rev 1).sfc",          1048576, 0xdc5a250b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJohnMaddenFootball93USARev1)
STD_ROM_FN(rJohnMaddenFootball93USARev1)

struct BurnDriver BurnDrvrJohnMaddenFootball93USARev1 = {
	"John Madden Football '93 (USA) (Rev 1)", NULL, NULL, "1986",
	"John Madden Football '93 (USA) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"John Madden Football '93 (USA) (Rev 1)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJohnMaddenFootball93USARev1RomInfo, rJohnMaddenFootball93USARev1RomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJohnMaddenFootball93USARomDesc[] = {
	{ "John Madden Football '93 (USA).sfc",          1048576, 0x60190859, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJohnMaddenFootball93USA)
STD_ROM_FN(rJohnMaddenFootball93USA)

struct BurnDriver BurnDrvrJohnMaddenFootball93USA = {
	"John Madden Football '93 (USA)", NULL, NULL, "1986",
	"John Madden Football '93 (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"John Madden Football '93 (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJohnMaddenFootball93USARomInfo, rJohnMaddenFootball93USARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJohnMaddenFootballUSARomDesc[] = {
	{ "John Madden Football (USA).sfc",          524288, 0x796294c6, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJohnMaddenFootballUSA)
STD_ROM_FN(rJohnMaddenFootballUSA)

struct BurnDriver BurnDrvrJohnMaddenFootballUSA = {
	"John Madden Football (USA)", NULL, NULL, "1986",
	"John Madden Football (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"John Madden Football (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJohnMaddenFootballUSARomInfo, rJohnMaddenFootballUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJoJonoKimyounaBoukenJapanRomDesc[] = {
	{ "JoJo no Kimyou na Bouken (Japan).sfc",          1048576, 0x56ba694a, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJoJonoKimyounaBoukenJapan)
STD_ROM_FN(rJoJonoKimyounaBoukenJapan)

struct BurnDriver BurnDrvrJoJonoKimyounaBoukenJapan = {
	"JoJo no Kimyou na Bouken (Japan)", NULL, NULL, "1986",
	"JoJo no Kimyou na Bouken (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"JoJo no Kimyou na Bouken (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJoJonoKimyounaBoukenJapanRomInfo, rJoJonoKimyounaBoukenJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJoushouMahjongTenpaiJapanRomDesc[] = {
	{ "Joushou Mahjong Tenpai (Japan).sfc",          1048576, 0xa24944e4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJoushouMahjongTenpaiJapan)
STD_ROM_FN(rJoushouMahjongTenpaiJapan)

struct BurnDriver BurnDrvrJoushouMahjongTenpaiJapan = {
	"Joushou Mahjong Tenpai (Japan)", NULL, NULL, "1986",
	"Joushou Mahjong Tenpai (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Joushou Mahjong Tenpai (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJoushouMahjongTenpaiJapanRomInfo, rJoushouMahjongTenpaiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJRAPATJapanTJAJRomDesc[] = {
	{ "JRA PAT (Japan) (TJAJ).sfc",          1048576, 0x355147c2, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJRAPATJapanTJAJ)
STD_ROM_FN(rJRAPATJapanTJAJ)

struct BurnDriver BurnDrvrJRAPATJapanTJAJ = {
	"JRA PAT (Japan) (TJAJ)", NULL, NULL, "1986",
	"JRA PAT (Japan) (TJAJ)\0", NULL, "Nintendo", "Miscellaneous",
	L"JRA PAT (Japan) (TJAJ)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJRAPATJapanTJAJRomInfo, rJRAPATJapanTJAJRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJRAPATJapanTJBJRomDesc[] = {
	{ "JRA PAT (Japan) (TJBJ).sfc",          1048576, 0x7fc1aa92, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJRAPATJapanTJBJ)
STD_ROM_FN(rJRAPATJapanTJBJ)

struct BurnDriver BurnDrvrJRAPATJapanTJBJ = {
	"JRA PAT (Japan) (TJBJ)", NULL, NULL, "1986",
	"JRA PAT (Japan) (TJBJ)\0", NULL, "Nintendo", "Miscellaneous",
	L"JRA PAT (Japan) (TJBJ)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJRAPATJapanTJBJRomInfo, rJRAPATJapanTJBJRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJRAPATWideTaiyoubanJapanTJDJRomDesc[] = {
	{ "JRA PAT - Wide Taiyouban (Japan) (TJDJ).sfc",          1048576, 0x1fc1915d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJRAPATWideTaiyoubanJapanTJDJ)
STD_ROM_FN(rJRAPATWideTaiyoubanJapanTJDJ)

struct BurnDriver BurnDrvrJRAPATWideTaiyoubanJapanTJDJ = {
	"JRA PAT - Wide Taiyouban (Japan) (TJDJ)", NULL, NULL, "1986",
	"JRA PAT - Wide Taiyouban (Japan) (TJDJ)\0", NULL, "Nintendo", "Miscellaneous",
	L"JRA PAT - Wide Taiyouban (Japan) (TJDJ)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJRAPATWideTaiyoubanJapanTJDJRomInfo, rJRAPATWideTaiyoubanJapanTJDJRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJRAPATWideTaiyoubanJapanTJEJRomDesc[] = {
	{ "JRA PAT - Wide Taiyouban (Japan) (TJEJ).sfc",          1048576, 0x673468c8, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJRAPATWideTaiyoubanJapanTJEJ)
STD_ROM_FN(rJRAPATWideTaiyoubanJapanTJEJ)

struct BurnDriver BurnDrvrJRAPATWideTaiyoubanJapanTJEJ = {
	"JRA PAT - Wide Taiyouban (Japan) (TJEJ)", NULL, NULL, "1986",
	"JRA PAT - Wide Taiyouban (Japan) (TJEJ)\0", NULL, "Nintendo", "Miscellaneous",
	L"JRA PAT - Wide Taiyouban (Japan) (TJEJ)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJRAPATWideTaiyoubanJapanTJEJRomInfo, rJRAPATWideTaiyoubanJapanTJEJRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJudgeDreddEuropeRomDesc[] = {
	{ "Judge Dredd (Europe).sfc",          2097152, 0x7742b6f4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJudgeDreddEurope)
STD_ROM_FN(rJudgeDreddEurope)

struct BurnDriver BurnDrvrJudgeDreddEurope = {
	"Judge Dredd (Europe)", NULL, NULL, "1986",
	"Judge Dredd (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Judge Dredd (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJudgeDreddEuropeRomInfo, rJudgeDreddEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJudgeDreddJapanRomDesc[] = {
	{ "Judge Dredd (Japan).sfc",          2097152, 0xd7bc8a52, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJudgeDreddJapan)
STD_ROM_FN(rJudgeDreddJapan)

struct BurnDriver BurnDrvrJudgeDreddJapan = {
	"Judge Dredd (Japan)", NULL, NULL, "1986",
	"Judge Dredd (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Judge Dredd (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJudgeDreddJapanRomInfo, rJudgeDreddJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJudgeDreddUSASampleRomDesc[] = {
	{ "Judge Dredd (USA) (Sample).sfc",          2097152, 0x23fc5de, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJudgeDreddUSASample)
STD_ROM_FN(rJudgeDreddUSASample)

struct BurnDriver BurnDrvrJudgeDreddUSASample = {
	"Judge Dredd (USA) (Sample)", NULL, NULL, "1986",
	"Judge Dredd (USA) (Sample)\0", NULL, "Nintendo", "Miscellaneous",
	L"Judge Dredd (USA) (Sample)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJudgeDreddUSASampleRomInfo, rJudgeDreddUSASampleRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJudgeDreddUSARomDesc[] = {
	{ "Judge Dredd (USA).sfc",          2097152, 0xa3f0288, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJudgeDreddUSA)
STD_ROM_FN(rJudgeDreddUSA)

struct BurnDriver BurnDrvrJudgeDreddUSA = {
	"Judge Dredd (USA)", NULL, NULL, "1986",
	"Judge Dredd (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Judge Dredd (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJudgeDreddUSARomInfo, rJudgeDreddUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJumboOzakinoHoleinOneJapanRomDesc[] = {
	{ "Jumbo Ozaki no Hole in One (Japan).sfc",          1048576, 0xfd99721, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJumboOzakinoHoleinOneJapan)
STD_ROM_FN(rJumboOzakinoHoleinOneJapan)

struct BurnDriver BurnDrvrJumboOzakinoHoleinOneJapan = {
	"Jumbo Ozaki no Hole in One (Japan)", NULL, NULL, "1986",
	"Jumbo Ozaki no Hole in One (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jumbo Ozaki no Hole in One (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJumboOzakinoHoleinOneJapanRomInfo, rJumboOzakinoHoleinOneJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJumpinDerbyJapanRomDesc[] = {
	{ "Jumpin' Derby (Japan).sfc",          2097152, 0xa473b7e4, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJumpinDerbyJapan)
STD_ROM_FN(rJumpinDerbyJapan)

struct BurnDriver BurnDrvrJumpinDerbyJapan = {
	"Jumpin' Derby (Japan)", NULL, NULL, "1986",
	"Jumpin' Derby (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jumpin' Derby (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJumpinDerbyJapanRomInfo, rJumpinDerbyJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJungleBookTheEuropeRomDesc[] = {
	{ "Jungle Book, The (Europe).sfc",          2097152, 0x392ae185, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJungleBookTheEurope)
STD_ROM_FN(rJungleBookTheEurope)

struct BurnDriver BurnDrvrJungleBookTheEurope = {
	"Jungle Book, The (Europe)", NULL, NULL, "1986",
	"Jungle Book, The (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jungle Book, The (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJungleBookTheEuropeRomInfo, rJungleBookTheEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJungleBookTheJapanRomDesc[] = {
	{ "Jungle Book, The (Japan).sfc",          2097152, 0xce14892d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJungleBookTheJapan)
STD_ROM_FN(rJungleBookTheJapan)

struct BurnDriver BurnDrvrJungleBookTheJapan = {
	"Jungle Book, The (Japan)", NULL, NULL, "1986",
	"Jungle Book, The (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jungle Book, The (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJungleBookTheJapanRomInfo, rJungleBookTheJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJungleBookTheUSABetaRomDesc[] = {
	{ "Jungle Book, The (USA) (Beta).sfc",          2097152, 0xbd037a57, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJungleBookTheUSABeta)
STD_ROM_FN(rJungleBookTheUSABeta)

struct BurnDriver BurnDrvrJungleBookTheUSABeta = {
	"Jungle Book, The (USA) (Beta)", NULL, NULL, "1986",
	"Jungle Book, The (USA) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jungle Book, The (USA) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJungleBookTheUSABetaRomInfo, rJungleBookTheUSABetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJungleBookTheUSARomDesc[] = {
	{ "Jungle Book, The (USA).sfc",          2097152, 0x3511efb3, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJungleBookTheUSA)
STD_ROM_FN(rJungleBookTheUSA)

struct BurnDriver BurnDrvrJungleBookTheUSA = {
	"Jungle Book, The (USA)", NULL, NULL, "1986",
	"Jungle Book, The (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jungle Book, The (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJungleBookTheUSARomInfo, rJungleBookTheUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJunglenoOujaTarchanSekaimanyuuDaikakutounoMakiJapanRomDesc[] = {
	{ "Jungle no Ouja Tar-chan - Sekaimanyuu Daikakutou no Maki (Japan).sfc",          1048576, 0xeec6a20f, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJunglenoOujaTarchanSekaimanyuuDaikakutounoMakiJapan)
STD_ROM_FN(rJunglenoOujaTarchanSekaimanyuuDaikakutounoMakiJapan)

struct BurnDriver BurnDrvrJunglenoOujaTarchanSekaimanyuuDaikakutounoMakiJapan = {
	"Jungle no Ouja Tar-chan - Sekaimanyuu Daikakutou no Maki (Japan)", NULL, NULL, "1986",
	"Jungle no Ouja Tar-chan - Sekaimanyuu Daikakutou no Maki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jungle no Ouja Tar-chan - Sekaimanyuu Daikakutou no Maki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJunglenoOujaTarchanSekaimanyuuDaikakutounoMakiJapanRomInfo, rJunglenoOujaTarchanSekaimanyuuDaikakutounoMakiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJungleStrikeEuropeRomDesc[] = {
	{ "Jungle Strike (Europe).sfc",          2097152, 0xfb770320, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJungleStrikeEurope)
STD_ROM_FN(rJungleStrikeEurope)

struct BurnDriver BurnDrvrJungleStrikeEurope = {
	"Jungle Strike (Europe)", NULL, NULL, "1986",
	"Jungle Strike (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jungle Strike (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJungleStrikeEuropeRomInfo, rJungleStrikeEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJungleStrikeUSARomDesc[] = {
	{ "Jungle Strike (USA).sfc",          2097152, 0x335487e5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJungleStrikeUSA)
STD_ROM_FN(rJungleStrikeUSA)

struct BurnDriver BurnDrvrJungleStrikeUSA = {
	"Jungle Strike (USA)", NULL, NULL, "1986",
	"Jungle Strike (USA)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jungle Strike (USA)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJungleStrikeUSARomInfo, rJungleStrikeUSARomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJungleStrikeUketsugaretaKyoukiJapanRomDesc[] = {
	{ "Jungle Strike - Uketsugareta Kyouki (Japan).sfc",          2097152, 0x5bdf5a87, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJungleStrikeUketsugaretaKyoukiJapan)
STD_ROM_FN(rJungleStrikeUketsugaretaKyoukiJapan)

struct BurnDriver BurnDrvrJungleStrikeUketsugaretaKyoukiJapan = {
	"Jungle Strike - Uketsugareta Kyouki (Japan)", NULL, NULL, "1986",
	"Jungle Strike - Uketsugareta Kyouki (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jungle Strike - Uketsugareta Kyouki (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJungleStrikeUketsugaretaKyoukiJapanRomInfo, rJungleStrikeUketsugaretaKyoukiJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJungleWars2KodaiMahouAtimosnoNazoJapanRomDesc[] = {
	{ "Jungle Wars 2 - Kodai Mahou Atimos no Nazo (Japan).sfc",          1572864, 0x42014b93, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJungleWars2KodaiMahouAtimosnoNazoJapan)
STD_ROM_FN(rJungleWars2KodaiMahouAtimosnoNazoJapan)

struct BurnDriver BurnDrvrJungleWars2KodaiMahouAtimosnoNazoJapan = {
	"Jungle Wars 2 - Kodai Mahou Atimos no Nazo (Japan)", NULL, NULL, "1986",
	"Jungle Wars 2 - Kodai Mahou Atimos no Nazo (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jungle Wars 2 - Kodai Mahou Atimos no Nazo (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJungleWars2KodaiMahouAtimosnoNazoJapanRomInfo, rJungleWars2KodaiMahouAtimosnoNazoJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJurassicParkEuropeBetaRomDesc[] = {
	{ "Jurassic Park (Europe) (Beta).sfc",          2097152, 0xb2b1804b, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJurassicParkEuropeBeta)
STD_ROM_FN(rJurassicParkEuropeBeta)

struct BurnDriver BurnDrvrJurassicParkEuropeBeta = {
	"Jurassic Park (Europe) (Beta)", NULL, NULL, "1986",
	"Jurassic Park (Europe) (Beta)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jurassic Park (Europe) (Beta)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJurassicParkEuropeBetaRomInfo, rJurassicParkEuropeBetaRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJurassicParkEuropeRomDesc[] = {
	{ "Jurassic Park (Europe).sfc",          2097152, 0x7ccb8762, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJurassicParkEurope)
STD_ROM_FN(rJurassicParkEurope)

struct BurnDriver BurnDrvrJurassicParkEurope = {
	"Jurassic Park (Europe)", NULL, NULL, "1986",
	"Jurassic Park (Europe)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jurassic Park (Europe)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJurassicParkEuropeRomInfo, rJurassicParkEuropeRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJurassicParkFranceRomDesc[] = {
	{ "Jurassic Park (France).sfc",          2097152, 0x61011074, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJurassicParkFrance)
STD_ROM_FN(rJurassicParkFrance)

struct BurnDriver BurnDrvrJurassicParkFrance = {
	"Jurassic Park (France)", NULL, NULL, "1986",
	"Jurassic Park (France)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jurassic Park (France)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJurassicParkFranceRomInfo, rJurassicParkFranceRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJurassicParkGermanyRomDesc[] = {
	{ "Jurassic Park (Germany).sfc",          2097152, 0x8c3f510d, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJurassicParkGermany)
STD_ROM_FN(rJurassicParkGermany)

struct BurnDriver BurnDrvrJurassicParkGermany = {
	"Jurassic Park (Germany)", NULL, NULL, "1986",
	"Jurassic Park (Germany)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jurassic Park (Germany)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJurassicParkGermanyRomInfo, rJurassicParkGermanyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJurassicParkItalyRomDesc[] = {
	{ "Jurassic Park (Italy).sfc",          2097152, 0x3ee3e840, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJurassicParkItaly)
STD_ROM_FN(rJurassicParkItaly)

struct BurnDriver BurnDrvrJurassicParkItaly = {
	"Jurassic Park (Italy)", NULL, NULL, "1986",
	"Jurassic Park (Italy)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jurassic Park (Italy)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJurassicParkItalyRomInfo, rJurassicParkItalyRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJurassicParkJapanRomDesc[] = {
	{ "Jurassic Park (Japan).sfc",          2097152, 0x559c7cf5, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJurassicParkJapan)
STD_ROM_FN(rJurassicParkJapan)

struct BurnDriver BurnDrvrJurassicParkJapan = {
	"Jurassic Park (Japan)", NULL, NULL, "1986",
	"Jurassic Park (Japan)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jurassic Park (Japan)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJurassicParkJapanRomInfo, rJurassicParkJapanRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJurassicParkSpainRomDesc[] = {
	{ "Jurassic Park (Spain).sfc",          2097152, 0x3dee6fd9, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJurassicParkSpain)
STD_ROM_FN(rJurassicParkSpain)

struct BurnDriver BurnDrvrJurassicParkSpain = {
	"Jurassic Park (Spain)", NULL, NULL, "1986",
	"Jurassic Park (Spain)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jurassic Park (Spain)", NULL, NULL, NULL,
	BDF_GAME_WORKING|BDF_16BIT_ONLY , 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0, 
	NULL, rJurassicParkSpainRomInfo, rJurassicParkSpainRomName, SnesInputInfo, SnesDIPInfo,
	SnesInit, SnesExit, SnesFrame, NULL, SnesScan,
	0, NULL, NULL, NULL, NULL, 512 , 244, 4, 3
};

static struct BurnRomInfo rJurassicParkUSARev1RomDesc[] = {
	{ "Jurassic Park (USA) (Rev 1).sfc",          2097152, 0x8bfde0b7, BRF_ESS | BRF_PRG },
};


STD_ROM_PICK(rJurassicParkUSARev1)
STD_ROM_FN(rJurassicParkUSARev1)

struct BurnDriver BurnDrvrJurassicParkUSARev1 = {
	"Jurassic Park (USA) (Rev 1)", NULL, NULL, "1986",
	"Jurassic Park (USA) (Rev 1)\0", NULL, "Nintendo", "Miscellaneous",
	L"Jurassic Park (USA)